// Generated by gtkmmproc -- DO NOT MODIFY!

#include <libgdamm/datamodel.h>
#include <libgdamm/private/datamodel_p.h>

/* $Id: datamodel.ccg,v 1.4 2004/03/30 18:40:28 murrayc Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* datamodel.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/gda-data-model.h>

namespace //anonymous
{

// This Signal Proxy allows the C++ coder to specify
// a sigc::slot instead of a static function.
class SignalProxy_ForEach
{
public:
  typedef Gnome::Gda::DataModel::SlotForEach SlotType;

  SignalProxy_ForEach(const SlotType& slot)
  : slot_(slot)
  {}
  
  ~SignalProxy_ForEach();

  static gboolean gtk_callback(GdaDataModel* model, GdaRow* row, gpointer user_data);

private:
  SlotType slot_;
};

SignalProxy_ForEach::~SignalProxy_ForEach()
{}

gboolean SignalProxy_ForEach::gtk_callback(GdaDataModel* model, GdaRow* row, gpointer user_data)
{
  SignalProxy_ForEach *const self = static_cast<SignalProxy_ForEach*>(user_data);

  try
  {
    return (self->slot_)(Glib::wrap(row));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0;
}

} // anonymous namespace

namespace Gnome
{

namespace Gda
{
  
void DataModel::foreach(const SlotForEach& slot)
{
  SignalProxy_ForEach proxy(slot);
  gda_data_model_foreach(gobj(), &SignalProxy_ForEach::gtk_callback, &proxy);
}         

} /* namespace Gda */

} /* namespace Gnome */


namespace
{

const Glib::SignalProxyInfo DataModel_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gnome::Gda::DataModel> wrap(GdaDataModel* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::DataModel>( dynamic_cast<Gnome::Gda::DataModel*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& DataModel_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &DataModel_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_data_model_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void DataModel_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->get_n_rows = &get_n_rows_vfunc_callback;
  klass->get_n_columns = &get_n_columns_vfunc_callback;
  klass->describe_column = &describe_column_vfunc_callback;
  klass->get_value_at = &get_value_at_vfunc_callback;
  klass->changed = &changed_callback;
}

int DataModel_Class::get_n_rows_vfunc_callback(GdaDataModel* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return obj->get_n_rows_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->get_n_rows)
      return (*base->get_n_rows)(self);
  }

  typedef int RType;
  return RType();
}

int DataModel_Class::get_n_columns_vfunc_callback(GdaDataModel* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return obj->get_n_columns_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->get_n_columns)
      return (*base->get_n_columns)(self);
  }

  typedef int RType;
  return RType();
}

GdaFieldAttributes* DataModel_Class::describe_column_vfunc_callback(GdaDataModel* self, int col)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return obj->describe_column_vfunc(col);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->describe_column)
      return (*base->describe_column)(self, col);
  }

  typedef GdaFieldAttributes* RType;
  return RType();
}

const GdaValue* DataModel_Class::get_value_at_vfunc_callback(GdaDataModel* self, int col, int row)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return obj->get_value_at_vfunc(col, row);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->get_value_at)
      return (*base->get_value_at)(self, col, row);
  }

  typedef const GdaValue* RType;
  return RType();
}


void DataModel_Class::changed_callback(GdaDataModel* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->changed)
      (*base->changed)(self);
  }
}


Glib::ObjectBase* DataModel_Class::wrap_new(GObject* object)
{
  return new DataModel((GdaDataModel*)object);
}


/* The implementation: */

GdaDataModel* DataModel::gobj_copy()
{
  reference();
  return gobj();
}

DataModel::DataModel(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

DataModel::DataModel(GdaDataModel* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

DataModel::~DataModel()
{}

DataModel::CppClassType DataModel::datamodel_class_; // initialize static member

GType DataModel::get_type()
{
  return datamodel_class_.init().get_type();
}

GType DataModel::get_base_type()
{
  return gda_data_model_get_type();
}


void DataModel::changed()
{
  gda_data_model_changed(gobj());
}

void DataModel::row_inserted(int row)
{
  gda_data_model_row_inserted(gobj(), row);
}

void DataModel::row_updated(int row)
{
  gda_data_model_row_updated(gobj(), row);
}

void DataModel::row_removed(int row)
{
  gda_data_model_row_removed(gobj(), row);
}

void DataModel::freeze()
{
  gda_data_model_freeze(gobj());
}

void DataModel::thaw()
{
  gda_data_model_thaw(gobj());
}

int DataModel::get_n_rows() const
{
  return gda_data_model_get_n_rows(const_cast<GdaDataModel*>(gobj()));
}

int DataModel::get_n_columns() const
{
  return gda_data_model_get_n_columns(const_cast<GdaDataModel*>(gobj()));
}

GdaFieldAttributes* DataModel::describe_column(int col)
{
  return gda_data_model_describe_column(gobj(), col);
}

Glib::ustring DataModel::get_column_title(int col) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_data_model_get_column_title(const_cast<GdaDataModel*>(gobj()), col));
}

void DataModel::set_column_title(int col, const Glib::ustring& title)
{
  gda_data_model_set_column_title(gobj(), col, title.c_str());
}

int DataModel::get_column_position(const Glib::ustring& title) const
{
  return gda_data_model_get_column_position(const_cast<GdaDataModel*>(gobj()), title.c_str());
}

Row DataModel::get_row(int row)
{
  return Glib::wrap(const_cast<GdaRow*>(gda_data_model_get_row(gobj(), row)), true);
}

const GdaValue* DataModel::get_value_at(int col, int row)
{
  return gda_data_model_get_value_at(gobj(), col, row);
}

bool DataModel::is_updatable() const
{
  return gda_data_model_is_updatable(const_cast<GdaDataModel*>(gobj()));
}

const GdaRow* DataModel::append_row(const GList * values)
{
  return gda_data_model_append_row(gobj(), values);
}

bool DataModel::remove_row(const Row& row)
{
  return gda_data_model_remove_row(gobj(), (row).gobj());
}

bool DataModel::update_row(const Row& row)
{
  return gda_data_model_update_row(gobj(), (row).gobj());
}

bool DataModel::has_changed() const
{
  return gda_data_model_has_changed(const_cast<GdaDataModel*>(gobj()));
}

bool DataModel::begin_update()
{
  return gda_data_model_begin_update(gobj());
}

bool DataModel::cancel_update()
{
  return gda_data_model_cancel_update(gobj());
}

bool DataModel::end_update()
{
  return gda_data_model_end_update(gobj());
}

Glib::ustring DataModel::to_comma_separated() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_data_model_to_comma_separated(const_cast<GdaDataModel*>(gobj())));
}

Glib::ustring DataModel::to_tab_separated() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_data_model_to_tab_separated(const_cast<GdaDataModel*>(gobj())));
}

Glib::ustring DataModel::to_xml(bool standalone) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_data_model_to_xml(const_cast<GdaDataModel*>(gobj()), static_cast<int>(standalone)));
}

Glib::ustring DataModel::get_command_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_data_model_get_command_text(const_cast<GdaDataModel*>(gobj())));
}

void DataModel::set_command_text(const Glib::ustring& txt)
{
  gda_data_model_set_command_text(gobj(), txt.c_str());
}

CommandType DataModel::get_command_type() const
{
  return ((CommandType)(gda_data_model_get_command_type(const_cast<GdaDataModel*>(gobj()))));
}

void DataModel::set_command_type(CommandType type)
{
  gda_data_model_set_command_type(gobj(), ((GdaCommandType)(type)));
}


Glib::SignalProxy0< void > DataModel::signal_changed()
{
  return Glib::SignalProxy0< void >(this, &DataModel_signal_changed_info);
}


void Gnome::Gda::DataModel::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->changed)
    (*base->changed)(gobj());
}


int Gnome::Gda::DataModel::get_n_rows_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_n_rows)
    return (*base->get_n_rows)(gobj());

  typedef int RType;
  return RType();
}

int Gnome::Gda::DataModel::get_n_columns_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_n_columns)
    return (*base->get_n_columns)(gobj());

  typedef int RType;
  return RType();
}

GdaFieldAttributes* Gnome::Gda::DataModel::describe_column_vfunc(int col) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->describe_column)
    return (*base->describe_column)(gobj(),col);

  typedef GdaFieldAttributes* RType;
  return RType();
}

const GdaValue* Gnome::Gda::DataModel::get_value_at_vfunc(int col, int row) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_value_at)
    return (*base->get_value_at)(gobj(),col,row);

  typedef const GdaValue* RType;
  return RType();
}


} // namespace Gda

} // namespace Gnome


