// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODEL_H
#define _LIBGDAMM_DATAMODEL_H


#include <glibmm.h>

/* $Id: datamodel.hg,v 1.32 2006/12/15 15:02:27 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* datamodel.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/command.h>
#include <libgdamm/row.h>
#include <libgdamm/column.h>
#include <libgdamm/parameterlist.h>
#include <libgdamm/datamodeliter.h>
//#include <libgdamm/serverprovider.h>
#include <libgda/gda-data-model.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModel GdaDataModel;
typedef struct _GdaDataModelClass GdaDataModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModel_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Row;
class ServerProvider;

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%DataModelAccessFlags operator|(DataModelAccessFlags, DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags operator&(DataModelAccessFlags, DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags operator^(DataModelAccessFlags, DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags operator~(DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags& operator|=(DataModelAccessFlags&, DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags& operator&=(DataModelAccessFlags&, DataModelAccessFlags)</tt><br>
 * <tt>%DataModelAccessFlags& operator^=(DataModelAccessFlags&, DataModelAccessFlags)</tt><br>
 */
enum DataModelAccessFlags
{
  DATA_MODEL_ACCESS_RANDOM = 1 << 0,
  DATA_MODEL_ACCESS_CURSOR_FORWARD = 1 << 1,
  DATA_MODEL_ACCESS_CURSOR_BACKWARD = 1 << 2,
  DATA_MODEL_ACCESS_INSERT = 1 << 3,
  DATA_MODEL_ACCESS_UPDATE = 1 << 4,
  DATA_MODEL_ACCESS_DELETE = 1 << 5,
  DATA_MODEL_ACCESS_WRITE = 0x8
};

/** @ingroup libgdammEnums */
inline DataModelAccessFlags operator|(DataModelAccessFlags lhs, DataModelAccessFlags rhs)
  { return static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags operator&(DataModelAccessFlags lhs, DataModelAccessFlags rhs)
  { return static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags operator^(DataModelAccessFlags lhs, DataModelAccessFlags rhs)
  { return static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags operator~(DataModelAccessFlags flags)
  { return static_cast<DataModelAccessFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags& operator|=(DataModelAccessFlags& lhs, DataModelAccessFlags rhs)
  { return (lhs = static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags& operator&=(DataModelAccessFlags& lhs, DataModelAccessFlags rhs)
  { return (lhs = static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline DataModelAccessFlags& operator^=(DataModelAccessFlags& lhs, DataModelAccessFlags rhs)
  { return (lhs = static_cast<DataModelAccessFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelAccessFlags> : public Glib::Value_Flags<Gnome::Gda::DataModelAccessFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum DataModelHint
{
  DATA_MODEL_HINT_START_BATCH_UPDATE,
  DATA_MODEL_HINT_END_BATCH_UPDATE,
  DATA_MODEL_HINT_REFRESH
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelHint> : public Glib::Value_Enum<Gnome::Gda::DataModelHint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum DataModelIOFormat
{
  DATA_MODEL_IO_DATA_ARRAY_XML,
  DATA_MODEL_IO_TEXT_SEPARATED
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelIOFormat> : public Glib::Value_Enum<Gnome::Gda::DataModelIOFormat>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** @defgroup DataModels Data Models
 */

/** Abstract DataModel (Base class for all DataModels)
 *
 * A DataModel represents an array of values organized in rows and columns. 
 * All the data in the same column have the same type, and all the data in each row have the same semantic meaning. 
 * The DataModel is actually an interface implemented by other objects to support various kinds of data storage and 
 * operations.
 *
 * Depending on the real implementation, the contents of data models may be modified by the user by using functions 
 * provided by the model. The actual operations that a data model permits can be discovered using the 
 * get_access_flags() method.
 *
 * Again, depending on the real implementation, data retreival can be done either by accessing direct random values 
 * located by their row and column, or by using a DataModelIter cursor, or both. Use the get_access_flags() method to 
 * discover how the data model can be accessed. Note that a Datamodel which can be accessed in a random way can also 
 * be accessed using cursors (and several cusrors may be used at the same time), whereas a data model which can only 
 * be accessed using cursors can only have one cursor for iterating.
 *
 * Random access data models are easier to use since picking a value is very simple by using the get_value_at(), 
 * but they consume more memory since all the accessible values must generally be present in memory even if they 
 * are not used. Thus, if a data model must handle large quantities of data, it is generally wiser to use a data 
 * model which can be only accessed using a cursor.
 *
 * As a side note there are also data models which wrap other data models such as:
 * - The DataProxy data model which stores temporary modifications and shows only some parts of the wrapped data model.
 * - The DataAccessWrapper data model which offers memory-efficient random access on top of a wrapped cursor based access data model.
 */

class DataModel : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModel CppObjectType;
  typedef DataModel_Class CppClassType;
  typedef GdaDataModel BaseObjectType;
  typedef GdaDataModelClass BaseClassType;

private:
  friend class DataModel_Class;
  static CppClassType datamodel_class_;

  // noncopyable
  DataModel(const DataModel&);
  DataModel& operator=(const DataModel&);

protected:
  DataModel(); // you must derive from this class
  explicit DataModel(GdaDataModel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModel();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModel*       gobj()       { return reinterpret_cast<GdaDataModel*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdaDataModel* gobj() const { return reinterpret_cast<GdaDataModel*>(gobject_); }

private:

public:

  
  /** Disables notifications of changes on the given data model. To
   * re-enable notifications again, you should call the
   * #gda_data_model_thaw function.
   */
  void freeze();  
  
  /** Re-enables notifications of changes on the given data model.
   */
  void thaw();

  
  /** 
   * @return The number of rows in the given data model, or -1 if the number of rows is not known.
   */
  int get_n_rows() const;
  
  /** 
   * @return The number of columns in the given data model.
   */
  int get_n_columns() const;

  
  /** Queries the underlying data model implementation for a description
   * of a given column. That description is returned in the form of
   * a Gda::Column structure, which contains all the information
   * about the given column in the data model.
   * 
   * WARNING: the returned Gda::Column object belongs to the @a model  model and
   * and should not be destroyed; any modification will impact the whole data model.
   * @param col Column number.
   * @return The description of the column.
   */
  Glib::RefPtr<Column> describe_column(int col);
  
  /** Queries the underlying data model implementation for a description
   * of a given column. That description is returned in the form of
   * a Gda::Column structure, which contains all the information
   * about the given column in the data model.
   * 
   * WARNING: the returned Gda::Column object belongs to the @a model  model and
   * and should not be destroyed; any modification will impact the whole data model.
   * @param col Column number.
   * @return The description of the column.
   */
  Glib::RefPtr<const Column> describe_column(int col) const;
  
  /** Get the index of the column named @a name  in @a model 
   * @param name A column name.
   * @return The column index, or -1 if no column named @a name  was found.
   */
  int get_column_index(const Glib::ustring& name) const;
  
  /** 
   * @param col Column number.
   * @return The title for the given column in a data model object.
   */
  Glib::ustring get_column_title(int col) const;
  
  /** Sets the @a title  of the given @a col  in @a model .
   * @param col Column number.
   * @param title Title for the given column.
   */
  void set_column_title(int col, const Glib::ustring& title);
  //TODO:_WRAP_METHOD(int get_column_position(const Glib::ustring& title) const, gda_data_model_get_column_position)

  //We use a custom conversion here, because we need to copy the value:
  //#m4 __CONVERSION(`GValue*',`Value',`Glib::wrap($3, true /* take_copy=true */)')
  //#m4 __CONVERSION(`const GValue*',`Value',`Glib::wrap(const_cast<GValue*>($3), true /* take_copy */)')
 
  Value get_value_at(int col, int row) const;
  

  Value get_value_at(const Glib::ustring& column_name, int row) const;
  

  /** Get the attributes of the value stored at (row, col) in @a proxy , which
   * is an ORed value of Gda::ValueAttribute flags. As a special case, if
   *  @a row  is -1, then the attributes returned correspond to a "would be" value
   * if a row was added to @a model .
   * @param col A valid column number.
   * @param row A valid row number, or -1.
   * @return The attributes as an ORed value of Gda::ValueAttribute.
   */
  ValueAttribute get_attributes_at(int col, int row);

  
  /** Creates a new iterator object Gda::DataModelIter object which can be used to iterate through
   * rows in @a model .
   * 
   * The row the returned Gda::DataModelIter represents is undefined. For models which can be accessed 
   * randomly the correspoding row can be set using move_iter_at_row(), 
   * and for models which are accessible sequentially only then the first row will be
   * fetched using move_iter_next().
   * @return A new Gda::DataModelIter object, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<DataModelIter> create_iter();
   
  //Ignore private functions:
  

  /** 
   * @param col Column number.
   * @param row Row number.
   * @param value A G::Value, or <tt>0</tt>.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the value in the data model has been updated and no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_value_at(int col, int row, const Value& value);
#else
  bool set_value_at(int col, int row, const Value& value, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: _WRAP_METHOD(bool gda_data_model_set_values(int row, GList *values), gda_data_model_set_values, errthrow)

  
  /** Tells if @a model  can be modified
   * @return <tt>true</tt> if @a model  can be modified.
   */
  bool is_updatable() const;
  
  /** Get the attributes of @a model  such as how to access the data it contains if it's modifiable, etc.
   * @return An ORed value of Gda::DataModelAccessFlags flags.
   */
  DataModelAccessFlags get_access_flags() const;

   
  /** Appends a row to the given data model. If any value in @a values  is actually <tt>0</tt>, then 
   * it is considered as a default value.
   * @param values G::List of G::Value* representing the row to add.  The
   * length must match model's column count.  These G::Value
   * are value-copied (the user is still responsible for freeing them).
   * @param error A place to store errors, or <tt>0</tt>.
   * @return The number of the added row, or -1 if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int append_values(const ValueList& values);
#else
  int append_values(const ValueList& values, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Appends a row to the data model.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return The number of the added row, or -1 if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool append_row();
#else
  bool append_row(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes a row from the data model.
   * @param row The row number to be removed.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove_row(int row);
#else
  bool remove_row(int row, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: _WRAP_METHOD(int get_row_from_values(GSList *values, int *cols_index), gda_data_model_get_row_from_values)

  
  /** Sends a hint to the data model. The hint may or may not be handled by the data
   * model, depending on its implementation
   * @param hint A hint to send to the model.
   * @param hint_value An optional value to specify the hint, or <tt>0</tt>.
   */
  void send_hint(DataModelHint hint, const Value& hint_value);

  //TODO: _WRAP_METHOD(Glib::ustring export_to_string(DataModelIOFormat format, const int *cols, int nb_cols, const Glib::RefPtr<const ParameterList>& options), gda_data_model_export_to_string)
//TODO: Hand-code this to use an Array for the cols and rows, using less parameters:
  //_WRAP_METHOD(bool export_to_file(DataModelIOFormat format, const std::string& file, const gint* cols, int nb_cols, const gint* rows, int nb_rows, const Glib::RefPtr<const ParameterList>& options), gda_data_model_export_to_file, errthrow)

  //TODO: _WRAP_METHOD(bool import_from_model(Glib::RefPtr<DataModel> from,  GHashTable *cols_trans), gda_data_model_import_from_model, errthrow)
  
  /** Loads the data from @a string  into @a model .
   * @param string The string to import data from.
   * @param cols_trans A hash table containing which columns of @a model  will be imported, or <tt>0</tt> for all columns.
   * @param options List of options for the export.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool import_from_string(const Glib::ustring& string, GHashTable *cols_trans, const Glib::RefPtr<const ParameterList>& options);
#else
  bool import_from_string(const Glib::ustring& string, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Imports data contained in the @a file  file into @a model ; the format is detected.
   * @param file The filename to import from.
   * @param cols_trans A G::HashTable for columns translating, or <tt>0</tt>.
   * @param options List of options for the export.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool import_from_file(const std::string& file, GHashTable *cols_trans, const Glib::RefPtr<const ParameterList>& options);
#else
  bool import_from_file(const std::string& file, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


//TODO: Implement.
  Glib::ustring to_xml(const Glib::ArrayHandle<int>& cols, const Glib::StringArrayHandle& names) const;
  ;

  //TODO: Wrap these if we want to depend on libxml++, though they seem silly. murrayc.
  
  //_WRAP_METHOD(xmlNodePtr to_xml(const GLib::ustring& name), gda_data_model_to_xml_node)
  //_WRAP_METHOD(bool add_data(xmlNodePtr node), gda_data_model_add_data_from_xml_node)

  
  /** Dumps a textual representation of the @a model  to the @a to_stream  stream
   * @param to_stream Where to dump the data model.
   */
  void dump(FILE* to_stream) const;
  
  /** Dumps a textual representation of the @a model  into a new string
   * @return A new string.
   */
  Glib::ustring dump_as_string() const;

  //These are from gda-datamodel-extra.h:
  //TODO: Are these meant to be public API?
  
  /** Notifies listeners of the given data model object of changes
   * in the underlying data. Listeners usually will connect
   * themselves to the "changed" signal in the Gda::DataModel
   * class, thus being notified of any new data being appended
   * or removed from the data model.
   */
  void signal_emit_changed();
  
  /** Emits the 'row_inserted' and 'changed' signals on @a model .
   * @param row Row number.
   */
  void row_inserted(int row);
  
  /** Emits the 'row_updated' and 'changed' signals on @a model .
   * @param row Row number.
   */
  void row_updated(int row);
  
  /** Emits the 'row_removed' and 'changed' signal on @a model .
   * @param row Row number.
   */
  void row_removed(int row);

  
  bool move_iter_at_row_default(const Glib::RefPtr<DataModelIter>& iter, int row);
  
  bool move_iter_next_default(const Glib::RefPtr<DataModelIter>& iter);
  
  bool move_iter_prev_default(const Glib::RefPtr<DataModelIter>& iter);

   
  /** If any value in @a values  is actually <tt>0</tt>, then 
   * it is considered as a default value.
   * @param row Row number.
   * @param values A list of G::Value, one for each n (&lt;nb_cols) columns of @a model .
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if the value in the data model has been updated and no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_values(int row, const ValueList& values);
#else
  bool set_values(int row, const ValueList& values, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED
;

	/* TODO: Is this correct here. Seems to be in the wrong header */
  
  /** Makes a copy of @a src  into a new Gda::DataModelArray object
   * @param error A place to store errors, or <tt>0</tt>.
   * @return A new data model, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> copy() const;
#else
  Glib::RefPtr<DataModel> copy(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //These are in a private header. Ignore them:
  

/**
   * @par Prototype:
   * <tt>void %row_inserted(int row)</tt>
   */

  Glib::SignalProxy1< void,int > signal_row_inserted();

  
/**
   * @par Prototype:
   * <tt>void %row_updated(int row)</tt>
   */

  Glib::SignalProxy1< void,int > signal_row_updated();

  
/**
   * @par Prototype:
   * <tt>void %row_removed(int row)</tt>
   */

  Glib::SignalProxy1< void,int > signal_row_removed();


protected:

  //We don't wrap the vfuncs because they are only useful for creating new backends,
  //and they have a high code-size and per-object memory cost.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_row_inserted(int row);
  virtual void on_row_updated(int row);
  virtual void on_row_removed(int row);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DataModel
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DataModel> wrap(GdaDataModel* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_DATAMODEL_H */

