// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUERYJOIN_H
#define _LIBGDAMM_QUERYJOIN_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* queryjoin.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/dict.h>
#include <libgdamm/datamodel.h>

#include <libgdamm/entity.h>
#include <libgdamm/xmlstorage.h>
#include <libgdamm/referer.h>
#include <libgdamm/queryobject.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaQueryJoin GdaQueryJoin;
typedef struct _GdaQueryJoinClass GdaQueryJoinClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class QueryJoin_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Query;
class QueryTarget;
class QueryCondition;

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum QueryJoinType
{
  QUERY_JOIN_TYPE_INNER,
  QUERY_JOIN_TYPE_LEFT_OUTER,
  QUERY_JOIN_TYPE_RIGHT_OUTER,
  QUERY_JOIN_TYPE_FULL_OUTER,
  QUERY_JOIN_TYPE_CROSS,
  QUERY_JOIN_TYPE_LAST
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::QueryJoinType> : public Glib::Value_Enum<Gnome::Gda::QueryJoinType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** This object is a join, within a SELECT query, between two different
 * entities participating in the query; the entities are themselves
 * represented by GdaQueryTarget objects. It is important to specify
 * joining conditions as joins and not simply as WHERE conditions because
 * the joins carry more information than a simple condition and because
 * some features of Libmergeant rely on the joins analysis.
 *
 * @ingroup Queries
 */

class QueryJoin
 : public QueryObject,
   public XmlStorage,
   public Referer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef QueryJoin CppObjectType;
  typedef QueryJoin_Class CppClassType;
  typedef GdaQueryJoin BaseObjectType;
  typedef GdaQueryJoinClass BaseClassType;

private:  friend class QueryJoin_Class;
  static CppClassType queryjoin_class_;

private:
  // noncopyable
  QueryJoin(const QueryJoin&);
  QueryJoin& operator=(const QueryJoin&);

protected:
  explicit QueryJoin(const Glib::ConstructParams& construct_params);
  explicit QueryJoin(GdaQueryJoin* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~QueryJoin();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaQueryJoin*       gobj()       { return reinterpret_cast<GdaQueryJoin*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaQueryJoin* gobj() const { return reinterpret_cast<GdaQueryJoin*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaQueryJoin* gobj_copy();

private:


protected:
  QueryJoin(const Glib::RefPtr<Query>& query, const Glib::RefPtr<QueryTarget>& target_1, const Glib::RefPtr<QueryTarget>& target_2);
  QueryJoin(const Glib::RefPtr<Query>& query, const Glib::ustring& target_1_xml_id, const Glib::ustring& target_2_xml_id);
  
  
public:
  
  static Glib::RefPtr<QueryJoin> create(const Glib::RefPtr<Query>& query, const Glib::RefPtr<QueryTarget>& target_1, const Glib::RefPtr<QueryTarget>& target_2);

  
  static Glib::RefPtr<QueryJoin> create(const Glib::RefPtr<Query>& query, const Glib::ustring& target_1_xml_id, const Glib::ustring& target_2_xml_id);


  // TODO: How to wrap GHashTable? armin.
  //_WRAP_METHOD(Glib::RefPtr<QueryJoin> copy(GHashTable* replacements), gda_query_join_new_copy)

  
  /** Sets the type of @a join 
   * @param type The new type of join.
   */
  void set_join_type(QueryJoinType type);
  
  /** Get the type of a join
   * @return The type of @a join .
   */
  QueryJoinType get_join_type() const;

  
  /** Get the Gda::Query to which @a join  is attached to
   * @return The Gda::Query.
   */
  Glib::RefPtr<Query> get_query();
  
  /** Get the Gda::Query to which @a join  is attached to
   * @return The Gda::Query.
   */
  Glib::RefPtr<const Query> get_query() const;

  
  /** Get the 1st Gda::QueryTarget participating in the join
   * @return The Gda::QueryTarget.
   */
  Glib::RefPtr<QueryTarget> get_target_1();
  
  /** Get the 1st Gda::QueryTarget participating in the join
   * @return The Gda::QueryTarget.
   */
  Glib::RefPtr<const QueryTarget> get_target_1() const;
  
  /** Get the 2nd Gda::QueryTarget participating in the join
   * @return The Gda::QueryTarget.
   */
  Glib::RefPtr<QueryTarget> get_target_2();
  
  /** Get the 2nd Gda::QueryTarget participating in the join
   * @return The Gda::QueryTarget.
   */
  Glib::RefPtr<const QueryTarget> get_target_2() const;

  
  /** Changes the relative roles of the two Gda::QueryTarget objects. It does not
   * change the join condition itself, and is usefull only for the internals
   * of the Gda::Query object
   */
  void swap_targets();
  
  /** Creates a Gda::QueryCondition for @a join  using the foreign key constraints
   * present in the database if the two targets @a join  joins are database tables
   * (Gda::DictTable objects).
   * 
   * If there is more than one FK constraint between the database tables, then
   * no join is created, and the call returns <tt>false</tt>.
   * @return <tt>true</tt> if suitable foreign keys were found and a join condition
   * has been created.
   */
  bool set_condition_from_fkcons();
  
  /** Parses @a cond  and if it represents a valid SQL expression to be @a join 's
   * condition, then set it to be @a join 's condition.
   * @param cond A SQL expression.
   * @param error Place to store the error, or <tt>0</tt>.
   * @return A <tt>true</tt> on success.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_condition_from_sql(const Glib::ustring& cond);
#else
  bool set_condition_from_sql(const Glib::ustring& cond, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets @a cond  to be @a join 's condition. This is possible only if @a cond  uses
   * query fields which are either of type GdaQueryFieldField and reference one of the two
   * targets which @a join  uses, or any other query field type.
   * @param cond A  Gda::QueryCondition object, or <tt>0</tt> to remove the join's condition.
   * @return <tt>true</tt> if no error occurred.
   */
  bool set_condition(const Glib::RefPtr<QueryCondition>& cond);

  
  /** Get the join's associated condition
   * @return The Gda::QueryCondition object.
   */
  Glib::RefPtr<QueryCondition> get_condition();
  
  /** Get the join's associated condition
   * @return The Gda::QueryCondition object.
   */
  Glib::RefPtr<const QueryCondition> get_condition() const;

  
  /** Get the SQL version of the join type ("INNER JOIN", "LEFT JOIN", etc)
   * @return The type as a const string.
   */
  Glib::ustring render_type() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Query> > property_query() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<QueryTarget> > property_target1() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<QueryTarget> > property_target1() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_target1_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<QueryTarget> > property_target2() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<QueryTarget> > property_target2() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_target2_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void %condition_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_condition_changed();

  
  /**
   * @par Prototype:
   * <tt>void %type_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_type_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_condition_changed();
  virtual void on_type_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::QueryJoin
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::QueryJoin> wrap(GdaQueryJoin* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_QUERYJOIN_H */

