// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_COMMAND_H
#define _LIBGDAMM_COMMAND_H


#include <glibmm.h>

/* $Id: command.hg,v 1.6 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* command.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdaCommand GdaCommand; } 
#endif

namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum CommandType
{
  COMMAND_TYPE_SQL,
  COMMAND_TYPE_XML,
  COMMAND_TYPE_PROCEDURE,
  COMMAND_TYPE_TABLE,
  COMMAND_TYPE_SCHEMA,
  COMMAND_TYPE_INVALID
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::CommandType> : public Glib::Value_Enum<Gnome::Gda::CommandType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%CommandOptions operator|(CommandOptions, CommandOptions)</tt><br>
 * <tt>%CommandOptions operator&(CommandOptions, CommandOptions)</tt><br>
 * <tt>%CommandOptions operator^(CommandOptions, CommandOptions)</tt><br>
 * <tt>%CommandOptions operator~(CommandOptions)</tt><br>
 * <tt>%CommandOptions& operator|=(CommandOptions&, CommandOptions)</tt><br>
 * <tt>%CommandOptions& operator&=(CommandOptions&, CommandOptions)</tt><br>
 * <tt>%CommandOptions& operator^=(CommandOptions&, CommandOptions)</tt><br>
 */
enum CommandOptions
{
  COMMAND_OPTION_IGNORE_ERRORS = 1,
  COMMAND_OPTION_STOP_ON_ERRORS = 1 << 1,
  COMMAND_OPTION_BAD_OPTION = 1 << 2
};

/** @ingroup libgdammEnums */
inline CommandOptions operator|(CommandOptions lhs, CommandOptions rhs)
  { return static_cast<CommandOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline CommandOptions operator&(CommandOptions lhs, CommandOptions rhs)
  { return static_cast<CommandOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline CommandOptions operator^(CommandOptions lhs, CommandOptions rhs)
  { return static_cast<CommandOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline CommandOptions operator~(CommandOptions flags)
  { return static_cast<CommandOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline CommandOptions& operator|=(CommandOptions& lhs, CommandOptions rhs)
  { return (lhs = static_cast<CommandOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline CommandOptions& operator&=(CommandOptions& lhs, CommandOptions rhs)
  { return (lhs = static_cast<CommandOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline CommandOptions& operator^=(CommandOptions& lhs, CommandOptions rhs)
  { return (lhs = static_cast<CommandOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::CommandOptions> : public Glib::Value_Flags<Gnome::Gda::CommandOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** For issuing commands to the provider.
 * The Command object holds data needed to issue a command to the providers. Applications usually create a Command, set 
 * its properties (via the set_* methods) and pass it over to the database using the Connection methods.
 *
 * Commands is that they can be reused. That is, applications don't need to create a command object every time they want to 
 * run a command on the connected database. Moreover, the ability to create command strings with placeholders allows the 
 * use of parameters to specify the values for those placeholders. Thus, an application can create a command of the form:
 *
 * INSERT INTO employees VALUES (id, name, address, salary)
 *
 * and reuse the same command over and over, just using different values for the placeholders.
 *
 * The value for the placeholders is specified when sending the Command to a database connection, 
 * which is done via the Gda::Connection::execute function.
 *
 * @ingroup Connections
 */
class Command
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Command CppObjectType;
  typedef GdaCommand BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Command();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Command(GdaCommand* castitem, bool make_a_copy = false);

  Command(const Command& src);
  Command& operator=(const Command& src);

  ~Command();

  GdaCommand*       gobj()       { return gobject_; }
  const GdaCommand* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdaCommand* gobj_copy() const;

protected:
  GdaCommand* gobject_;

private:

  
public:
  //TODO: What do the other command types do? How do they work?

  /** Creates a new Command.
   * If there are conflicting options, this will set options to GDA_COMMAND_OPTION_DEFAULT.
   * @param text The text of the command.
   * @param type The type of the command.
   * @param options Additional command options.
   */
  explicit Command(const Glib::ustring& text, CommandType type = COMMAND_TYPE_SQL, CommandOptions options = COMMAND_OPTION_STOP_ON_ERRORS);
 
  
  /** Gets the command text held by @a cmd .
   * @return The command string of @a cmd .
   */
  Glib::ustring get_text() const;
  
  /** Sets the command text of @a cmd .
   * @param text The command text.
   */
  void set_text(const Glib::ustring& text);
  
  /** Gets the command type of @a cmd .
   * @return The command type of @a cmd .
   */
  CommandType get_command_type() const;
  
  /** Sets the command type of @a cmd .
   * @param type The command type.
   */
  void set_command_type(CommandType type);
  
  /** Gets the command options of @a cmd .
   * @return The command options of @a cmd .
   */
  CommandOptions get_options() const;
  
  /** Sets the command options of @a cmd . If there conflicting options, it will just
   * leave the value as before.
   * @param options The command options.
   */
  void set_options(CommandOptions options);


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Command
   */
Gnome::Gda::Command wrap(GdaCommand* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_COMMAND_H */

