// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DICTCONSTRAINT_H
#define _LIBGDAMM_DICTCONSTRAINT_H


#include <glibmm.h>

/* $Id: dictconstraint.hg,v 1.2 2006/11/08 00:07:37 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* dictconstraint.h
 *
 * Copyright 2007 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/object.h>
#include <libgdamm/xmlstorage.h>
#include <libgdamm/dicttable.h>
#include <libgdamm/dictfield.h>
#include <libgdamm/dicttype.h>
#include <libgdamm/referer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDictConstraint GdaDictConstraint;
typedef struct _GdaDictConstraintClass GdaDictConstraintClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DictConstraint_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum DictConstraintType
{
  PRIMARY_KEY,
  FOREIGN_KEY,
  UNIQUE,
  NOT_NULL,
  CHECK_EXPR,
  CHECK_IN_LIST,
  CHECK_SETOF_LIST,
  UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DictConstraintType> : public Glib::Value_Enum<Gnome::Gda::DictConstraintType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum DictConstraintFkAction
{
  FK_ACTION_CASCADE,
  FK_ACTION_SET_NULL,
  FK_ACTION_SET_DEFAULT,
  FK_ACTION_SET_VALUE,
  FK_ACTION_NO_ACTION
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DictConstraintFkAction> : public Glib::Value_Enum<Gnome::Gda::DictConstraintFkAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


class Connection;

/** Represents a constraint within a database.
 * Any type of constraint in a database is represented by one instance of this class (see the possible types of 
 * constraints). As some constraints may not depend exclusively on a table, all the constraints are attached to the 
 * database itself.
 * 
 * @ingroup Dictionaries
 */

class DictConstraint
: public Gda::Object,
  public XmlStorage,
  public Referer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DictConstraint CppObjectType;
  typedef DictConstraint_Class CppClassType;
  typedef GdaDictConstraint BaseObjectType;
  typedef GdaDictConstraintClass BaseClassType;

private:  friend class DictConstraint_Class;
  static CppClassType dictconstraint_class_;

private:
  // noncopyable
  DictConstraint(const DictConstraint&);
  DictConstraint& operator=(const DictConstraint&);

protected:
  explicit DictConstraint(const Glib::ConstructParams& construct_params);
  explicit DictConstraint(GdaDictConstraint* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DictConstraint();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDictConstraint*       gobj()       { return reinterpret_cast<GdaDictConstraint*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDictConstraint* gobj() const { return reinterpret_cast<GdaDictConstraint*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDictConstraint* gobj_copy();

private:

  
protected:

  //TODO: File bug about gda_dict_constraint_new() and gda_dict_constraint_new_with_db() using private API:
  explicit DictConstraint(const Glib::RefPtr<DictTable>& table, DictConstraintType type);
  explicit DictConstraint(const Glib::RefPtr<DictDatabase>& db);

public:
  
  static Glib::RefPtr<DictConstraint> create(const Glib::RefPtr<DictTable>& table, DictConstraintType type);

  
  static Glib::RefPtr<DictConstraint> create(const Glib::RefPtr<DictDatabase>& db);


  /** Get the type of constraint the @a cstr  object represents
   * @return The constraint type.
   */
  DictConstraintType get_constraint_type() const;
  
  /** Compares two Gda::DictConstraint objects to see if they are equal, without taking into account the
   * name of the constraints or weather they are user or system defined
   * @param cstr2 The second Gda::DictConstraint to compare.
   * @return <tt>true</tt> if the two constraints are equal and <tt>false</tt> otherwise.
   */
  bool equal(const Glib::RefPtr<const DictConstraint>& cstr2) const;

  
  /** Get the table to which the constraint is attached
   * @return The Gda::DictTable.
   */
  Glib::RefPtr<DictTable> get_table();
  
  /** Get the table to which the constraint is attached
   * @return The Gda::DictTable.
   */
  Glib::RefPtr<const DictTable> get_table() const;

  
  /** Tests if @a field  is part of the @a cstr  constraint
   * @param field A Gda::DictField object.
   * @return <tt>true</tt> if @a cstr  uses @a field .
   */
  bool uses_field(const Glib::RefPtr<const DictField>& field) const;

/* Primary KEY specific */

   
  /** Sets the fields which make the primary key represented by @a cstr . All the fields
   * must belong to the same Gda::DictTable to which the constraint is attached
   * @param fields A list of Gda::DictField objects.
   */
  void pkey_set_fields(const Glib::SListHandle< Glib::RefPtr<DictField> >& fields);

   
  /** Get the list of fields composing the primary key constraint which @a cstr  represents. The
   * returned list is allocated and must be de-allocated by the caller.
   * @return A new list of fields.
   */
  Glib::SListHandle< Glib::RefPtr<DictField> > pkey_get_fields();
  
  /** Get the list of fields composing the primary key constraint which @a cstr  represents. The
   * returned list is allocated and must be de-allocated by the caller.
   * @return A new list of fields.
   */
  Glib::SListHandle< Glib::RefPtr<const DictField> > pkey_get_fields() const;

/* Foreign KEY specific */
  //TODO:
  
  /** Sets the field pairs which make the foreign key represented by @a cstr . All the field pairs
   * must list a field which belong to the same Gda::DictTable to which the constraint is attached
   * and a field which belongs to a Gda::DictTable which is different from the one just mentionned and which
   * is within the same database.
   * The pairs are of type Gda::DictConstraintFkeyPair.
   * @param pairs A list of Gda::DictField objects.
   */
  void fkey_set_fields(const GSList *pairs);

  
  /** Get the Gda::DictTable at the other end of the foreign key relation represented by this
   * constraint
   * @return The Gda::DictTable.
   */
  Glib::RefPtr<DictTable> fkey_get_ref_table();
  
  /** Get the Gda::DictTable at the other end of the foreign key relation represented by this
   * constraint
   * @return The Gda::DictTable.
   */
  Glib::RefPtr<const DictTable> fkey_get_ref_table() const;

  //TODO: Wrap GdaDictConstraintFkeyPair (which might or might not be a GObject):
  //_WRAP_METHOD(Glib::SListHandle< Glib::RefPtr<DictConstraintFkeyPair> > fkey_get_fields(), gda_dict_constraint_fkey_get_fields)
  //_WRAP_METHOD(Glib::SListHandle<const DictConstraintFkeyPair> fkey_get_fields() const, gda_dict_constraint_fkey_get_fields)

  
  /** Sets the actions undertaken by the DBMS when some actions occur on the referenced data
   * @param on_update The action undertaken when an UPDATE occurs.
   * @param on_delete The action undertaken when a DELETE occurs.
   */
  void fkey_set_actions(DictConstraintFkAction on_update,  DictConstraintFkAction on_delete);
  
  /** Get the actions undertaken by the DBMS when some actions occur on the referenced data
   * @param on_update An address to store the action undertaken when an UPDATE occurs.
   * @param on_delete An address to store the action undertaken when a DELETE occurs.
   */
  void fkey_get_actions(DictConstraintFkAction& on_update, DictConstraintFkAction& on_delete);

/* UNIQUE specific */
  
  /** 
   */
  void unique_set_fields(const Glib::SListHandle< Glib::RefPtr<DictField> >& fields);

  
  /** Get the list of fields represented by this UNIQUE constraint. It's up to the caller to free the list.
   * @return A new list of fields.
   */
  Glib::SListHandle< Glib::RefPtr<DictField> > unique_get_fields();
  
  /** Get the list of fields represented by this UNIQUE constraint. It's up to the caller to free the list.
   * @return A new list of fields.
   */
  Glib::SListHandle< Glib::RefPtr<const DictField> > unique_get_fields() const;

/* NOT NULL specific */
  
  void not_null_set_field(const Glib::RefPtr<DictField>& field);

  
  Glib::RefPtr<DictField> not_null_get_field();
  
  Glib::RefPtr<const DictField> not_null_get_field() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_user_constraint() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_user_constraint() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //TODO: properties, signals, vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DictConstraint
   */
  Glib::RefPtr<Gnome::Gda::DictConstraint> wrap(GdaDictConstraint* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DICTCONSTRAINT_H */

