// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SQLBUILDER_H
#define _LIBGDAMM_SQLBUILDER_H


#include <glibmm.h>

// -*- C++ -*- //

/* sqlbuilder.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/statement.h>
#include <libgdamm/sqlexpr.h>
#include <libgdamm/sqlstatement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaSqlBuilder GdaSqlBuilder;
typedef struct _GdaSqlBuilderClass GdaSqlBuilderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class SqlBuilder_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum SqlOperatorType
{
  SQL_OPERATOR_TYPE_AND,
  SQL_OPERATOR_TYPE_OR,
  SQL_OPERATOR_TYPE_EQ,
  SQL_OPERATOR_TYPE_IS,
  SQL_OPERATOR_TYPE_LIKE,
  SQL_OPERATOR_TYPE_BETWEEN,
  SQL_OPERATOR_TYPE_GT,
  SQL_OPERATOR_TYPE_LT,
  SQL_OPERATOR_TYPE_GEQ,
  SQL_OPERATOR_TYPE_LEQ,
  SQL_OPERATOR_TYPE_DIFF,
  SQL_OPERATOR_TYPE_REGEXP,
  SQL_OPERATOR_TYPE_REGEXP_CI,
  SQL_OPERATOR_TYPE_NOT_REGEXP,
  SQL_OPERATOR_TYPE_NOT_REGEXP_CI,
  SQL_OPERATOR_TYPE_SIMILAR,
  SQL_OPERATOR_TYPE_ISNULL,
  SQL_OPERATOR_TYPE_ISNOTNULL,
  SQL_OPERATOR_TYPE_NOT,
  SQL_OPERATOR_TYPE_IN,
  SQL_OPERATOR_TYPE_NOTIN,
  SQL_OPERATOR_TYPE_CONCAT,
  SQL_OPERATOR_TYPE_PLUS,
  SQL_OPERATOR_TYPE_MINUS,
  SQL_OPERATOR_TYPE_STAR,
  SQL_OPERATOR_TYPE_DIV,
  SQL_OPERATOR_TYPE_REM,
  SQL_OPERATOR_TYPE_BITAND,
  SQL_OPERATOR_TYPE_BITOR,
  SQL_OPERATOR_TYPE_BITNOT
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlOperatorType> : public Glib::Value_Enum<Gnome::Gda::SqlOperatorType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum SqlSelectJoinType
{
  SQL_SELECT_JOIN_CROSS,
  SQL_SELECT_JOIN_NATURAL,
  SQL_SELECT_JOIN_INNER,
  SQL_SELECT_JOIN_LEFT,
  SQL_SELECT_JOIN_RIGHT,
  SQL_SELECT_JOIN_FULL
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlSelectJoinType> : public Glib::Value_Enum<Gnome::Gda::SqlSelectJoinType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

class SqlBuilderError : public Glib::Error
{
public:
  enum Code
  {
    SQL_BUILDER_WRONG_TYPE_ERROR,
    SQL_BUILDER_MISUSE_ERROR
  };

  SqlBuilderError(Code error_code, const Glib::ustring& error_message);
  explicit SqlBuilderError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlBuilderError::Code> : public Glib::Value_Enum<Gnome::Gda::SqlBuilderError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

class SqlError : public Glib::Error
{
public:
  enum Code
  {
    SQL_STRUCTURE_CONTENTS_ERROR,
    SQL_MALFORMED_IDENTIFIER_ERROR,
    SQL_MISSING_IDENTIFIER_ERROR,
    SQL_VALIDATION_ERROR
  };

  SqlError(Code error_code, const Glib::ustring& error_message);
  explicit SqlError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlError::Code> : public Glib::Value_Enum<Gnome::Gda::SqlError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/*
 * @ingroup Connection
 */

class SqlBuilder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SqlBuilder CppObjectType;
  typedef SqlBuilder_Class CppClassType;
  typedef GdaSqlBuilder BaseObjectType;
  typedef GdaSqlBuilderClass BaseClassType;

private:  friend class SqlBuilder_Class;
  static CppClassType sqlbuilder_class_;

private:
  // noncopyable
  SqlBuilder(const SqlBuilder&);
  SqlBuilder& operator=(const SqlBuilder&);

protected:
  explicit SqlBuilder(const Glib::ConstructParams& construct_params);
  explicit SqlBuilder(GdaSqlBuilder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SqlBuilder();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaSqlBuilder*       gobj()       { return reinterpret_cast<GdaSqlBuilder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaSqlBuilder* gobj() const { return reinterpret_cast<GdaSqlBuilder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaSqlBuilder* gobj_copy();

private:

protected:
  SqlBuilder(SqlStatementType type);
public:
  
  static Glib::RefPtr<SqlBuilder> create(SqlStatementType type);


  Glib::RefPtr<Statement> get_statement() const;

 
  SqlStatement get_sql_statement() const;

  
  //A duplicate of the GdsSqlBuilderId typedef in libgda's header, to avoid including the header here.
  typedef guint Id;
  
  // Expression API:

  
  Id add_id(const Glib::ustring& string);
  
  
  Id add_field_id(const Glib::ustring& field_name, const Glib::ustring& table_name = Glib::ustring());

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param dh The datahandler to use
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  template <class ValueType>
  Id add_expr(const Glib::RefPtr<DataHandler>& dh, const ValueType& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param dh The datahandler to use
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_expr_as_value(const Glib::RefPtr<DataHandler>& dh, const Value& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  template <class ValueType>
  Id add_expr(const ValueType& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_expr_as_value(const Value& value);

  /** Defines a parameter which may be reused to build other parts of a statement.
   * @param: param_name: name of the parameter
   * @type: GType of the parameter
   * @nullok True if the parameter can be set to %NULL
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_param(const Glib::ustring& param_name, GType type, bool nullok = false);

  /** Builds a new expression which reprenents a condition (or operation).
   * @param op Type of condition
   * @param op1 The ID of the 1st argument (not 0)
   * @param op2 The ID of the 2st argument (maybe 0 if op only requires one argument)
   * @param op3 The ID of the 3st argument (maybe 0 if op only requires one or two arguments)
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_cond(SqlOperatorType op, Id op1, Id op2 = 0, Id op3 = 0);

  /** Builds a new expression which reprenents a condition (or operation).
   * @param op Type of condition
   * @param op_ids: list of IDs of the operands of the condition
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_cond(SqlOperatorType op, const Glib::ArrayHandle<Id>& op_ids);

  
  /** Builds a new expression which represents a function applied to some arguments.
    *
    * @param function_name The name of the function to embed (e.g. MAX, MIN, ...)
    * @param args: list of ids of the arguments to the function
    *
    * @return The ID of the new target, or 0 if there was an error.
    */
  Id add_function(const Glib::ustring& function_name, const Glib::ArrayHandle<Id>& args);

    /** Builds a new expression which represents a function applied to an argument.
    *
    * @param function_name The name of the function to embed (e.g. MAX, MIN, ...)
    * @param arg: The ids of the argument to the function
    *
    * @return The ID of the new target, or 0 if there was an error.
    */
  Id add_function(const Glib::ustring& function_name, Id arg);


  Id add_sub_select(const SqlStatement& sqlst);
  

//TODO:  _WRAP_METHOD(Id gda_sql_builder_add_case (GdaSqlBuilder *builder, Id id,  Id test_expr, Id else_expr, ...);
//TODO:  _WRAP_METHOD(Id gda_sql_builder_add_case_v (GdaSqlBuilder *builder, Id id,  Id test_expr, Id else_expr,  const Id *when_array, const Id *then_array, gint args_size);

  
  Id select_add_field(const Glib::ustring& field_name, const Glib::ustring& table_name, const Glib::ustring& alias = Glib::ustring());

  // Statement API
  /** Adds a new target to a SELECT statement
   * @param table_id The ID of the expression holding a table reference.
   * @param alias The alias to give to the target.
   *
   * @return The ID of the new target, or 0 if there was an error.
   */
  Id select_add_target(const Glib::ustring& table_name, const Glib::ustring& alias = Glib::ustring());
  

  //For instance, to add a sub-query?
  Id select_add_target_id(Id table_id, const Glib::ustring& alias = Glib::ustring());
  

  /** Joins two targets in a SELECT statement
   * @param left_target_id The ID of the left target to use (not %0)
   * @param right_target_id The ID of the right target to use (not %0)
   * @param join_type The type of join
   * @param join_expr Joining expression's ID, or %0
   *
   * @return The ID of the new join, or 0 if there was an error.
   */
  Id select_join_targets(Id left_target_id, Id right_target_id, SqlSelectJoinType join_type, Id join_expr = 0);

  
  void join_add_field(Id join_id, const Glib::ustring& field_name);
  
  void select_order_by(Id expr_id, bool asc = true, const Glib::ustring& collation_name = Glib::ustring());

  /** Adds or removes a DISTINCT clause for a SELECT statement.
   * @param distinct Whether a DISTINCT clause should be in the SELECT statement.
   * @newin4p2
   */
  void select_set_distinct(bool distinct = true);

  
  void select_set_distinct(bool distinct, Id expr_id);

  /** Defines the maximum number of rows in the DataModel resulting from the execution of the built statement.
   * @param limit_count The number of rows that should be returned.
   * @param The offset of the first row that should appear in the result. (note that
   * this feature may not be supported by all the database providers.)
  */
  void select_set_limit(Id limit_count, Id offset = 0);

  
  void select_set_limit_id(Id limit_count_expr_id, Id limit_offest_expr_id = 0);

  
  void select_set_having(Id cond_id);

  
  void select_group_by(Id expr_id);
  //TODO: Add select_group_by_field()?

  // General Statement API
  
  void set_table(const Glib::ustring& table_name);
  
  void set_where(Id cond_id);

  
  void add_field_value_id(Id field_id, Id value_id = 0);

  //TODO: Documentation:
  template <class ValueType>
  void add_field_value(const Glib::ustring& field_name, const ValueType& value);

  
  void add_field_value_as_value(const Glib::ustring& field_name, const Value& value);
  

/* COMPOUND SELECT Statement API */
  //TODO: Wrap the enum when we wrap GdaSqlStatementCompound _WRAP_METHOD(void compound_set_type(SqlStatementCompoundType compound_type), gda_sql_builder_compound_set_type)
  
  void compound_add_sub_select(const SqlStatement& sqlst);

  
  SqlExpr export_expression(Id id) const;

  Id import_expression(const SqlExpr& expr);
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class ValueType> inline
void SqlBuilder::add_field_value(const Glib::ustring& field_name, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  this->add_field_value_as_value(field_name, gdavalue);
}

template <class ValueType> inline
SqlBuilder::Id SqlBuilder::add_expr(const Glib::RefPtr<DataHandler>& dh, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  return this->add_expr_as_value(dh, gdavalue);
}

template <class ValueType> inline
SqlBuilder::Id SqlBuilder::add_expr(const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  return this->add_expr_as_value(gdavalue);
}

#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::SqlBuilder
   */
  Glib::RefPtr<Gnome::Gda::SqlBuilder> wrap(GdaSqlBuilder* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SQLBUILDER_H */

