// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODELITER_H
#define _LIBGDAMM_DATAMODELITER_H


#include <glibmm.h>

// -*- C++ -*- //

/* datamodeliter.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/set.h>
#include <libgdamm/value.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModelIter GdaDataModelIter;
typedef struct _GdaDataModelIterClass GdaDataModelIterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModelIter_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class DataModelIterError : public Glib::Error
{
public:
  enum Code
  {
    DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_ERROR
  };

  DataModelIterError(Code error_code, const Glib::ustring& error_message);
  explicit DataModelIterError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelIterError::Code> : public Glib::Value_Enum<Gnome::Gda::DataModelIterError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Data model iterator.
 *
 * A Gda::DataModelIter object is used to iterate through the rows of a Gda::DataModel. 
 * If the data model is accessible in a random access way then any number of Gda::DataModelIter 
 * objects can be created on the same data model, and if the data model only supports a cursor 
 * based access then only one Gda::DataModelIter can be created. In any case creating a 
 * Gda::DataModelIter should be done using the create_iter() method. 
 *
 * When a Gda::DataModelIter is valid (that is when it points to an existing row in the data model it iterates through), 
 * the individual values (corresponding to each column of the data model, at the pointer row) 
 * can be accessed using the get_value_at() or 
 * get_value_for_field() methods (or in the same way Gda::Set's values are 
 * accessed as Gda::DataModelIter inherits the Gda::Set).
 *
 * Right after being created, a Gda::DataModelIter is invalid (does not point to any row of its data model).
 * To read the first row of the data model, use the move_next() method. 
 * Calling this method several times will move the iterator forward, up to when the data model has 
 * no more rows and the Gda::DataModelIter will be declared invalid (and move_next() 
 * has returned FALSE). Note that at this point, the number of rows in the data model will be known.
 *
 * If the data model supports it, a Gda::DataModelIter can be moved backwards using the 
 * move_prev() method. However if the iterator is invalid, moving backwards will 
 * not be possible (on the contrary to move_next() which moves to the first row).
 *
 * The move_to_row() method, if the iterator can be moved both forward and backwards,
 * can move the iterator to a specific row (sometimes faster than moving it forward or backwards a number of times).
 *
 * @ingroup DataModels
 */

class DataModelIter
 : public Set
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModelIter CppObjectType;
  typedef DataModelIter_Class CppClassType;
  typedef GdaDataModelIter BaseObjectType;
  typedef GdaDataModelIterClass BaseClassType;

private:  friend class DataModelIter_Class;
  static CppClassType datamodeliter_class_;

private:
  // noncopyable
  DataModelIter(const DataModelIter&);
  DataModelIter& operator=(const DataModelIter&);

protected:
  explicit DataModelIter(const Glib::ConstructParams& construct_params);
  explicit DataModelIter(GdaDataModelIter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModelIter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModelIter*       gobj()       { return reinterpret_cast<GdaDataModelIter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataModelIter* gobj() const { return reinterpret_cast<GdaDataModelIter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataModelIter* gobj_copy();

private:

protected:
  explicit DataModelIter(const Glib::RefPtr<DataModel>& data_model);

public:
  
  static Glib::RefPtr<DataModelIter> create(const Glib::RefPtr<DataModel>& data_model);


  /** Tells if @a iter is a valid iterator (if it actually corresponds to a valid row in the model)
   * @return <tt>true</tt> if @a iter is valid.
   */
  bool is_valid() const;
  
  /** Moves @a iter one row further than where it already is 
   * (synchronizes the values of the parameters in @a iter with the values at the new row).
   * 
   * If the iterator was on the data model's last row, then it can't be moved forward
   * anymore, and the returned value is <tt>false</tt>; nore also that the "current-row" property
   * is set to -1 (which means that is_valid() would return <tt>false</tt>)
   * 
   * If any other error occurred then the returned value is <tt>false</tt>, but the "current-row"
   * property is set to the new current row (one row more than it was before the call). In this case
   * each Gda::Holder composing @a iter for which an error occurred will be invalid (see Gda::Holder::is_valid()).
   * @return <tt>true</tt> if the iterator is now at the next row.
   */
  bool move_next();
  
  /** Moves @a iter one row before where it already is (synchronizes the values of the parameters in @a iter 
   * with the values at the new row).
   * 
   * If the iterator was on the data model's first row, then it can't be moved backwards
   * anymore, and the returned value is <tt>false</tt>; note also that the "current-row" property
   * is set to -1 (which means that is_valid() would return <tt>false</tt>).
   * 
   * If any other error occurred then the returned value is <tt>false</tt>, but the "current-row"
   * property is set to the new current row (one row less than it was before the call).  In this case
   * each Gda::Holder composing @a iter for which an error occurred will be invalid (see Gda::Holder::is_valid()).
   * @return <tt>true</tt> if the iterator is now at the previous row.
   */
  bool move_prev();
  
  /** Synchronizes the values of the parameters in @a iter with the values at the @a row row.
   * 
   * If @a row is not a valid row, then the returned value is <tt>false</tt>, and the "current-row"
   * property is set to -1 (which means that is_valid() would return <tt>false</tt>)
   * 
   * If any other error occurred then the returned value is <tt>false</tt>, but the "current-row"
   * property is set to the @a row row.  In this case
   * each Gda::Holder composing @a iter for which an error occurred will be invalid (see Gda::Holder::is_valid()).
   * @param row The row to set @a iter to.
   * @return <tt>true</tt> if no error occurred.
   */
  bool move_to_row(int row);
  
  /** Get the row which @a iter represents in the data model
   * @return The row number, or -1 if @a iter is invalid.
   */
  int get_row() const;
  
  /** Declare all the parameters in @a iter invalid, without modifying the
   * Gda::DataModel @a iter is for or changing the row it represents. This method
   * is for internal usage. Note that for is_valid() to return <tt>false</tt>,
   * it is also necessary to set the "current-row" property to -1.
   */
  void invalidate_contents();
    
  
  /** Fetch a pointer to the Gda::Holder object which is synchronized with data at 
   * column @a col
   * @param col The requested column.
   * @return The Gda::Holder, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Holder> get_holder_for_field(int col);
  
  /** Fetch a pointer to the Gda::Holder object which is synchronized with data at 
   * column @a col
   * @param col The requested column.
   * @return The Gda::Holder, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<const Holder> get_holder_for_field(int col) const;

  
  /** Get the value stored at the column @a col in @a iter. The returned value must not be modified.
   * @param col The requested column.
   * @return The Value, or <tt>0</tt> if the value could not be fetched.
   */
  Value get_value_at(int col) const;
  
  /** Get the value stored at the column @a field_name in @a iter
   * @param field_name The requested column name.
   * @return The Value, or <tt>0</tt>.
   */
  Value get_value_for_field(const Glib::ustring& field_name) const;
  
  /** Sets a value in @a iter, at the column specified by @a col
   * @param col The column number.
   * @param value A Value (not <tt>0</tt>).
   * @return <tt>true</tt> if no error occurred.
   */
  bool set_value_at(int col, const Value& value);
    
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current represented row in the data model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_current_row() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current represented row in the data model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_current_row() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Data model for which the iter is for.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > property_data_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Overrides the data model the iter is attached to (reserved for internal usage).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<DataModel> > property_forced_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Overrides the data model the iter is attached to (reserved for internal usage).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DataModel> > property_forced_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_update_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_update_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%end_of_data()</tt>
   */

  Glib::SignalProxy0< void > signal_end_of_data();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%row_changed(int row)</tt>
   */

  Glib::SignalProxy1< void,int > signal_row_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_end_of_data();
  virtual void on_row_changed(int row);


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::DataModelIter
   */
  Glib::RefPtr<Gnome::Gda::DataModelIter> wrap(GdaDataModelIter* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAMODELITER_H */

