/* priorityqueue.c generated by valac, the Vala compiler
 * generated from priorityqueue.vala, do not modify */

/* priorityqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_PRIORITY_QUEUE (gee_priority_queue_get_type ())
#define GEE_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue))
#define GEE_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))
#define GEE_IS_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_IS_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_PRIORITY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))

typedef struct _GeePriorityQueue GeePriorityQueue;
typedef struct _GeePriorityQueueClass GeePriorityQueueClass;
typedef struct _GeePriorityQueuePrivate GeePriorityQueuePrivate;

#define GEE_PRIORITY_QUEUE_TYPE_NODE (gee_priority_queue_node_get_type ())
#define GEE_PRIORITY_QUEUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode))
#define GEE_PRIORITY_QUEUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))
#define GEE_PRIORITY_QUEUE_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))

typedef struct _GeePriorityQueueNode GeePriorityQueueNode;
typedef struct _GeePriorityQueueNodeClass GeePriorityQueueNodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE (gee_priority_queue_type1_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))

typedef struct _GeePriorityQueueType1Node GeePriorityQueueType1Node;
typedef struct _GeePriorityQueueType1NodeClass GeePriorityQueueType1NodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE (gee_priority_queue_type2_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2Node))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))

typedef struct _GeePriorityQueueType2Node GeePriorityQueueType2Node;
typedef struct _GeePriorityQueueType2NodeClass GeePriorityQueueType2NodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR (gee_priority_queue_node_pair_get_type ())
#define GEE_PRIORITY_QUEUE_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePair))
#define GEE_PRIORITY_QUEUE_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairClass))
#define GEE_PRIORITY_QUEUE_IS_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR))
#define GEE_PRIORITY_QUEUE_IS_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR))
#define GEE_PRIORITY_QUEUE_NODE_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairClass))

typedef struct _GeePriorityQueueNodePair GeePriorityQueueNodePair;
typedef struct _GeePriorityQueueNodePairClass GeePriorityQueueNodePairClass;
#define _gee_priority_queue_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_unref (var), NULL)))
#define _gee_priority_queue_node_pair_unref0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_pair_unref (var), NULL)))
typedef struct _GeePriorityQueueNodePrivate GeePriorityQueueNodePrivate;
typedef struct _GeePriorityQueueType1NodePrivate GeePriorityQueueType1NodePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_PRIORITY_QUEUE_TYPE_ITERATOR (gee_priority_queue_iterator_get_type ())
#define GEE_PRIORITY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator))
#define GEE_PRIORITY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))

typedef struct _GeePriorityQueueIterator GeePriorityQueueIterator;
typedef struct _GeePriorityQueueIteratorClass GeePriorityQueueIteratorClass;
typedef struct _GeePriorityQueueNodePairPrivate GeePriorityQueueNodePairPrivate;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeePriorityQueueParamSpecNode GeePriorityQueueParamSpecNode;
typedef struct _GeePriorityQueueType2NodePrivate GeePriorityQueueType2NodePrivate;
typedef struct _GeePriorityQueueParamSpecNodePair GeePriorityQueueParamSpecNodePair;
typedef struct _GeePriorityQueueIteratorPrivate GeePriorityQueueIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gboolean (*offer) (GeeAbstractQueue* self, gconstpointer element);
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	gint (*drain) (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeePriorityQueue {
	GeeAbstractQueue parent_instance;
	GeePriorityQueuePrivate * priv;
};

struct _GeePriorityQueueClass {
	GeeAbstractQueueClass parent_class;
};

struct _GeePriorityQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	gint _stamp;
	GeePriorityQueueType1Node* _r;
	GeePriorityQueueType2Node* _r_prime;
	GeePriorityQueueType2Node* _lm_head;
	GeePriorityQueueType2Node* _lm_tail;
	GeePriorityQueueType1Node* _p;
	GeePriorityQueueType1Node** _a;
	gint _a_length1;
	gint __a_size_;
	GeePriorityQueueNodePair* _lp_head;
	GeePriorityQueueNodePair* _lp_tail;
	gboolean* _b;
	gint _b_length1;
	gint __b_size_;
	GeePriorityQueueType1Node* _ll_head;
	GeePriorityQueueType1Node* _ll_tail;
};

struct _GeePriorityQueueNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePriorityQueueNodePrivate * priv;
	gpointer data;
	GeePriorityQueueNode* parent;
	gint type1_children_count;
	GeePriorityQueueType1Node* type1_children_head;
	GeePriorityQueueType1Node* type1_children_tail;
	gboolean pending_drop;
};

struct _GeePriorityQueueNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeePriorityQueueNode *self);
};

struct _GeePriorityQueueType1Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType1NodePrivate * priv;
	guint lost;
	GeePriorityQueueType1Node* brothers_prev;
	GeePriorityQueueType1Node* brothers_next;
	GeePriorityQueueType2Node* type2_child;
	GeePriorityQueueType1Node* ll_prev;
	GeePriorityQueueType1Node* ll_next;
	GeePriorityQueueNodePair* pair;
};

struct _GeePriorityQueueType1NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueNodePair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePriorityQueueNodePairPrivate * priv;
	GeePriorityQueueNodePair* lp_prev;
	GeePriorityQueueNodePair* lp_next;
	GeePriorityQueueType1Node* node1;
	GeePriorityQueueType1Node* node2;
};

struct _GeePriorityQueueNodePairClass {
	GTypeClass parent_class;
	void (*finalize) (GeePriorityQueueNodePair *self);
};

struct _GeePriorityQueueNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueParamSpecNode {
	GParamSpec parent_instance;
};

struct _GeePriorityQueueType1NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueType2Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType2NodePrivate * priv;
};

struct _GeePriorityQueueType2NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueType2NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueNodePairPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueParamSpecNodePair {
	GParamSpec parent_instance;
};

struct _GeePriorityQueueIterator {
	GObject parent_instance;
	GeePriorityQueueIteratorPrivate * priv;
};

struct _GeePriorityQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeePriorityQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeePriorityQueue* queue;
	gboolean started;
	gboolean from_type1_children;
	gboolean from_type2_child;
	GeePriorityQueueNode* position;
	GeePriorityQueueNode* _next;
	gint stamp;
	gboolean removed;
};


static gpointer gee_priority_queue_node_parent_class = NULL;
static gpointer gee_priority_queue_type1_node_parent_class = NULL;
static gpointer gee_priority_queue_type2_node_parent_class = NULL;
static gpointer gee_priority_queue_node_pair_parent_class = NULL;
static gpointer gee_priority_queue_iterator_parent_class = NULL;
static GeeIteratorIface* gee_priority_queue_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_priority_queue_parent_class = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_queue_get_type (void);
GType gee_abstract_queue_get_type (void);
GType gee_priority_queue_get_type (void);
static gpointer gee_priority_queue_node_ref (gpointer instance);
static void gee_priority_queue_node_unref (gpointer instance);
static GParamSpec* gee_priority_queue_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gee_priority_queue_value_set_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gee_priority_queue_value_take_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_priority_queue_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType gee_priority_queue_node_get_type (void) G_GNUC_UNUSED;
static GType gee_priority_queue_type1_node_get_type (void) G_GNUC_UNUSED;
static GType gee_priority_queue_type2_node_get_type (void) G_GNUC_UNUSED;
static gpointer gee_priority_queue_node_pair_ref (gpointer instance);
static void gee_priority_queue_node_pair_unref (gpointer instance);
static GParamSpec* gee_priority_queue_param_spec_node_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gee_priority_queue_value_set_node_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gee_priority_queue_value_take_node_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_priority_queue_value_get_node_pair (const GValue* value) G_GNUC_UNUSED;
static GType gee_priority_queue_node_pair_get_type (void) G_GNUC_UNUSED;
#define GEE_PRIORITY_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueuePrivate))
enum  {
	GEE_PRIORITY_QUEUE_DUMMY_PROPERTY,
	GEE_PRIORITY_QUEUE_COMPARE_FUNC,
	GEE_PRIORITY_QUEUE_CAPACITY,
	GEE_PRIORITY_QUEUE_REMAINING_CAPACITY,
	GEE_PRIORITY_QUEUE_IS_FULL,
	GEE_PRIORITY_QUEUE_SIZE,
	GEE_PRIORITY_QUEUE_G_TYPE,
	GEE_PRIORITY_QUEUE_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_G_DESTROY_FUNC
};
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_priority_queue_set_compare_func (GeePriorityQueue* self, GCompareFunc value);
GeePriorityQueue* gee_priority_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeePriorityQueue* gee_priority_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static void _gee_priority_queue_add (GeePriorityQueue* self, GeePriorityQueueType1Node* n);
static gboolean gee_priority_queue_real_offer (GeeAbstractQueue* base, gconstpointer element);
static gpointer gee_priority_queue_real_peek (GeeAbstractQueue* base);
static void _gee_priority_queue_remove_type2_node (GeePriorityQueue* self, GeePriorityQueueType2Node* node);
static inline gint _gee_priority_queue_compare (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2);
static void _gee_priority_queue_remove_type1_node (GeePriorityQueue* self, GeePriorityQueueType1Node* node);
static void _gee_priority_queue_add_in_r_prime (GeePriorityQueue* self, GeePriorityQueueType1Node* node);
static void _gee_priority_queue_adjust (GeePriorityQueue* self, GeePriorityQueueType1Node* p1, GeePriorityQueueType1Node* p2);
static gboolean _gee_priority_queue_check_linkable (GeePriorityQueue* self);
static gpointer gee_priority_queue_real_poll (GeeAbstractQueue* base);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gpointer gee_abstract_queue_poll (GeeAbstractQueue* self);
static gint gee_priority_queue_real_drain (GeeAbstractQueue* base, GeeCollection* recipient, gint amount);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
GCompareFunc gee_priority_queue_get_compare_func (GeePriorityQueue* self);
static gboolean gee_priority_queue_real_contains (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_queue_offer (GeeAbstractQueue* self, gconstpointer element);
static gboolean gee_priority_queue_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeePriorityQueueIterator* gee_priority_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue);
static GeePriorityQueueIterator* gee_priority_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue);
static GType gee_priority_queue_iterator_get_type (void) G_GNUC_UNUSED;
static void _gee_priority_queue_delete (GeePriorityQueue* self, GeePriorityQueueNode* n);
static GeePriorityQueueNode* gee_priority_queue_iterator_get_node (GeePriorityQueueIterator* self);
static gboolean gee_priority_queue_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_priority_queue_real_clear (GeeAbstractCollection* base);
static GeeIterator* gee_priority_queue_real_iterator (GeeAbstractCollection* base);
static inline void _gee_priority_queue_swap_data (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2);
static inline gint gee_priority_queue_node_degree (GeePriorityQueueNode* self);
static void _gee_priority_queue_add_to (GeePriorityQueue* self, GeePriorityQueueType1Node* node, GeePriorityQueueType1Node* parent);
static void _gee_priority_queue_link (GeePriorityQueue* self, GeePriorityQueueType1Node* ri, GeePriorityQueueType1Node* rj);
static GeePriorityQueueNode* _gee_priority_queue_re_insert (GeePriorityQueue* self, GeePriorityQueueType1Node* n);
static void _gee_priority_queue_decrease_key (GeePriorityQueue* self, GeePriorityQueueNode* n);
static inline void gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self, GeePriorityQueueType1Node* node);
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2);
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2);
static void _gee_priority_queue_updated_degree (GeePriorityQueue* self, GeePriorityQueueType1Node* node, gboolean child_removed);
static inline void gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_PRIORITY_QUEUE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_NODE_DUMMY_PROPERTY
};
static GeePriorityQueueNode* gee_priority_queue_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static void gee_priority_queue_node_finalize (GeePriorityQueueNode* obj);
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_TYPE1_NODE_DUMMY_PROPERTY
};
static void gee_priority_queue_type1_node_finalize (GeePriorityQueueNode* obj);
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_TYPE2_NODE_DUMMY_PROPERTY
};
#define GEE_PRIORITY_QUEUE_NODE_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairPrivate))
enum  {
	GEE_PRIORITY_QUEUE_NODE_PAIR_DUMMY_PROPERTY
};
static void gee_priority_queue_node_pair_finalize (GeePriorityQueueNodePair* obj);
#define GEE_PRIORITY_QUEUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorPrivate))
enum  {
	GEE_PRIORITY_QUEUE_ITERATOR_DUMMY_PROPERTY,
	GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC
};
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_priority_queue_iterator_real_next (GeeIterator* base);
static gboolean _gee_priority_queue_iterator_has_next (GeePriorityQueueIterator* self);
static gboolean gee_priority_queue_iterator_real_has_next (GeeIterator* base);
static gboolean gee_priority_queue_iterator_real_first (GeeIterator* base);
static gpointer gee_priority_queue_iterator_real_get (GeeIterator* base);
static void gee_priority_queue_iterator_real_remove (GeeIterator* base);
static void gee_priority_queue_iterator_finalize (GObject* obj);
static void gee_priority_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_priority_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_priority_queue_finalize (GObject* obj);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void gee_priority_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_priority_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



GeePriorityQueue* gee_priority_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	GeePriorityQueue * self;
	self = (GeePriorityQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (compare_func == NULL) {
		compare_func = gee_functions_get_compare_func_for (g_type);
	}
	gee_priority_queue_set_compare_func (self, compare_func);
	return self;
}


GeePriorityQueue* gee_priority_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	return gee_priority_queue_construct (GEE_TYPE_PRIORITY_QUEUE, g_type, g_dup_func, g_destroy_func, compare_func);
}


static gpointer _gee_priority_queue_node_ref0 (gpointer self) {
	return self ? gee_priority_queue_node_ref (self) : NULL;
}


static gboolean gee_priority_queue_real_offer (GeeAbstractQueue* base, gconstpointer element) {
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	if (self->priv->_r == NULL) {
		GeePriorityQueueType1Node* _tmp0_;
		GeePriorityQueueType1Node* _tmp1_;
		self->priv->_r = (_tmp0_ = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element), _gee_priority_queue_node_unref0 (self->priv->_r), _tmp0_);
		self->priv->_p = (_tmp1_ = _gee_priority_queue_node_ref0 (self->priv->_r), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp1_);
	} else {
		if (self->priv->_r_prime == NULL) {
			GeePriorityQueueType2Node* _tmp2_;
			GeePriorityQueueType2Node* _tmp3_;
			self->priv->_r_prime = (_tmp2_ = gee_priority_queue_type2_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element), _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp2_);
			((GeePriorityQueueNode*) self->priv->_r_prime)->parent = (GeePriorityQueueNode*) self->priv->_r;
			self->priv->_r->type2_child = (_tmp3_ = _gee_priority_queue_node_ref0 (self->priv->_r_prime), _gee_priority_queue_node_unref0 (self->priv->_r->type2_child), _tmp3_);
		} else {
			GeePriorityQueueType1Node* node;
			node = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element);
			_gee_priority_queue_add (self, node);
			_gee_priority_queue_node_unref0 (node);
		}
	}
	self->priv->_stamp++;
	self->priv->_size++;
	result = TRUE;
	return result;
}


static gpointer gee_priority_queue_real_peek (GeeAbstractQueue* base) {
	GeePriorityQueue * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeePriorityQueue*) base;
	if (self->priv->_r == NULL) {
		result = NULL;
		return result;
	}
	result = (_tmp0_ = ((GeePriorityQueueNode*) self->priv->_r)->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static gpointer gee_priority_queue_real_poll (GeeAbstractQueue* base) {
	GeePriorityQueue * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gpointer min;
	gpointer _tmp4_;
	gconstpointer _tmp3_;
	GeePriorityQueueType1Node* r_second;
	GeePriorityQueueType1Node* node;
	gpointer _tmp10_;
	gconstpointer _tmp9_;
	GeePriorityQueueType1Node* _tmp11_;
	self = (GeePriorityQueue*) base;
	if (self->priv->_r == NULL) {
		result = NULL;
		return result;
	}
	min = (_tmp0_ = ((GeePriorityQueueNode*) self->priv->_r)->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	((GeePriorityQueueNode*) self->priv->_r)->pending_drop = FALSE;
	self->priv->_stamp++;
	self->priv->_size--;
	if (self->priv->_r_prime == NULL) {
		GeePriorityQueueType1Node* _tmp1_;
		GeePriorityQueueType1Node* _tmp2_;
		self->priv->_r = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r), _tmp1_);
		self->priv->_p = (_tmp2_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp2_);
		result = min;
		return result;
	}
	((GeePriorityQueueNode*) self->priv->_r)->data = (_tmp4_ = (_tmp3_ = ((GeePriorityQueueNode*) self->priv->_r_prime)->data, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), ((((GeePriorityQueueNode*) self->priv->_r)->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (((GeePriorityQueueNode*) self->priv->_r)->data = (self->priv->g_destroy_func (((GeePriorityQueueNode*) self->priv->_r)->data), NULL)), _tmp4_);
	if (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head == NULL) {
		GeePriorityQueueType2Node* _tmp5_;
		_gee_priority_queue_remove_type2_node (self, self->priv->_r_prime);
		self->priv->_r_prime = (_tmp5_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp5_);
		result = min;
		return result;
	}
	r_second = NULL;
	node = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head);
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		GeePriorityQueueType1Node* _tmp8_;
		if (!(node != NULL)) {
			break;
		}
		if (r_second == NULL) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) node, (GeePriorityQueueNode*) r_second) < 0;
		}
		if (_tmp6_) {
			GeePriorityQueueType1Node* _tmp7_;
			r_second = (_tmp7_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (r_second), _tmp7_);
		}
		node = (_tmp8_ = _gee_priority_queue_node_ref0 (node->brothers_next), _gee_priority_queue_node_unref0 (node), _tmp8_);
	}
	((GeePriorityQueueNode*) self->priv->_r_prime)->data = (_tmp10_ = (_tmp9_ = ((GeePriorityQueueNode*) r_second)->data, ((_tmp9_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp9_) : self->priv->g_dup_func ((gpointer) _tmp9_)), ((((GeePriorityQueueNode*) self->priv->_r_prime)->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (((GeePriorityQueueNode*) self->priv->_r_prime)->data = (self->priv->g_destroy_func (((GeePriorityQueueNode*) self->priv->_r_prime)->data), NULL)), _tmp10_);
	_gee_priority_queue_remove_type1_node (self, r_second);
	node = (_tmp11_ = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) r_second)->type1_children_head), _gee_priority_queue_node_unref0 (node), _tmp11_);
	while (TRUE) {
		GeePriorityQueueType1Node* next;
		GeePriorityQueueType1Node* _tmp12_;
		if (!(node != NULL)) {
			break;
		}
		next = _gee_priority_queue_node_ref0 (node->brothers_next);
		_gee_priority_queue_remove_type1_node (self, node);
		_gee_priority_queue_add_in_r_prime (self, node);
		node = (_tmp12_ = _gee_priority_queue_node_ref0 (next), _gee_priority_queue_node_unref0 (node), _tmp12_);
		_gee_priority_queue_node_unref0 (next);
	}
	if (self->priv->_p == NULL) {
		GeePriorityQueueType1Node* _tmp13_;
		self->priv->_p = (_tmp13_ = _gee_priority_queue_node_ref0 (self->priv->_r), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp13_);
	}
	_gee_priority_queue_adjust (self, self->priv->_p, self->priv->_p);
	while (TRUE) {
		if (!_gee_priority_queue_check_linkable (self)) {
			break;
		}
	}
	result = min;
	_gee_priority_queue_node_unref0 (r_second);
	_gee_priority_queue_node_unref0 (node);
	return result;
}


static gint gee_priority_queue_real_drain (GeeAbstractQueue* base, GeeCollection* recipient, gint amount) {
	GeePriorityQueue * self;
	gint result = 0;
	self = (GeePriorityQueue*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == (-1)) {
		amount = self->priv->_size;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				gee_collection_add (recipient, _tmp1_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self));
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
	return result;
}


static gboolean gee_priority_queue_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	{
		GeeIterator* _an_item_it;
		_an_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		while (TRUE) {
			gpointer an_item;
			if (!gee_iterator_next (_an_item_it)) {
				break;
			}
			an_item = gee_iterator_get (_an_item_it);
			if (gee_priority_queue_get_compare_func (self) (item, an_item) == 0) {
				result = TRUE;
				((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
				_g_object_unref0 (_an_item_it);
				return result;
			}
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
		}
		_g_object_unref0 (_an_item_it);
	}
	result = FALSE;
	return result;
}


static gboolean gee_priority_queue_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeePriorityQueue * self;
	gboolean result = FALSE;
	self = (GeePriorityQueue*) base;
	result = gee_abstract_queue_offer ((GeeAbstractQueue*) self, item);
	return result;
}


static gboolean gee_priority_queue_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeePriorityQueue * self;
	gboolean result = FALSE;
	GeePriorityQueueIterator* iterator;
	self = (GeePriorityQueue*) base;
	iterator = gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	while (TRUE) {
		gpointer an_item;
		if (!gee_iterator_next ((GeeIterator*) iterator)) {
			break;
		}
		an_item = gee_iterator_get ((GeeIterator*) iterator);
		if (gee_priority_queue_get_compare_func (self) (item, an_item) == 0) {
			GeePriorityQueueNode* _tmp0_;
			_gee_priority_queue_delete (self, _tmp0_ = gee_priority_queue_iterator_get_node (iterator));
			_gee_priority_queue_node_unref0 (_tmp0_);
			result = TRUE;
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
			_g_object_unref0 (iterator);
			return result;
		}
		((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
	}
	result = FALSE;
	_g_object_unref0 (iterator);
	return result;
}


static void gee_priority_queue_real_clear (GeeAbstractCollection* base) {
	GeePriorityQueue * self;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType2Node* _tmp1_;
	GeePriorityQueueType2Node* _tmp2_;
	GeePriorityQueueType2Node* _tmp3_;
	GeePriorityQueueType1Node* _tmp4_;
	GeePriorityQueueType1Node** _tmp5_;
	GeePriorityQueueNodePair* _tmp6_;
	GeePriorityQueueNodePair* _tmp7_;
	gboolean* _tmp8_;
	GeePriorityQueueType1Node* _tmp9_;
	GeePriorityQueueType1Node* _tmp10_;
	self = (GeePriorityQueue*) base;
	self->priv->_size = 0;
	self->priv->_r = (_tmp0_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r), _tmp0_);
	self->priv->_r_prime = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp1_);
	self->priv->_lm_head = (_tmp2_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_lm_head), _tmp2_);
	self->priv->_lm_tail = (_tmp3_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_lm_tail), _tmp3_);
	self->priv->_p = (_tmp4_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp4_);
	self->priv->_a = (_tmp5_ = g_new0 (GeePriorityQueueType1Node*, 0 + 1), self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL), self->priv->_a_length1 = 0, self->priv->__a_size_ = self->priv->_a_length1, _tmp5_);
	self->priv->_lp_head = (_tmp6_ = NULL, _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp6_);
	self->priv->_lp_tail = (_tmp7_ = NULL, _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp7_);
	self->priv->_b = (_tmp8_ = g_new0 (gboolean, 0), self->priv->_b = (g_free (self->priv->_b), NULL), self->priv->_b_length1 = 0, self->priv->__b_size_ = self->priv->_b_length1, _tmp8_);
	self->priv->_ll_head = (_tmp9_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp9_);
	self->priv->_ll_tail = (_tmp10_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp10_);
}


static GeeIterator* gee_priority_queue_real_iterator (GeeAbstractCollection* base) {
	GeePriorityQueue * self;
	GeeIterator* result = NULL;
	self = (GeePriorityQueue*) base;
	result = (GeeIterator*) gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static inline gint _gee_priority_queue_compare (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node1 != NULL, 0);
	g_return_val_if_fail (node2 != NULL, 0);
	if (node1->pending_drop) {
		result = -1;
		return result;
	} else {
		if (node2->pending_drop) {
			result = 1;
			return result;
		} else {
			result = gee_priority_queue_get_compare_func (self) (node1->data, node2->data);
			return result;
		}
	}
}


static inline void _gee_priority_queue_swap_data (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2) {
	gpointer _tmp0_;
	gpointer temp_data;
	gboolean temp_pending_drop;
	gpointer _tmp2_;
	gpointer _tmp1_;
	gpointer _tmp4_;
	gpointer _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node1 != NULL);
	g_return_if_fail (node2 != NULL);
	temp_data = (_tmp0_ = node1->data, node1->data = NULL, _tmp0_);
	temp_pending_drop = node1->pending_drop;
	node1->data = (_tmp2_ = (_tmp1_ = node2->data, node2->data = NULL, _tmp1_), ((node1->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node1->data = (self->priv->g_destroy_func (node1->data), NULL)), _tmp2_);
	node1->pending_drop = node2->pending_drop;
	node2->data = (_tmp4_ = (_tmp3_ = temp_data, temp_data = NULL, _tmp3_), ((node2->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node2->data = (self->priv->g_destroy_func (node2->data), NULL)), _tmp4_);
	node2->pending_drop = temp_pending_drop;
	((temp_data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (temp_data = (self->priv->g_destroy_func (temp_data), NULL));
}


static void _gee_priority_queue_link (GeePriorityQueue* self, GeePriorityQueueType1Node* ri, GeePriorityQueueType1Node* rj) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ri != NULL);
	g_return_if_fail (rj != NULL);
	g_assert (gee_priority_queue_node_degree ((GeePriorityQueueNode*) ri) == gee_priority_queue_node_degree ((GeePriorityQueueNode*) rj));
	_gee_priority_queue_remove_type1_node (self, ri);
	_gee_priority_queue_remove_type1_node (self, rj);
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) ri, (GeePriorityQueueNode*) rj) > 0) {
		GeePriorityQueueType1Node* temp;
		temp = _gee_priority_queue_node_ref0 (ri);
		ri = rj;
		rj = temp;
		_gee_priority_queue_node_unref0 (temp);
	}
	_gee_priority_queue_add_to (self, rj, ri);
	_gee_priority_queue_add_in_r_prime (self, ri);
}


static void _gee_priority_queue_add (GeePriorityQueue* self, GeePriorityQueueType1Node* n) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_gee_priority_queue_add_in_r_prime (self, n);
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) self->priv->_r_prime) < 0) {
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) self->priv->_r_prime);
	}
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r) < 0) {
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r);
	}
	_gee_priority_queue_check_linkable (self);
}


static gpointer _gee_priority_queue_node_pair_ref0 (gpointer self) {
	return self ? gee_priority_queue_node_pair_ref (self) : NULL;
}


static gboolean _gee_priority_queue_check_linkable (GeePriorityQueue* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_lp_head != NULL) {
		GeePriorityQueueNodePair* pair;
		pair = _gee_priority_queue_node_pair_ref0 (self->priv->_lp_head);
		_gee_priority_queue_link (self, pair->node1, pair->node2);
		result = TRUE;
		_gee_priority_queue_node_pair_unref0 (pair);
		return result;
	}
	result = FALSE;
	return result;
}


static GeePriorityQueueNode* _gee_priority_queue_re_insert (GeePriorityQueue* self, GeePriorityQueueType1Node* n) {
	GeePriorityQueueNode* result = NULL;
	GeePriorityQueueNode* parent;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	g_assert (n != self->priv->_r);
	parent = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) n)->parent);
	_gee_priority_queue_remove_type1_node (self, n);
	_gee_priority_queue_add (self, n);
	result = parent;
	return result;
}


static void _gee_priority_queue_adjust (GeePriorityQueue* self, GeePriorityQueueType1Node* p1, GeePriorityQueueType1Node* p2) {
	GeePriorityQueueType1Node* m;
	GeePriorityQueueType1Node* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p1 != NULL);
	g_return_if_fail (p2 != NULL);
	if (self->priv->_ll_head == NULL) {
		return;
	}
	m = NULL;
	if (p1->lost > p2->lost) {
		GeePriorityQueueType1Node* _tmp0_;
		m = (_tmp0_ = _gee_priority_queue_node_ref0 (p1), _gee_priority_queue_node_unref0 (m), _tmp0_);
	} else {
		GeePriorityQueueType1Node* _tmp1_;
		m = (_tmp1_ = _gee_priority_queue_node_ref0 (p2), _gee_priority_queue_node_unref0 (m), _tmp1_);
	}
	if (m->lost <= 1) {
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
		m = (_tmp2_ = _gee_priority_queue_node_ref0 (self->priv->_ll_head), _gee_priority_queue_node_unref0 (m), _tmp2_);
		if (self->priv->_ll_head->ll_next != NULL) {
			self->priv->_ll_head->ll_next->ll_prev = NULL;
		}
		self->priv->_ll_head = (_tmp3_ = _gee_priority_queue_node_ref0 (self->priv->_ll_head->ll_next), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp3_);
	}
	self->priv->_p = (_tmp4_ = GEE_PRIORITY_QUEUE_TYPE1_NODE (_gee_priority_queue_re_insert (self, m)), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp4_);
	_gee_priority_queue_node_unref0 (m);
}


static void _gee_priority_queue_delete (GeePriorityQueue* self, GeePriorityQueueNode* n) {
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_gee_priority_queue_decrease_key (self, n);
	_tmp0_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self);
	((_tmp0_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_ = (self->priv->g_destroy_func (_tmp0_), NULL));
}


static void _gee_priority_queue_decrease_key (GeePriorityQueue* self, GeePriorityQueueNode* n) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeePriorityQueueNode* p_prime;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	if (n == GEE_PRIORITY_QUEUE_NODE (self->priv->_r)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_r_prime == NULL;
	}
	if (_tmp0_) {
		return;
	}
	n->pending_drop = TRUE;
	if (n == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
		_tmp1_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r) < 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r);
		return;
	}
	p_prime = _gee_priority_queue_re_insert (self, GEE_PRIORITY_QUEUE_TYPE1_NODE (n));
	if (GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (p_prime)) {
		_gee_priority_queue_adjust (self, self->priv->_p, self->priv->_p);
	} else {
		_gee_priority_queue_adjust (self, self->priv->_p, GEE_PRIORITY_QUEUE_TYPE1_NODE (p_prime));
	}
	_gee_priority_queue_node_unref0 (p_prime);
}


static void _gee_priority_queue_add_to (GeePriorityQueue* self, GeePriorityQueueType1Node* node, GeePriorityQueueType1Node* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (parent != NULL);
	gee_priority_queue_type1_node_add (parent, node);
	parent->lost = (guint) 0;
}


static void _gee_priority_queue_add_in_r_prime (GeePriorityQueue* self, GeePriorityQueueType1Node* node) {
	gint degree;
	GeePriorityQueueType1Node* insertion_point;
	GeePriorityQueueType1Node* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
	insertion_point = NULL;
	if (degree < self->priv->_a_length1) {
		GeePriorityQueueType1Node* _tmp0_;
		insertion_point = (_tmp0_ = _gee_priority_queue_node_ref0 (self->priv->_a[degree]), _gee_priority_queue_node_unref0 (insertion_point), _tmp0_);
	}
	if (insertion_point == NULL) {
		GeePriorityQueueType1Node* _tmp3_;
		if (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail != NULL) {
			GeePriorityQueueType1Node* _tmp1_;
			node->brothers_prev = ((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail;
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail->brothers_next), _tmp1_);
		} else {
			GeePriorityQueueType1Node* _tmp2_;
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head = (_tmp2_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head), _tmp2_);
		}
		((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail = (_tmp3_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail), _tmp3_);
	} else {
		GeePriorityQueueType1Node* _tmp6_;
		if (insertion_point->brothers_prev != NULL) {
			GeePriorityQueueType1Node* _tmp4_;
			insertion_point->brothers_prev->brothers_next = (_tmp4_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (insertion_point->brothers_prev->brothers_next), _tmp4_);
			node->brothers_prev = insertion_point->brothers_prev;
		} else {
			GeePriorityQueueType1Node* _tmp5_;
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head = (_tmp5_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head), _tmp5_);
		}
		node->brothers_next = (_tmp6_ = _gee_priority_queue_node_ref0 (insertion_point), _gee_priority_queue_node_unref0 (node->brothers_next), _tmp6_);
		insertion_point->brothers_prev = node;
	}
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) self->priv->_r_prime;
	if (degree >= self->priv->_a_length1) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = degree + 1;
		self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, degree + 1);
		(_tmp7_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp7_ - self->priv->_a_length1)) : NULL;
		self->priv->_a_length1 = _tmp7_;
		_tmp8_ = degree + 1;
		self->priv->_b = g_renew (gboolean, self->priv->_b, degree + 1);
		(_tmp8_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp8_ - self->priv->_b_length1)) : NULL;
		self->priv->_b_length1 = _tmp8_;
	}
	if (self->priv->_a[degree] == NULL) {
		self->priv->_b[degree] = TRUE;
	} else {
		if (self->priv->_b[degree]) {
			GeePriorityQueueNodePair* pair;
			pair = gee_priority_queue_node_pair_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, node, node->brothers_next);
			node->brothers_next->pair = pair;
			node->pair = pair;
			if (self->priv->_lp_head == NULL) {
				GeePriorityQueueNodePair* _tmp9_;
				GeePriorityQueueNodePair* _tmp10_;
				self->priv->_lp_head = (_tmp9_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp9_);
				self->priv->_lp_tail = (_tmp10_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp10_);
			} else {
				GeePriorityQueueNodePair* _tmp11_;
				GeePriorityQueueNodePair* _tmp12_;
				pair->lp_prev = self->priv->_lp_tail;
				self->priv->_lp_tail->lp_next = (_tmp11_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail->lp_next), _tmp11_);
				self->priv->_lp_tail = (_tmp12_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp12_);
			}
			self->priv->_b[degree] = FALSE;
			_gee_priority_queue_node_pair_unref0 (pair);
		} else {
			self->priv->_b[degree] = TRUE;
		}
	}
	self->priv->_a[degree] = (_tmp13_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp13_);
	_gee_priority_queue_node_unref0 (insertion_point);
}


static void _gee_priority_queue_remove_type1_node (GeePriorityQueue* self, GeePriorityQueueType1Node* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (((GeePriorityQueueNode*) node)->parent == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
		_gee_priority_queue_updated_degree (self, node, FALSE);
	} else {
		if (node->ll_prev != NULL) {
			GeePriorityQueueType1Node* _tmp0_;
			node->ll_prev->ll_next = (_tmp0_ = _gee_priority_queue_node_ref0 (node->ll_next), _gee_priority_queue_node_unref0 (node->ll_prev->ll_next), _tmp0_);
		} else {
			if (self->priv->_ll_head == node) {
				GeePriorityQueueType1Node* _tmp1_;
				self->priv->_ll_head = (_tmp1_ = _gee_priority_queue_node_ref0 (node->ll_next), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp1_);
			}
		}
		if (node->ll_next != NULL) {
			node->ll_next->ll_prev = node->ll_prev;
		} else {
			if (self->priv->_ll_tail == node) {
				GeePriorityQueueType1Node* _tmp2_;
				self->priv->_ll_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (node->ll_prev), _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp2_);
			}
		}
		if (((GeePriorityQueueNode*) node)->parent != NULL) {
			if (((GeePriorityQueueNode*) node)->parent->parent == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
				_gee_priority_queue_updated_degree (self, GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent), TRUE);
			} else {
				if (((GeePriorityQueueNode*) node)->parent->parent != NULL) {
					GeePriorityQueueType1Node* parent;
					parent = _gee_priority_queue_node_ref0 (GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent));
					parent->lost++;
					if (parent->lost > 1) {
						GeePriorityQueueType1Node* _tmp5_;
						if (self->priv->_ll_tail != NULL) {
							GeePriorityQueueType1Node* _tmp3_;
							parent->ll_prev = self->priv->_ll_tail;
							self->priv->_ll_tail->ll_next = (_tmp3_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_tail->ll_next), _tmp3_);
						} else {
							GeePriorityQueueType1Node* _tmp4_;
							self->priv->_ll_head = (_tmp4_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp4_);
						}
						self->priv->_ll_tail = (_tmp5_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp5_);
					}
					_gee_priority_queue_node_unref0 (parent);
				}
			}
		}
	}
	if (node == self->priv->_p) {
		GeePriorityQueueType1Node* _tmp6_;
		self->priv->_p = (_tmp6_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp6_);
	}
	gee_priority_queue_type1_node_remove (node);
}


static void _gee_priority_queue_updated_degree (GeePriorityQueue* self, GeePriorityQueueType1Node* node, gboolean child_removed) {
	gint degree;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
	if (child_removed) {
		_tmp0_ = self->priv->_a[degree - 1] == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeePriorityQueueType1Node* _tmp1_;
		self->priv->_a[degree - 1] = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (self->priv->_a[degree - 1]), _tmp1_);
		self->priv->_b[degree - 1] = !self->priv->_b[degree - 1];
	}
	self->priv->_b[degree] = !self->priv->_b[degree];
	if (self->priv->_a[degree] == node) {
		GeePriorityQueueType1Node* next;
		gboolean _tmp2_ = FALSE;
		next = _gee_priority_queue_node_ref0 (node->brothers_next);
		if (next != NULL) {
			_tmp2_ = gee_priority_queue_node_degree ((GeePriorityQueueNode*) next) == degree;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GeePriorityQueueType1Node* _tmp3_;
			self->priv->_a[degree] = (_tmp3_ = _gee_priority_queue_node_ref0 (next), _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp3_);
		} else {
			GeePriorityQueueType1Node* _tmp4_;
			gint i;
			gint _tmp5_;
			gint _tmp6_;
			self->priv->_a[degree] = (_tmp4_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp4_);
			i = self->priv->_a_length1 - 1;
			while (TRUE) {
				if (!(self->priv->_a[i] == NULL)) {
					break;
				}
				i--;
			}
			_tmp5_ = i + 1;
			self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, i + 1);
			(_tmp5_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp5_ - self->priv->_a_length1)) : NULL;
			self->priv->_a_length1 = _tmp5_;
			_tmp6_ = i + 1;
			self->priv->_b = g_renew (gboolean, self->priv->_b, i + 1);
			(_tmp6_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp6_ - self->priv->_b_length1)) : NULL;
			self->priv->_b_length1 = _tmp6_;
		}
		_gee_priority_queue_node_unref0 (next);
	}
	if (node->pair != NULL) {
		GeePriorityQueueNodePair* pair;
		GeePriorityQueueType1Node* _tmp7_;
		GeePriorityQueueType1Node* other;
		pair = _gee_priority_queue_node_pair_ref0 (node->pair);
		_tmp7_ = NULL;
		if (pair->node1 == node) {
			_tmp7_ = pair->node2;
		} else {
			_tmp7_ = pair->node1;
		}
		other = _gee_priority_queue_node_ref0 (_tmp7_);
		node->pair = NULL;
		other->pair = NULL;
		if (pair->lp_prev != NULL) {
			GeePriorityQueueNodePair* _tmp8_;
			pair->lp_prev->lp_next = (_tmp8_ = _gee_priority_queue_node_pair_ref0 (pair->lp_next), _gee_priority_queue_node_pair_unref0 (pair->lp_prev->lp_next), _tmp8_);
		} else {
			GeePriorityQueueNodePair* _tmp9_;
			self->priv->_lp_head = (_tmp9_ = _gee_priority_queue_node_pair_ref0 (pair->lp_next), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp9_);
		}
		if (pair->lp_next != NULL) {
			pair->lp_next->lp_prev = pair->lp_prev;
		} else {
			GeePriorityQueueNodePair* _tmp10_;
			self->priv->_lp_tail = (_tmp10_ = _gee_priority_queue_node_pair_ref0 (pair->lp_prev), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp10_);
		}
		_gee_priority_queue_node_pair_unref0 (pair);
		_gee_priority_queue_node_unref0 (other);
	}
}


static void _gee_priority_queue_remove_type2_node (GeePriorityQueue* self, GeePriorityQueueType2Node* node) {
	GeePriorityQueueType2Node* _tmp1_;
	GeePriorityQueueType2Node* *_tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = &GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent)->type2_child;
	(*_tmp0_) = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 ((*_tmp0_)), _tmp1_);
	((GeePriorityQueueNode*) node)->parent = NULL;
}


GCompareFunc gee_priority_queue_get_compare_func (GeePriorityQueue* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
	return result;
}


static void gee_priority_queue_set_compare_func (GeePriorityQueue* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


static gint gee_priority_queue_real_get_capacity (GeeAbstractQueue* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gint gee_priority_queue_real_get_remaining_capacity (GeeAbstractQueue* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gboolean gee_priority_queue_real_get_is_full (GeeAbstractQueue* base) {
	gboolean result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = FALSE;
	return result;
}


static gint gee_priority_queue_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = self->priv->_size;
	return result;
}


static GeePriorityQueueNode* gee_priority_queue_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	GeePriorityQueueNode* self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeePriorityQueueNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->data = (_tmp1_ = (_tmp0_ = data, ((_tmp0_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp0_) : g_dup_func ((gpointer) _tmp0_)), _g_destroy_func0 (self->data), _tmp1_);
	return self;
}


static inline gint gee_priority_queue_node_degree (GeePriorityQueueNode* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->type1_children_count;
	return result;
}


static void gee_priority_queue_value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_priority_queue_value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_priority_queue_node_unref (value->data[0].v_pointer);
	}
}


static void gee_priority_queue_value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_priority_queue_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_priority_queue_value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_priority_queue_value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeePriorityQueueNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_priority_queue_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_priority_queue_value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeePriorityQueueNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_priority_queue_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_priority_queue_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeePriorityQueueParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_priority_queue_value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void gee_priority_queue_value_set_node (GValue* value, gpointer v_object) {
	GeePriorityQueueNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_priority_queue_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_unref (old);
	}
}


static void gee_priority_queue_value_take_node (GValue* value, gpointer v_object) {
	GeePriorityQueueNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_unref (old);
	}
}


static void gee_priority_queue_node_class_init (GeePriorityQueueNodeClass * klass) {
	gee_priority_queue_node_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_CLASS (klass)->finalize = gee_priority_queue_node_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueNodePrivate));
}


static void gee_priority_queue_node_instance_init (GeePriorityQueueNode * self) {
	self->priv = GEE_PRIORITY_QUEUE_NODE_GET_PRIVATE (self);
	self->parent = NULL;
	self->type1_children_head = NULL;
	self->type1_children_tail = NULL;
	self->ref_count = 1;
}


static void gee_priority_queue_node_finalize (GeePriorityQueueNode* obj) {
	GeePriorityQueueNode * self;
	self = GEE_PRIORITY_QUEUE_NODE (obj);
	((self->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->data = (self->priv->g_destroy_func (self->data), NULL));
	_gee_priority_queue_node_unref0 (self->type1_children_head);
	_gee_priority_queue_node_unref0 (self->type1_children_tail);
}


static GType gee_priority_queue_node_get_type (void) {
	static volatile gsize gee_priority_queue_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_priority_queue_value_node_init, gee_priority_queue_value_node_free_value, gee_priority_queue_value_node_copy_value, gee_priority_queue_value_node_peek_pointer, "p", gee_priority_queue_value_node_collect_value, "p", gee_priority_queue_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueNode), 0, (GInstanceInitFunc) gee_priority_queue_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_priority_queue_node_type_id;
		gee_priority_queue_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePriorityQueueNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gee_priority_queue_node_type_id__volatile, gee_priority_queue_node_type_id);
	}
	return gee_priority_queue_node_type_id__volatile;
}


static gpointer gee_priority_queue_node_ref (gpointer instance) {
	GeePriorityQueueNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_priority_queue_node_unref (gpointer instance) {
	GeePriorityQueueNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PRIORITY_QUEUE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static GeePriorityQueueType1Node* gee_priority_queue_type1_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	GeePriorityQueueType1Node* self;
	self = (GeePriorityQueueType1Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, data);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static GeePriorityQueueType1Node* gee_priority_queue_type1_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	return gee_priority_queue_type1_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, g_type, g_dup_func, g_destroy_func, data);
}


static inline void gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self, GeePriorityQueueType1Node* node) {
	GeePriorityQueueType1Node* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) self;
	if (((GeePriorityQueueNode*) self)->type1_children_head == NULL) {
		GeePriorityQueueType1Node* _tmp0_;
		((GeePriorityQueueNode*) self)->type1_children_head = (_tmp0_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_head), _tmp0_);
	} else {
		node->brothers_prev = ((GeePriorityQueueNode*) self)->type1_children_tail;
	}
	if (((GeePriorityQueueNode*) self)->type1_children_tail != NULL) {
		GeePriorityQueueType1Node* _tmp1_;
		((GeePriorityQueueNode*) self)->type1_children_tail->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_tail->brothers_next), _tmp1_);
	}
	((GeePriorityQueueNode*) self)->type1_children_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_tail), _tmp2_);
	((GeePriorityQueueNode*) self)->type1_children_count++;
}


static inline void gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self) {
	GeePriorityQueueType1Node* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->brothers_prev == NULL) {
		GeePriorityQueueType1Node* _tmp0_;
		((GeePriorityQueueNode*) self)->parent->type1_children_head = (_tmp0_ = _gee_priority_queue_node_ref0 (self->brothers_next), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->parent->type1_children_head), _tmp0_);
	} else {
		GeePriorityQueueType1Node* _tmp1_;
		self->brothers_prev->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (self->brothers_next), _gee_priority_queue_node_unref0 (self->brothers_prev->brothers_next), _tmp1_);
	}
	if (self->brothers_next == NULL) {
		GeePriorityQueueType1Node* _tmp2_;
		((GeePriorityQueueNode*) self)->parent->type1_children_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (self->brothers_prev), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->parent->type1_children_tail), _tmp2_);
	} else {
		self->brothers_next->brothers_prev = self->brothers_prev;
	}
	((GeePriorityQueueNode*) self)->parent->type1_children_count--;
	((GeePriorityQueueNode*) self)->parent = NULL;
	self->brothers_prev = NULL;
	self->brothers_next = (_tmp3_ = NULL, _gee_priority_queue_node_unref0 (self->brothers_next), _tmp3_);
}


static void gee_priority_queue_type1_node_class_init (GeePriorityQueueType1NodeClass * klass) {
	gee_priority_queue_type1_node_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_CLASS (klass)->finalize = gee_priority_queue_type1_node_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueType1NodePrivate));
}


static void gee_priority_queue_type1_node_instance_init (GeePriorityQueueType1Node * self) {
	self->priv = GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_PRIVATE (self);
	self->brothers_prev = NULL;
	self->brothers_next = NULL;
	self->type2_child = NULL;
	self->ll_prev = NULL;
	self->ll_next = NULL;
	self->pair = NULL;
}


static void gee_priority_queue_type1_node_finalize (GeePriorityQueueNode* obj) {
	GeePriorityQueueType1Node * self;
	self = GEE_PRIORITY_QUEUE_TYPE1_NODE (obj);
	_gee_priority_queue_node_unref0 (self->brothers_next);
	_gee_priority_queue_node_unref0 (self->type2_child);
	_gee_priority_queue_node_unref0 (self->ll_next);
	GEE_PRIORITY_QUEUE_NODE_CLASS (gee_priority_queue_type1_node_parent_class)->finalize (obj);
}


static GType gee_priority_queue_type1_node_get_type (void) {
	static volatile gsize gee_priority_queue_type1_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type1_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType1NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type1_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType1Node), 0, (GInstanceInitFunc) gee_priority_queue_type1_node_instance_init, NULL };
		GType gee_priority_queue_type1_node_type_id;
		gee_priority_queue_type1_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType1Node", &g_define_type_info, 0);
		g_once_init_leave (&gee_priority_queue_type1_node_type_id__volatile, gee_priority_queue_type1_node_type_id);
	}
	return gee_priority_queue_type1_node_type_id__volatile;
}


static GeePriorityQueueType2Node* gee_priority_queue_type2_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	GeePriorityQueueType2Node* self;
	self = (GeePriorityQueueType2Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, data);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static GeePriorityQueueType2Node* gee_priority_queue_type2_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	return gee_priority_queue_type2_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, g_type, g_dup_func, g_destroy_func, data);
}


static void gee_priority_queue_type2_node_class_init (GeePriorityQueueType2NodeClass * klass) {
	gee_priority_queue_type2_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueueType2NodePrivate));
}


static void gee_priority_queue_type2_node_instance_init (GeePriorityQueueType2Node * self) {
	self->priv = GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_PRIVATE (self);
}


static GType gee_priority_queue_type2_node_get_type (void) {
	static volatile gsize gee_priority_queue_type2_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type2_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType2NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type2_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType2Node), 0, (GInstanceInitFunc) gee_priority_queue_type2_node_instance_init, NULL };
		GType gee_priority_queue_type2_node_type_id;
		gee_priority_queue_type2_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType2Node", &g_define_type_info, 0);
		g_once_init_leave (&gee_priority_queue_type2_node_type_id__volatile, gee_priority_queue_type2_node_type_id);
	}
	return gee_priority_queue_type2_node_type_id__volatile;
}


static GeePriorityQueueNodePair* gee_priority_queue_node_pair_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2) {
	GeePriorityQueueNodePair* self;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* _tmp1_;
	g_return_val_if_fail (node1 != NULL, NULL);
	g_return_val_if_fail (node2 != NULL, NULL);
	self = (GeePriorityQueueNodePair*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->node1 = (_tmp0_ = _gee_priority_queue_node_ref0 (node1), _gee_priority_queue_node_unref0 (self->node1), _tmp0_);
	self->node2 = (_tmp1_ = _gee_priority_queue_node_ref0 (node2), _gee_priority_queue_node_unref0 (self->node2), _tmp1_);
	return self;
}


static GeePriorityQueueNodePair* gee_priority_queue_node_pair_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2) {
	return gee_priority_queue_node_pair_construct (GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, g_type, g_dup_func, g_destroy_func, node1, node2);
}


static void gee_priority_queue_value_node_pair_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_priority_queue_value_node_pair_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_priority_queue_node_pair_unref (value->data[0].v_pointer);
	}
}


static void gee_priority_queue_value_node_pair_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_priority_queue_node_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_priority_queue_value_node_pair_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_priority_queue_value_node_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeePriorityQueueNodePair* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_priority_queue_node_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_priority_queue_value_node_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeePriorityQueueNodePair** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_priority_queue_node_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_priority_queue_param_spec_node_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeePriorityQueueParamSpecNodePair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_priority_queue_value_get_node_pair (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR), NULL);
	return value->data[0].v_pointer;
}


static void gee_priority_queue_value_set_node_pair (GValue* value, gpointer v_object) {
	GeePriorityQueueNodePair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_priority_queue_node_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_pair_unref (old);
	}
}


static void gee_priority_queue_value_take_node_pair (GValue* value, gpointer v_object) {
	GeePriorityQueueNodePair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_pair_unref (old);
	}
}


static void gee_priority_queue_node_pair_class_init (GeePriorityQueueNodePairClass * klass) {
	gee_priority_queue_node_pair_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_PAIR_CLASS (klass)->finalize = gee_priority_queue_node_pair_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueNodePairPrivate));
}


static void gee_priority_queue_node_pair_instance_init (GeePriorityQueueNodePair * self) {
	self->priv = GEE_PRIORITY_QUEUE_NODE_PAIR_GET_PRIVATE (self);
	self->lp_prev = NULL;
	self->lp_next = NULL;
	self->node1 = NULL;
	self->node2 = NULL;
	self->ref_count = 1;
}


static void gee_priority_queue_node_pair_finalize (GeePriorityQueueNodePair* obj) {
	GeePriorityQueueNodePair * self;
	self = GEE_PRIORITY_QUEUE_NODE_PAIR (obj);
	_gee_priority_queue_node_pair_unref0 (self->lp_next);
	_gee_priority_queue_node_unref0 (self->node1);
	_gee_priority_queue_node_unref0 (self->node2);
}


static GType gee_priority_queue_node_pair_get_type (void) {
	static volatile gsize gee_priority_queue_node_pair_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_node_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_priority_queue_value_node_pair_init, gee_priority_queue_value_node_pair_free_value, gee_priority_queue_value_node_pair_copy_value, gee_priority_queue_value_node_pair_peek_pointer, "p", gee_priority_queue_value_node_pair_collect_value, "p", gee_priority_queue_value_node_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueNodePairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_node_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueNodePair), 0, (GInstanceInitFunc) gee_priority_queue_node_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_priority_queue_node_pair_type_id;
		gee_priority_queue_node_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePriorityQueueNodePair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gee_priority_queue_node_pair_type_id__volatile, gee_priority_queue_node_pair_type_id);
	}
	return gee_priority_queue_node_pair_type_id__volatile;
}


static gpointer gee_priority_queue_node_pair_ref (gpointer instance) {
	GeePriorityQueueNodePair* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_priority_queue_node_pair_unref (gpointer instance) {
	GeePriorityQueueNodePair* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PRIORITY_QUEUE_NODE_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeePriorityQueueIterator* gee_priority_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue) {
	GeePriorityQueueIterator * self;
	GeePriorityQueue* _tmp0_;
	g_return_val_if_fail (queue != NULL, NULL);
	self = (GeePriorityQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->queue = (_tmp0_ = _g_object_ref0 (queue), _g_object_unref0 (self->priv->queue), _tmp0_);
	self->priv->position = (GeePriorityQueueNode*) queue->priv->_r;
	self->priv->stamp = queue->priv->_stamp;
	return self;
}


static GeePriorityQueueIterator* gee_priority_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue) {
	return gee_priority_queue_iterator_construct (GEE_PRIORITY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
}


static gboolean gee_priority_queue_iterator_real_next (GeeIterator* base) {
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	self = (GeePriorityQueueIterator*) base;
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	if (!gee_iterator_has_next ((GeeIterator*) self)) {
		result = FALSE;
		return result;
	}
	self->priv->removed = FALSE;
	self->priv->position = self->priv->_next;
	self->priv->_next = NULL;
	result = self->priv->position != NULL;
	return result;
}


static gboolean gee_priority_queue_iterator_real_has_next (GeeIterator* base) {
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	self = (GeePriorityQueueIterator*) base;
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	if (self->priv->_next == NULL) {
		self->priv->_next = self->priv->position;
		if (!_gee_priority_queue_iterator_has_next (self)) {
			self->priv->_next = NULL;
		}
	}
	result = self->priv->_next != NULL;
	return result;
}


static gboolean _gee_priority_queue_iterator_has_next (GeePriorityQueueIterator* self) {
	gboolean result = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->started) {
		self->priv->started = TRUE;
		result = self->priv->_next != NULL;
		return result;
	} else {
		if (GEE_PRIORITY_QUEUE_IS_TYPE1_NODE (self->priv->_next)) {
			GeePriorityQueueNode* _tmp0_;
			GeePriorityQueueType1Node* node;
			gboolean _tmp1_ = FALSE;
			node = _gee_priority_queue_node_ref0 ((_tmp0_ = self->priv->_next, GEE_PRIORITY_QUEUE_IS_TYPE1_NODE (_tmp0_) ? ((GeePriorityQueueType1Node*) _tmp0_) : NULL));
			if (!self->priv->from_type1_children) {
				_tmp1_ = ((GeePriorityQueueNode*) node)->type1_children_head != NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				self->priv->_next = (GeePriorityQueueNode*) ((GeePriorityQueueNode*) node)->type1_children_head;
				self->priv->from_type1_children = FALSE;
				self->priv->from_type2_child = FALSE;
				result = TRUE;
				_gee_priority_queue_node_unref0 (node);
				return result;
			} else {
				gboolean _tmp2_ = FALSE;
				if (!self->priv->from_type2_child) {
					_tmp2_ = node->type2_child != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					self->priv->_next = (GeePriorityQueueNode*) node->type2_child;
					self->priv->from_type1_children = FALSE;
					self->priv->from_type2_child = FALSE;
					result = TRUE;
					_gee_priority_queue_node_unref0 (node);
					return result;
				} else {
					if (node->brothers_next != NULL) {
						self->priv->_next = (GeePriorityQueueNode*) node->brothers_next;
						self->priv->from_type1_children = FALSE;
						self->priv->from_type2_child = FALSE;
						result = TRUE;
						_gee_priority_queue_node_unref0 (node);
						return result;
					}
				}
			}
			self->priv->from_type1_children = TRUE;
			_gee_priority_queue_node_unref0 (node);
		} else {
			if (GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (self->priv->_next)) {
				GeePriorityQueueNode* _tmp3_;
				GeePriorityQueueType2Node* node;
				gboolean _tmp4_ = FALSE;
				node = _gee_priority_queue_node_ref0 ((_tmp3_ = self->priv->_next, GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (_tmp3_) ? ((GeePriorityQueueType2Node*) _tmp3_) : NULL));
				if (!self->priv->from_type1_children) {
					_tmp4_ = ((GeePriorityQueueNode*) node)->type1_children_head != NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					self->priv->_next = (GeePriorityQueueNode*) ((GeePriorityQueueNode*) node)->type1_children_head;
					self->priv->from_type1_children = FALSE;
					self->priv->from_type2_child = FALSE;
					result = TRUE;
					_gee_priority_queue_node_unref0 (node);
					return result;
				}
				self->priv->from_type2_child = TRUE;
				_gee_priority_queue_node_unref0 (node);
			}
		}
	}
	if (self->priv->_next != NULL) {
		_tmp5_ = self->priv->_next != GEE_PRIORITY_QUEUE_NODE (self->priv->queue->priv->_r);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->priv->_next = self->priv->_next->parent;
		result = _gee_priority_queue_iterator_has_next (self);
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean gee_priority_queue_iterator_real_first (GeeIterator* base) {
	GeePriorityQueueIterator * self;
	gboolean result = FALSE;
	self = (GeePriorityQueueIterator*) base;
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	self->priv->position = (GeePriorityQueueNode*) self->priv->queue->priv->_r;
	self->priv->started = FALSE;
	self->priv->from_type1_children = FALSE;
	self->priv->from_type2_child = FALSE;
	result = gee_iterator_next ((GeeIterator*) self);
	return result;
}


static gpointer gee_priority_queue_iterator_real_get (GeeIterator* base) {
	GeePriorityQueueIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeePriorityQueueIterator*) base;
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	g_assert (self->priv->position != NULL);
	g_assert (!self->priv->removed);
	result = (_tmp0_ = self->priv->position->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static void gee_priority_queue_iterator_real_remove (GeeIterator* base) {
	GeePriorityQueueIterator * self;
	GeePriorityQueueNode* node;
	self = (GeePriorityQueueIterator*) base;
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	g_assert (self->priv->position != NULL);
	g_assert (!self->priv->removed);
	gee_iterator_has_next ((GeeIterator*) self);
	node = _gee_priority_queue_node_ref0 (self->priv->position);
	self->priv->position = NULL;
	_gee_priority_queue_delete (self->priv->queue, node);
	self->priv->stamp = self->priv->queue->priv->_stamp;
	self->priv->removed = TRUE;
	_gee_priority_queue_node_unref0 (node);
}


static GeePriorityQueueNode* gee_priority_queue_iterator_get_node (GeePriorityQueueIterator* self) {
	GeePriorityQueueNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
	g_assert (self->priv->position != NULL);
	result = _gee_priority_queue_node_ref0 (self->priv->position);
	return result;
}


static void gee_priority_queue_iterator_class_init (GeePriorityQueueIteratorClass * klass) {
	gee_priority_queue_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueueIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_priority_queue_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_priority_queue_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_priority_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_priority_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_priority_queue_iterator_real_next;
	iface->has_next = gee_priority_queue_iterator_real_has_next;
	iface->first = gee_priority_queue_iterator_real_first;
	iface->get = gee_priority_queue_iterator_real_get;
	iface->remove = gee_priority_queue_iterator_real_remove;
}


static void gee_priority_queue_iterator_instance_init (GeePriorityQueueIterator * self) {
	self->priv = GEE_PRIORITY_QUEUE_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->from_type1_children = FALSE;
	self->priv->from_type2_child = FALSE;
	self->priv->removed = FALSE;
}


static void gee_priority_queue_iterator_finalize (GObject* obj) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (obj);
	_g_object_unref0 (self->priv->queue);
	G_OBJECT_CLASS (gee_priority_queue_iterator_parent_class)->finalize (obj);
}


static GType gee_priority_queue_iterator_get_type (void) {
	static volatile gsize gee_priority_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueIterator), 0, (GInstanceInitFunc) gee_priority_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_priority_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_priority_queue_iterator_type_id;
		gee_priority_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeePriorityQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_priority_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_priority_queue_iterator_type_id__volatile, gee_priority_queue_iterator_type_id);
	}
	return gee_priority_queue_iterator_type_id__volatile;
}


static void gee_priority_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_priority_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_priority_queue_class_init (GeePriorityQueueClass * klass) {
	gee_priority_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueuePrivate));
	GEE_ABSTRACT_QUEUE_CLASS (klass)->offer = gee_priority_queue_real_offer;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_priority_queue_real_peek;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_priority_queue_real_poll;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->drain = gee_priority_queue_real_drain;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_priority_queue_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_priority_queue_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_priority_queue_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_priority_queue_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_priority_queue_real_iterator;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_priority_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_priority_queue_real_get_remaining_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_priority_queue_real_get_is_full;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_priority_queue_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_priority_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_priority_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_CAPACITY, "capacity");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_REMAINING_CAPACITY, "remaining-capacity");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_IS_FULL, "is-full");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_SIZE, "size");
}


static void gee_priority_queue_instance_init (GeePriorityQueue * self) {
	self->priv = GEE_PRIORITY_QUEUE_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_r = NULL;
	self->priv->_r_prime = NULL;
	self->priv->_lm_head = NULL;
	self->priv->_lm_tail = NULL;
	self->priv->_p = NULL;
	self->priv->_a = g_new0 (GeePriorityQueueType1Node*, 0 + 1);
	self->priv->_a_length1 = 0;
	self->priv->__a_size_ = self->priv->_a_length1;
	self->priv->_lp_head = NULL;
	self->priv->_lp_tail = NULL;
	self->priv->_b = g_new0 (gboolean, 0);
	self->priv->_b_length1 = 0;
	self->priv->__b_size_ = self->priv->_b_length1;
	self->priv->_ll_head = NULL;
	self->priv->_ll_tail = NULL;
}


static void gee_priority_queue_finalize (GObject* obj) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (obj);
	_gee_priority_queue_node_unref0 (self->priv->_r);
	_gee_priority_queue_node_unref0 (self->priv->_r_prime);
	_gee_priority_queue_node_unref0 (self->priv->_lm_head);
	_gee_priority_queue_node_unref0 (self->priv->_lm_tail);
	_gee_priority_queue_node_unref0 (self->priv->_p);
	self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL);
	_gee_priority_queue_node_pair_unref0 (self->priv->_lp_head);
	_gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail);
	self->priv->_b = (g_free (self->priv->_b), NULL);
	_gee_priority_queue_node_unref0 (self->priv->_ll_head);
	_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
	G_OBJECT_CLASS (gee_priority_queue_parent_class)->finalize (obj);
}


GType gee_priority_queue_get_type (void) {
	static volatile gsize gee_priority_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_priority_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueue), 0, (GInstanceInitFunc) gee_priority_queue_instance_init, NULL };
		GType gee_priority_queue_type_id;
		gee_priority_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeePriorityQueue", &g_define_type_info, 0);
		g_once_init_leave (&gee_priority_queue_type_id__volatile, gee_priority_queue_type_id);
	}
	return gee_priority_queue_type_id__volatile;
}


static void gee_priority_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (object);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_COMPARE_FUNC:
		g_value_set_pointer (value, gee_priority_queue_get_compare_func (self));
		break;
		case GEE_PRIORITY_QUEUE_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_REMAINING_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_IS_FULL:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_priority_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (object);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_COMPARE_FUNC:
		gee_priority_queue_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_PRIORITY_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




