/* abstractcollection.c generated by valac 0.9.8.14-51a7, the Vala compiler
 * generated from abstractcollection.vala, do not modify */

/* abstractcollection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeCollection* _read_only_view;
};


static gpointer gee_abstract_collection_parent_class = NULL;
static GeeIterableIface* gee_abstract_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_abstract_collection_gee_collection_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
#define GEE_ABSTRACT_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionPrivate))
enum  {
	GEE_ABSTRACT_COLLECTION_DUMMY_PROPERTY,
	GEE_ABSTRACT_COLLECTION_SIZE,
	GEE_ABSTRACT_COLLECTION_IS_EMPTY,
	GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE,
	GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW,
	GEE_ABSTRACT_COLLECTION_G_TYPE,
	GEE_ABSTRACT_COLLECTION_G_DUP_FUNC,
	GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC
};
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item);
void gee_abstract_collection_clear (GeeAbstractCollection* self);
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self);
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1);
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1);
static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1);
static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1);
static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1);
static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1);
static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1);
static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1);
static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1);
static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1);
static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1);
static float* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1);
static double* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self);
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GType gee_read_only_collection_get_type (void) G_GNUC_CONST;
static void gee_abstract_collection_finalize (GObject* obj);
GType gee_iterable_get_element_type (GeeIterable* self);
static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains (self, item);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add (self, item);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove (self, item);
}


/**
 * {@inheritDoc}
 */
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gee_abstract_collection_clear (GeeAbstractCollection* self) {
	GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->clear (self);
}


/**
 * {@inheritDoc}
 */
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1) {
	gpointer* result = NULL;
	GType t;
	g_return_val_if_fail (self != NULL, NULL);
	t = self->priv->g_type;
	if (t == G_TYPE_BOOLEAN) {
		gint _tmp0_;
		gpointer* _tmp1_;
		result = (_tmp1_ = (gpointer*) gee_abstract_collection_to_bool_array (GEE_COLLECTION (self), &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			gint _tmp2_;
			gpointer* _tmp3_;
			result = (_tmp3_ = (gpointer*) gee_abstract_collection_to_char_array (GEE_COLLECTION (self), &_tmp2_), *result_length1 = _tmp2_, _tmp3_);
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				gint _tmp4_;
				gpointer* _tmp5_;
				result = (_tmp5_ = (gpointer*) gee_abstract_collection_to_uchar_array (GEE_COLLECTION (self), &_tmp4_), *result_length1 = _tmp4_, _tmp5_);
				return result;
			} else {
				if (t == G_TYPE_INT) {
					gint _tmp6_;
					gpointer* _tmp7_;
					result = (_tmp7_ = (gpointer*) gee_abstract_collection_to_int_array (GEE_COLLECTION (self), &_tmp6_), *result_length1 = _tmp6_, _tmp7_);
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						gint _tmp8_;
						gpointer* _tmp9_;
						result = (_tmp9_ = (gpointer*) gee_abstract_collection_to_uint_array (GEE_COLLECTION (self), &_tmp8_), *result_length1 = _tmp8_, _tmp9_);
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							gint _tmp10_;
							gpointer* _tmp11_;
							result = (_tmp11_ = (gpointer*) gee_abstract_collection_to_int64_array (GEE_COLLECTION (self), &_tmp10_), *result_length1 = _tmp10_, _tmp11_);
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								gint _tmp12_;
								gpointer* _tmp13_;
								result = (_tmp13_ = (gpointer*) gee_abstract_collection_to_uint64_array (GEE_COLLECTION (self), &_tmp12_), *result_length1 = _tmp12_, _tmp13_);
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									gint _tmp14_;
									gpointer* _tmp15_;
									result = (_tmp15_ = (gpointer*) gee_abstract_collection_to_long_array (GEE_COLLECTION (self), &_tmp14_), *result_length1 = _tmp14_, _tmp15_);
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										gint _tmp16_;
										gpointer* _tmp17_;
										result = (_tmp17_ = (gpointer*) gee_abstract_collection_to_ulong_array (GEE_COLLECTION (self), &_tmp16_), *result_length1 = _tmp16_, _tmp17_);
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											gint _tmp18_;
											gpointer* _tmp19_;
											result = (_tmp19_ = (gpointer*) gee_abstract_collection_to_float_array (GEE_COLLECTION (self), &_tmp18_), *result_length1 = _tmp18_, _tmp19_);
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												gint _tmp20_;
												gpointer* _tmp21_;
												result = (_tmp21_ = (gpointer*) gee_abstract_collection_to_double_array (GEE_COLLECTION (self), &_tmp20_), *result_length1 = _tmp20_, _tmp21_);
												return result;
											} else {
												gint array_length1;
												gint _array_size_;
												gpointer* _tmp23_;
												gint _tmp22_;
												gpointer* array;
												gint index;
												gpointer* _tmp27_;
												array = (_tmp23_ = g_new0 (gpointer, _tmp22_ = gee_collection_get_size ((GeeCollection*) self)), array_length1 = _tmp22_, _array_size_ = array_length1, _tmp23_);
												index = 0;
												{
													GeeIterator* _element_it;
													_element_it = gee_abstract_collection_iterator (self);
													while (TRUE) {
														gpointer element;
														gconstpointer _tmp24_;
														gpointer *_tmp25_;
														gpointer _tmp26_;
														if (!gee_iterator_next (_element_it)) {
															break;
														}
														element = gee_iterator_get (_element_it);
														_tmp25_ = &array[index++];
														(*_tmp25_) = (_tmp26_ = (_tmp24_ = element, ((_tmp24_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp24_) : self->priv->g_dup_func ((gpointer) _tmp24_)), (((*_tmp25_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp25_) = (self->priv->g_destroy_func ((*_tmp25_)), NULL)), _tmp26_);
														((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
													}
													_g_object_unref0 (_element_it);
												}
												result = (_tmp27_ = array, *result_length1 = array_length1, _tmp27_);
												return result;
												array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->to_array (self, result_length1);
}


static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1) {
	gboolean* result = NULL;
	gint array_length1;
	gint _array_size_;
	gboolean* _tmp1_;
	gint _tmp0_;
	gboolean* array;
	gint index;
	gboolean* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (gboolean, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			gboolean element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1) {
	gchar* result = NULL;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp1_;
	gint _tmp0_;
	gchar* array;
	gint index;
	gchar* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (gchar, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			gchar element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1) {
	guchar* result = NULL;
	gint array_length1;
	gint _array_size_;
	guchar* _tmp1_;
	gint _tmp0_;
	guchar* array;
	gint index;
	guchar* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (guchar, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			guchar element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1) {
	gint* result = NULL;
	gint array_length1;
	gint _array_size_;
	gint* _tmp1_;
	gint _tmp0_;
	gint* array;
	gint index;
	gint* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (gint, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			gint element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1) {
	guint* result = NULL;
	gint array_length1;
	gint _array_size_;
	guint* _tmp1_;
	gint _tmp0_;
	guint* array;
	gint index;
	guint* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (guint, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			guint element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1) {
	gint64* result = NULL;
	gint array_length1;
	gint _array_size_;
	gint64* _tmp1_;
	gint _tmp0_;
	gint64* array;
	gint index;
	gint64* _tmp4_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (gint64, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			gint64* _tmp2_;
			gint64 _tmp3_;
			gint64 element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = (_tmp3_ = *(_tmp2_ = (gint64*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
	return result;
	array = (g_free (array), NULL);
}


static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1) {
	guint64* result = NULL;
	gint array_length1;
	gint _array_size_;
	guint64* _tmp1_;
	gint _tmp0_;
	guint64* array;
	gint index;
	guint64* _tmp4_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (guint64, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			guint64* _tmp2_;
			guint64 _tmp3_;
			guint64 element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = (_tmp3_ = *(_tmp2_ = (guint64*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
	return result;
	array = (g_free (array), NULL);
}


static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1) {
	glong* result = NULL;
	gint array_length1;
	gint _array_size_;
	glong* _tmp1_;
	gint _tmp0_;
	glong* array;
	gint index;
	glong* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (glong, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			glong element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1) {
	gulong* result = NULL;
	gint array_length1;
	gint _array_size_;
	gulong* _tmp1_;
	gint _tmp0_;
	gulong* array;
	gint index;
	gulong* _tmp2_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (gulong, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			gulong element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
	return result;
	array = (g_free (array), NULL);
}


static float* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1) {
	float* result = NULL;
	gint array_length1;
	gint _array_size_;
	float* _tmp1_;
	gint _tmp0_;
	float* array;
	gint index;
	float* _tmp4_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (float, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			float* _tmp2_;
			float _tmp3_;
			float element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = (_tmp3_ = *(_tmp2_ = (float*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
	return result;
	array = (g_free (array), NULL);
}


static double* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1) {
	double* result = NULL;
	gint array_length1;
	gint _array_size_;
	double* _tmp1_;
	gint _tmp0_;
	double* array;
	gint index;
	double* _tmp4_;
	g_return_val_if_fail (coll != NULL, NULL);
	array = (_tmp1_ = g_new0 (double, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
		while (TRUE) {
			double* _tmp2_;
			double _tmp3_;
			double element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = (_tmp3_ = *(_tmp2_ = (double*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
			array[index++] = element;
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
	return result;
	array = (g_free (array), NULL);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	if (gee_collection_get_is_empty (collection)) {
		result = FALSE;
		return result;
	}
	changed = FALSE;
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
		while (TRUE) {
			gpointer item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = gee_iterator_get (_item_it);
			changed = changed | gee_abstract_collection_add (self, item);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	if (gee_collection_get_size (collection) > gee_collection_get_size ((GeeCollection*) self)) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
		while (TRUE) {
			gpointer item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = gee_iterator_get (_item_it);
			if (!gee_abstract_collection_contains (self, item)) {
				result = FALSE;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				_g_object_unref0 (_item_it);
				return result;
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = TRUE;
	return result;
}


gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
		while (TRUE) {
			gpointer item;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = gee_iterator_get (_item_it);
			changed = changed | gee_abstract_collection_remove (self, item);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
	return result;
}


gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
	gint items_length1;
	gint _items_size_;
	gpointer* _tmp1_;
	gint _tmp0_;
	gpointer* items;
	gint size_of_items;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	items = (_tmp1_ = gee_abstract_collection_to_array (self, &_tmp0_), items_length1 = _tmp0_, _items_size_ = items_length1, _tmp1_);
	size_of_items = gee_collection_get_size ((GeeCollection*) self);
	{
		gint index;
		index = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					index++;
				}
				_tmp2_ = FALSE;
				if (!(index < size_of_items)) {
					break;
				}
				if (!gee_collection_contains (collection, items[index])) {
					changed = changed | gee_abstract_collection_remove (self, items[index]);
				}
			}
		}
	}
	result = changed;
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	return result;
}


gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->retain_all (self, collection);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_iterator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->iterator (self);
}


GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeAbstractCollection * self;
	self = (GeeAbstractCollection*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


gint gee_abstract_collection_get_size (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_collection_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeAbstractCollection* self;
	self = base;
	result = gee_collection_get_size ((GeeCollection*) self) == 0;
	return result;
}


static GType gee_abstract_collection_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeAbstractCollection* self;
	self = (GeeAbstractCollection*) base;
	result = self->priv->g_type;
	return result;
}


GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_read_only_view (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeCollection* gee_abstract_collection_real_get_read_only_view (GeeAbstractCollection* base) {
	GeeCollection* result;
	GeeAbstractCollection* self;
	GeeCollection* instance;
	self = base;
	instance = _g_object_ref0 (self->priv->_read_only_view);
	if (self->priv->_read_only_view == NULL) {
		GeeCollection* _tmp0_;
		instance = (_tmp0_ = (GeeCollection*) gee_read_only_collection_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeCollection*) self), _g_object_unref0 (instance), _tmp0_);
		self->priv->_read_only_view = instance;
		g_object_add_weak_pointer ((GObject*) instance, (void**) (&self->priv->_read_only_view));
	}
	result = instance;
	return result;
}


static void gee_abstract_collection_class_init (GeeAbstractCollectionClass * klass) {
	gee_abstract_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractCollectionPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_abstract_collection_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_collection_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_abstract_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_abstract_collection_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->to_array = gee_abstract_collection_real_to_array;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_abstract_collection_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains_all = gee_abstract_collection_real_contains_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove_all = gee_abstract_collection_real_remove_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->retain_all = gee_abstract_collection_real_retain_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_abstract_collection_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_abstract_collection_real_get_is_empty;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only_view = gee_abstract_collection_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_IS_EMPTY, "is-empty");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE, "element-type");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW, "read-only-view");
}


static void gee_abstract_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_abstract_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) gee_abstract_collection_iterator;
	iface->get_element_type = gee_abstract_collection_real_get_element_type;
}


static void gee_abstract_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_abstract_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_contains;
	iface->add = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_add;
	iface->remove = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_remove;
	iface->clear = (void (*)(GeeCollection*)) gee_abstract_collection_clear;
	iface->to_array = (gpointer* (*)(GeeCollection* ,int*)) gee_abstract_collection_to_array;
	iface->add_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_add_all;
	iface->contains_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_contains_all;
	iface->remove_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_remove_all;
	iface->retain_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_retain_all;
	iface->get_size = (gint (*) (GeeCollection *)) gee_abstract_collection_get_size;
	iface->get_is_empty = (gboolean (*) (GeeCollection *)) gee_abstract_collection_get_is_empty;
	iface->get_read_only_view = (GeeCollection* (*) (GeeCollection *)) gee_abstract_collection_get_read_only_view;
}


static void gee_abstract_collection_instance_init (GeeAbstractCollection * self) {
	self->priv = GEE_ABSTRACT_COLLECTION_GET_PRIVATE (self);
}


static void gee_abstract_collection_finalize (GObject* obj) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (obj);
	G_OBJECT_CLASS (gee_abstract_collection_parent_class)->finalize (obj);
}


/**
 * Skeletal implementation of the {@link Collection} interface.
 *
 * Contains common code shared by all collection implementations.
 *
 * @see AbstractList
 * @see AbstractSet
 * @see AbstractMultiSet
 */
GType gee_abstract_collection_get_type (void) {
	static volatile gsize gee_abstract_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_abstract_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractCollection), 0, (GInstanceInitFunc) gee_abstract_collection_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_abstract_collection_type_id;
		gee_abstract_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_once_init_leave (&gee_abstract_collection_type_id__volatile, gee_abstract_collection_type_id);
	}
	return gee_abstract_collection_type_id__volatile;
}


static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		case GEE_ABSTRACT_COLLECTION_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty (self));
		break;
		case GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		case GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW:
		g_value_take_object (value, gee_abstract_collection_get_read_only_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




