
#include <libgnomecanvasmm/path-def.h>
#include <libgnomecanvasmm/private/path-def_p.h>

/* path-def.cc
 *
 * Copyright (C) 2002 The libgnomecanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gnome
{

namespace Canvas
{
Gnome::Art::Point PathDef::currentpoint() const
{
  Gnome::Art::Point point;
  gnome_canvas_path_def_currentpoint(gobj(), point.gobj());
  return point;
}


} /* namespace Canvas */

} /* namespace Gnome */

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<PathDef*>(gobject) is needed:
 *
 * A PathDef instance is in fact always a GnomeCanvasPathDef instance.
 * Unfortunately, GnomeCanvasPathDef cannot be a member of PathDef,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because PathDef does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gnome::Canvas::PathDef> wrap(GnomeCanvasPathDef* object, bool take_copy)
{
  if(take_copy && object)
    gnome_canvas_path_def_duplicate(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gnome::Canvas::PathDef>(reinterpret_cast<Gnome::Canvas::PathDef*>(object));
}

} // namespace Glib


namespace Gnome
{

namespace Canvas
{


// static
Glib::RefPtr<PathDef> PathDef::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<PathDef>(reinterpret_cast<PathDef*>(gnome_canvas_path_def_new()));
}

void PathDef::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_canvas_path_def_duplicate(reinterpret_cast<GnomeCanvasPathDef*>(const_cast<PathDef*>(this)));
}

void PathDef::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_canvas_path_def_unref(reinterpret_cast<GnomeCanvasPathDef*>(const_cast<PathDef*>(this)));
}

GnomeCanvasPathDef* PathDef::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GnomeCanvasPathDef*>(this);
}

const GnomeCanvasPathDef* PathDef::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GnomeCanvasPathDef*>(this);
}

GnomeCanvasPathDef* PathDef::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GnomeCanvasPathDef *const gobject = reinterpret_cast<GnomeCanvasPathDef*>(const_cast<PathDef*>(this));
  gnome_canvas_path_def_duplicate(gobject);
  return gobject;
}

Glib::RefPtr<PathDef> PathDef::create(int length)
{
  return Glib::wrap(gnome_canvas_path_def_new_sized(length));
}

Glib::RefPtr<PathDef> PathDef::create(ArtBpath& bpath)
{
  return Glib::wrap(gnome_canvas_path_def_new_from_bpath(&(bpath)));
}

Glib::RefPtr<PathDef> PathDef::open_parts()
{
  return Glib::wrap(gnome_canvas_path_def_open_parts(gobj()));
}

Glib::RefPtr<PathDef> PathDef::closed_parts()
{
  return Glib::wrap(gnome_canvas_path_def_closed_parts(gobj()));
}

Glib::RefPtr<PathDef> PathDef::close_all()
{
  return Glib::wrap(gnome_canvas_path_def_close_all(gobj()));
}

void PathDef::finish()
{
  gnome_canvas_path_def_finish(gobj());
}

void PathDef::ensure_space(int space)
{
  gnome_canvas_path_def_ensure_space(gobj(), space);
}

void PathDef::reset()
{
  gnome_canvas_path_def_reset(gobj());
}

void PathDef::moveto(double x, double y)
{
  gnome_canvas_path_def_moveto(gobj(), x, y);
}

void PathDef::lineto(double x, double y)
{
  gnome_canvas_path_def_lineto(gobj(), x, y);
}

void PathDef::lineto_moving(double x, double y)
{
  gnome_canvas_path_def_lineto_moving(gobj(), x, y);
}

void PathDef::curveto(double x1, double y1, double x2, double y2, double x3, double y3)
{
  gnome_canvas_path_def_curveto(gobj(), x1, y1, x2, y2, x3, y3);
}

void PathDef::closepath()
{
  gnome_canvas_path_def_closepath(gobj());
}

void PathDef::closepath_current()
{
  gnome_canvas_path_def_closepath_current(gobj());
}

ArtBpath* PathDef::get_bpath() const
{
  return gnome_canvas_path_def_bpath(const_cast<GnomeCanvasPathDef*>(gobj()));
}

ArtBpath* PathDef::first_bpath() const
{
  return gnome_canvas_path_def_first_bpath(const_cast<GnomeCanvasPathDef*>(gobj()));
}

ArtBpath* PathDef::last_bpath() const
{
  return gnome_canvas_path_def_last_bpath(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::is_empty() const
{
  return gnome_canvas_path_def_is_empty(const_cast<GnomeCanvasPathDef*>(gobj()));
}

int PathDef::length() const
{
  return gnome_canvas_path_def_length(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::has_currentpoint() const
{
  return gnome_canvas_path_def_has_currentpoint(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::any_open() const
{
  return gnome_canvas_path_def_any_open(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::all_open() const
{
  return gnome_canvas_path_def_all_open(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::any_closed() const
{
  return gnome_canvas_path_def_any_closed(const_cast<GnomeCanvasPathDef*>(gobj()));
}

bool PathDef::all_closed() const
{
  return gnome_canvas_path_def_all_closed(const_cast<GnomeCanvasPathDef*>(gobj()));
}


} // namespace Canvas

} // namespace Gnome


