/* GNOME DB library
 * Copyright (C) 1999-2001, The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_connection_selector_h__)
#  define __gnome_db_connection_selector_h__

#include <gtk/gtkoptionmenu.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_CONNECTION_SELECTOR            (gnome_db_connection_selector_get_type())
#define GNOME_DB_CONNECTION_SELECTOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_CONNECTION_SELECTOR, GnomeDbConnectionSelector))
#define GNOME_DB_CONNECTION_SELECTOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_CONNECTION_SELECTOR, GnomeDbConnectionSelectorClass))
#define GNOME_DB_IS_CONNECTION_SELECTOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_CONNECTION_SELECTOR))
#define GNOME_DB_IS_CONNECTION_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_CONNECTION_SELECTOR))

typedef struct _GnomeDbConnectionSelector        GnomeDbConnectionSelector;
typedef struct _GnomeDbConnectionSelectorClass   GnomeDbConnectionSelectorClass;
typedef struct _GnomeDbConnectionSelectorPrivate GnomeDbConnectionSelectorPrivate;

struct _GnomeDbConnectionSelector {
	GtkOptionMenu menu;
	GnomeDbConnectionSelectorPrivate *priv;
};

struct _GnomeDbConnectionSelectorClass {
	GtkOptionMenuClass parent_class;
};

GType      gnome_db_connection_selector_get_type (void);
GtkWidget *gnome_db_connection_selector_new (void);

G_END_DECLS

#endif
