/* GNOME-DB Components
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <bonobo/bonobo-listener.h>
#include <libgnomedb/gnome-db-browser.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomedb/gnome-db-window.h>
#include "connection-mime-handler.h"
#include "db-shell.h"
#include "utils.h"

static void
window_closed_cb (GnomeDbWindow *window, gpointer user_data)
{
	GList *window_list;
	BonoboListener *listener = user_data;

	window_list = g_object_get_data (G_OBJECT (listener), "GnomeDbComponents_WindowList");
	window_list = g_list_remove (window_list, window);
	g_object_set_data (G_OBJECT (listener), "GnomeDbComponents_WindowList", window_list);

	if (!window_list)
		bonobo_object_unref (BONOBO_OBJECT (listener));
}

static void
listener_event_cb (BonoboListener *listener,
		   const char *event_name,
		   const CORBA_any *args,
		   CORBA_Environment *ev,
		   gpointer user_data)
{
	const CORBA_sequence_CORBA_string *list;
	gint i;
	GList *window_list;

	if (!CORBA_TypeCode_equivalent (args->_type, TC_CORBA_sequence_CORBA_string, ev))
		return;
	list = (CORBA_sequence_CORBA_string *) args->_value;

	g_return_if_fail (list != NULL);

	window_list = g_object_get_data (G_OBJECT (listener), "GnomeDbComponents_WindowList");
	for (i = 0; i < list->_length; i++) {
		GdaConnection *cnc;
		GtkWidget *widget, *window;

		/* log the user into the database */
		if (!(cnc = db_connect (list->_buffer[i])))
			continue;

		if (!strcmp (event_name, "BrowseDatabase")) {
			widget = gnome_db_browser_new ();
			gnome_db_browser_set_connection (GNOME_DB_BROWSER (widget), cnc);

			window = db_shell_new (_("Database browser"), widget, cnc);
		} else {
			g_object_unref (cnc);
			return;
		}

		window_list = g_list_append (window_list, window);

		g_signal_connect (window, "close", G_CALLBACK (window_closed_cb), listener);
	}

	if (window_list)
		g_object_set_data (G_OBJECT (listener), "GnomeDbComponents_WindowList", window_list);
	else
		bonobo_object_unref (BONOBO_OBJECT (listener));
}

BonoboObject *
connection_mime_handler_new (void)
{
	return (BonoboObject *) bonobo_listener_new ((BonoboListenerCallbackFn) listener_event_cb,
						     NULL);
}
