/* GNOME-DB Components
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <locale.h>
#include <string.h>
#include <bonobo/bonobo-generic-factory.h>
#include <libgnomedb/libgnomedb.h>
#include "connection-mime-handler.h"
#include "sql-mime-handler.h"

static void client_error_cb (GdaClient *client, GdaConnection *cnc,
			     GList *error_list, gpointer user_data);
static void initialize_component_factory (gpointer user_data);

static gint objects_loaded = 0;
GdaClient *db_client = NULL;

int
main (int argc, char *argv[])
{
	setlocale (LC_ALL, "");
        bindtextdomain (GETTEXT_PACKAGE, LIBGNOMEDB_LOCALEDIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
        textdomain (GETTEXT_PACKAGE);

        /* initialize application */
        gnome_db_init ("gnome-database-components", VERSION, argc, argv);

	db_client = gda_client_new ();
	g_signal_connect (G_OBJECT (db_client), "error",
			  G_CALLBACK (client_error_cb), NULL);

        /* run application */
        gnome_db_main_run ((GdaInitFunc) initialize_component_factory, NULL);

        /* free all resources */
        g_object_unref (G_OBJECT (db_client));

        return 0;
}

static void
client_error_cb (GdaClient *client, GdaConnection *cnc,
		 GList *error_list, gpointer user_data)
{
	GtkWidget *error_dialog;

        g_return_if_fail (GDA_IS_CLIENT (client));
        g_return_if_fail (GDA_IS_CONNECTION (cnc));
        g_return_if_fail (error_list != NULL);

        if (error_list != NULL) {
                error_dialog = gnome_db_error_dialog_new (_("Error viewer"));
                gnome_db_error_dialog_show_errors (GNOME_DB_ERROR_DIALOG (error_dialog),
                                                   error_list);
        }
}

static void
object_destroyed_cb (BonoboObject *object, gpointer user_data)
{
        objects_loaded--;
        if (objects_loaded == 0)
                gnome_db_main_quit ();
}

static BonoboObject *
factory_callback (BonoboGenericFactory *factory, const gchar *id, gpointer closure)
{
	BonoboObject *object = NULL;

	if (!strcmp (id, "OAFIID:GNOME_Database_ConnectionMimeHandler_Component"))
		object = connection_mime_handler_new ();
	else if (!strcmp (id, "OAFIID:GNOME_Database_SqlMimeHandler_Component"))
		object = sql_mime_handler_new ();

	if (BONOBO_IS_OBJECT (object)) {
                objects_loaded++;
                g_signal_connect (G_OBJECT (object), "destroy",
                                  G_CALLBACK (object_destroyed_cb), NULL);
        }

        return object;
}

static void
initialize_component_factory (gpointer user_data)
{
        BonoboGenericFactory *component_factory;

        component_factory = bonobo_generic_factory_new (
                "OAFIID:GNOME_Database_ComponentFactory",
                factory_callback,
                NULL);
        if (!component_factory) {
                gnome_db_main_quit ();
                return;
        }
}
