/* graph-utility.h
 * Copyright (C) 2004 Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomecanvas/libgnomecanvas.h>
#include "gnome-db-canvas-entity.h"

typedef enum {
	CANVAS_SHAPE_EXT_JOIN_OUTER_1  = 1 << 0,
	CANVAS_SHAPE_EXT_JOIN_OUTER_2  = 1 << 1
} CanvasShapeExt;

/* structure to return shapes, being either points or a path definition */
typedef struct {
	guint                       type; /* GNOME_TYPE_CANVAS_TEXT | _LINE | _RECT | _BPATH */
	union {
		GnomeCanvasPoints  *points;
		GnomeCanvasPathDef *path_def;
	} d;

	gchar                      *text;
	GtkAnchorType               text_anchor;
} CanvasShape;
#define CANVAS_SHAPE(x) ((CanvasShape*)(x))

GSList *graph_util_compute_anchor_shapes  (GnomeDbCanvasEntity *fk_ent, GnomeDbCanvasEntity *ref_pk_ent,
					   guint nb_anchors, guint ext);
GSList *graph_util_compute_connect_shapes (GnomeDbCanvasEntity *ent1, GnomeDbField *field1,
					   GnomeDbCanvasEntity *ent2, GnomeDbField *field2, guint ext);
GSList *graph_util_compute_handle_shapes  (gdouble x1, gdouble y1, gdouble x2, gdouble y2);
void    graph_util_free_canvas_shapes     (GSList *canvas_shapes);

GSList *graph_util_draw_canvas_shapes     (GnomeCanvasGroup *cg, GSList *canvas_shapes);
