/* Dictionary browser
 *
 * The GnomeDbSeletor widget can be used to display
 * parts of the dictionary
 */

#include <libgnomedb/libgnomedb.h>
#include <libgnomedb-extra/libgnomedb-extra.h>

extern GdaDict *demo_dict;
static GtkWidget *window = NULL;

typedef struct {
	GtkWidget  *table;
        GtkWidget  *selector;
	guint       sel_mode;
	guint       sel_columns;
} DemoData;

static GtkWidget *make_selector_mode (DemoData *data);
static void selector_mode_toggled_cb (GtkCheckButton *cb, DemoData *data);

GtkWidget *
do_selector (GtkWidget *do_widget)
{  
	if (!window) {
		GtkWidget *table;
		GtkWidget *label;
		GtkWidget *mode;
		DemoData *data;

                data = g_new0 (DemoData, 1);

		window = gtk_dialog_new_with_buttons ("Dictionary browser",
						      GTK_WINDOW (do_widget),
						      0,
						      GTK_STOCK_CLOSE,
						      GTK_RESPONSE_NONE,
						      NULL);
		
		g_signal_connect (window, "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
		g_signal_connect (window, "destroy",
				  G_CALLBACK (gtk_widget_destroyed), &window);
		
		table = gtk_table_new (3, 2, FALSE);
		data->table = table;
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), table, TRUE, TRUE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (table), 5);
		
		label = gtk_label_new ("The following GnomeDbSelector widget displays\n"
				       "data stored in the dictionary. Select on the left part\n"
				       "what should be displayed");
		gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1, 0, 0, 0, 0);
		
		/* selector's mode */
		label = gtk_label_new ("<b>Information displayed:</b>");
		gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
		gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, 0, 0, 0, 0);
		mode = make_selector_mode (data);
		gtk_table_attach (GTK_TABLE (table), mode, 0, 1, 2, 3, GTK_FILL, 
				  GTK_EXPAND | GTK_FILL, 0, 0);
		
		/* selector widget preparation */
		label = gtk_label_new ("<b>GnomeDbSelector widget:</b>");
		gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
		gtk_table_attach (GTK_TABLE (table), label, 1, 2, 1, 2, 0, 0, 0, 0);
		gtk_widget_set_size_request (window, 500, 550);
	}

	if (!GTK_WIDGET_VISIBLE (window))
		gtk_widget_show_all (window);
	else
		gtk_widget_destroy (window);

	return window;
}

static GtkWidget *
make_selector_mode (DemoData *data)
{
	GtkWidget *vb, *cb, *label, *hbox;
	GtkWidget *mode;

	vb = gtk_vbox_new (FALSE, 0);
	mode = vb;

	cb = gtk_check_button_new_with_label ("Data types");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_DATA_TYPES));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);


	cb = gtk_check_button_new_with_label ("Functions");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_FUNCTIONS));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	cb = gtk_check_button_new_with_label ("Aggregates");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_AGGREGATES));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);


	cb = gtk_check_button_new_with_label ("Tables");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_TABLES));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cb), TRUE);

	hbox = gtk_hbox_new (FALSE, 0); /* Offset */
	gtk_box_pack_start (GTK_BOX (vb), hbox, FALSE, FALSE, 0);
	label = gtk_label_new ("    ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	cb = gtk_check_button_new_with_label ("Fields");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_FIELDS));
	gtk_box_pack_start (GTK_BOX (hbox), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cb), TRUE);


	cb = gtk_check_button_new_with_label ("Queries");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_QUERIES));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	hbox = gtk_hbox_new (FALSE, 0); /* Offset */
	gtk_box_pack_start (GTK_BOX (vb), hbox, FALSE, FALSE, 0);
	label = gtk_label_new ("    ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	vb = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vb, FALSE, FALSE, 0);

	cb = gtk_check_button_new_with_label ("Targets");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_TARGETS));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	cb = gtk_check_button_new_with_label ("Joins");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_JOINS));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	cb = gtk_check_button_new_with_label ("Visible fields");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_QVIS_FIELDS));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	cb = gtk_check_button_new_with_label ("All fields");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_QALL_FIELDS));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	cb = gtk_check_button_new_with_label ("Sub queries");
	g_object_set_data (G_OBJECT (cb), "mode", GUINT_TO_POINTER (GNOME_DB_SELECTOR_SUB_QUERIES));
	gtk_box_pack_start (GTK_BOX (vb), cb, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (cb), "toggled", 
			  G_CALLBACK (selector_mode_toggled_cb), data);

	return mode;
}

static void
selector_mode_toggled_cb (GtkCheckButton *cb, DemoData *data)
{
	GtkWidget *selector;
	guint cb_mode = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (cb), "mode"));
		
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cb))) 
		data->sel_mode = data->sel_mode | cb_mode;
	else
		data->sel_mode = data->sel_mode & ~cb_mode;

	if (data->selector) {
		gtk_widget_destroy (data->selector);
		data->selector = NULL;
	}
	selector = gnome_db_selector_new (demo_dict, NULL, data->sel_mode, data->sel_columns);
	gtk_table_attach_defaults (GTK_TABLE (data->table), selector, 1, 2, 2, 3);
	gtk_widget_show (selector);
	data->selector = selector;
}
