
#include <libgnomeuimm/client.h>
#include <libgnomeuimm/private/client_p.h>

/* $Id: client.ccg,v 1.7 2002/01/19 04:26:33 daniel Exp $ */


/* client.ccg
 * 
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>

namespace Gnome
{

namespace UI
{

Client::Client(bool connect_to_sm)
  :  Gtk::Object(GTK_OBJECT(g_object_new(get_type(),0)))
{
  gobj()->program = 0; // this should normally be program_invocation_name

  if(connect_to_sm)
    connect_to_session_manager();
}

void
Client::set_restart_command (const Glib::ArrayHandle<Glib::ustring>& argv)
{
  gnome_client_set_restart_command(gobj(), argv.size(), const_cast<char**>(argv.data()));
}

void 
Client::set_discard_command(const Glib::ArrayHandle<Glib::ustring>& argv)
{
  gnome_client_set_discard_command(gobj(), argv.size(), const_cast<char**>(argv.data()));
}

void 
Client::set_shutdown_command(const Glib::ArrayHandle<Glib::ustring>& argv)
{
  gnome_client_set_shutdown_command(gobj(), argv.size(), const_cast<char**>(argv.data()));
}

void  
Client::set_resign_command (const Glib::ArrayHandle<Glib::ustring>& argv)
{
  gnome_client_set_resign_command(gobj(), argv.size(), const_cast<char**>(argv.data()));
}

void  
Client::set_clone_command (const Glib::ArrayHandle<Glib::ustring>& argv)
{
  gnome_client_set_clone_command(gobj(), argv.size(),
				 const_cast<char**>(argv.data()));
}

bool
Client::is_connected()
{
  return GNOME_CLIENT_CONNECTED(gobj());
}

} /* namespace UI */
} /* namespace Gnome */


namespace
{


gboolean Client_signal_save_yourself_callback(GnomeClient*, gint p0,GnomeSaveStyle p1,gboolean p2,GnomeInteractStyle p3,gboolean p4,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot5<bool,int,GnomeSaveStyle,bool,GnomeInteractStyle,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1,p2
,p3,p4
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Client_signal_save_yourself_notify_callback(GnomeClient*, gint p0,GnomeSaveStyle p1,gboolean p2,GnomeInteractStyle p3,gboolean p4,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot5<void,int,GnomeSaveStyle,bool,GnomeInteractStyle,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1,p2
,p3,p4
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Client_signal_save_yourself_info =
{
  "save_yourself",
  (GCallback) &Client_signal_save_yourself_callback,
  (GCallback) &Client_signal_save_yourself_notify_callback
};


const Glib::SignalProxyInfo Client_signal_die_info =
{
  "die",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Client_signal_save_complete_info =
{
  "save_complete",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Client_signal_shutdown_cancelled_info =
{
  "shutdown_cancelled",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void Client_signal_connect_callback(GnomeClient*, gboolean p0,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Client_signal_connect_info =
{
  "connect",
  (GCallback) &Client_signal_connect_callback,
  (GCallback) &Client_signal_connect_callback
};


const Glib::SignalProxyInfo Client_signal_disconnect_info =
{
  "disconnect",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::Client* wrap(GnomeClient* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::Client *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType Client_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_client_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Client_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->save_yourself = &save_yourself_callback;
  klass->die = &die_callback;
  klass->save_complete = &save_complete_callback;
  klass->shutdown_cancelled = &shutdown_cancelled_callback;
  klass->connect = &connect_callback;
  klass->disconnect = &disconnect_callback;
}


gboolean Client_Class::save_yourself_callback(GnomeClient* self, gint p0, GnomeSaveStyle p1, gboolean p2, GnomeInteractStyle p3, gboolean p4)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_save_yourself(p0
, p1, p2
, p3, p4
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->save_yourself)
      (*base->save_yourself)(self, p0, p1, p2, p3, p4);
  }

  typedef gboolean RType;
  return RType();
}

void Client_Class::die_callback(GnomeClient* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_die();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->die)
      (*base->die)(self);
  }
}

void Client_Class::save_complete_callback(GnomeClient* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_save_complete();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->save_complete)
      (*base->save_complete)(self);
  }
}

void Client_Class::shutdown_cancelled_callback(GnomeClient* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_shutdown_cancelled();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->shutdown_cancelled)
      (*base->shutdown_cancelled)(self);
  }
}

void Client_Class::connect_callback(GnomeClient* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_connect(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->connect)
      (*base->connect)(self, p0);
  }
}

void Client_Class::disconnect_callback(GnomeClient* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_disconnect();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->disconnect)
      (*base->disconnect)(self);
  }
}


Glib::ObjectBase* Client_Class::wrap_new(GObject* o)
{
  return manage(new Client((GnomeClient*)(o)));
}


/* The implementation: */

Client::Client(GnomeClient* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

Client::~Client()
{
  destroy_();
}

Client::CppClassType Client::client_class_; //Initialize static member.

GType Client::get_type()
{
  return client_class_.get_type();
}

GType Client::get_base_type()
{
  return gnome_client_get_type();
}

Client* Client::master_client()
{
  return Glib::wrap(gnome_master_client());
}

Glib::ustring Client::get_config_prefix()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_client_get_config_prefix(gobj()));
}

Glib::ustring Client::get_global_config_prefix()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_client_get_global_config_prefix(gobj()));
}

void Client::set_global_config_prefix(const Glib::ustring& prefix)
{
  gnome_client_set_global_config_prefix(gobj(), prefix.c_str());
}

GnomeClientFlags Client::get_flags()
{
  return gnome_client_get_flags(gobj());
}

void Client::set_restart_style(GnomeRestartStyle style)
{
  gnome_client_set_restart_style(gobj(), style);
}

void Client::set_priority(guint priority)
{
  gnome_client_set_priority(gobj(), priority);
}

void Client::set_restart_command(gint argc, char** argv)
{
  gnome_client_set_restart_command(gobj(), argc, argv);
}

void Client::set_discard_command(gint argc, char** argv)
{
  gnome_client_set_discard_command(gobj(), argc, argv);
}

void Client::set_resign_command(gint argc, char** argv)
{
  gnome_client_set_resign_command(gobj(), argc, argv);
}

void Client::set_shutdown_command(gint argc, char** argv)
{
  gnome_client_set_shutdown_command(gobj(), argc, argv);
}

void Client::set_current_directory(const Glib::ustring& dir)
{
  gnome_client_set_current_directory(gobj(), dir.c_str());
}

void Client::set_environment(const Glib::ustring& name, const Glib::ustring& value)
{
  gnome_client_set_environment(gobj(), name.c_str(), value.c_str());
}

void Client::set_clone_command(gint argc, char** argv)
{
  gnome_client_set_clone_command(gobj(), argc, argv);
}

void Client::set_process_id(pid_t pid)
{
  gnome_client_set_process_id(gobj(), pid);
}

void Client::set_program(const Glib::ustring& program)
{
  gnome_client_set_program(gobj(), program.c_str());
}

void Client::set_user_id(const Glib::ustring& user_id)
{
  gnome_client_set_user_id(gobj(), user_id.c_str());
}

void Client::save_any_dialog(Gtk::Dialog& dialog)
{
  gnome_client_save_any_dialog(gobj(), dialog.gobj());
}

void Client::save_error_dialog(Gtk::Dialog& dialog)
{
  gnome_client_save_error_dialog(gobj(), dialog.gobj());
}

void Client::request_phase_2()
{
  gnome_client_request_phase_2(gobj());
}

void Client::request_save(GnomeSaveStyle save_style, bool shutdown, GnomeInteractStyle interact_style, bool fast, bool global)
{
  gnome_client_request_save(gobj(), save_style, static_cast<int>(shutdown), interact_style, static_cast<int>(fast), static_cast<int>(global));
}

void Client::flush()
{
  gnome_client_flush(gobj());
}

void Client::connect_to_session_manager()
{
  gnome_client_connect(gobj());
}

void Client::disconnect()
{
  gnome_client_disconnect(gobj());
}

void Client::set_id(const Glib::ustring& client_id)
{
  gnome_client_set_id(gobj(), client_id.c_str());
}

Glib::ustring Client::get_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_client_get_id(const_cast<GnomeClient*>(gobj())));
}

Glib::ustring Client::get_previous_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_client_get_previous_id(const_cast<GnomeClient*>(gobj())));
}

Glib::ustring Client::get_desktop_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_client_get_desktop_id(const_cast<GnomeClient*>(gobj())));
}

void Client::request_interaction(GnomeDialogType dialog, GnomeInteractFunction func, gpointer client_data)
{
  gnome_client_request_interaction(gobj(), dialog, func, client_data);
}

void Client::gnome_interaction_key_return(gint key, bool cancel_shutdown)
{
  gnome_interaction_key_return(key, static_cast<int>(cancel_shutdown));
}


Glib::SignalProxy5<bool,int,GnomeSaveStyle,bool,GnomeInteractStyle,bool> Client::signal_save_yourself()
{
  return Glib::SignalProxy5<bool,int,GnomeSaveStyle,bool,GnomeInteractStyle,bool>(this, &Client_signal_save_yourself_info);
}

Glib::SignalProxy0<void> Client::signal_die()
{
  return Glib::SignalProxy0<void>(this, &Client_signal_die_info);
}

Glib::SignalProxy0<void> Client::signal_save_complete()
{
  return Glib::SignalProxy0<void>(this, &Client_signal_save_complete_info);
}

Glib::SignalProxy0<void> Client::signal_shutdown_cancelled()
{
  return Glib::SignalProxy0<void>(this, &Client_signal_shutdown_cancelled_info);
}

Glib::SignalProxy1<void,bool> Client::signal_connect()
{
  return Glib::SignalProxy1<void,bool>(this, &Client_signal_connect_info);
}

Glib::SignalProxy0<void> Client::signal_disconnect()
{
  return Glib::SignalProxy0<void>(this, &Client_signal_disconnect_info);
}


bool Gnome::UI::Client::on_save_yourself(int phase, GnomeSaveStyle save_style, bool shutdown, GnomeInteractStyle interact_style, bool fast)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->save_yourself)
    return (*base->save_yourself)(gobj(),phase,save_style,static_cast<int>(shutdown),interact_style,static_cast<int>(fast));

  typedef bool RType;
  return RType();
}

void Gnome::UI::Client::on_die()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->die)
    (*base->die)(gobj());
}

void Gnome::UI::Client::on_save_complete()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->save_complete)
    (*base->save_complete)(gobj());
}

void Gnome::UI::Client::on_shutdown_cancelled()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->shutdown_cancelled)
    (*base->shutdown_cancelled)(gobj());
}

void Gnome::UI::Client::on_connect(bool restarted)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->connect)
    (*base->connect)(gobj(),static_cast<int>(restarted));
}

void Gnome::UI::Client::on_disconnect()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->disconnect)
    (*base->disconnect)(gobj());
}


} // namespace UI

} // namespace Gnome

