
#include <libgnomeuimm/color-picker.h>
#include <libgnomeuimm/private/color-picker_p.h>

// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in
/* $Id: color-picker.ccg,v 1.5 2001/12/05 16:40:56 murrayc Exp $ */

/* color-picker.cc
 * 
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * Copyright (C) 1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomeui/gnome-color-picker.h>


namespace
{


void ColorPicker_signal_color_set_callback(GnomeColorPicker*, guint p0,guint p1,guint p2,guint p3,void* data)
{
  using namespace Gnome::UI;
  typedef SigC::Slot4<void,guint,guint,guint,guint> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,p1,p2,p3, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo ColorPicker_signal_color_set_info =
{
  "color_set",
  (GCallback) &ColorPicker_signal_color_set_callback,
  (GCallback) &ColorPicker_signal_color_set_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::UI::ColorPicker* wrap(GnomeColorPicker* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::UI::ColorPicker *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace UI
{


/* The *_Class implementation: */

GType ColorPicker_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gnome_color_picker_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void ColorPicker_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->color_set = &color_set_callback;
}


void ColorPicker_Class::color_set_callback(GnomeColorPicker* self, guint p0, guint p1, guint p2, guint p3)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_color_set(p0, p1, p2, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->color_set)
      (*base->color_set)(self, p0, p1, p2, p3);
  }
}


Glib::ObjectBase* ColorPicker_Class::wrap_new(GObject* o)
{
  return manage(new ColorPicker((GnomeColorPicker*)(o)));
}


/* The implementation: */

ColorPicker::ColorPicker(GnomeColorPicker* castitem)
: Gtk::Button((GtkButton*)(castitem))
{}

ColorPicker::~ColorPicker()
{
  destroy_();
}

ColorPicker::CppClassType ColorPicker::colorpicker_class_; //Initialize static member.

GType ColorPicker::get_type()
{
  return colorpicker_class_.get_type();
}

GType ColorPicker::get_base_type()
{
  return gnome_color_picker_get_type();
}

ColorPicker::ColorPicker()
: Gtk::Button((GtkButton*)(g_object_new(get_type(), (char*)0)))
{}

void ColorPicker::set(double r, double g, double b, double a)
{
  gnome_color_picker_set_d(gobj(), r, g, b, a);
}

void ColorPicker::set(guint8 r, guint8 g, guint8 b, guint8 a)
{
  gnome_color_picker_set_i8(gobj(), r, g, b, a);
}

void ColorPicker::set(gushort r, gushort g, gushort b, gushort a)
{
  gnome_color_picker_set_i16(gobj(), r, g, b, a);
}

void ColorPicker::get(double& r, double& g, double& b, double& a) const
{
  gnome_color_picker_get_d(const_cast<GnomeColorPicker*>(gobj()), &(r), &(g), &(b), &(a));
}

void ColorPicker::get(guint8& r, guint8& g, guint8& b, guint8& a) const
{
  gnome_color_picker_get_i8(const_cast<GnomeColorPicker*>(gobj()), &(r), &(g), &(b), &(a));
}

void ColorPicker::get(gushort& r, gushort& g, gushort& b, gushort& a) const
{
  gnome_color_picker_get_i16(const_cast<GnomeColorPicker*>(gobj()), &(r), &(g), &(b), &(a));
}

void ColorPicker::set_dither(bool dither)
{
  gnome_color_picker_set_dither(gobj(), static_cast<int>(dither));
}

bool ColorPicker::get_dither() const
{
  return gnome_color_picker_get_dither(const_cast<GnomeColorPicker*>(gobj()));
}

void ColorPicker::set_use_alpha(bool use_alpha)
{
  gnome_color_picker_set_use_alpha(gobj(), static_cast<int>(use_alpha));
}

bool ColorPicker::get_use_alpha() const
{
  return gnome_color_picker_get_use_alpha(const_cast<GnomeColorPicker*>(gobj()));
}

void ColorPicker::set_title(const Glib::ustring& title)
{
  gnome_color_picker_set_title(gobj(), title.c_str());
}

Glib::ustring ColorPicker::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_color_picker_get_title(const_cast<GnomeColorPicker*>(gobj())));
}


Glib::SignalProxy4<void,guint,guint,guint,guint> ColorPicker::signal_color_set()
{
  return Glib::SignalProxy4<void,guint,guint,guint,guint>(this, &ColorPicker_signal_color_set_info);
}


Glib::PropertyProxy<bool> ColorPicker::property_dither()
{
  return Glib::PropertyProxy<bool>(this, "dither");
}

Glib::PropertyProxy<bool> ColorPicker::property_use_alpha()
{
  return Glib::PropertyProxy<bool>(this, "use_alpha");
}

Glib::PropertyProxy<Glib::ustring> ColorPicker::property_title()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "title");
}

Glib::PropertyProxy<guint> ColorPicker::property_red()
{
  return Glib::PropertyProxy<guint>(this, "red");
}

Glib::PropertyProxy<guint> ColorPicker::property_green()
{
  return Glib::PropertyProxy<guint>(this, "green");
}

Glib::PropertyProxy<guint> ColorPicker::property_blue()
{
  return Glib::PropertyProxy<guint>(this, "blue");
}

Glib::PropertyProxy<guint> ColorPicker::property_alpha()
{
  return Glib::PropertyProxy<guint>(this, "alpha");
}


void Gnome::UI::ColorPicker::on_color_set(guint r, guint g, guint b, guint a)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->color_set)
    (*base->color_set)(gobj(),r,g,b,a);
}


} // namespace UI

} // namespace Gnome

