/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreeModel;

/**
  * This event is used to identify when a EntryCompletion receives an event
 * 
 * @see EntryCompletionListener
 */
public class EntryCompletionEvent extends GtkEvent {
	
	private TreeModel model;
	private TreeIter iter;
	private int index;

	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		/**
		 */
		public static final Type MATCH_SELECTED = new Type(1, "MATCH_SELECTED");

		/**
		 */
		public static final Type ACTION_ACTIVATED = new Type(2, "ACTION_ACTIVATED");

	}

	/**
	 * Constructor for EntryCompletionEvent.
	 * @param source
	 * @param type
	 */
	public EntryCompletionEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DialogEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
	/**
	 * @return Returns the index.
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @param index The index to set.
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * @return Returns the iter.
	 */
	public TreeIter getIter() {
		return iter;
	}

	/**
	 * @param iter The iter to set.
	 */
	public void setIter(TreeIter iter) {
		this.iter = iter;
	}

	/**
	 * @return Returns the model.
	 */
	public TreeModel getModel() {
		return model;
	}

	/**
	 * @param model The model to set.
	 */
	public void setModel(TreeModel model) {
		this.model = model;
	}

}
