/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-09-28 10:15:52 BST
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

 	JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1string_1from_1iter( JNIEnv *env, jclass cls, jint treeModel, jint iter ){
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
		char * result = gtk_tree_model_get_string_from_iter( treeModel_g, iter_g );
		jstring result_j = (*env)->NewStringUTF(env, result);
		g_free(result);
		return result_j;
	}
	
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iterExists (JNIEnv *env, 
        jclass cls, jint treeModel, int path) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_get_iter (treeModel_g, iter_g, path_g));
            return result_j;
        }
    }
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iterObj (JNIEnv *env, 
        jclass cls, jint treeModel, jint path) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
        GtkTreePath *path_g = (GtkTreePath *)path;
        gtk_tree_model_get_iter (treeModel_g, iter_g, path_g);
        return (jint) iter_g;
    }
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1from_1stringExists (
        JNIEnv *env, jclass cls, jint treeModel, jstring pathString) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
        const gchar* pathString_g = (*env)->GetStringUTFChars( env, pathString, NULL);
		jboolean result_j = (jboolean) (gtk_tree_model_get_iter_from_string (treeModel_g, 
				iter_g, pathString_g));
		(*env)->ReleaseStringUTFChars( env, pathString, pathString_g);
		return result_j;
    }
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1from_1stringObj (
        JNIEnv *env, jclass cls, jint treeModel, jstring pathString) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *) g_malloc(sizeof(GtkTreeIter));
        const gchar* pathString_g = (*env)->GetStringUTFChars( env, pathString, NULL);
		 gtk_tree_model_get_iter_from_string (treeModel_g, 
				iter_g, pathString_g);
		(*env)->ReleaseStringUTFChars( env, pathString, pathString_g);
		return (jint)iter_g;
    }

    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1firstExists (
        JNIEnv *env, jclass cls, jint treeModel) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
        {
            jboolean result_j = (jboolean) (gtk_tree_model_get_iter_first (treeModel_g, iter_g));
            return result_j;
        }
    }
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1firstObj (
        JNIEnv *env, jclass cls, jint treeModel) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)g_malloc(sizeof(GtkTreeIter));
        {
            gtk_tree_model_get_iter_first (treeModel_g, iter_g);
            return (jint) iter_g;
        }
    }
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1childrenGet (JNIEnv 
        *env, jclass cls, jint treeModel, jint parent) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *) g_malloc(sizeof(GtkTreeIter));
        GtkTreeIter *parent_g = (GtkTreeIter *)parent;
        {
            gtk_tree_model_iter_children (treeModel_g, iter_g, 
                    parent_g);
            return (jint) iter_g;
        }
    }
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1type (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gtk_tree_model_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_flags
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1flags (JNIEnv *env, 
        jclass cls, jint treeModel) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        {
            jint result_j = (jint) (gtk_tree_model_get_flags (treeModel_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_n_columns
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1n_1columns (JNIEnv 
        *env, jclass cls, jint treeModel) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        {
            jint result_j = (jint) (gtk_tree_model_get_n_columns (treeModel_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_column_type
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1column_1type (JNIEnv 
        *env, jclass cls, jint treeModel, jint index) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        gint32 index_g = (gint32) index;
        {
            return (jint)gtk_tree_model_get_column_type (treeModel_g, index_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_iter
     * Signature: (III)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter (JNIEnv *env, 
        jclass cls, jint treeModel, jint iter, jint path) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_get_iter (treeModel_g, iter_g, path_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_iter_from_string
     * Signature: (II[B)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1from_1string (
        JNIEnv *env, jclass cls, jint treeModel, jint iter, jstring pathString) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
		const gchar* pathString_g = (*env)->GetStringUTFChars( env, pathString, NULL);
		jboolean result_j = (jboolean) (gtk_tree_model_get_iter_from_string (treeModel_g, 
				iter_g, pathString_g));
		(*env)->ReleaseStringUTFChars(env, pathString, pathString_g );
		return result_j;
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_iter_first
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1first (
        JNIEnv *env, jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_get_iter_first (treeModel_g, iter_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_path
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1path (JNIEnv *env, 
        jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            return (jint)gtk_tree_model_get_path (treeModel_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_get_value
     * Signature: (III)I
     */
    JNIEXPORT int JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1value (JNIEnv *env, 
        jclass cls, jint treeModel, jint iter, jint column) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        gint32 column_g = (gint32) column;
        GValue *value_g = (GValue *) g_malloc(sizeof(GValue));
		value_g->g_type = 0;
        gtk_tree_model_get_value (treeModel_g, iter_g, column_g, value_g);
        return (jint)value_g;
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_next
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1next (JNIEnv 
        *env, jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_iter_next (treeModel_g, iter_g));
            if (result_j == JNI_TRUE)
            	return (jint)iter_g;
            return -1;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_children
     * Signature: (III)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1children (JNIEnv 
        *env, jclass cls, jint treeModel, jint iter, jint parent) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        GtkTreeIter *parent_g = (GtkTreeIter *)parent;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_iter_children (treeModel_g, iter_g, 
                    parent_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_has_child
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1has_1child (
        JNIEnv *env, jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_iter_has_child (treeModel_g, iter_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_n_children
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1n_1children (JNIEnv 
        *env, jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jint result_j = (jint) (gtk_tree_model_iter_n_children (treeModel_g, iter_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_nth_child
     * Signature: (IIII)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1nth_1child (
        JNIEnv *env, jclass cls, jint treeModel, jint iter, jint parent, jint n) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        GtkTreeIter *parent_g = (GtkTreeIter *)parent;
        gint32 n_g = (gint32) n;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_iter_nth_child (treeModel_g, iter_g, 
                    parent_g, n_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_iter_parent
     * Signature: (III)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1parent (JNIEnv 
        *env, jclass cls, jint treeModel, jint iter, jint child) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        GtkTreeIter *child_g = (GtkTreeIter *)child;
        {
            jboolean result_j = (jboolean) (gtk_tree_model_iter_parent (treeModel_g, iter_g, 
                    child_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_ref_node
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1ref_1node (JNIEnv *env, 
        jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_model_ref_node (treeModel_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_unref_node
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1unref_1node (JNIEnv *env, 
        jclass cls, jint treeModel, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_model_unref_node (treeModel_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_row_changed
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1changed (JNIEnv *env, 
        jclass cls, jint treeModel, jint path, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreePath *path_g = (GtkTreePath *)path;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_model_row_changed (treeModel_g, path_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_row_inserted
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1inserted (JNIEnv *env, 
        jclass cls, jint treeModel, jint path, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreePath *path_g = (GtkTreePath *)path;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_model_row_inserted (treeModel_g, path_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_row_has_child_toggled
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1has_1child_1toggled (
        JNIEnv *env, jclass cls, jint treeModel, jint path, jint iter) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreePath *path_g = (GtkTreePath *)path;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_model_row_has_child_toggled (treeModel_g, path_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_row_deleted
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1deleted (JNIEnv *env, 
        jclass cls, jint treeModel, jint path) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            gtk_tree_model_row_deleted (treeModel_g, path_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeModel
     * Method:    gtk_tree_model_rows_reordered
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1rows_1reordered (JNIEnv 
        *env, jclass cls, jint treeModel, jint path, jint iter, jint newOrder) 
    {
        GtkTreeModel *treeModel_g = (GtkTreeModel *)treeModel;
        GtkTreePath *path_g = (GtkTreePath *)path;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        gint32 *newOrder_g = (gint32*) newOrder;
        {
            gtk_tree_model_rows_reordered (treeModel_g, path_g, iter_g, newOrder_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
