/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 12:41:21 EDT
 */

package org.gnu.atk;

import org.gnu.glib.GObject;

public class RelationSet extends GObject 
{
	/**
	 * Create a new empty RelationSet
	 */
	public RelationSet() {
		setHandle(atk_relation_set_new());
	}
	
	/**
	 * Add a new relation to the current relation set if it is not already present.
	 */
	public void add(Relation relation) {
		atk_relation_set_add(getHandle(), relation.getHandle());
	}
	
	/**
	 * Remove a relation from the relation set.
	 */
	public void remove(Relation relation) {
		atk_relation_set_remove(getHandle(), relation.getHandle());
	}
	
	/**
	 * Determines whether the relation set contains a relation that matches
	 * the specified type.
	 */
	public boolean contains(RelationType relationship) {
		return atk_relation_set_contains(getHandle(), relationship.getValue());
	}
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int atk_relation_set_get_type ();
    native static final protected int atk_relation_set_new ();
    native static final protected boolean atk_relation_set_contains (int set, int relationship);
    native static final protected void atk_relation_set_remove (int set, int relation);
    native static final protected void atk_relation_set_add (int set, int relation);
    native static final protected int atk_relation_set_get_n_relations (int set);
    native static final protected int atk_relation_set_get_relation (int set, int index);
    native static final protected int atk_relation_set_get_relation_by_type (int set, int 
        relationship);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

