/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 *
 */
public class TearoffMenuItem extends MenuItem 
{
	/**
	 * Construct a new TearoffMenuItem
	 */
	public TearoffMenuItem() {
		noopInit();
	}
	
	/**
	 * Construct a TearoffMenuItem using a handle to a native resource.
	 */
	public TearoffMenuItem(int handle) {
	    setHandle(handle);
		initializeEventHandlers();
	}

	protected void noopInit() {
		if (-1 == getHandle()) {
			setHandle(TearoffMenuItem.gtk_tearoff_menu_item_new());
			initializeEventHandlers();
		}
	}
	
	public boolean getTornOff() {
		return getTornOff(getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tearoff_menu_item_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_tearoff_menu_item_get_type ();
    native static final protected int gtk_tearoff_menu_item_new ();
    native static final protected boolean getTornOff(int menu);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

