package org.gnu.gtkhtml.dom;

import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 * An event representing an action generated by a DOM mouse event on an
 * {@link org.gnu.gtkhtml.HTMLDocument} widget.
 *
 * <p>
 * NOTE: we can't extend from GtkEvent because instances of this class are
 * instantiated by the C code (GObject.c) and expect what it is instantiating
 * to have the handle data member.  So this implementation extends GObject and
 * implements the important GtkEvent methods.
 */
public class DomMouseEvent extends GObject {

	public static class Type extends EventType {
		private Type(int id, String name) {
			super(id, name);
		}

		public static final Type DOM_MOUSE_DOWN = new Type(1,"DOM_MOUSE_DOWN");
		public static final Type DOM_MOUSE_UP = new Type(2,"DOM_MOUSE_UP");
		public static final Type DOM_MOUSE_CLICK = new Type(3,"DOM_MOUSE_CLICK");
		public static final Type DOM_MOUSE_OVER = new Type(4,"DOM_MOUSE_OVER");
		public static final Type DOM_MOUSE_OUT = new Type(5,"DOM_MOUSE_OUT");
	}

	public DomMouseEvent( Handle handle ) {
		super( handle );
	}

	private Type type;
	public Type getType() { return type; }
	public void setType( Type t ) { type = t; }

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DomMouseEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
