// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCETAGTABLE_H
#define _GTKSOURCEVIEWMM_SOURCETAGTABLE_H


#include <glibmm.h>

/* sourcetagtable.hg
 * 
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C)2006 Dodji Seketeli
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/// \file
/// \brief the SourceTagTable class

#include <glibmm/object.h>
#include <gtksourceviewmm/sourcetag.h>
#include <gtksourceview/gtksourcetagtable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceTagTable GtkSourceTagTable;
typedef struct _GtkSourceTagTableClass GtkSourceTagTableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceTagTable_Class; } // namespace gtksourceview
namespace gtksourceview
{

/// \brief an Abstraction SourceTag list.
///
/// This object is used to do the bookeeping of all the tags
/// in use by a SourceBuffer at a given time.

class SourceTagTable : public Glib::Object
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceTagTable CppObjectType;
  typedef SourceTagTable_Class CppClassType;
  typedef GtkSourceTagTable BaseObjectType;
  typedef GtkSourceTagTableClass BaseClassType;

private:  friend class SourceTagTable_Class;
  static CppClassType sourcetagtable_class_;

private:
  // noncopyable
  SourceTagTable(const SourceTagTable&);
  SourceTagTable& operator=(const SourceTagTable&);

protected:
  explicit SourceTagTable(const Glib::ConstructParams& construct_params);
  explicit SourceTagTable(GtkSourceTagTable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceTagTable();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceTagTable*       gobj()       { return reinterpret_cast<GtkSourceTagTable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceTagTable* gobj() const { return reinterpret_cast<GtkSourceTagTable*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceTagTable* gobj_copy();

private:


protected:
    SourceTagTable();

public:

    /// \brief create a new SourceTagTable
    ///
    /// It contains no SourceTag by default.
    /// \return the newly created SourceTagTable
    
  static Glib::RefPtr<SourceTagTable> create();


    /// \brief add tags to the SourceTagTable.
    ///
    /// Adds a list of tag to the table. The added tags
    /// are assigned the highest priority in the table.
    /// If a tag is already present in table or has the same name as an already-added tag,
    /// then it is not added to the table.
    
  void add_tags(const Glib::SListHandle<Glib::RefPtr<Gtk::TextTag> > &a_tags);

    /// \brief removes all source tags from the table.
    ///
    /// This will  remove the table's reference to the tags, so be carefull -
    /// Tags will be destroyed if you don't have a reference to them.
    
  void remove_source_tags();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};//end class SourceTagTable
}//end namespace gtksourceview


namespace Glib
{
  /** @relates gtksourceview::SourceTagTable
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<gtksourceview::SourceTagTable> wrap(GtkSourceTagTable* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCETAGTABLE_H */

