// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEVIEW_H
#define _GTKSOURCEVIEWMM_SOURCEVIEW_H


#include <glibmm.h>

/* sourceview.hg
 * 
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2005-2006 Dodji Seketeli
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceView class

#include <gtkmm/textview.h>
#include <gtksourceviewmm/sourcebuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceView GtkSourceView;
typedef struct _GtkSourceViewClass GtkSourceViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceView_Class; } // namespace gtksourceview
namespace gtksourceview
{

/// \brief Multi-line source editing widget.
///
/// It displays a Gtk::SourceBuffer.

class SourceView : public Gtk::TextView
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SourceView CppObjectType;
  typedef SourceView_Class CppClassType;
  typedef GtkSourceView BaseObjectType;
  typedef GtkSourceViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SourceView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SourceView_Class;
  static CppClassType sourceview_class_;

  // noncopyable
  SourceView(const SourceView&);
  SourceView& operator=(const SourceView&);

protected:
  explicit SourceView(const Glib::ConstructParams& construct_params);
  explicit SourceView(GtkSourceView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSourceView*       gobj()       { return reinterpret_cast<GtkSourceView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSourceView* gobj() const { return reinterpret_cast<GtkSourceView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_redo();
  virtual void on_undo();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  //_CTOR_DEFAULT(gtk_source_view_new_val) ;
  //_WRAP_CTOR (SourceView (Glib::RefPtr<SourceBuffer> &buffer), gtk_source_view_new_with_buffer)

  /// \brief default constructor
  explicit SourceView () ;

  /// \brief constructor.
  ///
  /// create an instance of SourceView displaying a given buffer
  /// \param buffer the buffer to display in the SourceView
  explicit SourceView (Glib::RefPtr<SourceBuffer> &buffer) ;


  static Glib::RefPtr<SourceView> create();

  
  static Glib::RefPtr<SourceView> create(Glib::RefPtr<SourceBuffer> & buffer);


  /// \brief get the source buffer associated to the current instance
  ///
  /// \return the source buffer associated to the current instance
  Glib::RefPtr<const SourceBuffer> get_source_buffer () const ;

  /// \brief get the source buffer associated to the current instance
  ///
  /// \return the source buffer associated to the current instance
  Glib::RefPtr<SourceBuffer> get_source_buffer () ;

  /// \brief set the source buffer to be displayed by the SourceView
  ///
  /// \param source_buffer the source buffer to set
  void set_source_buffer (Glib::RefPtr<SourceBuffer> &source_buffer) ;

  /// \brief display line numbers beside the text, or not
  ///
  /// \param show if true, line numbers will be displayed beside test text.
  
  void set_show_line_numbers(bool show=true);

  /// \brief test whether line numbers are displayed beside the text
  ///
  /// \return true if line numbers are displayed beside the text, false otherwise
  
  bool get_show_line_numbers() const;

  /// \brief display line markers beside the text, nor not.
  ///
  /// \param show if true, line markers will be displayed beside the text
  
  void set_show_line_markers(bool show=true);

  /// \brief test whether if line markers are displayed beside the text
  ///
  /// \return true if line  markers are displayed beside the text, false otherwise
  
  bool get_show_line_markers() const;

  /// \brief set tabs width
  ///
  /// \param width the new tab width
  
  void set_tabs_width(guint width);

  /// \brief get tab width
  ///
  /// \return the tab width
  
  guint get_tabs_width() const;

  /// \brief set automatic text indention or not
  ///
  /// \param enable if true, automatic text indentation is activated
  
  void set_auto_indent(bool enable=true);

  /// \brief test whether automatic text indentation is activated
  ///
  /// \return true if automatic text indentation is activated, false otherwise
  
  bool get_auto_indent() const;

  /// \brief activate (or de-activate) the replacement of any inserted tabulator character by a group of space character
  ///
  /// \param enable if true, any tabulator character inserted is replaced by a group of space character
  
  void set_insert_spaces_instead_of_tabs(bool enable=true);

  /// \brief test whether the replacement of any inserted tabulator character by a group of space character is activated
  ///
  /// \return true if the replacement of any inserted tabulator character by a group of space character is activated, false otherwise
  
  bool get_insert_spaces_instead_of_tabs() const;

  /// \brief activate (or de-activate) the display of a margin
  ///
  /// \param show if true, activate the display of a margin
  
  void set_show_margin(bool show=true);

  /// \brief test if a margin is displayed
  ///
  /// \return true if a margin is displayed, false otherwise
  
  bool get_show_margin() const;

  /// \brief do highlight the currently selected line, or not
  ///
  /// \param highlight if true, do highlight the currently selected line
  
  void set_highlight_current_line(bool highlight=true);

  /// \brief test if the currently selected line is to be hightlighted
  ///
  /// \return true if the currently selected line is to be highlighted, false otherwise
  
  bool get_highlight_current_line() const;
  
  /// \brief  set the position of the right margin
  ///
  /// \param margin the position (in pixels) of the right margin
  
  void set_margin(guint margin);

  /// \brief get the position of the right margin
  ///
  /// \return the position of the right margin
  
  guint get_margin() const;

  /// \brief associates a marker pixbuf with a given marker name
  ///
  /// \param marker the marker name to consider
  /// \param pixbuf the new pixbuf
  
  void set_marker_pixbuf(const Glib::ustring& marker, Glib::RefPtr<Gdk::Pixbuf> pixbuf);

  /// \brief get the marker pixbuf associated to a given marker name
  ///
  /// \param marker the marker name to consider
  /// \return the pixbuf, or nil if no pixbuf is associated to the given marker name
  
  Glib::RefPtr<Gdk::Pixbuf> get_marker_pixbuf(const Glib::ustring& marker);

  /// \brief get the marker pixbuf associated to a given marker name
  ///
  /// \param marker the marker name to consider
  /// \return the pixbuf, or nil if no pixbuf is associated to the given marker name
  
  Glib::RefPtr<const Gdk::Pixbuf> get_marker_pixbuf(const Glib::ustring& marker) const;

  /// \brief activate whether if HOME and END keys will move to the first/last non space character of the line before moving to the start/end
  ///
  /// if true, HOME and END keys will move to the first/last non space character of the line before moving to the start/end
  
  void set_smart_home_end(bool enable=true);

  /// \brief test whether if HOME and END keys will move to the first/last non space character of the line before moving to the start/end
  ///
  /// \return true if HOME and END keys will move to the first/last non space character of the line before moving to the start/end, false otherwise
  
  bool get_smart_home_end() const;

  
/**
   * @par Prototype:
   * <tt>void %redo()</tt>
   */

  Glib::SignalProxy0< void > signal_redo();


/**
   * @par Prototype:
   * <tt>void %undo()</tt>
   */

  Glib::SignalProxy0< void > signal_undo();


};

} /* namespace gtksourceview */


namespace Glib
{
  /** @relates gtksourceview::SourceView
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  gtksourceview::SourceView* wrap(GtkSourceView* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKSOURCEVIEWMM_SOURCEVIEW_H */

