// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBVTEMM_TERMINAL_H
#define _LIBVTEMM_TERMINAL_H

#include <libvtemmconfig.h>


#include <glibmm.h>

/* terminal.h
 *
 * Copyright (C) 2008 libvtemm Development Team
 *
 * This file is part of libvtemm.
 *
 * libvtemm is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libvtemm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser Public License for more details.
 *
 * You should have received a copy of the GNU Lesser Public License
 * along with libvtemm.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gdkmm.h>
#include <glibmm.h>
#include <gtkmm.h>
#include <libvtemm/textandcharattrs.h>
#include <pangomm.h>
#include <sigc++/sigc++.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _VteTerminal VteTerminal;
typedef struct _VteTerminalClass VteTerminalClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Vte
{ class Terminal_Class; } // namespace Vte

} // namespace Gnome
namespace Gnome
{

namespace Vte
{

/** @addtogroup libvtemmEnums Enums and Flags */

/**
 * @ingroup libvtemmEnums
 */
enum TerminalEraseBinding
{
  ERASE_AUTO,
  ERASE_ASCII_BACKSPACE,
  ERASE_ASCII_DELETE,
  ERASE_DELETE_SEQUENCE
};

} // namespace Vte

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Vte::TerminalEraseBinding> : public Glib::Value_Enum<Gnome::Vte::TerminalEraseBinding>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Vte
{

#ifndef LIBVTEMM_DISABLE_DEPRECATED

/**
 * @ingroup libvtemmEnums
 */
enum TerminalAntiAlias
{
  ANTI_ALIAS_USE_DEFAULT,
  ANTI_ALIAS_FORCE_ENABLE,
  ANTI_ALIAS_FORCE_DISABLE
};

} // namespace Vte

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Vte::TerminalAntiAlias> : public Glib::Value_Enum<Gnome::Vte::TerminalAntiAlias>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Vte
{

#endif // LIBVTEMM_DISABLE_DEPRECATED

/**
 * @ingroup libvtemmEnums
 */
enum TerminalCursorBlinkMode
{
  CURSOR_BLINK_SYSTEM,
  CURSOR_BLINK_ON,
  CURSOR_BLINK_OFF
};

} // namespace Vte

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Vte::TerminalCursorBlinkMode> : public Glib::Value_Enum<Gnome::Vte::TerminalCursorBlinkMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Vte
{

/**
 * @ingroup libvtemmEnums
 */
enum TerminalCursorShape
{
  CURSOR_SHAPE_BLOCK,
  CURSOR_SHAPE_IBEAM,
  CURSOR_SHAPE_UNDERLINE
};

} // namespace Vte

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Vte::TerminalCursorShape> : public Glib::Value_Enum<Gnome::Vte::TerminalCursorShape>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Vte
{


/** Terminal - a terminal emulator implemented as a gtkmm widget.
 */

class Terminal : public Gtk::Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Terminal CppObjectType;
  typedef Terminal_Class CppClassType;
  typedef VteTerminal BaseObjectType;
  typedef VteTerminalClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Terminal();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Terminal_Class;
  static CppClassType terminal_class_;

  // noncopyable
  Terminal(const Terminal&);
  Terminal& operator=(const Terminal&);

protected:
  explicit Terminal(const Glib::ConstructParams& construct_params);
  explicit Terminal(VteTerminal* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  VteTerminal*       gobj()       { return reinterpret_cast<VteTerminal*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const VteTerminal* gobj() const { return reinterpret_cast<VteTerminal*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_eof();
  virtual void on_child_exited();
  virtual void on_emulation_changed();
  virtual void on_encoding_changed();
  virtual void on_char_size_changed(guint char_width, guint char_height);
  virtual void on_window_title_changed();
  virtual void on_icon_title_changed();
  virtual void on_selection_changed();
  virtual void on_contents_changed();
  virtual void on_cursor_moved();
  virtual void on_status_line_changed();
  virtual void on_commit(char* text, guint size);
  virtual void on_deiconify_window();
  virtual void on_iconify_window();
  virtual void on_raise_window();
  virtual void on_lower_window();
  virtual void on_refresh_window();
  virtual void on_restore_window();
  virtual void on_maximize_window();
  virtual void on_resize_window(guint width, guint height);
  virtual void on_move_window(guint x, guint y);
  virtual void on_increase_font_size();
  virtual void on_decrease_font_size();
  virtual void on_text_modified();
  virtual void on_text_inserted();
  virtual void on_text_deleted();
  virtual void on_text_scrolled(int delta);
  virtual void on_copy_clipboard();
  virtual void on_paste_clipboard();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Terminal();
  
  /** Starts the specified command under a newly-allocated controlling
   * pseudo-terminal.  The @a argv and @a envv lists should be empty string terminated, and
   * argv[0] is expected to be the name of the file being run, as it would be if
   * execve() were being called. TERM is automatically set to reflect the
   * terminal widget's emulation setting.  If @a lastlog, @a utmp, or @a wtmp are <tt>true</tt>,
   * logs the session to the specified system log files.
   * @param command The name of a binary to run, or <tt>0</tt> to get user's shell.
   * @param argv The empty string terminated argument list to be passed to @a command.
   * @param envv An empty string terminated list of environment variables to be
   * added to the environment before starting @a command.
   * @param directory The name of a directory the command should start in, or empty string.
   * @param lastlog <tt>true</tt> if the session should be logged to the lastlog.
   * @param utmp <tt>true</tt> if the session should be logged to the utmp/utmpx log.
   * @param wtmp <tt>true</tt> if the session should be logged to the wtmp/wtmpx log.
   * @return The ID of the new process.
   */
  Glib::Pid fork_command(const std::string& command, const Glib::StringArrayHandle& argv, const Glib::StringArrayHandle& envv, const std::string& directory, bool lastlog, bool utmp, bool wtmp);

  
  /** Starts a new child process under a newly-allocated controlling
   * pseudo-terminal.  TERM is automatically set to reflect the terminal widget's
   * emulation setting.  If @a lastlog, @a utmp, or @a wtmp are <tt>true</tt>, logs the session
   * to the specified system log files.
   * @param envv An empty string terminated list of environment variables to be
   * added to the environment before starting returning in the child process.
   * @param directory The name of a directory the child process should change to, or
   * empty string.
   * @param lastlog <tt>true</tt> if the session should be logged to the lastlog.
   * @param utmp <tt>true</tt> if the session should be logged to the utmp/utmpx log.
   * @param wtmp <tt>true</tt> if the session should be logged to the wtmp/wtmpx log.
   * @return The ID of the new process in the parent
   * 
   * Since: 0.11.11.
   */
  Glib::Pid forkpty(const Glib::StringArrayHandle& envv, const std::string& directory, bool lastlog, bool utmp, bool wtmp);

  
  /** Interprets @a data as if it were data received from a child process.  This
   * can either be used to drive the terminal without a child process, or just
   * to mess with your users.
   * @param data A string in the terminal's current encoding.
   */

  void feed(const Glib::ustring& data);
  
  /** Sends a block of UTF-8 text to the child as if it were entered by the user
   * at the keyboard.
   * @param text Data to send to the child.
   */

  void feed_child(const Glib::ustring& text);
  
  /** Sends a block of binary data to the child.
   * 
   * Since: 0.12.1
   * @param data Data to send to the child.
   */

  void feed_child_binary(const std::string& data);
  

  /** Places the selected text in the terminal in the Gdk::SELECTION_CLIPBOARD
   * selection.
   */
  void copy_clipboard();
  
  /** Sends the contents of the Gdk::SELECTION_CLIPBOARD selection to the
   * terminal's child.  If necessary, the data is converted from UTF-8 to the
   * terminal's current encoding. It's called on paste menu item, or when
   * user presses Shift+Insert.
   */
  void paste_clipboard();
  
  /** Places the selected text in the terminal in the Gdk::SELECTION_PRIMARY
   * selection.
   */
  void copy_primary();
  
  /** Sends the contents of the Gdk::SELECTION_PRIMARY selection to the terminal's
   * child.  If necessary, the data is converted from UTF-8 to the terminal's
   * current encoding.  The terminal will call also paste the
   * Gdk::SELECTION_PRIMARY selection when the user clicks with the the second
   * mouse button.
   */
  void paste_primary();

  
  /** Selects all text within the terminal (including the scrollback buffer).
   * 
   * Since: 0.16
   */
  void select_all();
  
  /** Clears the current selection.
   * 
   * Since: 0.16
   */
  void select_none();

  
  /** Attempts to change the terminal's size in terms of rows and columns.  If
   * the attempt succeeds, the widget will resize itself to the proper size.
   * @param columns The desired number of columns.
   * @param rows The desired number of rows.
   */
  void set_size(long columns, long rows);

  
  /** Controls whether or not the terminal will beep when the child outputs the
   * "bl" sequence.
   * @param is_audible <tt>true</tt> if the terminal should beep.
   */
  void set_audible_bell(bool is_audible);
  
  /** Checks whether or not the terminal will beep when the child outputs the
   * "bl" sequence.
   * @return <tt>true</tt> if audible bell is enabled, <tt>false</tt> if not.
   */
  bool get_audible_bell();
  
  /** Checks whether or not the terminal will beep when the child outputs the
   * "bl" sequence.
   * @return <tt>true</tt> if audible bell is enabled, <tt>false</tt> if not.
   */
  bool get_audible_bell() const;
  
  /** Controls whether or not the terminal will present a visible bell to the
   * user when the child outputs the "bl" sequence.  The terminal
   * will clear itself to the default foreground color and then repaint itself.
   * @param is_visible <tt>true</tt> if the terminal should flash.
   */
  void set_visible_bell(bool is_visible);
  
  /** Checks whether or not the terminal will present a visible bell to the
   * user when the child outputs the "bl" sequence.  The terminal
   * will clear itself to the default foreground color and then repaint itself.
   * @return <tt>true</tt> if visible bell is enabled, <tt>false</tt> if not.
   */
  bool get_visible_bell();
  
  /** Checks whether or not the terminal will present a visible bell to the
   * user when the child outputs the "bl" sequence.  The terminal
   * will clear itself to the default foreground color and then repaint itself.
   * @return <tt>true</tt> if visible bell is enabled, <tt>false</tt> if not.
   */
  bool get_visible_bell() const;
  
  /** Controls whether or not the terminal will scroll the background image (if
   * one is set) when the text in the window must be scrolled.
   * 
   * Since: 0.11
   * @param scroll <tt>true</tt> if the terminal should scroll the background image along with
   * text.
   */
  void set_scroll_background(bool scroll);
  
  /** Controls whether or not the terminal will forcibly scroll to the bottom of
   * the viewable history when the new data is received from the child.
   * @param scroll <tt>true</tt> if the terminal should scroll on output.
   */
  void set_scroll_on_output(bool scroll);
  
  /** Controls whether or not the terminal will forcibly scroll to the bottom of
   * the viewable history when the user presses a key.  Modifier keys do not
   * trigger this behavior.
   * @param scroll <tt>true</tt> if the terminal should scroll on keystrokes.
   */
  void set_scroll_on_keystroke(bool scroll);

  
  /** Sets the color used to draw dim text in the default foreground color.
   * @param dim The new dim color.
   */
  void set_color_dim(const Gdk::Color& dim);
  
  /** Sets the color used to draw bold text in the default foreground color.
   * @param bold The new bold color.
   */
  void set_color_bold(const Gdk::Color& bold);
  
  /** Sets the foreground color used to draw normal text
   * @param foreground The new foreground color.
   */
  void set_color_foreground(const Gdk::Color& foreground);
  
  /** Sets the background color for text which does not have a specific background
   * color assigned.  Only has effect when no background image is set and when
   * the terminal is not transparent.
   * @param background The new background color.
   */
  void set_color_background(const Gdk::Color& background);
  
  /** Sets the background color for text which is under the cursor.  If <tt>0</tt>, text
   * under the cursor will be drawn with foreground and background colors
   * reversed.
   * 
   * Since: 0.11.11
   * @param cursor_background The new color to use for the text cursor.
   */
  void set_color_cursor(const Gdk::Color& cursor_background);
  
  /** Sets the background color for text which is highlighted.  If <tt>0</tt>,
   * highlighted text (which is usually highlighted because it is selected) will
   * be drawn with foreground and background colors reversed.
   * 
   * Since: 0.11.11
   * @param highlight_background The new color to use for highlighted text.
   */
  void set_color_highlight(const Gdk::Color& highlight_background);
  
  /** The terminal widget uses a 28-color model comprised of the default foreground
   * and background colors, the bold foreground color, the dim foreground
   * color, an eight color palette, bold versions of the eight color palette,
   * and a dim version of the the eight color palette.
   * 
   * Size of @a palette must be either 0, 8, 16, or 24.  If @a foreground is <tt>0</tt> and
   * size of @a palette is greater than 0, the new foreground color is taken from
   *  @a palette[7].  If @a background is <tt>0</tt> and size of @a palette is greater than 0,
   * the new background color is taken from @a palette[0].  If
   * size of @a palette is 8 or 16, the third (dim) and possibly the second (bold)
   * 8-color palettes are extrapolated from the new background color and the items
   * in @a palette.
   * @param foreground The new foreground color, or <tt>0</tt>.
   * @param background The new background color, or <tt>0</tt>.
   * @param palette The color palette.
   */

  void set_colors(const Gdk::Color& foreground, const Gdk::Color& background, const Gdk::ArrayHandle_Color& palette);
  
  
  /** Reset the terminal palette to reasonable compiled-in defaults.
   */
  void set_default_colors();

  
  /** Sets a background image for the widget.  Text which would otherwise be
   * drawn using the default background color will instead be drawn over the
   * specified image.  If necessary, the image will be tiled to cover the
   * widget's entire visible area. If specified by
   * set_background_saturation(), the terminal will tint its
   * in-memory copy of the image before applying it to the terminal.
   * @param image A Gdk::Pixbuf to use, or <tt>0</tt> to cancel.
   */
  void set_background_image(const Glib::RefPtr<Gdk::Pixbuf>& image);
  
  /** Sets a background image for the widget.  If specified by
   * set_background_saturation(), the terminal will tint its
   * in-memory copy of the image before applying it to the terminal.
   * @param path Path to an image file.
   */
  void set_background_image_file(const std::string& path);
  
  /** If a background image has been set using
   * set_background_image(),
   * set_background_image_file(), or
   * set_background_transparent(), and the value set by
   * set_background_saturation() is less than one, the terminal
   * will adjust the color of the image before drawing the image.  To do so,
   * the terminal will create a copy of the background image (or snapshot of
   * the root window) and modify its pixel values.  The initial tint color
   * is black.
   * 
   * Since: 0.11
   * @param color A color which the terminal background should be tinted to if its
   * saturation is not 1.0.
   */
  void set_background_tint_color(const Gdk::Color& color);
  
  /** If a background image has been set using
   * set_background_image(),
   * set_background_image_file(), or
   * set_background_transparent(), and the saturation value is less
   * than 1.0, the terminal will adjust the colors of the image before drawing
   * the image.  To do so, the terminal will create a copy of the background
   * image (or snapshot of the root window) and modify its pixel values.
   * @param saturation A floating point value between 0.0 and 1.0.
   */
  void set_background_saturation(double saturation);
  
  /** Sets the terminal's background image to the pixmap stored in the root
   * window, adjusted so that if there are no windows below your application,
   * the widget will appear to be transparent.
   * @param transparent <tt>true</tt> if the terminal should fake transparency.
   */
  void set_background_transparent(bool transparent);
  
  /** Sets the opacity of the terminal background, were 0 means completely
   * transparent and 65535 means completely opaque.
   * @param opacity The new opacity.
   */
  void set_opacity(guint16 opacity);

  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** Sets whether or not the cursor will blink.
   * 
   * Deprecated: 0.17.1 Use set_cursor_blink_mode() instead.
   * @deprecated Use set_cursor_blink_mode instead
   * @param blink <tt>true</tt> if the cursor should blink.
   */
  void set_cursor_blinks(bool blink);
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** Sets whether or not the cursor will blink. Using Vte::CURSOR_BLINK_SYSTEM
   * will use the Gtk::Settings::gtk-cursor-blink setting.
   * 
   * Since: 0.17.1
   * @param mode The Vte::TerminalCursorBlinkMode to use.
   */
  void set_cursor_blink_mode(TerminalCursorBlinkMode mode);
  
  /** Return value: cursor blink mode.
   * @return Cursor blink mode.
   * 
   * Since: 0.17.1.
   */
  TerminalCursorBlinkMode get_cursor_blink_mode();
  
  /** Return value: cursor blink mode.
   * @return Cursor blink mode.
   * 
   * Since: 0.17.1.
   */
  TerminalCursorBlinkMode get_cursor_blink_mode() const;
  
  
  /** Sets the shape of the cursor drawn.
   * 
   * Since: 0.19.1
   * @param shape The Vte::TerminalCursorShape to use.
   */
  void set_cursor_shape(TerminalCursorShape shape);
  
  /** Return value: cursor shape.
   * @return Cursor shape.
   * 
   * Since: 0.17.6.
   */
  TerminalCursorShape get_cursor_shape();
  
  /** Return value: cursor shape.
   * @return Cursor shape.
   * 
   * Since: 0.17.6.
   */
  TerminalCursorShape get_cursor_shape() const;

  
  /** Sets the length of the scrollback buffer used by the terminal.  The size of
   * the scrollback buffer will be set to the larger of this value and the number
   * of visible rows the widget can display, so 0 can safely be used to disable
   * scrollback.  Note that this setting only affects the normal screen buffer.
   * For terminal types which have an alternate screen buffer, no scrollback is
   * allowed on the alternate screen buffer.
   * @param lines The length of the history buffer.
   */
  void set_scrollback_lines(long lines);

  
  /** Appends menu items for various input methods to the given menu.  The
   * user can select one of these items to modify the input method used by
   * the terminal.
   * @param menushell A GtkMenuShell.
   */
  void im_append_menuitems(Gtk::MenuShell& menushell);

  
  /** Sets the font used for rendering all text displayed by the terminal,
   * overriding any fonts set using gtk_widget_modify_font().  The terminal
   * will immediately attempt to load the desired font, retrieve its
   * metrics, and attempt to resize itself to keep the same number of rows
   * and columns.
   * @param font_desc The Pango::FontDescription of the desired font.
   */
  void set_font(const Pango::FontDescription& font_desc);
  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** Sets the font used for rendering all text displayed by the terminal,
   * overriding any fonts set using gtk_widget_modify_font().  The terminal
   * will immediately attempt to load the desired font, retrieve its
   * metrics, and attempt to resize itself to keep the same number of rows
   * and columns.
   * 
   * Since: 0.11.11
   * 
   * Deprecated: 0.19.1
   * @param font_desc The Pango::FontDescription of the desired font.
   * @param antialias Specify if anti aliasing of the fonts is to be used or not.
   */
  void set_font_full(const Pango::FontDescription& font_desc, TerminalAntiAlias antialias);
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** A convenience function which converts @a name into a Pango::FontDescription and
   * passes it to set_font().
   * @param name A string describing the font.
   */
  void set_font_from_string(const Glib::ustring& name);
  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** A convenience function which converts @a name into a Pango::FontDescription and
   * passes it to set_font_full().
   * 
   * Since: 0.11.11
   * 
   * Deprecated: 0.19.1
   * @param name A string describing the font.
   * @param antialias Whether or not to antialias the font (if possible).
   */
  void set_font_from_string_full(const Glib::ustring name, TerminalAntiAlias antialias);
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** Queries the terminal for information about the fonts which will be
   * used to draw text in the terminal.
   * @return A Pango::FontDescription describing the font the terminal is
   * currently using to render text.
   */
  const Pango::FontDescription get_font();
  
  /** Queries the terminal for information about the fonts which will be
   * used to draw text in the terminal.
   * @return A Pango::FontDescription describing the font the terminal is
   * currently using to render text.
   */
  const Pango::FontDescription get_font() const;
  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** A Vte::Terminal can use multiple methods to draw text.  This function
   * allows an application to determine whether or not the current method uses
   * fontconfig to find fonts.  This setting cannot be changed by the caller,
   * but in practice usually matches the behavior of GTK+ itself.
   * @return <tt>true</tt>
   * 
   * Deprecated: 0.19.1.
   */
  bool get_using_xft();
#endif // LIBVTEMM_DISABLE_DEPRECATED


#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** A Vte::Terminal can use multiple methods to draw text.  This function
   * allows an application to determine whether or not the current method uses
   * fontconfig to find fonts.  This setting cannot be changed by the caller,
   * but in practice usually matches the behavior of GTK+ itself.
   * @return <tt>true</tt>
   * 
   * Deprecated: 0.19.1.
   */
  bool get_using_xft() const;
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** Controls whether or not the terminal will attempt to draw bold text,
   * either by using a bold font variant or by repainting text with a different
   * offset.
   * @param allow_bold <tt>true</tt> if the terminal should attempt to draw bold text.
   */
  void set_allow_bold(bool allow_bold);
  
  /** Checks whether or not the terminal will attempt to draw bold text by
   * repainting text with a one-pixel offset.
   * @return <tt>true</tt> if bolding is enabled, <tt>false</tt> if not.
   */
  bool get_allow_bold();
  
  /** Checks whether or not the terminal will attempt to draw bold text by
   * repainting text with a one-pixel offset.
   * @return <tt>true</tt> if bolding is enabled, <tt>false</tt> if not.
   */
  bool get_allow_bold() const;

  
  /** Checks if the terminal currently contains selected text.  Note that this
   * is different from determining if the terminal is the owner of any
   * Gtk::Clipboard items.
   * @return <tt>true</tt> if part of the text in the terminal is selected.
   */
  bool get_has_selection();
  
  /** Checks if the terminal currently contains selected text.  Note that this
   * is different from determining if the terminal is the owner of any
   * Gtk::Clipboard items.
   * @return <tt>true</tt> if part of the text in the terminal is selected.
   */
  bool get_has_selection() const;

  
  /** When the user double-clicks to start selection, the terminal will extend
   * the selection on word boundaries.  It will treat characters included in @a spec
   * as parts of words, and all other characters as word separators.  Ranges of
   * characters can be specified by separating them with a hyphen.
   * 
   * As a special case, if @a spec is <tt>0</tt> or the empty string, the terminal will
   * treat all graphic non-punctuation non-space characters as word characters.
   * @param spec A specification.
   */
  void set_word_chars(const Glib::ustring& spec);
  
  /** Checks if a particular character is considered to be part of a word or not,
   * based on the values last passed to set_word_chars().
   * @param c A candidate Unicode code point.
   * @return <tt>true</tt> if the character is considered to be part of a word.
   */
  bool is_word_char(gunichar c);

  
  /** Modifies the terminal's backspace key binding, which controls what
   * string or control sequence the terminal sends to its child when the user
   * presses the backspace key.
   * @param binding A Vte::TerminalEraseBinding for the backspace key.
   */
  void set_backspace_binding(TerminalEraseBinding binding);
  
  /** Modifies the terminal's delete key binding, which controls what
   * string or control sequence the terminal sends to its child when the user
   * presses the delete key.
   * @param binding A Vte::TerminalEraseBinding for the delete key.
   */
  void set_delete_binding(TerminalEraseBinding binding);

  
  /** Changes the value of the terminal's mouse autohide setting.  When autohiding
   * is enabled, the mouse cursor will be hidden when the user presses a key and
   * shown when the user moves the mouse.  This setting can be read using
   * get_mouse_autohide().
   * @param setting <tt>true</tt> if the autohide should be enabled.
   */
  void set_mouse_autohide(bool setting);
  
  /** Determines the value of the terminal's mouse autohide setting.  When
   * autohiding is enabled, the mouse cursor will be hidden when the user presses
   * a key and shown when the user moves the mouse.  This setting can be changed
   * using set_mouse_autohide().
   * @return <tt>true</tt> if autohiding is enabled, <tt>false</tt> if not.
   */
  bool get_mouse_autohide() const;

  
  /** Resets as much of the terminal's internal state as possible, discarding any
   * unprocessed input data, resetting character attributes, cursor state,
   * national character set state, status line, terminal modes (insert/delete),
   * selection state, and encoding.
   * @param full <tt>true</tt> to reset tabstops.
   * @param clear_history <tt>true</tt> to empty the terminal's scrollback buffer.
   */
  void reset(bool full, bool clear_history);

  typedef sigc::slot<bool, Terminal& /* terminal */, long /* column */, long /* row */> SlotSelectedCallback;
  
  /** Extracts a view of the visible part of the terminal.  If @a slot is not
   * <tt>0</tt>, characters will only be read if @a slot returns <tt>true</tt> after being
   * passed the column and row, respectively.  A Vte::CharAttributes structure
   * is added to Text::AndCharAttrs return value for each byte added to the returned
   * string detailing the character's position, colors, and other
   * characteristics.
   * @param slot A slot for callback.
   * @return A Text::AndCharAttrs with text that may be empty and stored text
   * attributes.
   */

  TextAndCharAttrs get_text(const SlotSelectedCallback& slot);
  TextAndCharAttrs get_text(const SlotSelectedCallback& slot) const;
  
  /** Extracts a view of the visible part of the terminal.  If @a slot is not
   * <tt>0</tt>, characters will only be read if @a slot returns <tt>true</tt> after being
   * passed the column and row, respectively.  A Vte::CharAttributes structure
   * is added to Text::AndCharAttrs return value for each byte added to the returned
   * string detailing the character's position, colors, and other
   * characteristics. This function differs from vte_terminal_get_text in that
   * trailing spaces at the end of lines are included.
   * @param slot A slot for callback.
   * @return A Text::AndCharAttrs with text that may be empty and stored text
   * attributes.
   */

  TextAndCharAttrs get_text_include_trailing_spaces(const SlotSelectedCallback& slot);
  TextAndCharAttrs get_text_include_trailing_spaces(const SlotSelectedCallback& slot) const;
  
  /** Extracts a view of the visible part of the terminal.  If @a slot is not
   * <tt>0</tt>, characters will only be read if @a slot returns <tt>true</tt> after being
   * passed the column and row, respectively.  A Vte::CharAttributes structure
   * is added to Text::AndCharAttrs return value for each byte added to the returned
   * string detailing the character's position, colors, and other
   * characteristics. The entire scrollback buffer is scanned, so it is possible to
   * read the entire contents of the buffer using this function.
   * @param start_row First row to search for data.
   * @param start_col First column to search for data.
   * @param end_row Last row to search for data.
   * @param end_col Last column to search for data.
   * @param slot A slot for callback.
   * @return A Text::AndCharAttrs with text that may be empty and stored text
   * attributes.
   */

  TextAndCharAttrs get_text_range(long start_row, long start_col, long end_row, long end_col, const SlotSelectedCallback& slot);
  TextAndCharAttrs get_text_range(long start_row, long start_col, long end_row, long end_col, const SlotSelectedCallback& slot) const;
  
  
  /** Reads the location of the insertion cursor and returns it.  The row
   * coordinate is absolute.
   * @param column Long which will hold the column.
   * @param row Long which will hold the row.
   */
  void get_cursor_position(long& column, long& row);
  
  /** Reads the location of the insertion cursor and returns it.  The row
   * coordinate is absolute.
   * @param column Long which will hold the column.
   * @param row Long which will hold the row.
   */
  void get_cursor_position(long& column, long& row) const;

  
  /** Clears the list of regular expressions the terminal uses to highlight text
   * when the user moves the mouse cursor.
   */
  void match_clear_all();

  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** Adds a regular expression to the list of matching expressions.  When the
   * user moves the mouse cursor over a section of displayed text which matches
   * this expression, the text will be highlighted.
   * @deprecated Use match_add_gregex instead
   * @param match A regular expression.
   * @return An integer associated with this expression
   * 
   *  @a Deprecated: 0.17.1.
   */
  int match_add(const Glib::ustring& match);
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** Adds the regular expression @a regex to the list of matching expressions.  When the
   * user moves the mouse cursor over a section of displayed text which matches
   * this expression, the text will be highlighted.
   * @param regex A Regex.
   * @param flags The RegexMatchFlags to use when matching the regex.
   * @return An integer associated with this expression
   * 
   * Since: 0.17.1.
   */
  int match_add_gregex(Glib::RefPtr<Glib::Regex> regex, Glib::RegexMatchFlags flags);

  
  /** Sets which cursor the terminal will use if the pointer is over the pattern
   * specified by @a tag.  The terminal keeps a reference to @a cursor.
   * 
   * Since: 0.11
   * @param tag The tag of the regex which should use the specified cursor.
   * @param cursor The Gdk::Cursor which the terminal should use when the pattern is
   * highlighted.
   */
  void match_set_cursor(int tag, Gdk::Cursor& cursor);
  
  /** Sets which cursor the terminal will use if the pointer is over the pattern
   * specified by @a tag.
   * 
   * Since: 0.11.9
   * @param tag The tag of the regex which should use the specified cursor.
   * @param cursor_type A Gdk::CursorType.
   */
  void match_set_cursor_type(int tag, Gdk::CursorType cursor_type);
  
  /** Sets which cursor the terminal will use if the pointer is over the pattern
   * specified by @a tag.
   * 
   * Since: 0.17.1
   * @param tag The tag of the regex which should use the specified cursor.
   * @param cursor_name The name of the cursor.
   */
  void match_set_cursor_name(int tag, const Glib::ustring& cursor_name);

  
  /** Removes the regular expression which is associated with the given @a tag from
   * the list of expressions which the terminal will highlight when the user
   * moves the mouse cursor over matching text.
   * @param tag The tag of the regex to remove.
   */
  void match_remove(int tag);

  
  /** Checks if the text in and around the specified position matches any of the
   * regular expressions previously set using match_add().  If a
   * match exists, the text string is returned and the number associated with
   * the matched regular expression will be stored in @a tag.
   * 
   * If more than one regular expression has been set with
   * match_add(), then expressions are checked in the order in
   * which they were added.
   * @param column The text column.
   * @param row The text row.
   * @param tag Pointer to an integer.
   * @return A string which matches one of the previously set regular
   * expressions.
   */

  Glib::ustring match_check(long column, long row, int& tag);
  

  /** Sets what type of terminal the widget attempts to emulate by scanning for
   * control sequences defined in the system's termcap file.  Unless you
   * are interested in this feature, always use "xterm".
   * @param emulation The name of a terminal description.
   */
  void set_emulation(const Glib::ustring& emulation);
  
  /** Queries the terminal for its current emulation, as last set by a call to
   * set_emulation().
   * @return The name of the terminal type the widget is attempting to emulate.
   */
  const Glib::ustring get_emulation();
  
  /** Queries the terminal for its current emulation, as last set by a call to
   * set_emulation().
   * @return The name of the terminal type the widget is attempting to emulate.
   */
  const Glib::ustring get_emulation() const;
  
  /** Queries the terminal for its default emulation, which is attempted if the
   * terminal type passed to set_emulation() is <tt>0</tt>.
   * @return The name of the default terminal type the widget attempts to emulate
   * 
   * Since: 0.11.11.
   */
  const Glib::ustring get_default_emulation();
  
  /** Queries the terminal for its default emulation, which is attempted if the
   * terminal type passed to set_emulation() is <tt>0</tt>.
   * @return The name of the default terminal type the widget attempts to emulate
   * 
   * Since: 0.11.11.
   */
  const Glib::ustring get_default_emulation() const;

  
  /** Changes the encoding the terminal will expect data from the child to
   * be encoded with.  For certain terminal types, applications executing in the
   * terminal can change the encoding.  The default encoding is defined by the
   * application's locale settings.
   * @param codeset A valid #g_iconv target.
   */
  void set_encoding(const Glib::ustring& codeset);
  
  /** Determines the name of the encoding in which the terminal expects data to be
   * encoded.
   * @return The current encoding for the terminal.
   */
  const Glib::ustring get_encoding();
  
  /** Determines the name of the encoding in which the terminal expects data to be
   * encoded.
   * @return The current encoding for the terminal.
   */
  const Glib::ustring get_encoding() const;

  
  /** Some terminal emulations specify a status line which is separate from the
   * main display area, and define a means for applications to move the cursor
   * to the status line and back.
   * @return The current contents of the terminal's status line.  For terminals
   * like "xterm", this will usually be the empty string.  The string must not
   * be modified or freed by the caller.
   */
  const Glib::ustring get_status_line();
  
  /** Some terminal emulations specify a status line which is separate from the
   * main display area, and define a means for applications to move the cursor
   * to the status line and back.
   * @return The current contents of the terminal's status line.  For terminals
   * like "xterm", this will usually be the empty string.  The string must not
   * be modified or freed by the caller.
   */
  const Glib::ustring get_status_line() const;

  
  /** Determines the amount of additional space the widget is using to pad the
   * edges of its visible area.  This is necessary for cases where characters in
   * the selected font don't themselves include a padding area and the text
   * itself would otherwise be contiguous with the window border.  Applications
   * which use the widget's #row_count, #column_count, #char_height, and
   * #char_width fields to set geometry hints using
   * gtk_window_set_geometry_hints() will need to add this value to the base
   * size.  The values returned in @a xpad and @a ypad are the total padding used in
   * each direction, and do not need to be doubled.
   * @param xpad Address in which to store left/right-edge padding.
   * @param ypad Address in which to store top/bottom-edge ypadding.
   */
  void get_padding(int& xpad, int& ypad);
  
  /** Determines the amount of additional space the widget is using to pad the
   * edges of its visible area.  This is necessary for cases where characters in
   * the selected font don't themselves include a padding area and the text
   * itself would otherwise be contiguous with the window border.  Applications
   * which use the widget's #row_count, #column_count, #char_height, and
   * #char_width fields to set geometry hints using
   * gtk_window_set_geometry_hints() will need to add this value to the base
   * size.  The values returned in @a xpad and @a ypad are the total padding used in
   * each direction, and do not need to be doubled.
   * @param xpad Address in which to store left/right-edge padding.
   * @param ypad Address in which to store top/bottom-edge ypadding.
   */
  void get_padding(int& xpad, int& ypad) const;

  
  /** Attach an existing PTY master side to the terminal widget.  Use
   * instead of fork_command() or forkpty().
   * 
   * Since: 0.12.1
   * @param pty_master A file descriptor of the master end of a PTY.
   */
  void set_pty(int pty_master);
  
  /** Return value: the file descriptor, or -1 if the terminal has no PTY.
   * @return The file descriptor, or -1 if the terminal has no PTY.
   * 
   * Since: 0.19.1.
   */
  int get_pty();
  
  /** Return value: the file descriptor, or -1 if the terminal has no PTY.
   * @return The file descriptor, or -1 if the terminal has no PTY.
   * 
   * Since: 0.19.1.
   */
  int get_pty() const;

  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's adjustment field.
   */
  Gtk::Adjustment* get_adjustment();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's adjustment field.
   */
  Gtk::Adjustment const* get_adjustment() const;
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_width field.
   */
  long get_char_width();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_width field.
   */
  long get_char_width() const;
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_height field.
   */
  long get_char_height();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_height field.
   */
  long get_char_height() const;
  
#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_descent field
   * 
   * Deprecated: 0.19.1.
   */
  long get_char_descent();
#endif // LIBVTEMM_DISABLE_DEPRECATED


#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_descent field
   * 
   * Deprecated: 0.19.1.
   */
  long get_char_descent() const;
#endif // LIBVTEMM_DISABLE_DEPRECATED


#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_ascent field
   * 
   * Deprecated: 0.19.1.
   */
  long get_char_ascent();
#endif // LIBVTEMM_DISABLE_DEPRECATED


#ifndef LIBVTEMM_DISABLE_DEPRECATED

  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's char_ascent field
   * 
   * Deprecated: 0.19.1.
   */
  long get_char_ascent() const;
#endif // LIBVTEMM_DISABLE_DEPRECATED


  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's row_count field.
   */
  long get_row_count();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's row_count field.
   */
  long get_row_count() const;
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's column_count field.
   */
  long get_column_count();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's column_count field.
   */
  long get_column_count() const;
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's window_title field.
   */
  const Glib::ustring get_window_title();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's window_title field.
   */
  const Glib::ustring get_window_title() const;
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's icon_title field.
   */
  const Glib::ustring get_icon_title();
  
  /** An accessor function provided for the benefit of language bindings.
   * @return The contents of @a terminal's icon_title field.
   */
  const Glib::ustring get_icon_title() const;
  
  
  /** Gets the exit status of the command started by fork_command().
   * See your C library's documentation for more details on how to interpret the
   * exit status.
   * 
   * Note that this function may only be called from the signal handler of
   * the "child-exited" signal.
   * @return The child's exit status
   * 
   * Since: 0.19.1.
   */
  int get_child_exit_status();
  
  /** Gets the exit status of the command started by fork_command().
   * See your C library's documentation for more details on how to interpret the
   * exit status.
   * 
   * Note that this function may only be called from the signal handler of
   * the "child-exited" signal.
   * @return The child's exit status
   * 
   * Since: 0.19.1.
   */
  int get_child_exit_status() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%eof()</tt>
   */

  Glib::SignalProxy0< void > signal_eof();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_exited()</tt>
   */

  Glib::SignalProxy0< void > signal_child_exited();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%emulation_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_emulation_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%encoding_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_encoding_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%char_size_changed(guint char_width, guint char_height)</tt>
   */

  Glib::SignalProxy2< void,guint,guint > signal_char_size_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%window_title_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_window_title_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%icon_title_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_icon_title_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%selection_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_selection_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%contents_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_contents_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%cursor_moved()</tt>
   */

  Glib::SignalProxy0< void > signal_cursor_moved();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%status_line_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_status_line_changed();

  // the one below could just send std::string...
  
  /**
   * @par Prototype:
   * <tt>void on_my_%commit(char* text, guint size)</tt>
   */

  Glib::SignalProxy2< void,char*,guint > signal_commit();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%deiconify_window()</tt>
   */

  Glib::SignalProxy0< void > signal_deiconify_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%iconify_window()</tt>
   */

  Glib::SignalProxy0< void > signal_iconify_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%raise_window()</tt>
   */

  Glib::SignalProxy0< void > signal_raise_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%lower_window()</tt>
   */

  Glib::SignalProxy0< void > signal_lower_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%refresh_window()</tt>
   */

  Glib::SignalProxy0< void > signal_refresh_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%restore_window()</tt>
   */

  Glib::SignalProxy0< void > signal_restore_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%maximize_window()</tt>
   */

  Glib::SignalProxy0< void > signal_maximize_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%resize_window(guint width, guint height)</tt>
   */

  Glib::SignalProxy2< void,guint,guint > signal_resize_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%move_window(guint x, guint y)</tt>
   */

  Glib::SignalProxy2< void,guint,guint > signal_move_window();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%increase_font_size()</tt>
   */

  Glib::SignalProxy0< void > signal_increase_font_size();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%decrease_font_size()</tt>
   */

  Glib::SignalProxy0< void > signal_decrease_font_size();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%text_modified()</tt>
   */

  Glib::SignalProxy0< void > signal_text_modified();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%text_inserted()</tt>
   */

  Glib::SignalProxy0< void > signal_text_inserted();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%text_deleted()</tt>
   */

  Glib::SignalProxy0< void > signal_text_deleted();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%text_scrolled(int delta)</tt>
   */

  Glib::SignalProxy1< void,int > signal_text_scrolled();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%copy_clipboard()</tt>
   */

  Glib::SignalProxy0< void > signal_copy_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paste_clipboard()</tt>
   */

  Glib::SignalProxy0< void > signal_paste_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%set_scroll_adjustments(Gtk::Adjustment* hadjustment, Gtk::Adjustment* vadjustment)</tt>
   */

  Glib::SignalProxy2< void,Gtk::Adjustment*,Gtk::Adjustment* > signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%beep()</tt>
   */

  Glib::SignalProxy0< void > signal_beep();

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_allow_bold() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_allow_bold() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_audible_bell() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_audible_bell() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_background_image_file() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_background_image_file() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Pixbuf> property_background_image_pixbuf() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Pixbuf> property_background_image_pixbuf() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_background_opacity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_background_opacity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_background_saturation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_background_saturation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Color> property_background_tint_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Color> property_background_tint_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_background_transparent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_background_transparent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TerminalEraseBinding> property_backspace_binding() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TerminalEraseBinding> property_backspace_binding() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TerminalCursorBlinkMode> property_cursor_blink_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TerminalCursorBlinkMode> property_cursor_blink_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TerminalCursorShape> property_cursor_shape() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TerminalCursorShape> property_cursor_shape() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TerminalEraseBinding> property_delete_binding() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TerminalEraseBinding> property_delete_binding() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_emulation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_emulation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_encoding() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_encoding() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::FontDescription> property_font_desc() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::FontDescription> property_font_desc() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_icon_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_pointer_autohide() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_pointer_autohide() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_pty() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_pty() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_scroll_background() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_scroll_background() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_scroll_on_keystroke() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_scroll_on_keystroke() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_scroll_on_output() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_scroll_on_output() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_scrollback_lines() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_scrollback_lines() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_bell() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_bell() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_window_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_word_chars() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_word_chars() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Vte

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Vte::Terminal
   */
  Gnome::Vte::Terminal* wrap(VteTerminal* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBVTEMM_TERMINAL_H */

