// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libvtemm/terminal.h>
#include <libvtemm/private/terminal_p.h>

/* terminal.cc
 *
 * Copyright (C) 2008, 2009 libvtemm Development Team
 *
 * This file is part of libvtemm.
 *
 * libvtemm is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libvtemm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser Public License for more details.
 *
 * You should have received a copy of the GNU Lesser Public License
 * along with libvtemm.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <vte/vte.h>

#include <gtkmm/border.h>

#include "internalroutines.h"

namespace Gnome
{

namespace Vte
{

namespace Private
{

static gboolean
SignalProxy_selected_gtk_callback(VteTerminal *terminal G_GNUC_UNUSED, glong column, glong row, gpointer user_data)
{
  Gnome::Vte::Terminal::SlotSelectedCallback* the_slot = static_cast<Gnome::Vte::Terminal::SlotSelectedCallback*>(user_data);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
#endif // GLIBMM_EXCEPTIONS_ENABLED
    return static_cast<gboolean>((*the_slot)(column, row));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
  return TRUE;
#endif // GLIBMM_EXCEPTIONS_ENABLED
}

} // namespace Private

Glib::Pid
Terminal::fork_command(const std::string& command, const StdStringArrayHandle& argv, const StdStringArrayHandle& envv, const std::string& directory, bool lastlog, bool utmp, bool wtmp)
{
  const char* c_command = get_c_string(command);
  char** c_argv = get_c_string_vector(argv);
  char** c_envv = get_c_string_vector(envv);
  const char* c_directory = get_c_string(directory);
  Glib::Pid pid = vte_terminal_fork_command(gobj(), c_command, c_argv, c_envv, c_directory, lastlog, utmp, wtmp);
  g_strfreev(c_argv);
  g_strfreev(c_envv);
  return pid;
}

Glib::Pid
Terminal::forkpty(const StdStringArrayHandle& envv, const std::string& directory, bool lastlog, bool utmp, bool wtmp)
{
  char** c_envv = get_c_string_vector(envv);
  const char* c_directory = get_c_string(directory);
  Glib::Pid pid = vte_terminal_forkpty(gobj(), c_envv, c_directory, lastlog, utmp, wtmp);
  g_strfreev(c_envv);
  return pid;
}

void
Terminal::feed(const Glib::ustring& data)
{
  vte_terminal_feed(gobj(), data.data(), data.size());
}

void
Terminal::feed_child(const Glib::ustring& text)
{
  vte_terminal_feed_child(gobj(), text.data(), text.size());
}

void
Terminal::feed_child_binary(const std::string& data)
{
  vte_terminal_feed_child_binary(gobj(), data.data(), data.size());
}

void
Terminal::set_default_color_cursor()
{
  vte_terminal_set_color_cursor(gobj(), 0);
}

void
Terminal::set_default_color_highlight()
{
  vte_terminal_set_color_highlight(gobj(), 0);
}

void
Terminal::set_colors(const Gdk::Color& foreground, const Gdk::Color& background, const Gdk::ArrayHandle_Color& palette)
{
  vte_terminal_set_colors(gobj(), foreground.gobj(), background.gobj(), palette.data(), palette.size());
}

void
Terminal::set_default_colors(const Gdk::ArrayHandle_Color& palette)
{
  vte_terminal_set_colors(gobj(), 0, 0, palette.data(), palette.size());
}

void
Terminal::unset_background_image()
{
  vte_terminal_set_background_image(gobj(), 0);
}

bool
Terminal::always_selected(long, long)
{
  return true;
}

bool
Terminal::never_selected(long, long)
{
  return false;
}

TextAndCharAttrs
Terminal::get_text(const Gnome::Vte::Terminal::SlotSelectedCallback& slot) const
{
  GArray* array = g_array_new(FALSE, FALSE, sizeof(VteCharAttributes));
  char* c_text = vte_terminal_get_text(const_cast<VteTerminal*>(gobj()), &Private::SignalProxy_selected_gtk_callback, const_cast<Gnome::Vte::Terminal::SlotSelectedCallback*>(&slot), array);
  Glib::ustring text(c_text);
  g_free(c_text);
  ArrayHandle_CharAttributes attributes(reinterpret_cast<VteCharAttributes*>(array->data), array->len, Glib::OWNERSHIP_DEEP);
  g_array_free(array, FALSE);
  return TextAndCharAttrs(text, attributes);
}

TextAndCharAttrs
Terminal::get_text_include_trailing_spaces(const Gnome::Vte::Terminal::SlotSelectedCallback& slot) const
{
  GArray* array = g_array_new(FALSE, FALSE, sizeof(VteCharAttributes));
  char* c_text = vte_terminal_get_text_include_trailing_spaces(const_cast<VteTerminal*>(gobj()), &Private::SignalProxy_selected_gtk_callback, const_cast<Gnome::Vte::Terminal::SlotSelectedCallback*>(&slot), array);
  Glib::ustring text(c_text);
  g_free(c_text);
  ArrayHandle_CharAttributes attributes(reinterpret_cast<VteCharAttributes*>(array->data), static_cast<size_t>(array->len), Glib::OWNERSHIP_DEEP);
  g_array_free(array, FALSE);
  return TextAndCharAttrs(text, attributes);
}

TextAndCharAttrs
Terminal::get_text_range(long start_row, long start_col, long end_row, long end_col, const Gnome::Vte::Terminal::SlotSelectedCallback& slot) const
{
  GArray* array = g_array_new(FALSE, FALSE, sizeof(VteCharAttributes));
  char* c_text = vte_terminal_get_text_range(const_cast<VteTerminal*>(gobj()), start_row, start_col, end_row, end_col, &Private::SignalProxy_selected_gtk_callback, const_cast<Gnome::Vte::Terminal::SlotSelectedCallback*>(&slot), array);
  Glib::ustring text(c_text);
  g_free(c_text);
  ArrayHandle_CharAttributes attributes(reinterpret_cast<VteCharAttributes*>(array->data), static_cast<size_t>(array->len), Glib::OWNERSHIP_DEEP);
  g_array_free(array, FALSE);
  return TextAndCharAttrs(text, attributes);
}

CursorPosition
Terminal::get_cursor_position() const
{
  long column(0), row(0);
  vte_terminal_get_cursor_position(const_cast<VteTerminal*>(gobj()), &column, &row);
  return CursorPosition(column, row);
}

Match
Terminal::match_check(long column, long row)
{
  int tag = 0;
  char* c_text = vte_terminal_match_check(gobj(), column, row, &tag);
  Glib::ustring text(c_text);
  g_free(c_text);
  return Match(text, tag);
}

void
Terminal::set_default_emulation()
{
  vte_terminal_set_emulation(gobj(), 0);
}

Padding
Terminal::get_padding() const
{
  Gtk::Border border;
  get_style_property("inner-border", border);
  return Padding(border.left + border.right, border.top + border.bottom);
}

} // namespace Vte

} // namespace Gnome

namespace
{


static const Glib::SignalProxyInfo Terminal_signal_eof_info =
{
  "eof",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_child_exited_info =
{
  "child-exited",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_emulation_changed_info =
{
  "emulation-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_encoding_changed_info =
{
  "encoding-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Terminal_signal_char_size_changed_callback(VteTerminal* self, guint p0,guint p1,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,guint,guint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0, p1);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_char_size_changed_info =
{
  "char-size-changed",
  (GCallback) &Terminal_signal_char_size_changed_callback,
  (GCallback) &Terminal_signal_char_size_changed_callback
};


static const Glib::SignalProxyInfo Terminal_signal_window_title_changed_info =
{
  "window-title-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_icon_title_changed_info =
{
  "icon-title-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_selection_changed_info =
{
  "selection-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_contents_changed_info =
{
  "contents-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_cursor_moved_info =
{
  "cursor-moved",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_status_line_changed_info =
{
  "status-line-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Terminal_signal_commit_callback(VteTerminal* self, const gchar* text,guint size,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,const Glib::ustring& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(      Glib::ustring(text, text + size));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_commit_info =
{
  "commit",
  (GCallback) &Terminal_signal_commit_callback,
  (GCallback) &Terminal_signal_commit_callback
};


static const Glib::SignalProxyInfo Terminal_signal_deiconify_window_info =
{
  "deiconify-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_iconify_window_info =
{
  "iconify-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_raise_window_info =
{
  "raise-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_lower_window_info =
{
  "lower-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_refresh_window_info =
{
  "refresh-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_restore_window_info =
{
  "restore-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_maximize_window_info =
{
  "maximize-window",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Terminal_signal_resize_window_callback(VteTerminal* self, guint p0,guint p1,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,guint,guint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0, p1);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_resize_window_info =
{
  "resize-window",
  (GCallback) &Terminal_signal_resize_window_callback,
  (GCallback) &Terminal_signal_resize_window_callback
};


static void Terminal_signal_move_window_callback(VteTerminal* self, guint p0,guint p1,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,guint,guint > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0, p1);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_move_window_info =
{
  "move-window",
  (GCallback) &Terminal_signal_move_window_callback,
  (GCallback) &Terminal_signal_move_window_callback
};


static const Glib::SignalProxyInfo Terminal_signal_increase_font_size_info =
{
  "increase-font-size",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_decrease_font_size_info =
{
  "decrease-font-size",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_text_modified_info =
{
  "text-modified",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_text_inserted_info =
{
  "text-inserted",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_text_deleted_info =
{
  "text-deleted",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Terminal_signal_text_scrolled_callback(VteTerminal* self, gint p0,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_text_scrolled_info =
{
  "text-scrolled",
  (GCallback) &Terminal_signal_text_scrolled_callback,
  (GCallback) &Terminal_signal_text_scrolled_callback
};


static const Glib::SignalProxyInfo Terminal_signal_copy_clipboard_info =
{
  "copy-clipboard",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Terminal_signal_paste_clipboard_info =
{
  "paste-clipboard",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Terminal_signal_set_scroll_adjustments_callback(VteTerminal* self, GtkAdjustment* p0,GtkAdjustment* p1,void* data)
{
  using namespace Gnome::Vte;
  typedef sigc::slot< void,Gtk::Adjustment&,Gtk::Adjustment& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(*(Glib::wrap(p0))
, *(Glib::wrap(p1))
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Terminal_signal_set_scroll_adjustments_info =
{
  "set-scroll-adjustments",
  (GCallback) &Terminal_signal_set_scroll_adjustments_callback,
  (GCallback) &Terminal_signal_set_scroll_adjustments_callback
};


static const Glib::SignalProxyInfo Terminal_signal_beep_info =
{
  "beep",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gnome::Vte::TerminalEraseBinding>::value_type()
{
  return vte_terminal_erase_binding_get_type();
}

// static
GType Glib::Value<Gnome::Vte::TerminalCursorBlinkMode>::value_type()
{
  return vte_terminal_cursor_blink_mode_get_type();
}

// static
GType Glib::Value<Gnome::Vte::TerminalCursorShape>::value_type()
{
  return vte_terminal_cursor_shape_get_type();
}


namespace Glib
{

Gnome::Vte::Terminal* wrap(VteTerminal* object, bool take_copy)
{
  return dynamic_cast<Gnome::Vte::Terminal *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Vte
{


/* The *_Class implementation: */

const Glib::Class& Terminal_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Terminal_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(vte_terminal_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Terminal_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->eof = &eof_callback;
  klass->child_exited = &child_exited_callback;
  klass->emulation_changed = &emulation_changed_callback;
  klass->encoding_changed = &encoding_changed_callback;
  klass->char_size_changed = &char_size_changed_callback;
  klass->window_title_changed = &window_title_changed_callback;
  klass->icon_title_changed = &icon_title_changed_callback;
  klass->selection_changed = &selection_changed_callback;
  klass->contents_changed = &contents_changed_callback;
  klass->cursor_moved = &cursor_moved_callback;
  klass->status_line_changed = &status_line_changed_callback;
  klass->commit = &commit_callback;
  klass->deiconify_window = &deiconify_window_callback;
  klass->iconify_window = &iconify_window_callback;
  klass->raise_window = &raise_window_callback;
  klass->lower_window = &lower_window_callback;
  klass->refresh_window = &refresh_window_callback;
  klass->restore_window = &restore_window_callback;
  klass->maximize_window = &maximize_window_callback;
  klass->resize_window = &resize_window_callback;
  klass->move_window = &move_window_callback;
  klass->increase_font_size = &increase_font_size_callback;
  klass->decrease_font_size = &decrease_font_size_callback;
  klass->text_modified = &text_modified_callback;
  klass->text_inserted = &text_inserted_callback;
  klass->text_deleted = &text_deleted_callback;
  klass->text_scrolled = &text_scrolled_callback;
  klass->copy_clipboard = &copy_clipboard_callback;
  klass->paste_clipboard = &paste_clipboard_callback;
  klass->beep = &beep_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Terminal_Class::eof_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_eof();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->eof)
    (*base->eof)(self);
}
void Terminal_Class::child_exited_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_child_exited();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->child_exited)
    (*base->child_exited)(self);
}
void Terminal_Class::emulation_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_emulation_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->emulation_changed)
    (*base->emulation_changed)(self);
}
void Terminal_Class::encoding_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_encoding_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->encoding_changed)
    (*base->encoding_changed)(self);
}
void Terminal_Class::char_size_changed_callback(VteTerminal* self, guint p0, guint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_char_size_changed(p0, p1);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->char_size_changed)
    (*base->char_size_changed)(self, p0, p1);
}
void Terminal_Class::window_title_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_title_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_title_changed)
    (*base->window_title_changed)(self);
}
void Terminal_Class::icon_title_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_icon_title_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->icon_title_changed)
    (*base->icon_title_changed)(self);
}
void Terminal_Class::selection_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_selection_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_changed)
    (*base->selection_changed)(self);
}
void Terminal_Class::contents_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_contents_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->contents_changed)
    (*base->contents_changed)(self);
}
void Terminal_Class::cursor_moved_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_cursor_moved();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->cursor_moved)
    (*base->cursor_moved)(self);
}
void Terminal_Class::status_line_changed_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_status_line_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->status_line_changed)
    (*base->status_line_changed)(self);
}
void Terminal_Class::commit_callback(VteTerminal* self, const gchar* text, guint size)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)      self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_commit(      Glib::ustring(text, text + size));
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->commit)
    (*base->commit)(      self, text, size);
}
void Terminal_Class::deiconify_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_deiconify_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->deiconify_window)
    (*base->deiconify_window)(self);
}
void Terminal_Class::iconify_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_iconify_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->iconify_window)
    (*base->iconify_window)(self);
}
void Terminal_Class::raise_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_raise_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->raise_window)
    (*base->raise_window)(self);
}
void Terminal_Class::lower_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_lower_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->lower_window)
    (*base->lower_window)(self);
}
void Terminal_Class::refresh_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_refresh_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->refresh_window)
    (*base->refresh_window)(self);
}
void Terminal_Class::restore_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_restore_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->restore_window)
    (*base->restore_window)(self);
}
void Terminal_Class::maximize_window_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_maximize_window();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->maximize_window)
    (*base->maximize_window)(self);
}
void Terminal_Class::resize_window_callback(VteTerminal* self, guint p0, guint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_resize_window(p0, p1);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->resize_window)
    (*base->resize_window)(self, p0, p1);
}
void Terminal_Class::move_window_callback(VteTerminal* self, guint p0, guint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_move_window(p0, p1);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->move_window)
    (*base->move_window)(self, p0, p1);
}
void Terminal_Class::increase_font_size_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_increase_font_size();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->increase_font_size)
    (*base->increase_font_size)(self);
}
void Terminal_Class::decrease_font_size_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_decrease_font_size();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->decrease_font_size)
    (*base->decrease_font_size)(self);
}
void Terminal_Class::text_modified_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_modified();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->text_modified)
    (*base->text_modified)(self);
}
void Terminal_Class::text_inserted_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_inserted();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->text_inserted)
    (*base->text_inserted)(self);
}
void Terminal_Class::text_deleted_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_deleted();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->text_deleted)
    (*base->text_deleted)(self);
}
void Terminal_Class::text_scrolled_callback(VteTerminal* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_scrolled(p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->text_scrolled)
    (*base->text_scrolled)(self, p0);
}
void Terminal_Class::copy_clipboard_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_copy_clipboard();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->copy_clipboard)
    (*base->copy_clipboard)(self);
}
void Terminal_Class::paste_clipboard_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_paste_clipboard();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->paste_clipboard)
    (*base->paste_clipboard)(self);
}
void Terminal_Class::beep_callback(VteTerminal* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_beep();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->beep)
    (*base->beep)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Terminal_Class::wrap_new(GObject* o)
{
  return manage(new Terminal((VteTerminal*)(o)));

}


/* The implementation: */

Terminal::Terminal(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

Terminal::Terminal(VteTerminal* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }

Terminal::~Terminal()
{
  destroy_();
}

Terminal::CppClassType Terminal::terminal_class_; // initialize static member

GType Terminal::get_type()
{
  return terminal_class_.init().get_type();
}


GType Terminal::get_base_type()
{
  return vte_terminal_get_type();
}


Terminal::Terminal()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Widget(Glib::ConstructParams(terminal_class_.init()))
{
  

}

void Terminal::copy_clipboard()
{
vte_terminal_copy_clipboard(gobj()); 
}

void Terminal::paste_clipboard()
{
vte_terminal_paste_clipboard(gobj()); 
}

void Terminal::copy_primary()
{
vte_terminal_copy_primary(gobj()); 
}

void Terminal::paste_primary()
{
vte_terminal_paste_primary(gobj()); 
}

void Terminal::select_all()
{
vte_terminal_select_all(gobj()); 
}

void Terminal::select_none()
{
vte_terminal_select_none(gobj()); 
}

void Terminal::set_size(long columns, long rows)
{
vte_terminal_set_size(gobj(), columns, rows); 
}

void Terminal::set_audible_bell(bool is_audible)
{
vte_terminal_set_audible_bell(gobj(), static_cast<int>(is_audible)); 
}

bool Terminal::get_audible_bell() const
{
  return vte_terminal_get_audible_bell(const_cast<VteTerminal*>(gobj()));
}

void Terminal::set_visible_bell(bool is_visible)
{
vte_terminal_set_visible_bell(gobj(), static_cast<int>(is_visible)); 
}

bool Terminal::get_visible_bell() const
{
  return vte_terminal_get_visible_bell(const_cast<VteTerminal*>(gobj()));
}

void Terminal::set_scroll_background(bool scroll)
{
vte_terminal_set_scroll_background(gobj(), static_cast<int>(scroll)); 
}

void Terminal::set_scroll_on_output(bool scroll)
{
vte_terminal_set_scroll_on_output(gobj(), static_cast<int>(scroll)); 
}

void Terminal::set_scroll_on_keystroke(bool scroll)
{
vte_terminal_set_scroll_on_keystroke(gobj(), static_cast<int>(scroll)); 
}

void Terminal::set_color_dim(const Gdk::Color& dim)
{
vte_terminal_set_color_dim(gobj(), (dim).gobj()); 
}

void Terminal::set_color_bold(const Gdk::Color& bold)
{
vte_terminal_set_color_bold(gobj(), (bold).gobj()); 
}

void Terminal::set_color_foreground(const Gdk::Color& foreground)
{
vte_terminal_set_color_foreground(gobj(), (foreground).gobj()); 
}

void Terminal::set_color_background(const Gdk::Color& background)
{
vte_terminal_set_color_background(gobj(), (background).gobj()); 
}

void Terminal::set_color_cursor(const Gdk::Color& cursor_background)
{
vte_terminal_set_color_cursor(gobj(), (cursor_background).gobj()); 
}

void Terminal::set_color_highlight(const Gdk::Color& highlight_background)
{
vte_terminal_set_color_highlight(gobj(), (highlight_background).gobj()); 
}

void Terminal::set_default_colors()
{
vte_terminal_set_default_colors(gobj()); 
}

void Terminal::set_background_image(const Glib::RefPtr<Gdk::Pixbuf>& image)
{
vte_terminal_set_background_image(gobj(), Glib::unwrap(image)); 
}

void Terminal::set_background_image_file(const std::string& path)
{
vte_terminal_set_background_image_file(gobj(), path.c_str()); 
}

void Terminal::set_background_tint_color(const Gdk::Color& color)
{
vte_terminal_set_background_tint_color(gobj(), (color).gobj()); 
}

void Terminal::set_background_saturation(double saturation)
{
vte_terminal_set_background_saturation(gobj(), saturation); 
}

void Terminal::set_background_transparent(bool transparent)
{
vte_terminal_set_background_transparent(gobj(), static_cast<int>(transparent)); 
}

void Terminal::set_opacity(guint16 opacity)
{
vte_terminal_set_opacity(gobj(), opacity); 
}

void Terminal::set_cursor_blink_mode(TerminalCursorBlinkMode mode)
{
vte_terminal_set_cursor_blink_mode(gobj(), ((VteTerminalCursorBlinkMode)(mode))); 
}

TerminalCursorBlinkMode Terminal::get_cursor_blink_mode() const
{
  return ((TerminalCursorBlinkMode)(vte_terminal_get_cursor_blink_mode(const_cast<VteTerminal*>(gobj()))));
}

void Terminal::set_cursor_shape(TerminalCursorShape shape)
{
vte_terminal_set_cursor_shape(gobj(), ((VteTerminalCursorShape)(shape))); 
}

TerminalCursorShape Terminal::get_cursor_shape() const
{
  return ((TerminalCursorShape)(vte_terminal_get_cursor_shape(const_cast<VteTerminal*>(gobj()))));
}

void Terminal::set_scrollback_lines(long lines)
{
vte_terminal_set_scrollback_lines(gobj(), lines); 
}

void Terminal::im_append_menuitems(Gtk::MenuShell& menushell)
{
vte_terminal_im_append_menuitems(gobj(), (menushell).gobj()); 
}

void Terminal::set_font(const Pango::FontDescription& font_desc)
{
vte_terminal_set_font(gobj(), (font_desc).gobj()); 
}

void Terminal::set_font_from_string(const Glib::ustring& name)
{
vte_terminal_set_font_from_string(gobj(), name.c_str()); 
}

Pango::FontDescription Terminal::get_font() const
{
  return Pango::FontDescription(const_cast<PangoFontDescription*>(vte_terminal_get_font(const_cast<VteTerminal*>(gobj()))));
}

void Terminal::set_allow_bold(bool allow_bold)
{
vte_terminal_set_allow_bold(gobj(), static_cast<int>(allow_bold)); 
}

bool Terminal::get_allow_bold() const
{
  return vte_terminal_get_allow_bold(const_cast<VteTerminal*>(gobj()));
}

bool Terminal::get_has_selection() const
{
  return vte_terminal_get_has_selection(const_cast<VteTerminal*>(gobj()));
}

void Terminal::set_word_chars(const Glib::ustring& spec)
{
vte_terminal_set_word_chars(gobj(), spec.c_str()); 
}

bool Terminal::is_word_char(gunichar c)
{
  return vte_terminal_is_word_char(gobj(), c);
}

void Terminal::set_backspace_binding(TerminalEraseBinding binding)
{
vte_terminal_set_backspace_binding(gobj(), ((VteTerminalEraseBinding)(binding))); 
}

void Terminal::set_delete_binding(TerminalEraseBinding binding)
{
vte_terminal_set_delete_binding(gobj(), ((VteTerminalEraseBinding)(binding))); 
}

void Terminal::set_mouse_autohide(bool setting)
{
vte_terminal_set_mouse_autohide(gobj(), static_cast<int>(setting)); 
}

bool Terminal::get_mouse_autohide() const
{
  return vte_terminal_get_mouse_autohide(const_cast<VteTerminal*>(gobj()));
}

void Terminal::reset(bool full, bool clear_history)
{
vte_terminal_reset(gobj(), static_cast<int>(full), static_cast<int>(clear_history)); 
}

void Terminal::match_clear_all()
{
vte_terminal_match_clear_all(gobj()); 
}

int Terminal::match_add_gregex(Glib::RefPtr<Glib::Regex> regex, Glib::RegexMatchFlags flags)
{
  return vte_terminal_match_add_gregex(gobj(), Glib::unwrap(regex), ((GRegexMatchFlags)(flags)));
}

void Terminal::match_set_cursor(int tag, Gdk::Cursor& cursor)
{
vte_terminal_match_set_cursor(gobj(), tag, (cursor).gobj()); 
}

void Terminal::match_set_cursor_type(int tag, Gdk::CursorType cursor_type)
{
vte_terminal_match_set_cursor_type(gobj(), tag, ((GdkCursorType)(cursor_type))); 
}

void Terminal::match_set_cursor_name(int tag, const Glib::ustring& cursor_name)
{
vte_terminal_match_set_cursor_name(gobj(), tag, cursor_name.c_str()); 
}

void Terminal::match_remove(int tag)
{
vte_terminal_match_remove(gobj(), tag); 
}

void Terminal::set_emulation(const Glib::ustring& emulation)
{
vte_terminal_set_emulation(gobj(), emulation.c_str()); 
}

Glib::ustring Terminal::get_emulation() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(vte_terminal_get_emulation(const_cast<VteTerminal*>(gobj())));
}

Glib::ustring Terminal::get_default_emulation() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(vte_terminal_get_default_emulation(const_cast<VteTerminal*>(gobj())));
}

void Terminal::set_encoding(const std::string& codeset)
{
vte_terminal_set_encoding(gobj(), codeset.c_str()); 
}

std::string Terminal::get_encoding() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(vte_terminal_get_encoding(const_cast<VteTerminal*>(gobj())));
}

Glib::ustring Terminal::get_status_line() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(vte_terminal_get_status_line(const_cast<VteTerminal*>(gobj())));
}

void Terminal::set_pty(int pty_master)
{
vte_terminal_set_pty(gobj(), pty_master); 
}

int Terminal::get_pty() const
{
  return vte_terminal_get_pty(const_cast<VteTerminal*>(gobj()));
}

Gtk::Adjustment& Terminal::get_adjustment()
{
  return *(Glib::wrap(vte_terminal_get_adjustment(gobj())));
}

const Gtk::Adjustment& Terminal::get_adjustment() const
{
  return const_cast<Terminal*>(this)->get_adjustment();
}

long Terminal::get_char_width() const
{
  return vte_terminal_get_char_width(const_cast<VteTerminal*>(gobj()));
}

long Terminal::get_char_height() const
{
  return vte_terminal_get_char_height(const_cast<VteTerminal*>(gobj()));
}

long Terminal::get_row_count() const
{
  return vte_terminal_get_row_count(const_cast<VteTerminal*>(gobj()));
}

long Terminal::get_column_count() const
{
  return vte_terminal_get_column_count(const_cast<VteTerminal*>(gobj()));
}

Glib::ustring Terminal::get_window_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(vte_terminal_get_window_title(const_cast<VteTerminal*>(gobj())));
}

Glib::ustring Terminal::get_icon_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(vte_terminal_get_icon_title(const_cast<VteTerminal*>(gobj())));
}

int Terminal::get_child_exit_status() const
{
  return vte_terminal_get_child_exit_status(const_cast<VteTerminal*>(gobj()));
}


Glib::SignalProxy0< void > Terminal::signal_eof()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_eof_info);
}


Glib::SignalProxy0< void > Terminal::signal_child_exited()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_child_exited_info);
}


Glib::SignalProxy0< void > Terminal::signal_emulation_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_emulation_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_encoding_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_encoding_changed_info);
}


Glib::SignalProxy2< void,guint,guint > Terminal::signal_char_size_changed()
{
  return Glib::SignalProxy2< void,guint,guint >(this, &Terminal_signal_char_size_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_window_title_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_window_title_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_icon_title_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_icon_title_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_selection_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_selection_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_contents_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_contents_changed_info);
}


Glib::SignalProxy0< void > Terminal::signal_cursor_moved()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_cursor_moved_info);
}


Glib::SignalProxy0< void > Terminal::signal_status_line_changed()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_status_line_changed_info);
}


Glib::SignalProxy1< void,const Glib::ustring& > Terminal::signal_commit()
{
  return Glib::SignalProxy1< void,const Glib::ustring& >(this, &Terminal_signal_commit_info);
}


Glib::SignalProxy0< void > Terminal::signal_deiconify_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_deiconify_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_iconify_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_iconify_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_raise_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_raise_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_lower_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_lower_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_refresh_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_refresh_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_restore_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_restore_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_maximize_window()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_maximize_window_info);
}


Glib::SignalProxy2< void,guint,guint > Terminal::signal_resize_window()
{
  return Glib::SignalProxy2< void,guint,guint >(this, &Terminal_signal_resize_window_info);
}


Glib::SignalProxy2< void,guint,guint > Terminal::signal_move_window()
{
  return Glib::SignalProxy2< void,guint,guint >(this, &Terminal_signal_move_window_info);
}


Glib::SignalProxy0< void > Terminal::signal_increase_font_size()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_increase_font_size_info);
}


Glib::SignalProxy0< void > Terminal::signal_decrease_font_size()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_decrease_font_size_info);
}


Glib::SignalProxy0< void > Terminal::signal_text_modified()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_text_modified_info);
}


Glib::SignalProxy0< void > Terminal::signal_text_inserted()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_text_inserted_info);
}


Glib::SignalProxy0< void > Terminal::signal_text_deleted()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_text_deleted_info);
}


Glib::SignalProxy1< void,int > Terminal::signal_text_scrolled()
{
  return Glib::SignalProxy1< void,int >(this, &Terminal_signal_text_scrolled_info);
}


Glib::SignalProxy0< void > Terminal::signal_copy_clipboard()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_copy_clipboard_info);
}


Glib::SignalProxy0< void > Terminal::signal_paste_clipboard()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_paste_clipboard_info);
}


Glib::SignalProxy2< void,Gtk::Adjustment&,Gtk::Adjustment& > Terminal::signal_set_scroll_adjustments()
{
  return Glib::SignalProxy2< void,Gtk::Adjustment&,Gtk::Adjustment& >(this, &Terminal_signal_set_scroll_adjustments_info);
}


Glib::SignalProxy0< void > Terminal::signal_beep()
{
  return Glib::SignalProxy0< void >(this, &Terminal_signal_beep_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_allow_bold() 
{
  return Glib::PropertyProxy<bool>(this, "allow-bold");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_allow_bold() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "allow-bold");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_audible_bell() 
{
  return Glib::PropertyProxy<bool>(this, "audible-bell");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_audible_bell() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "audible-bell");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Terminal::property_background_image_file() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "background-image-file");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_background_image_file() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "background-image-file");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gdk::Pixbuf> Terminal::property_background_image_pixbuf() 
{
  return Glib::PropertyProxy<Gdk::Pixbuf>(this, "background-image-pixbuf");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gdk::Pixbuf> Terminal::property_background_image_pixbuf() const
{
  return Glib::PropertyProxy_ReadOnly<Gdk::Pixbuf>(this, "background-image-pixbuf");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Terminal::property_background_opacity() 
{
  return Glib::PropertyProxy<double>(this, "background-opacity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Terminal::property_background_opacity() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "background-opacity");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Terminal::property_background_saturation() 
{
  return Glib::PropertyProxy<double>(this, "background-saturation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Terminal::property_background_saturation() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "background-saturation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gdk::Color> Terminal::property_background_tint_color() 
{
  return Glib::PropertyProxy<Gdk::Color>(this, "background-tint-color");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gdk::Color> Terminal::property_background_tint_color() const
{
  return Glib::PropertyProxy_ReadOnly<Gdk::Color>(this, "background-tint-color");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_background_transparent() 
{
  return Glib::PropertyProxy<bool>(this, "background-transparent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_background_transparent() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "background-transparent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TerminalEraseBinding> Terminal::property_backspace_binding() 
{
  return Glib::PropertyProxy<TerminalEraseBinding>(this, "backspace-binding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TerminalEraseBinding> Terminal::property_backspace_binding() const
{
  return Glib::PropertyProxy_ReadOnly<TerminalEraseBinding>(this, "backspace-binding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TerminalCursorBlinkMode> Terminal::property_cursor_blink_mode() 
{
  return Glib::PropertyProxy<TerminalCursorBlinkMode>(this, "cursor-blink-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TerminalCursorBlinkMode> Terminal::property_cursor_blink_mode() const
{
  return Glib::PropertyProxy_ReadOnly<TerminalCursorBlinkMode>(this, "cursor-blink-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TerminalCursorShape> Terminal::property_cursor_shape() 
{
  return Glib::PropertyProxy<TerminalCursorShape>(this, "cursor-shape");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TerminalCursorShape> Terminal::property_cursor_shape() const
{
  return Glib::PropertyProxy_ReadOnly<TerminalCursorShape>(this, "cursor-shape");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<TerminalEraseBinding> Terminal::property_delete_binding() 
{
  return Glib::PropertyProxy<TerminalEraseBinding>(this, "delete-binding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<TerminalEraseBinding> Terminal::property_delete_binding() const
{
  return Glib::PropertyProxy_ReadOnly<TerminalEraseBinding>(this, "delete-binding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Terminal::property_emulation() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "emulation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_emulation() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "emulation");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Terminal::property_encoding() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "encoding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_encoding() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "encoding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Pango::FontDescription> Terminal::property_font_desc() 
{
  return Glib::PropertyProxy<Pango::FontDescription>(this, "font-desc");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Pango::FontDescription> Terminal::property_font_desc() const
{
  return Glib::PropertyProxy_ReadOnly<Pango::FontDescription>(this, "font-desc");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_icon_title() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "icon-title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_pointer_autohide() 
{
  return Glib::PropertyProxy<bool>(this, "pointer-autohide");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_pointer_autohide() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "pointer-autohide");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Terminal::property_pty() 
{
  return Glib::PropertyProxy<int>(this, "pty");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Terminal::property_pty() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "pty");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_scroll_background() 
{
  return Glib::PropertyProxy<bool>(this, "scroll-background");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_scroll_background() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "scroll-background");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_scroll_on_keystroke() 
{
  return Glib::PropertyProxy<bool>(this, "scroll-on-keystroke");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_scroll_on_keystroke() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "scroll-on-keystroke");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_scroll_on_output() 
{
  return Glib::PropertyProxy<bool>(this, "scroll-on-output");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_scroll_on_output() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "scroll-on-output");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Terminal::property_scrollback_lines() 
{
  return Glib::PropertyProxy<int>(this, "scrollback-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Terminal::property_scrollback_lines() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "scrollback-lines");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Terminal::property_visible_bell() 
{
  return Glib::PropertyProxy<bool>(this, "visible-bell");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Terminal::property_visible_bell() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "visible-bell");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_window_title() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "window-title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Terminal::property_word_chars() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "word-chars");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Terminal::property_word_chars() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "word-chars");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Vte::Terminal::on_eof()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->eof)
    (*base->eof)(gobj());
}
void Gnome::Vte::Terminal::on_child_exited()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->child_exited)
    (*base->child_exited)(gobj());
}
void Gnome::Vte::Terminal::on_emulation_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->emulation_changed)
    (*base->emulation_changed)(gobj());
}
void Gnome::Vte::Terminal::on_encoding_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->encoding_changed)
    (*base->encoding_changed)(gobj());
}
void Gnome::Vte::Terminal::on_char_size_changed(guint char_width, guint char_height)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->char_size_changed)
    (*base->char_size_changed)(gobj(),char_width,char_height);
}
void Gnome::Vte::Terminal::on_window_title_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_title_changed)
    (*base->window_title_changed)(gobj());
}
void Gnome::Vte::Terminal::on_icon_title_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->icon_title_changed)
    (*base->icon_title_changed)(gobj());
}
void Gnome::Vte::Terminal::on_selection_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_changed)
    (*base->selection_changed)(gobj());
}
void Gnome::Vte::Terminal::on_contents_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->contents_changed)
    (*base->contents_changed)(gobj());
}
void Gnome::Vte::Terminal::on_cursor_moved()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->cursor_moved)
    (*base->cursor_moved)(gobj());
}
void Gnome::Vte::Terminal::on_status_line_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->status_line_changed)
    (*base->status_line_changed)(gobj());
}
void Gnome::Vte::Terminal::on_commit(const Glib::ustring& text)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->commit)
    (*base->commit)(gobj(),text.data(),text.bytes());
}
void Gnome::Vte::Terminal::on_deiconify_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->deiconify_window)
    (*base->deiconify_window)(gobj());
}
void Gnome::Vte::Terminal::on_iconify_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->iconify_window)
    (*base->iconify_window)(gobj());
}
void Gnome::Vte::Terminal::on_raise_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->raise_window)
    (*base->raise_window)(gobj());
}
void Gnome::Vte::Terminal::on_lower_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->lower_window)
    (*base->lower_window)(gobj());
}
void Gnome::Vte::Terminal::on_refresh_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->refresh_window)
    (*base->refresh_window)(gobj());
}
void Gnome::Vte::Terminal::on_restore_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->restore_window)
    (*base->restore_window)(gobj());
}
void Gnome::Vte::Terminal::on_maximize_window()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->maximize_window)
    (*base->maximize_window)(gobj());
}
void Gnome::Vte::Terminal::on_resize_window(guint width, guint height)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->resize_window)
    (*base->resize_window)(gobj(),width,height);
}
void Gnome::Vte::Terminal::on_move_window(guint x, guint y)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->move_window)
    (*base->move_window)(gobj(),x,y);
}
void Gnome::Vte::Terminal::on_increase_font_size()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->increase_font_size)
    (*base->increase_font_size)(gobj());
}
void Gnome::Vte::Terminal::on_decrease_font_size()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->decrease_font_size)
    (*base->decrease_font_size)(gobj());
}
void Gnome::Vte::Terminal::on_text_modified()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->text_modified)
    (*base->text_modified)(gobj());
}
void Gnome::Vte::Terminal::on_text_inserted()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->text_inserted)
    (*base->text_inserted)(gobj());
}
void Gnome::Vte::Terminal::on_text_deleted()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->text_deleted)
    (*base->text_deleted)(gobj());
}
void Gnome::Vte::Terminal::on_text_scrolled(int delta)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->text_scrolled)
    (*base->text_scrolled)(gobj(),delta);
}
void Gnome::Vte::Terminal::on_copy_clipboard()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->copy_clipboard)
    (*base->copy_clipboard)(gobj());
}
void Gnome::Vte::Terminal::on_paste_clipboard()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->paste_clipboard)
    (*base->paste_clipboard)(gobj());
}
void Gnome::Vte::Terminal::on_beep()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->beep)
    (*base->beep)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Vte

} // namespace Gnome


