'''
Defines a convenience collection that can be used to notify all L{AEMonitor}s
of a certain event.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Base
from LSRInterfaces import implements

class MonitorCollection(object):
  '''
  Collection of known monitors. Defines methods for informing all elements about
  about information to be buffered.
  
  @ivar monitors: list of L{AEMonitor}s that will be notified of events
  @type monitors: list of L{AEMonitor}s
  ''' 
  def __init__(self):
    '''Initializes the monitor list.'''
    self.monitors = []
    
  def add(self, interface, kind, monitors):
    ''' 
    Adds one or more L{AEMonitor}s to the list of monitors to be notified.
    Filters the list of monitors based on the interfaces they implement and
    the kind of events in which they are interested.
    
    @param interface: L{AEMonitor} subinterface desired
    @type interface: class
    @param kind: Kind of event of interest to the monitor
    @type kind: class
    @param monitors: L{AEMonitor.EventMonitor}s to notify
    @type monitors: tuple of L{AEMonitor.EventMonitor}s
    '''
    for m in monitors:
      print implements(m.getEventType(), kind)
      if implements(m, interface) and implements(m.getEventType(), kind):
        print m
        # store only event monitors
        self.monitors.append(m)
        # initialize each monitor so it is displayed
        m.init()

  def show(self, **kwargs):
    '''
    Informs L{AEMonitor}s added via L{add} of information to be buffered. Calls
    L{AEMonitor.EventMonitor.EventMonitor.show} on all monitors. Monitors 
    raising IOError in show are removed from the L{monitors} list and are no 
    longer notified of events.
    
    @param kwargs: Information to buffer
    @type kwargs: dictionary
    '''
    i = 0
    # can't use a for loop here because we're removing elements along the way
    while i < len(self.monitors):
      m = self.monitors[i]
      try:
        # buffer the given information
        m.show(**kwargs)
      except IOError:
        # remove any monitors that have indicated that want no more events
        del self.monitors[i]
        continue
      except:
        # log all exceptions other than IO
        # @todo: PP: add logging
        pass
      i += 1