'''
Defines internal L{AEEvent}s and their execution logic. The subclasses of the
base L{Base.AccessEngineEvent} class are instantiated by the event handler
adapters (either the default or specialized event handler adapters).

Additional import statements should be added to this file as this package
grows new modules.

@author: Peter Parente
@author: Pete Brunet
@author: Brett Clippingdale
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Constants, Base
from Constants import NORMAL, HIGH, IMMEDIATE, FOCUS_LAYER, \
     TIER_LAYER, BACKGROUND_LAYER, ALL_LAYERS
from InputGesture import *
from ViewChange import *
from FocusChange import *
from CaretChange import *
from SelectorChange import *
from PropertyChange import *
from StateChange import *
from ChildrenChange import *
from TableChange import *
from ScreenChange import *
from ChooserChange import *

def getDefaults():
  '''
  Suggests the default L{Task}s to be monitored. Reads the 
  
  @return: Names of defaults to monitor
  @rtype: list of string
  '''
  return Constants.default_types  
  
def getNames():
  '''
  Gets the names of all the L{Task} types.
  
  @return: List of all L{Task} names
  @rtype: list of string
  '''
  names = Constants.all_types
  names.sort()
  return names
