/* mg-data-cell-renderer-textual.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 * Copyright (C) 2003  Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MG_DATA_CELL_RENDERER_TEXTUAL_H__
#define __MG_DATA_CELL_RENDERER_TEXTUAL_H__

#include <gtk/gtk.h>
#include <pango/pango.h>
#include <libmergeant/mg-defs.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MG_DATA_CELL_RENDERER_TEXTUAL_TYPE		(mg_data_cell_renderer_textual_get_type ())
#define MG_DATA_CELL_RENDERER_TEXTUAL(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), MG_DATA_CELL_RENDERER_TEXTUAL_TYPE, MgDataCellRendererTextual))
#define MG_DATA_CELL_RENDERER_TEXTUAL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), MG_DATA_CELL_RENDERER_TEXTUAL_TYPE, MgDataCellRendererTextualClass))
#define IS_MG_DATA_CELL_RENDERER_TEXTUAL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MG_DATA_CELL_RENDERER_TEXTUAL_TYPE))
#define IS_MG_DATA_CELL_RENDERER_TEXTUAL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), MG_DATA_CELL_RENDERER_TEXTUAL_TYPE))
#define MG_DATA_CELL_RENDERER_TEXTUAL_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), MG_DATA_CELL_RENDERER_TEXTUAL_TYPE, MgDataCellRendererTextualClass))

typedef struct _MgDataCellRendererTextual        MgDataCellRendererTextual;
typedef struct _MgDataCellRendererTextualClass   MgDataCellRendererTextualClass;
typedef struct _MgDataCellRendererTextualPrivate MgDataCellRendererTextualPrivate;

struct _MgDataCellRendererTextual
{
	GtkCellRendererText            parent;

	MgDataCellRendererTextualPrivate *priv;
};

struct _MgDataCellRendererTextualClass
{
	GtkCellRendererTextClass parent_class;
	
	void (* changed) (MgDataCellRendererTextual  *cell_renderer_textual,
			  const gchar         *path,
			  const GdaValue      *new_value);
};

GType            mg_data_cell_renderer_textual_get_type (void);
GtkCellRenderer *mg_data_cell_renderer_textual_new      (MgDataHandler *dh, GdaValueType type);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MG_DATA_CELL_RENDERER_TEXTUAL_H__ */
