/* default-display.h
 *
 * Copyright (C) 1999 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_DATA_DISPLAY__
#define __SQL_DATA_DISPLAY__

#include "datadisplay-common.h"
#include "server-rs.h"

G_BEGIN_DECLS

/* FIXME: convert the one for the time to the one for timestamps, and create a new
   one for the time (with 3 spin buttons) */

/*****************************************************************************/
/*                                                                           */
/* Default functions => Read only                                            */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_default    (const GdaValue * value);
GdaValue    *value_from_widget_default    (GtkWidget * wid);
void         widget_update_default        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_default       (const GdaValue * value);
gchar       *str_from_value_default       (const GdaValue * value);

/*****************************************************************************/
/*                                                                           */
/* String functions                                                          */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_string    (const GdaValue * value);
GdaValue    *value_from_widget_string    (GtkWidget * wid);
void         widget_update_string        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_string       (const GdaValue * value);
gchar       *str_from_value_string       (const GdaValue * value);


/*****************************************************************************/
/*                                                                           */
/* Functions for the numbers                                                 */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_number    (const GdaValue * value);
GdaValue    *value_from_widget_number    (GtkWidget * wid);
void         widget_update_number        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_number       (const GdaValue * value);
gchar       *str_from_value_number       (const GdaValue * value);

/*****************************************************************************/
/*                                                                           */
/* Functions for the booleans                                                */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_bool    (const GdaValue * value);
GdaValue    *value_from_widget_bool    (GtkWidget * wid);
void         widget_update_bool        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_bool       (const GdaValue * value);
gchar       *str_from_value_bool       (const GdaValue * value);

/*****************************************************************************/
/*                                                                           */
/* Functions for the dates                                                   */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_date    (const GdaValue * value);
GdaValue    *value_from_widget_date    (GtkWidget * wid);
void         widget_update_date        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_date       (const GdaValue * value);
gchar       *str_from_value_date       (const GdaValue * value);

/*****************************************************************************/
/*                                                                           */
/* Functions for the times                                                   */
/*                                                                           */
/*****************************************************************************/
GtkWidget   *widget_from_value_time    (const GdaValue * value);
GdaValue    *value_from_widget_time    (GtkWidget * wid);
void         widget_update_time        (GtkWidget * wid, const GdaValue * value, gboolean value_as_init);
gchar       *sql_from_value_time       (const GdaValue * value);
gchar       *str_from_value_time       (const GdaValue * value);


/*****************************************************************************/
/*                                                                           */
/* Helper functions                                                          */
/*                                                                           */
/*****************************************************************************/

/* conversion of a text string to escape the forbidden characters */
/* WARNING: the str string is freed, and the returned value will have
   to be freeed */
gchar  *val_access_escape_chars           (gchar * str);
gchar  *val_access_unescape_chars         (gchar * str);

/* Returns a list of DataDisplayFns structs packaging all the above 
   functions */
GSList *data_display_get_initial_list ();
void    data_display_free_display_fns (DataDisplayFns * fns);

G_END_DECLS

#endif
