/*
 *
 * capplet.c : Metatheme capplet.
 *             The mtm-selector is the main object of the metatheme capplet
 *             to this object we attach controls (like control-list) and
 *             views (like preview or info).
 *
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Richard Hestilow <hestgray@ionet.net>
 *          Chema Celorio <chema@ximian.com>
 *
 */

#include <config.h>
#include <capplet-widget.h>
#include <../mtm/mtm.h>
#if 0
#include <mtm-ui/mtm-ext-selector.h>
#endif
#include <glade/glade.h>

#include "mtm-selector.h"
#include "mtm-control-list.h"
#include "mtm-view-preview.h"
#include "mtm-view-info.h"
#include "mtm-view-extensions.h"
#include "mtm-view-author.h"

static void
capplet_ok_cb (GtkObject *capplet, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));

	mtm_selector_activate_selected_theme (selector);
}

static void
capplet_try_cb (GtkObject *capplet, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));

	/* Backup in case the user hits "cancel" */
	mtm_selector_record_current_theme (selector);

	mtm_selector_activate_selected_theme (selector);

}

static void
capplet_cancel_cb (GtkObject *capplet, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));

	mtm_selector_rollback_theme (selector);

}

static void
capplet_revert_cb (GtkObject *capplet, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));

	mtm_selector_rollback_theme (selector);

}

static void
capplet_info_cb (GtkObject *capplet, GtkWidget *info_dialog)
{
	g_return_if_fail (GNOME_IS_DIALOG (info_dialog));

	gtk_widget_show (info_dialog);
}

static void
capplet_implement_me_dialog ()
{
	GnomeDialog *dialog;
	GtkWidget *label;

	dialog = GNOME_DIALOG (gnome_dialog_new ("Implement me !",
									 GNOME_STOCK_BUTTON_OK,
									 NULL));
	label = gtk_label_new ("I am not implemented :-(\n"
					   "Please give me some love ..\n");
	gtk_box_pack_start (GTK_BOX (dialog->vbox), label, TRUE, TRUE, 10);
#if 0
	gnome_dialog_set_parent (dialog, parent);
#endif	
	gtk_widget_show_all (GTK_WIDGET (dialog));
		
	gnome_dialog_run_and_close (dialog);
}

static void
capplet_add_cb (GtkObject *button, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));


	capplet_implement_me_dialog ();
}

static void
capplet_delete_cb (GtkObject *button, MtmSelector *selector)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));


	capplet_implement_me_dialog ();
}

static void
capplet_changed_cb (MtmSelector *selector, CappletWidget *capplet)
{
	g_return_if_fail (MTM_IS_SELECTOR (selector));
	g_return_if_fail (IS_CAPPLET_WIDGET (capplet));

	capplet_widget_state_changed (capplet, TRUE);
}

static gchar *set_theme;

int
main (int argc, char **argv)
{
	MtmSelector *selector;
	GtkWidget *info_dialog;	
	GtkWidget *main_vbox;
	GtkWidget *capplet;
	GtkWidget *preview;
	GtkWidget *extensions;
	GtkWidget *clist;
	GtkWidget *author;
	GtkWidget *w;
	GladeXML *xml;
	
	int ret;
#ifdef GTKHTML_HAVE_GCONF
	GConfError  *gconf_error  = NULL;
#endif
	static struct poptOption options[] = {
		{ "set-theme", '\0', POPT_ARG_STRING, &set_theme, 0,
			N_("Set the current theme."), "FILENAME"},
		{ NULL, '\0', 0, NULL, 0}
	};

	ret = gnome_capplet_init ("metatheme_selector_capplet", VERSION,
		argc, argv, options, 0, NULL);

	if (ret < 0)
		return 1;
	
#ifdef GTKHTML_HAVE_GCONF
        if (!gconf_init (argc, argv, &gconf_error)) {
                g_assert (gconf_error != NULL);
                g_error ("GConf init failed:\n  %s", gconf_error->str);
                return FALSE;
        }
#endif
	glade_gnome_init ();
	mtm_init ();

	xml = glade_xml_new (SHAREDIR "mtm-selector.glade", "vbox16");
	g_return_val_if_fail (xml != NULL, -1);

	main_vbox = glade_xml_get_widget (xml, "vbox16");
	g_return_val_if_fail (GTK_IS_WIDGET (main_vbox), -1);

	/* The selector is the main object, you can then attach controls or views */
	selector = mtm_selector_new ();
	g_return_val_if_fail (MTM_IS_SELECTOR (selector), -1);
	mtm_selector_add_default_dirs (selector);

	/* Add the "available themes" GtkCList control */
	w = glade_xml_get_widget (xml, "optionmenu_vbox");
	g_return_val_if_fail (w != NULL, -1);
	clist = mtm_control_list_new (selector);
	gtk_box_pack_start (GTK_BOX (w), clist, TRUE, TRUE, 0);

	/* Add the Preview window view */
	w = glade_xml_get_widget (xml, "preview_scrolled_window");
	g_return_val_if_fail (w != NULL, -1);
	preview = mtm_view_preview_new (selector);
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (w),
								    preview);

	/* Add the author view */
	w = glade_xml_get_widget (xml, "author_hbox");
	g_return_val_if_fail (w != NULL, -1);
	//author = mtm_view_author_new (selector);
	//gtk_box_pack_start (GTK_BOX (w), author, FALSE, FALSE, 0);

	/* Add the extensions selector view  */
	w = glade_xml_get_widget (xml, "extensions_scrolled_window");
	g_return_val_if_fail (w != NULL, -1);
	extensions = mtm_view_extensions_new (selector);
//	gtk_box_pack_start (GTK_BOX (w), extensions,
//					TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (w), extensions);
	/* Get the dialog for the theme info */
	info_dialog = mtm_view_info_dialog_new (selector);
	
	/* Emit a signal so that we update the list of themes */
	mtm_selector_files_changed (selector);
	mtm_control_list_select_default (clist);
		
	capplet = capplet_widget_new ();
	gtk_container_add (GTK_CONTAINER (capplet), main_vbox);

	gtk_signal_connect (GTK_OBJECT (capplet), "ok",
					capplet_ok_cb,     selector);
	gtk_signal_connect (GTK_OBJECT (capplet), "try",
					capplet_try_cb,    selector);
	gtk_signal_connect (GTK_OBJECT (capplet), "cancel",
					capplet_cancel_cb, selector);
	gtk_signal_connect (GTK_OBJECT (capplet), "revert",
					capplet_revert_cb, selector);

#if 0
	/* connext the buttons */
	w = glade_xml_get_widget (xml, "try_button");
	g_return_val_if_fail (w != NULL, -1);
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
					capplet_try_cb, selector);
	w = glade_xml_get_widget (xml, "info_button");
	g_return_val_if_fail (w != NULL, -1);
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
					capplet_info_cb, info_dialog);
	w = glade_xml_get_widget (xml, "add_button");
	g_return_val_if_fail (w != NULL, -1);
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
					capplet_add_cb, selector);
	w = glade_xml_get_widget (xml, "delete_button");
	g_return_val_if_fail (w != NULL, -1);
	gtk_signal_connect (GTK_OBJECT (w), "clicked",
					capplet_delete_cb, selector);
#endif	
	gtk_signal_connect (GTK_OBJECT (selector), "selection_changed",
					capplet_changed_cb, capplet);
	capplet_changed_cb (selector, capplet);
	gtk_widget_show_all (capplet);

	w = glade_xml_get_widget (xml, "button37");
	gtk_widget_hide (w);

	capplet_gtk_main ();

	gtk_object_destroy (GTK_OBJECT (selector));

	return 0;
}

