/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

/**
 *@file
 *The place where MlView application is launched.
 *Here the command line is parsed, and mlview high level classes
 *are instanciated.
 *
 */

#include <stdio.h>
#include <gnome.h>
#include <libxml/parser.h>
#include <libxml/catalog.h>
#include "config.h"

#include "mlview-utils.h"
#include "mlview-app.h"


/**
 *MlView main entry point.
 */
int
main (int argc, char **argv)
{
        GnomeApp *mlview_application = NULL;

        gchar **args = NULL;
        poptContext popt_context = { 0 };
        gboolean show_version = FALSE,
                show_info = FALSE;
        struct poptOption cmd_options_table[] = {
                {
                 "version",
                 'v',
                 POPT_ARG_NONE,
                 &show_version,
                 0,
                 N_
                 ("Prints The version of gnome-mlview you are using"),
                 NULL},
                {
                 "about",
                 'a',
                 POPT_ARG_NONE,
                 &show_info,
                 0,
                 N_
                 ("Prints some information about gnome-mlview"),
                 NULL},
                {0}
        };

        /*init gnome */
        gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv,
                                    cmd_options_table, 0,
                                    &popt_context);

        /*init underlaying facilities */
        mlview_utils_init ();

        /*Then, parse the non option command arguments */
        args = (gchar **) poptGetArgs (popt_context);

        if (show_version == TRUE) {
                g_print ("%s\n", VERSION);
                poptFreeContext (popt_context);
                return 0;
        }

        if (show_info == TRUE) {
                g_print ("%s\n", _("No usefull info yest"));
                poptFreeContext (popt_context);
                return 0;
        }

        /*instanciate an mlview application */
        mlview_application = mlview_app_new (PACKAGE);

        gtk_window_set_wmclass (GTK_WINDOW (mlview_application),
                                "main-application-window",
                                "MlView");

        gtk_widget_realize (GTK_WIDGET (mlview_application));

        mlview_app_set_icon (mlview_application);

        gtk_widget_set_usize (GTK_WIDGET (mlview_application),
                              800, 600);

        gtk_widget_show_all (GTK_WIDGET (mlview_application));

        if (args) {
                /*
                 *they are some argument on the comment line. Treat them 
                 *like files to open
                 */
                MlViewEditor *mlview_editor =
                        mlview_app_get_editor
                        (mlview_application);

                if (mlview_editor) {
                        int i;

                        for (i = 0; args[i] != NULL; i++) {
                                mlview_editor_load_xml_file
                                        (mlview_editor,
                                         (gchar *) args[i]);
                        }
                }
        }

        poptFreeContext (popt_context);

        gtk_main ();

        mlview_utils_cleanup ();

        return 0;
}                               //end main
