/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#include "mlview-global-settings.h"


/*possible settings hash table keys*/

/*wether if validation is on/off. possible values are MLVIEW_STG_V_YES or MLVIEW_STG_V_NO*/
const char *MLVIEW_STG_K_IS_VALIDATION_ON =
        "mlview-is-validation-on";

/*the default tree expansion level*/
const char *MLVIEW_STG_K_DEFAULT_TREE_EXPANSION_LEVEL =
        "mlview-default-node-expansion-level";

const char *MLVIEW_STG_K_PIXMAPS_DIR = "mlview-pixmaps-dir";

const char *MLVIEW_STG_K_ICON_PATH = "mlview-icon-path";

const char *MLVIEW_STG_K_OPEN_ELEMENT_NODE_XPM =
        "open-element-node-xpm";
const char *MLVIEW_STG_K_CLOSE_ELEMENT_NODE_XPM =
        "close-element-node-xpm";
const char *MLVIEW_STG_K_TEXT_NODE_XPM = "text-element-node-xpm";
const char *MLVIEW_STG_K_OPEN_ELEMENT_NODE_BPM =
        "open-element-node-bpm";
const char *MLVIEW_STG_K_CLOSE_ELEMENT_NODE_BPM =
        "close-element-node-bpm";
const char *MLVIEW_STG_K_TEXT_NODE_BPM = "text-element-node-bpm";

/*possible settings hash table values*/
const char *MLVIEW_STG_V_YES = "yes";
const char *MLVIEW_STG_V_NO = "no";
const char *MLVIEW_STG_V_DEFAULT_TREE_EXPANSION_LEVEL = "2";

#ifdef MLVIEW_PIXMAPS_DIR
const char *MLVIEW_STG_V_PIXMAPS_DIR = MLVIEW_PIXMAPS_DIR;
#else
const char *MLVIEW_STG_V_PIXMAPS_DIR = NULL;
#endif

#ifdef MLVIEW_ICON_PATH
const char *MLVIEW_STG_V_ICON_PATH = MLVIEW_ICON_PATH;
#else
const char *MLVIEW_STG_V_ICON_PATH = NULL;
#endif

const char *MLVIEW_STG_V_OPEN_ELEMENT_NODE_XPM =
        "xml-element-node-open";
const char *MLVIEW_STG_V_CLOSE_ELEMENT_NODE_XPM =
        "xml-element-node";
const char *MLVIEW_STG_V_TEXT_NODE_XPM = "xml-text-node";
const char *MLVIEW_STG_K_XML_CATALOG = "xml-catalog";
