/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

/**
 *@file
 *This class is the abstraction of a visual tree editor.
 *Given an xmlNode (gnome-xml) based tree, 
 *it can visualize it, support cut/copy/paste operations
 *that modifies directly the underlying xmlNode based tree etc ...
 *@author Dodji Seketeli <dodji@gnome.org>
 *
 */
#ifndef __MLVIEW_TREE_EDITOR_H__
#  define __MLVIEW_TREE_EDITOR_H__

#  include <libxml/tree.h>
#  include "mlview-node-type-picker.h"
#  include "mlview-settings-builder.h"
#  include "mlview-app-context.h"
#  include "mlview-xml-document.h"


G_BEGIN_DECLS
/*common macros to comply with the GtkObject typing system.*/
#  define MLVIEW_TYPE_TREE_EDITOR (mlview_tree_editor_get_type())
#  define MLVIEW_TREE_EDITOR(object) (G_TYPE_CHECK_INSTANCE_CAST((object),MLVIEW_TYPE_TREE_EDITOR,MlViewTreeEditor))
#  define MLVIEW_TREE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass),MLVIEW_TYPE_TREE_EDITOR,MlViewTreeEditorClass))
#  define MLVIEW_IS_TREE_EDITOR(object) (G_TYPE_CHECK_INSTANCE_TYPE((object),MLVIEW_TYPE_TREE_EDITOR))
#  define MLVIEW_IS_TREE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),MLVIEW_TYPE_TREE_EDITOR))
/*common class and instance definitions*/
typedef struct _MlViewTreeEditor MlViewTreeEditor;
typedef struct _MlViewTreeEditorClass MlViewTreeEditorClass;
typedef struct _MlViewTreeEditorPrivate MlViewTreeEditorPrivate;


/*====================================================================
 *The structure representing
 *the MlViewTreeEditor object.
 *===================================================================*/
struct _MlViewTreeEditor {
        GtkVBox vbox;
        MlViewTreeEditorPrivate *priv;
};

/*==========================================================
 *Exported methods:
 *==========================================================*/

guint mlview_tree_editor_get_type (void);

GtkWidget *mlview_tree_editor_new (MlViewAppContext *
                                   a_app_context);

void
 mlview_tree_editor_destroy (GtkObject * a_object);

guint
mlview_tree_editor_edit_xml_doc (MlViewTreeEditor * a_editor,
                                 MlViewXMLDocument * a_xmldoc,
                                 gchar * a_doc_name);

void
 mlview_tree_editor_update_visual_node (MlViewTreeEditor * a_tree_editor,
                                        GtkCTreeNode *
                                        a_visual_node);

void
 mlview_tree_editor_update_visual_xml_node (MlViewTreeEditor * a_tree_editor,
                                            xmlNode * a_node);

gint
mlview_tree_editor_add_child_node (MlViewTreeEditor *
                                   a_tree_editor,
                                   GtkCTreeNode * a_parent_node,
                                   xmlNodePtr a_xml_node);

xmlNode *mlview_tree_editor_insert_sibling_node (MlViewTreeEditor
                                                 * a_tree_editor,
                                                 GtkCTreeNode *
                                                 a_sibling_node,
                                                 xmlNodePtr
                                                 a_xml_node,
                                                 gboolean
                                                 previous);

void
 mlview_tree_editor_cut_node (MlViewTreeEditor * a_tree_editor,
                              GtkCTreeNode * a_visual_node);

void
 mlview_tree_editor_create_new_xml_doc (MlViewTreeEditor * a_tree_editor,
                                        MlViewXMLDocument *
                                        a_xml_doc);

GtkCTreeNode
        * mlview_tree_editor_set_root_element (MlViewTreeEditor *
                                               a_tree_editor,
                                               xmlNodePtr);

GtkCTree *mlview_tree_editor_get_visual_tree (MlViewTreeEditor *
                                              a_tree_editor);

GtkCTreeNode
        * mlview_tree_editor_get_current_selected_node
        (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_paste_node_as_child (MlViewTreeEditor * a_tree_editor,
                                         GtkCTreeNode *
                                         a_visual_parent_node);

void
 mlview_tree_editor_paste_node_as_sibling (MlViewTreeEditor * a_tree_editor,
                                           GtkCTreeNode *
                                           a_visual_sibling_node,
                                           gboolean a_previous);

MlViewXMLDocument
        * mlview_tree_editor_get_xml_document (MlViewTreeEditor *
                                               a_tree_editor);

void
 mlview_tree_editor_set_node_type_picker (MlViewTreeEditor * a_tree_editor,
                                          MlViewNodeTypePicker *
                                          a_node_type_picker);

MlViewNodeTypePicker
        * mlview_tree_editor_get_node_type_picker
        (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_add_child_node_interactive (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_insert_sibling_node_interactive (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_insert_next_sibling_node_interactive (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_insert_prev_sibling_node_interactive (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_copy_node (MlViewTreeEditor * a_tree_editor,
                               GtkCTreeNode * a_visual_node,
                               gboolean a_recursive);

GtkCTreeNode
        * mlview_tree_editor_find_xml_node_that_contains_str
        (MlViewTreeEditor * a_tree_editor, const gchar * a_str,
         const enum WhereInTheNodeBitmap a_where_in_node_bitmap,
         const gboolean a_start_after);

GtkCTreeNode
        *
        mlview_tree_editor_find_xml_node_that_contains_str_interactive
        (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_set_xml_document_path (MlViewTreeEditor * a_tree_editor, gchar * a_file_path);

void
 mlview_tree_editor_set_application_context (MlViewTreeEditor * a_tree_editor,
                                             MlViewAppContext *
                                             a_app_context);
MlViewAppContext
        * mlview_tree_editor_get_application_context
        (MlViewTreeEditor * a_tree_editor);

void
 mlview_tree_editor_expand_tree_to_depth (MlViewTreeEditor * a_editor,
                                          gint a_depth);
void
 mlview_tree_editor_update_contextual_menu (MlViewTreeEditor * a_tree_editor,
                                            GtkMenu **
                                            a_menu_ptr);

void
 mlview_tree_editor_update_child_node_added (MlViewTreeEditor * a_tree_editor,
                                             xmlNode *
                                             a_parent_node,
                                             xmlNode *
                                             a_added_node);

void
 mlview_tree_editor_update_node_cut (MlViewTreeEditor * a_tree_editor, xmlNode * a_parent_node,
                                     xmlNode * a_cut_node);

void
 mlview_tree_editor_update_node_pasted (MlViewTreeEditor * a_tree_editor,
                                        xmlNode * a_parent_node,
                                        xmlNode * a_pasted_node);

void
 mlview_tree_editor_update_sibling_node_inserted (MlViewTreeEditor * a_tree_editor,
                                                  xmlNode *
                                                  a_sibling_node,
                                                  xmlNode *
                                                  a_inserted_node,
                                                  gboolean
                                                  a_previous);

/*===============================================================
 *The structure representing the class of all the MlViewTreeEditor objects.
 *==============================================================*/
struct _MlViewTreeEditorClass {
        GtkVBoxClass parent_class;

 /*============================
	 *signal handlers definitions
	 *===========================
	 */
        void (*tree_changed) (MlViewTreeEditor * a_editor,
                              gpointer a_data);

        /*mark signals... not used */
        void (*mark_set_to_node) (MlViewTreeEditor * a_editor,
                                  GtkCTree * a_visual_tree,
                                  GtkCTreeNode * a_visual_node,
                                  gpointer a_user_data);

        void (*mark_removed_from_node) (MlViewTreeEditor *
                                        a_editor,
                                        GtkCTree * a_visual_tree,
                                        GtkCTreeNode * a_node,
                                        gpointer a_user_data);
        /*copy/cut/paste signals */
        void (*node_cut) (MlViewTreeEditor * a_editor,
                          GtkCTreeNode * a_visual_node,
                          gpointer a_user_data);

        void (*node_pasted) (MlViewTreeEditor * a_editor,
                             GtkCTreeNode * a_visual_node,
                             gpointer a_user_data);

        void (*node_added) (MlViewTreeEditor * a_editor,
                            GtkCTreeNode * a_visual_node,
                            gpointer a_user_data);

        void (*node_selected) (MlViewTreeEditor * a_editor,
                               GtkCTreeNode * a_visual_node,
                               gpointer a_user_data);

        void (*node_unselected) (MlViewTreeEditor * a_editor,
                                 GtkCTreeNode * a_visual_node,
                                 gpointer a_user_data);
};


G_END_DECLS
#endif /*__MLVIEW_TREE_EDITOR_H__*/
