
#ifndef __SRC_MAINWINDOW_H__
#define __SRC_MAINWINDOW_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "src/SerialStreamRecorder.h"
#include "src/RecordDialog.h"

G_BEGIN_DECLS


#define MOSERIAL_TYPE_MAIN_WINDOW (moserial_main_window_get_type ())
#define MOSERIAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindow))
#define MOSERIAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))
#define MOSERIAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))

typedef struct _moserialMainWindow moserialMainWindow;
typedef struct _moserialMainWindowClass moserialMainWindowClass;
typedef struct _moserialMainWindowPrivate moserialMainWindowPrivate;

struct _moserialMainWindow {
	GtkWindow parent_instance;
	moserialMainWindowPrivate * priv;
};

struct _moserialMainWindowClass {
	GtkWindowClass parent_class;
};


moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename);
moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename);
void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w);
void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o);
void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o);
void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button);
void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog);
void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction);
gboolean moserial_main_window_recordTimeout (moserialMainWindow* self);
void moserial_main_window_showWindow (moserialMainWindow* self);
gboolean moserial_main_window_ensureConnected (moserialMainWindow* self);
void moserial_main_window_ensureDisconnected (moserialMainWindow* self);
GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self);
const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self);
GType moserial_main_window_get_type (void);


G_END_DECLS

#endif
