
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DEFAULT_PATHS (default_paths_get_type ())
#define DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_PATHS, DefaultPaths))
#define DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_PATHS, DefaultPathsClass))
#define IS_DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_PATHS))
#define IS_DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_PATHS))
#define DEFAULT_PATHS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_PATHS, DefaultPathsClass))

typedef struct _DefaultPaths DefaultPaths;
typedef struct _DefaultPathsClass DefaultPathsClass;
typedef struct _DefaultPathsPrivate DefaultPathsPrivate;

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _DefaultPaths {
	GObject parent_instance;
	DefaultPathsPrivate * priv;
};

struct _DefaultPathsClass {
	GObjectClass parent_class;
};

struct _DefaultPathsPrivate {
	char* _recordTo;
	char* _receiveTo;
	char* _sendFrom;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer default_paths_parent_class = NULL;

GType default_paths_get_type (void);
#define DEFAULT_PATHS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DEFAULT_PATHS, DefaultPathsPrivate))
enum  {
	DEFAULT_PATHS_DUMMY_PROPERTY,
	DEFAULT_PATHS_RECORD_TO,
	DEFAULT_PATHS_RECEIVE_TO,
	DEFAULT_PATHS_SEND_FROM
};
void default_paths_set_recordTo (DefaultPaths* self, const char* value);
void default_paths_set_receiveTo (DefaultPaths* self, const char* value);
void default_paths_set_sendFrom (DefaultPaths* self, const char* value);
DefaultPaths* default_paths_new (const char* RecordTo, const char* ReceiveTo, const char* SendFrom);
DefaultPaths* default_paths_construct (GType object_type, const char* RecordTo, const char* ReceiveTo, const char* SendFrom);
const char* default_paths_get_recordTo (DefaultPaths* self);
GType profile_get_type (void);
const char* default_paths_get_receiveTo (DefaultPaths* self);
const char* default_paths_get_sendFrom (DefaultPaths* self);
void default_paths_saveToProfile (DefaultPaths* self, Profile* profile);
char* default_paths_getPath (Profile* profile, const char* group, const char* key);
DefaultPaths* default_paths_loadFromProfile (Profile* profile);
gboolean mo_utils_fileExists (const char* path);
static void default_paths_finalize (GObject* obj);
static void default_paths_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void default_paths_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DefaultPaths* default_paths_construct (GType object_type, const char* RecordTo, const char* ReceiveTo, const char* SendFrom) {
	DefaultPaths * self;
	self = g_object_newv (object_type, 0, NULL);
	default_paths_set_recordTo (self, RecordTo);
	default_paths_set_receiveTo (self, ReceiveTo);
	default_paths_set_sendFrom (self, SendFrom);
	return self;
}


DefaultPaths* default_paths_new (const char* RecordTo, const char* ReceiveTo, const char* SendFrom) {
	return default_paths_construct (TYPE_DEFAULT_PATHS, RecordTo, ReceiveTo, SendFrom);
}


void default_paths_saveToProfile (DefaultPaths* self, Profile* profile) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	if (self->priv->_recordTo != NULL) {
		g_key_file_set_string (profile->keyFile, "paths", "last_record_path", self->priv->_recordTo);
	}
	if (self->priv->_receiveTo != NULL) {
		g_key_file_set_string (profile->keyFile, "paths", "last_receive_path", self->priv->_receiveTo);
	}
	if (self->priv->_sendFrom != NULL) {
		g_key_file_set_string (profile->keyFile, "paths", "last_send_path", self->priv->_sendFrom);
	}
}


DefaultPaths* default_paths_loadFromProfile (Profile* profile) {
	DefaultPaths* result;
	char* RecordTo;
	char* ReceiveTo;
	char* SendFrom;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_val_if_fail (profile != NULL, NULL);
	RecordTo = NULL;
	ReceiveTo = NULL;
	SendFrom = NULL;
	_tmp0_ = NULL;
	RecordTo = (_tmp0_ = default_paths_getPath (profile, "paths", "last_record_path"), RecordTo = (g_free (RecordTo), NULL), _tmp0_);
	_tmp1_ = NULL;
	ReceiveTo = (_tmp1_ = default_paths_getPath (profile, "paths", "last_receive_path"), ReceiveTo = (g_free (ReceiveTo), NULL), _tmp1_);
	_tmp2_ = NULL;
	SendFrom = (_tmp2_ = default_paths_getPath (profile, "paths", "last_send_path"), SendFrom = (g_free (SendFrom), NULL), _tmp2_);
	result = default_paths_new (RecordTo, ReceiveTo, SendFrom);
	RecordTo = (g_free (RecordTo), NULL);
	ReceiveTo = (g_free (ReceiveTo), NULL);
	SendFrom = (g_free (SendFrom), NULL);
	return result;
}


char* default_paths_getPath (Profile* profile, const char* group, const char* key) {
	char* result;
	GError * _inner_error_;
	char* path;
	g_return_val_if_fail (profile != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	path = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = g_key_file_get_string (profile->keyFile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch27_g_key_file_error;
			}
			goto __finally27;
		}
		_tmp1_ = NULL;
		path = (_tmp1_ = _tmp0_, path = (g_free (path), NULL), _tmp1_);
		if (!mo_utils_fileExists (path)) {
			result = NULL;
			path = (g_free (path), NULL);
			return result;
		}
	}
	goto __finally27;
	__catch27_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		path = (g_free (path), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	/*stdout.printf("%s\n", e.message);*/
	result = path;
	return result;
}


const char* default_paths_get_recordTo (DefaultPaths* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_recordTo;
	return result;
}


void default_paths_set_recordTo (DefaultPaths* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_recordTo = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_recordTo = (g_free (self->priv->_recordTo), NULL), _tmp1_);
	g_object_notify ((GObject *) self, "recordTo");
}


const char* default_paths_get_receiveTo (DefaultPaths* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_receiveTo;
	return result;
}


void default_paths_set_receiveTo (DefaultPaths* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_receiveTo = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_receiveTo = (g_free (self->priv->_receiveTo), NULL), _tmp1_);
	g_object_notify ((GObject *) self, "receiveTo");
}


const char* default_paths_get_sendFrom (DefaultPaths* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sendFrom;
	return result;
}


void default_paths_set_sendFrom (DefaultPaths* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_sendFrom = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_sendFrom = (g_free (self->priv->_sendFrom), NULL), _tmp1_);
	g_object_notify ((GObject *) self, "sendFrom");
}


static void default_paths_class_init (DefaultPathsClass * klass) {
	default_paths_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DefaultPathsPrivate));
	G_OBJECT_CLASS (klass)->get_property = default_paths_get_property;
	G_OBJECT_CLASS (klass)->set_property = default_paths_set_property;
	G_OBJECT_CLASS (klass)->finalize = default_paths_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_PATHS_RECORD_TO, g_param_spec_string ("recordTo", "recordTo", "recordTo", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_PATHS_RECEIVE_TO, g_param_spec_string ("receiveTo", "receiveTo", "receiveTo", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEFAULT_PATHS_SEND_FROM, g_param_spec_string ("sendFrom", "sendFrom", "sendFrom", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void default_paths_instance_init (DefaultPaths * self) {
	self->priv = DEFAULT_PATHS_GET_PRIVATE (self);
}


static void default_paths_finalize (GObject* obj) {
	DefaultPaths * self;
	self = DEFAULT_PATHS (obj);
	self->priv->_recordTo = (g_free (self->priv->_recordTo), NULL);
	self->priv->_receiveTo = (g_free (self->priv->_receiveTo), NULL);
	self->priv->_sendFrom = (g_free (self->priv->_sendFrom), NULL);
	G_OBJECT_CLASS (default_paths_parent_class)->finalize (obj);
}


GType default_paths_get_type (void) {
	static GType default_paths_type_id = 0;
	if (default_paths_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DefaultPathsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_paths_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultPaths), 0, (GInstanceInitFunc) default_paths_instance_init, NULL };
		default_paths_type_id = g_type_register_static (G_TYPE_OBJECT, "DefaultPaths", &g_define_type_info, 0);
	}
	return default_paths_type_id;
}


static void default_paths_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DefaultPaths * self;
	gpointer boxed;
	self = DEFAULT_PATHS (object);
	switch (property_id) {
		case DEFAULT_PATHS_RECORD_TO:
		g_value_set_string (value, default_paths_get_recordTo (self));
		break;
		case DEFAULT_PATHS_RECEIVE_TO:
		g_value_set_string (value, default_paths_get_receiveTo (self));
		break;
		case DEFAULT_PATHS_SEND_FROM:
		g_value_set_string (value, default_paths_get_sendFrom (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void default_paths_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DefaultPaths * self;
	self = DEFAULT_PATHS (object);
	switch (property_id) {
		case DEFAULT_PATHS_RECORD_TO:
		default_paths_set_recordTo (self, g_value_get_string (value));
		break;
		case DEFAULT_PATHS_RECEIVE_TO:
		default_paths_set_receiveTo (self, g_value_get_string (value));
		break;
		case DEFAULT_PATHS_SEND_FROM:
		default_paths_set_sendFrom (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




