/* SerialConnection.c generated by valac, the Vala compiler
 * generated from SerialConnection.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	char* echoReference;
	char* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	struct termios restoretio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	gboolean localEcho;
};

typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_serial_connection_parent_class = NULL;

GType moserial_serial_connection_get_type (void);
#define MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionPrivate))
enum  {
	MOSERIAL_SERIAL_CONNECTION_DUMMY_PROPERTY
};
GType moserial_serial_connection_line_end_get_type (void);
GType settings_access_mode_get_type (void);
GType settings_get_type (void);
SettingsAccessMode settings_get_accessMode (Settings* self);
const char* settings_get_device (Settings* self);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition);
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static guint* _uint_dup (guint* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
GType settings_parity_get_type (void);
SettingsParity settings_get_parity (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_handshake_get_type (void);
SettingsHandshake settings_get_handshake (Settings* self);
char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
static void moserial_serial_connection_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType moserial_serial_connection_line_end_get_type (void) {
	static GType moserial_serial_connection_line_end_type_id = 0;
	if (G_UNLIKELY (moserial_serial_connection_line_end_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC, "MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC", "esc"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
		moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
	}
	return moserial_serial_connection_line_end_type_id;
}


static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_serial_connection_readBytes (self, source, condition);
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings) {
	gboolean result;
	gint n;
	GIOChannel* _tmp0_;
	guint* _tmp2_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		if (settings_get_accessMode (settings) == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	self->priv->m_fd = open (settings_get_device (settings), (self->priv->flags | O_NDELAY) | O_NONBLOCK, 0);
	if (self->priv->m_fd < 0) {
		self->priv->m_fd = -1;
		result = FALSE;
		return result;
	}
	tcflush (self->priv->m_fd, TCIOFLUSH);
	n = fcntl (self->priv->m_fd, F_GETFL);
	fcntl (self->priv->m_fd, F_SETFL, (gulong) (n & (~O_NDELAY)));
	tcgetattr (self->priv->m_fd, &self->priv->restoretio);
	moserial_serial_connection_applySettings (self, settings);
	tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
	self->priv->connected = TRUE;
	self->priv->IOChannelFd = (_tmp0_ = g_io_channel_unix_new (self->priv->m_fd), _g_io_channel_unref0 (self->priv->IOChannelFd), _tmp0_);
	self->priv->sourceId = (_tmp2_ = __uint_dup0 ((_tmp1_ = g_io_add_watch (self->priv->IOChannelFd, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self), &_tmp1_)), _g_free0 (self->priv->sourceId), _tmp2_);
	self->priv->localEcho = settings_get_localEcho (settings);
	result = TRUE;
	return result;
}


void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guchar* _tmp0_;
		gint b_size;
		gint b_length1;
		guchar* b;
		gsize x;
		b = (_tmp0_ = g_new0 (guchar, 1), b_length1 = 1, b_size = b_length1, _tmp0_);
		b[0] = byte;
		x = (gsize) write (self->priv->m_fd, b, (gsize) 1);
		self->tx = self->tx + x;
		b = (g_free (b), NULL);
	}
}


void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size) {
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gsize x;
		x = (gsize) write (self->priv->m_fd, bytes, size);
		tcdrain (self->priv->m_fd);
		self->tx = self->tx + x;
	}
}


char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e) {
	char* result;
	char* s;
	g_return_val_if_fail (self != NULL, NULL);
	s = NULL;
	switch (e) {
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CR:
		{
			{
				char* _tmp0_;
				s = (_tmp0_ = g_strdup ("\r"), _g_free0 (s), _tmp0_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_LF:
		{
			{
				char* _tmp1_;
				s = (_tmp1_ = g_strdup ("\n"), _g_free0 (s), _tmp1_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF:
		{
			{
				char* _tmp2_;
				s = (_tmp2_ = g_strdup ("\r\n"), _g_free0 (s), _tmp2_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB:
		{
			{
				char* _tmp3_;
				s = (_tmp3_ = g_strdup ("\t"), _g_free0 (s), _tmp3_);
				break;
			}
		}
		case MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC:
		{
			{
				char* _tmp4_;
				s = (_tmp4_ = g_strdup ("\x1b"), _g_free0 (s), _tmp4_);
				break;
			}
		}
		default:
		{
			{
				char* _tmp5_;
				s = (_tmp5_ = g_strdup (""), _g_free0 (s), _tmp5_);
				break;
			}
		}
	}
	result = s;
	return result;
}


void moserial_serial_connection_doDisconnect (moserialSerialConnection* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->connected) {
		guint* _tmp0_;
		GIOChannel* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		g_source_remove (*self->priv->sourceId);
		self->priv->sourceId = (_tmp0_ = NULL, _g_free0 (self->priv->sourceId), _tmp0_);
		{
			g_io_channel_shutdown (self->priv->IOChannelFd, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch6_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally6;
		__catch6_g_io_channel_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("SerialConnection.vala:135: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->IOChannelFd = (_tmp1_ = NULL, _g_io_channel_unref0 (self->priv->IOChannelFd), _tmp1_);
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->tx = self->rx = self->nonprintable = (gulong) 0;
		self->echoReference = (_tmp2_ = g_strdup (""), _g_free0 (self->echoReference), _tmp2_);
		self->echoCompare = (_tmp3_ = g_strdup (""), _g_free0 (self->echoCompare), _tmp3_);
		tcsetattr (self->priv->m_fd, TCSANOW, &self->priv->newtio);
		close (self->priv->m_fd);
	}
}


static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition) {
	gboolean result;
	guchar* _tmp0_;
	gint m_buf_size;
	gint m_buf_length1;
	guchar* m_buf;
	gint bytesRead;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	m_buf = (_tmp0_ = g_new0 (guchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp0_);
	bytesRead = (gint) read (self->priv->m_fd, m_buf, (gsize) 1000);
	self->rx = self->rx + ((gulong) bytesRead);
	if (bytesRead < 0) {
		result = FALSE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	}
	g_signal_emit_by_name (self, "new-data", m_buf, m_buf_length1, bytesRead);
	if (self->priv->localEcho) {
		moserial_serial_connection_sendBytes (self, (gchar*) m_buf, m_buf_length1, (gsize) bytesRead);
	}
	result = self->priv->connected;
	m_buf = (g_free (m_buf), NULL);
	return result;
}


static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings) {
	guint baudRate;
	gint dataBits = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint mcs;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	baudRate = (guint) 0;
	switch (settings_get_baudRate (settings)) {
		case 300:
		{
			baudRate = B300;
			break;
		}
		case 600:
		{
			baudRate = B600;
			break;
		}
		case 1200:
		{
			baudRate = B1200;
			break;
		}
		case 2400:
		{
			baudRate = B2400;
			break;
		}
		case 4800:
		{
			baudRate = B4800;
			break;
		}
		case 9600:
		{
			baudRate = B9600;
			break;
		}
		case 19200:
		{
			baudRate = B19200;
			break;
		}
		case 38400:
		{
			baudRate = B38400;
			break;
		}
		case 57600:
		{
			baudRate = B57600;
			break;
		}
		case 115200:
		{
			baudRate = B115200;
			break;
		}
		case 230400:
		{
			baudRate = B230400;
			break;
		}
		case 460800:
		{
			baudRate = B460800;
			break;
		}
		case 576000:
		{
			baudRate = B576000;
			break;
		}
		case 921600:
		{
			baudRate = B921600;
			break;
		}
		case 1000000:
		{
			baudRate = B1000000;
			break;
		}
		case 2000000:
		{
			baudRate = B2000000;
			break;
		}
	}
	cfsetospeed (&self->priv->newtio, baudRate);
	cfsetispeed (&self->priv->newtio, baudRate);
	dataBits = settings_get_dataBits (settings);
	if (settings_get_dataBits (settings) == 7) {
		gboolean _tmp1_ = FALSE;
		if (settings_get_parity (settings) == SETTINGS_PARITY_MARK) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = settings_get_parity (settings) == SETTINGS_PARITY_SPACE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		dataBits = 8;
	}
	switch (dataBits) {
		case 5:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS7;
			break;
		}
		default:
		{
			self->priv->newtio.c_cflag = (self->priv->newtio.c_cflag & (~CSIZE)) | CS8;
			break;
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (CLOCAL | CREAD);
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~(PARENB | PARODD));
	if (settings_get_parity (settings) == SETTINGS_PARITY_EVEN) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | PARENB;
	} else {
		if (settings_get_parity (settings) == SETTINGS_PARITY_ODD) {
			self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (PARENB | PARODD);
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	if (settings_get_stopBits (settings) == 2) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CSTOPB;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CSTOPB);
	}
	self->priv->newtio.c_iflag = IGNBRK;
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp2_) {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag | (IXON | IXOFF);
	} else {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag & (~((IXON | IXOFF) | IXANY));
	}
	self->priv->newtio.c_lflag = (guint) 0;
	self->priv->newtio.c_oflag = (guint) 0;
	self->priv->newtio.c_cc[VTIME] = (guchar) 1;
	self->priv->newtio.c_cc[VMIN] = (guchar) 1;
	self->priv->newtio.c_lflag = self->priv->newtio.c_lflag & (~(ECHONL | NOFLSH));
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &mcs);
	mcs = mcs | TIOCM_RTS;
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
	if (settings_get_handshake (settings) == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = settings_get_handshake (settings) == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp3_) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CRTSCTS;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	}
}


char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self) {
	char* result;
	char* r;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	if (self->nonprintable > 0) {
		char* _tmp0_;
		r = (_tmp0_ = g_strdup_printf (_ ("TX: %lu, RX: %lu (%lu unprintable)"), self->tx, self->rx, self->nonprintable), _g_free0 (r), _tmp0_);
	} else {
		char* _tmp1_;
		r = (_tmp1_ = g_strdup_printf (_ ("TX: %lu, RX: %lu"), self->tx, self->rx), _g_free0 (r), _tmp1_);
	}
	result = r;
	return result;
}


moserialSerialConnection* moserial_serial_connection_construct (GType object_type) {
	moserialSerialConnection * self;
	self = (moserialSerialConnection*) g_object_new (object_type, NULL);
	return self;
}


moserialSerialConnection* moserial_serial_connection_new (void) {
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}


static void moserial_serial_connection_class_init (moserialSerialConnectionClass * klass) {
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSerialConnectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	g_signal_new ("new_data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
}


static void moserial_serial_connection_instance_init (moserialSerialConnection * self) {
	self->priv = MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	self->echoReference = g_strdup ("");
	self->echoCompare = g_strdup ("");
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}


static void moserial_serial_connection_finalize (GObject* obj) {
	moserialSerialConnection * self;
	self = MOSERIAL_SERIAL_CONNECTION (obj);
	_g_free0 (self->echoReference);
	_g_free0 (self->echoCompare);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	_g_free0 (self->priv->sourceId);
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}


GType moserial_serial_connection_get_type (void) {
	static GType moserial_serial_connection_type_id = 0;
	if (moserial_serial_connection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
		moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
	}
	return moserial_serial_connection_type_id;
}



static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}



