/* HexTextBuffer.c generated by valac 0.10.2, the Vala compiler
 * generated from HexTextBuffer.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;
typedef struct _moserialHexTextBufferPrivate moserialHexTextBufferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _moserialHexTextBuffer {
	GtkTextBuffer parent_instance;
	moserialHexTextBufferPrivate * priv;
};

struct _moserialHexTextBufferClass {
	GtkTextBufferClass parent_class;
};

struct _moserialHexTextBufferPrivate {
	GtkTextMark* nextHexMark;
	GtkTextMark* nextCharMark;
	GtkTextTag* addressTag;
	GtkTextTag* oddTag;
	gint hexBytes;
};


static gpointer moserial_hex_text_buffer_parent_class = NULL;

GType moserial_hex_text_buffer_get_type (void) G_GNUC_CONST;
#define MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferPrivate))
enum  {
	MOSERIAL_HEX_TEXT_BUFFER_DUMMY_PROPERTY
};
GType preferences_get_type (void) G_GNUC_CONST;
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences);
const char* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_hex_text_buffer_finalize (GObject* obj);



void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (preferences != NULL);
	g_object_set (self->priv->addressTag, "foreground", preferences_get_highlightColor (preferences), NULL);
	g_object_set (self->priv->oddTag, "foreground", preferences_get_highlightColor (preferences), NULL);
}


void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", 0);
	moserial_hex_text_buffer_setup (self);
}


static void moserial_hex_text_buffer_setup (moserialHexTextBuffer* self) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &nextHexIter);
	self->priv->nextHexMark = (_tmp0_ = gtk_text_mark_new ("nextHex", TRUE), _g_object_unref0 (self->priv->nextHexMark), _tmp0_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	nextCharIter = nextHexIter;
	self->priv->nextCharMark = (_tmp1_ = gtk_text_mark_new ("nextChar", TRUE), _g_object_unref0 (self->priv->nextCharMark), _tmp1_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	self->priv->hexBytes = 0;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data) {
	GtkTextIter nextHexIter = {0};
	GtkTextIter nextCharIter = {0};
	char* incomingHexBuffer;
	char* _tmp4_;
	char* _tmp5_;
	GtkTextIter tempIter = {0};
	char* _tmp6_;
	GtkTextMark* _tmp7_;
	char* _tmp8_;
	gunichar _tmp9_;
	gunichar c;
	char* s;
	gboolean _tmp10_ = FALSE;
	GtkTextMark* _tmp11_;
	g_return_if_fail (self != NULL);
	incomingHexBuffer = g_strdup ("");
	if ((self->priv->hexBytes % 16) == 0) {
		GtkTextIter startIter = {0};
		GtkTextMark* startMark;
		char* _tmp0_;
		GtkTextMark* _tmp1_;
		GtkTextMark* _tmp2_;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
		startMark = gtk_text_mark_new ("startMark", TRUE);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, startMark, &nextCharIter);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, _tmp0_ = g_strdup_printf ("\n%08x", (guint) self->priv->hexBytes), 9);
		_g_free0 (_tmp0_);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &startIter, startMark);
		gtk_text_buffer_apply_tag_by_name ((GtkTextBuffer*) self, "hex_address", &startIter, &nextCharIter);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, startMark);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, " ", 1);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
		nextHexIter = nextCharIter;
		self->priv->nextHexMark = (_tmp1_ = gtk_text_mark_new ("nextHex", TRUE), _g_object_unref0 (self->priv->nextHexMark), _tmp1_);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, "                                                   ", 51);
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
		self->priv->nextCharMark = (_tmp2_ = gtk_text_mark_new ("nextChar", TRUE), _g_object_unref0 (self->priv->nextCharMark), _tmp2_);
		gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
		_g_object_unref0 (startMark);
	} else {
		if ((self->priv->hexBytes % 8) == 0) {
			GtkTextIter tempIter = {0};
			GtkTextMark* _tmp3_;
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
			gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, "  ", 2);
			tempIter = nextHexIter;
			gtk_text_iter_forward_chars (&tempIter, 2);
			gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
			gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
			self->priv->nextHexMark = (_tmp3_ = gtk_text_mark_new ("nextHex", TRUE), _g_object_unref0 (self->priv->nextHexMark), _tmp3_);
			gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
		}
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextHexIter, self->priv->nextHexMark);
	incomingHexBuffer = (_tmp5_ = g_strconcat (incomingHexBuffer, _tmp4_ = g_strdup_printf ("%02X ", (guint) data), NULL), _g_free0 (incomingHexBuffer), _tmp5_);
	_g_free0 (_tmp4_);
	gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextHexIter, incomingHexBuffer, (gint) string_get_length (incomingHexBuffer));
	tempIter = nextHexIter;
	gtk_text_iter_forward_chars (&tempIter, 3);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &nextHexIter, &tempIter);
	incomingHexBuffer = (_tmp6_ = g_strdup (""), _g_free0 (incomingHexBuffer), _tmp6_);
	self->priv->hexBytes++;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextHexMark);
	self->priv->nextHexMark = (_tmp7_ = gtk_text_mark_new ("nextHex", TRUE), _g_object_unref0 (self->priv->nextHexMark), _tmp7_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextHexMark, &nextHexIter);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &nextCharIter, self->priv->nextCharMark);
	c = (_tmp9_ = g_utf8_get_char (_tmp8_ = g_strdup_printf ("%c", (gint) data)), _g_free0 (_tmp8_), _tmp9_);
	s = g_strdup_printf ("%c", (gint) data);
	if (g_utf8_validate (s, -1, NULL)) {
		_tmp10_ = g_unichar_isprint (c);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, s, (gint) string_get_length (s));
	} else {
		gtk_text_buffer_insert ((GtkTextBuffer*) self, &nextCharIter, ".", 1);
	}
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, self->priv->nextCharMark);
	self->priv->nextCharMark = (_tmp11_ = gtk_text_mark_new ("nextChar", TRUE), _g_object_unref0 (self->priv->nextCharMark), _tmp11_);
	gtk_text_buffer_add_mark ((GtkTextBuffer*) self, self->priv->nextCharMark, &nextCharIter);
	_g_free0 (s);
	_g_free0 (incomingHexBuffer);
}


moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type) {
	moserialHexTextBuffer * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


moserialHexTextBuffer* moserial_hex_text_buffer_new (void) {
	return moserial_hex_text_buffer_construct (MOSERIAL_TYPE_HEX_TEXT_BUFFER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GObject * moserial_hex_text_buffer_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialHexTextBuffer * self;
	parent_class = G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	{
		GtkTextTag* _tmp0_;
		GtkTextTag* _tmp1_;
		moserial_hex_text_buffer_setup (self);
		self->priv->addressTag = (_tmp0_ = _g_object_ref0 (gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_address", "foreground", "#2020ff", NULL, NULL)), _g_object_unref0 (self->priv->addressTag), _tmp0_);
		self->priv->oddTag = (_tmp1_ = _g_object_ref0 (gtk_text_buffer_create_tag ((GtkTextBuffer*) self, "hex_odd", "foreground", "#2020ff", NULL, NULL)), _g_object_unref0 (self->priv->oddTag), _tmp1_);
	}
	return obj;
}


static void moserial_hex_text_buffer_class_init (moserialHexTextBufferClass * klass) {
	moserial_hex_text_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialHexTextBufferPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_hex_text_buffer_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_hex_text_buffer_finalize;
}


static void moserial_hex_text_buffer_instance_init (moserialHexTextBuffer * self) {
	self->priv = MOSERIAL_HEX_TEXT_BUFFER_GET_PRIVATE (self);
}


static void moserial_hex_text_buffer_finalize (GObject* obj) {
	moserialHexTextBuffer * self;
	self = MOSERIAL_HEX_TEXT_BUFFER (obj);
	_g_object_unref0 (self->priv->nextHexMark);
	_g_object_unref0 (self->priv->nextCharMark);
	_g_object_unref0 (self->priv->addressTag);
	_g_object_unref0 (self->priv->oddTag);
	G_OBJECT_CLASS (moserial_hex_text_buffer_parent_class)->finalize (obj);
}


GType moserial_hex_text_buffer_get_type (void) {
	static volatile gsize moserial_hex_text_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_hex_text_buffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialHexTextBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_hex_text_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialHexTextBuffer), 0, (GInstanceInitFunc) moserial_hex_text_buffer_instance_init, NULL };
		GType moserial_hex_text_buffer_type_id;
		moserial_hex_text_buffer_type_id = g_type_register_static (GTK_TYPE_TEXT_BUFFER, "moserialHexTextBuffer", &g_define_type_info, 0);
		g_once_init_leave (&moserial_hex_text_buffer_type_id__volatile, moserial_hex_text_buffer_type_id);
	}
	return moserial_hex_text_buffer_type_id__volatile;
}




