# Note that this is NOT a relocatable package
%define name		nautilus
%define ver		1.1.6
%define RELEASE		0_cvs_0
%define rel		%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name:		%name
Vendor:		GNOME
Distribution:	CVS
Summary:	Nautilus is a network user environment
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group:		User Interface/Desktop
Source: 	ftp://ftp.gnome.org/pub/GNOME/stable/sources/%{name}-%{ver}.tar.gz
URL: 		http://nautilus.eazel.com/
BuildRoot:	/var/tmp/%{name}-%{ver}-root

Requires:	GConf >= @GCONF_REQUIRED@
Requires:	ORBit >= @ORBIT_REQUIRED@
Requires:	bonobo >= @BONOBO_REQUIRED@
Requires:	bonobo-activation >= @BONOBO_ACTIVATION_REQUIRED@
Requires:	eel >= 1.1.5
Requires:	esound >= @ESOUND_REQUIRED@
Requires:	gdk-pixbuf >= @GDK_PIXBUF_REQUIRED@
Requires:	glib >= @GLIB_REQUIRED@
Requires:	gnome-libs >= @GNOME_LIBS_REQUIRED@
Requires:	gnome-vfs >= 1.1
Requires:	gtk+ >= @GTK_REQUIRED@
Requires:	imlib >= @IMLIB_REQUIRED@
Requires:	libpng
Requires:	librsvg >= @LIBRSVG_REQUIRED@
Requires:	libxml >= @LIBXML_REQUIRED@
Requires:	medusa >= 0.5.1
Requires:	popt >= @POPT_REQUIRED@

BuildRequires:	GConf-devel >= @GCONF_REQUIRED@
BuildRequires:	ORBit-devel >= @ORBIT_REQUIRED@
BuildRequires:	bonobo-activation-devel >= @BONOBO_ACTIVATION_REQUIRED@
BuildRequires:	bonobo-devel >= @BONOBO_REQUIRED@
BuildRequires:	eel-devel >= 1.1.5
BuildRequires:	esound-devel >= @ESOUND_REQUIRED@
BuildRequires:	gdk-pixbuf-devel >= @GDK_PIXBUF_REQUIRED@
BuildRequires:	glib-devel >= @GLIB_REQUIRED@
BuildRequires:	gnome-libs-devel >= @GNOME_LIBS_REQUIRED@
BuildRequires:	gnome-vfs-devel >= 1.1
BuildRequires:	gtk+-devel >= @GTK_REQUIRED@
BuildRequires:	imlib-devel >= @IMLIB_REQUIRED@
BuildRequires:	libpng-devel
BuildRequires:	librsvg-devel >= @LIBRSVG_REQUIRED@
BuildRequires:	libxml-devel >= @LIBXML_REQUIRED@
BuildRequires:	medusa-devel >= 0.5.1
BuildRequires:	popt >= @POPT_REQUIRED@
BuildRequires:	xpdf >= 0.90

%description
Nautilus integrates access to files, applications, media, Internet-based
resources and the Web.  Nautilus delivers a dynamic and rich user
experience.  Nautilus is an free software project developed under the
GNU General Public License and is a core component of the GNOME desktop
project.

%package devel
Summary:	Libraries and include files for developing Nautilus components
Group:		Development/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description devel
This package provides the necessary development libraries and include
files to allow you to develop Nautilus components.

%package extras
Summary:	Extra goodies to use with Nautilus
Group:          User Interface/Desktop
Requires:	xpdf >= 0.90

%description extras
This is a meta-package that requires useful add-ons for Nautilus.

%package suggested
Summary:	Nautilus and a suggested set of components
Group:          User Interface/Desktop
Requires:       %name = %{PACKAGE_VERSION}
Requires:	%name-extras = %{PACKAGE_VERSION}

%description suggested
This is a meta-package that requires packages useful for running
Nautilus, and getting multimedia to work, such as eog and mpg123.

%prep
%setup

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

LC_ALL=""
LINGUAS=""
LANG=""
export LC_ALL LINGUAS LANG

## Warning!  Make sure there are no spaces or tabs after the \ 
## continuation character, or else the rpm demons will eat you.
CFLAGS="$RPM_OPT_FLAGS -DENABLE_SCROLLKEEPER_SUPPORT" ./configure \
    $MYARCH_FLAGS --enable-more-warnings \
    --prefix=%{_prefix} --datadir=%{_datadir} \
    --sysconfdir=%{_sysconfdir} --includedir=%{_includedir} \
    --libdir=%{_libdir} --bindir=%{_bindir}

make -k
make check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make -k prefix=$RPM_BUILD_ROOT/%{_prefix} \
    sysconfdir=$RPM_BUILD_ROOT/%{_sysconfdir} \
    datadir=$RPM_BUILD_ROOT/%{_datadir} \
    includedir=$RPM_BUILD_ROOT/%{_includedir} \
    libdir=$RPM_BUILD_ROOT/%{_libdir} \
    bindir=$RPM_BUILD_ROOT/%{_bindir} install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{_libdir} /etc/ld.so.conf > /dev/null ; then
	echo "%{_libdir}" >> /etc/ld.so.conf
fi
/sbin/ldconfig
scrollkeeper-update

%postun -p /sbin/ldconfig
scrollkeeper-update

%files

%defattr(0555, bin, bin)
%doc AUTHORS COPYING COPYING-DOCS COPYING.LIB TRADEMARK_NOTICE ChangeLog NEWS README
%{_bindir}/nautilus
%{_bindir}/nautilus-adapter
%{_bindir}/nautilus-error-dialog
%{_bindir}/nautilus-hardware-view
%{_bindir}/nautilus-history-view
%{_bindir}/nautilus-image-view
# %{_bindir}/nautilus-mpg123
%{_bindir}/nautilus-music-view
%{_bindir}/nautilus-news
%{_bindir}/nautilus-notes
%{_bindir}/nautilus-restore-settings-to-default.sh
%{_bindir}/nautilus-sample-content-view
%{_bindir}/nautilus-text-view
%{_bindir}/nautilus-throbber
%{_bindir}/nautilus-verify-rpm.sh
%{_libdir}/libnautilus-adapter.so
%{_libdir}/libnautilus-adapter.so.0
%{_libdir}/libnautilus-adapter.so.0.0.0
%{_libdir}/libnautilus-private.so
%{_libdir}/libnautilus-private.so.0
%{_libdir}/libnautilus-private.so.0.0.0
%{_libdir}/libnautilus-tree-view.so
%{_libdir}/libnautilus-tree-view.so.0
%{_libdir}/libnautilus-tree-view.so.0.0.0
%{_libdir}/libnautilus.so
%{_libdir}/libnautilus.so.0
%{_libdir}/libnautilus.so.0.0.0
%{_libdir}/vfs/modules/*.so


%defattr (0444, bin, bin)
%config %{_sysconfdir}/vfs/modules/*.conf
%{_datadir}/gnome-2.0/ui/*.xml
%{_datadir}/gnome/apps/Applications/*.desktop
%{_datadir}/locale/*/LC_MESSAGES/*.mo
%{_datadir}/nautilus/*.xml
%{_datadir}/nautilus/emblems/*.png
%{_datadir}/nautilus/linksets/*.xml
%{_datadir}/nautilus/patterns/*.jpg
%{_datadir}/nautilus/patterns/*.png
%{_datadir}/nautilus/patterns/.*.png
%{_datadir}/nautilus/services/text/*.xml
%{_datadir}/pixmaps/*.png
%{_datadir}/pixmaps/nautilus/*.gif
%{_datadir}/pixmaps/nautilus/*.png
%{_datadir}/pixmaps/nautilus/*.svg
%{_datadir}/pixmaps/nautilus/*.xml
%{_datadir}/pixmaps/nautilus/crux_eggplant/*.png
%{_datadir}/pixmaps/nautilus/crux_eggplant/*.xml
%{_datadir}/pixmaps/nautilus/crux_eggplant/backgrounds/*.png
%{_datadir}/pixmaps/nautilus/crux_eggplant/sidebar_tab_pieces/*.png
%{_datadir}/pixmaps/nautilus/crux_eggplant/throbber/*.png
%{_datadir}/pixmaps/nautilus/crux_teal/*.png
%{_datadir}/pixmaps/nautilus/crux_teal/*.xml
%{_datadir}/pixmaps/nautilus/crux_teal/backgrounds/*.png
%{_datadir}/pixmaps/nautilus/crux_teal/sidebar_tab_pieces/*.png
%{_datadir}/pixmaps/nautilus/crux_teal/throbber/*.png
%{_datadir}/pixmaps/nautilus/gnome/*.png
%{_datadir}/pixmaps/nautilus/gnome/*.xml
%{_datadir}/pixmaps/nautilus/gnome/throbber/*.png
%{_datadir}/pixmaps/nautilus/sidebar_tab_pieces/*.png
%{_datadir}/pixmaps/nautilus/sierra/*.png
%{_datadir}/pixmaps/nautilus/sierra/*.xml
%{_datadir}/pixmaps/nautilus/tahoe/*.png
%{_datadir}/pixmaps/nautilus/tahoe/*.xml
%{_datadir}/pixmaps/nautilus/throbber/*.png
%{_libdir}/bonobo/servers/Nautilus_ComponentAdapterFactory_std.server
%{_libdir}/bonobo/servers/Nautilus_Control_throbber.server
%{_libdir}/bonobo/servers/Nautilus_View_hardware.server
%{_libdir}/bonobo/servers/Nautilus_View_history.server
%{_libdir}/bonobo/servers/Nautilus_View_image.server
%{_libdir}/bonobo/servers/Nautilus_View_music.server
%{_libdir}/bonobo/servers/Nautilus_View_news.server
%{_libdir}/bonobo/servers/Nautilus_View_notes.server
%{_libdir}/bonobo/servers/Nautilus_View_sample.server
%{_libdir}/bonobo/servers/Nautilus_View_text.server
%{_libdir}/bonobo/servers/Nautilus_View_tree.server
%{_libdir}/bonobo/servers/Nautilus_shell.server

# We put the idl files in the main package, not the devel package
# because the perl corba bindings can use the .idl files at run time.
%{_datadir}/idl/nautilus-view-component.idl
%{_datadir}/idl/nautilus-distributed-undo.idl

%defattr (-, root, root)
%{_datadir}/gnome/help
%{_datadir}/omf/nautilus

%files devel

%defattr(0555, bin, bin)
%{_libdir}/*.la
%{_libdir}/*.sh
%{_libdir}/vfs/modules/*.la

%defattr(0444, bin, bin)
%{_includedir}/libnautilus/*.h

%files extras

%defattr(0444, bin, bin)
%{_datadir}/nautilus/nautilus-extras.placeholder

%files suggested

%defattr(0444, bin, bin)
%{_datadir}/nautilus/nautilus-suggested.placeholder

%changelog
* Tue Apr 17 2001 Gregory Leblanc <gleblanc@grego1.cu-portland.edu>
- Added BuildRequires lines
- Changed Source to point to ftp.gnome.org instead of just the tarball name
- Moved %description sections closer to their %package sections
- Moved %changelog to the end, where so that it's not in the way
- Changed configure and make install options to allow moving of
  libraries, includes, binaries more easily
- Removed hard-coded paths (don't define %prefix or %docdir)
- replace %{prefix}/bin with %{_bindir}
- replace %{prefix}/share with %{_datadir}
- replace %{prefix}/lib with %{_libdir}
- replace %{prefix}/include with %{_includedir}

* Tue Oct 10 2000 Robin Slomkowski <rslomkow@eazel.com>
- removed obsoletes from sub packages and added mozilla and trilobite
subpackages

* Wed Apr 26 2000 Ramiro Estrugo <ramiro@eazel.com>
- created this thing
