// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - category-editor-model.hh
 *
 *  Copyright (C) 2008 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_CATEGORY_EDITOR_MODEL_HH__
#define __PAPER_BOX_CATEGORY_EDITOR_MODEL_HH__

#include <map>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include <gtkmm/textbuffer.h>
#include "category.hh"
#include "category-factory.hh"

namespace paperbox {

    class CategoryEditorData : public boost::noncopyable
    {
    public:
        explicit CategoryEditorData(const Glib::ustring& name);
        explicit CategoryEditorData(boost::shared_ptr<Category>& cat);
        ~CategoryEditorData() {}

        boost::shared_ptr<Category> category;
        Glib::RefPtr<Gtk::TextBuffer> buffer;
        bool dirty;
    };

    class CategoryEditorModel
    {
    public:
        explicit CategoryEditorModel();
        ~CategoryEditorModel();

        std::list<boost::shared_ptr<CategoryEditorData> > load_category_data();

        // throws CategoryExists, propagated from CategoryFactory
        boost::shared_ptr<CategoryEditorData> new_category(const Glib::ustring& name);

        // check for pointer, might return null
        boost::shared_ptr<CategoryEditorData> get_category(const Glib::ustring& name);

        void save_category(const Glib::ustring& name);

        // throws CategoryNotFound, from CategoryFactory
        void delete_category(const Glib::ustring& name);

    protected:
        std::map<Glib::ustring,
                 boost::shared_ptr<CategoryEditorData> > model_data_;
    };

} // namespace paperbox

#endif // __PAPER_BOX_CATEGORY_EDITOR_MODEL_HH__
