/* Generated by GOB (v1.0.7) on Wed Apr 18 22:18:33 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "value-entry.gob"

/* PonG-Edit: a value entry widget
 * Author: George Lebl
 * (c) 2000 Eazel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 30 "value-entry.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 7

#include "value-entry.h"

#include "value-entry-private.h"


#line 28 "value-entry.gob"

#include "config.h"
#include <gnome.h>

enum {
	ENTRY_PAGE = 0,
	INT_SPINNER_PAGE,
	FLOAT_SPINNER_PAGE,
	TOGGLE_PAGE
};


#line 53 "value-entry.c"
/* self casting macros */
#define SELF(x) VALUE_ENTRY(x)
#define SELF_CONST(x) VALUE_ENTRY_CONST(x)
#define IS_SELF(x) IS_VALUE_ENTRY(x)
#define SELF_CLASS(x) VALUE_ENTRY_CLASS(x)

#define SELF_GET_CLASS(x) VALUE_ENTRY_GET_CLASS(x)

/* self typedefs */
typedef ValueEntry Self;
typedef ValueEntryClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void value_entry_class_init (ValueEntryClass * c) G_GNUC_UNUSED;
static void value_entry_init (ValueEntry * self) G_GNUC_UNUSED;
static void value_entry_toggle_toggled (ValueEntry * self) G_GNUC_UNUSED;
static void value_entry_do_changed (ValueEntry * self) G_GNUC_UNUSED;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkNotebookClass *parent_class = NULL;

GtkType
value_entry_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"ValueEntry",
			sizeof (ValueEntry),
			sizeof (ValueEntryClass),
			(GtkClassInitFunc) value_entry_class_init,
			(GtkObjectInitFunc) value_entry_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_notebook_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new() value_entry_new()
#define toggle_toggled(args...) value_entry_toggle_toggled(args)
#define changed(args...) value_entry_changed(args)
#define do_changed(args...) value_entry_do_changed(args)
#define set_type(args...) value_entry_set_type(args)
#define get_text(args...) value_entry_get_text(args)
#define set_text(args...) value_entry_set_text(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const new) (void) = value_entry_new;
static void (* const toggle_toggled) (ValueEntry * self) = value_entry_toggle_toggled;
static void (* const changed) (ValueEntry * self) = value_entry_changed;
static void (* const do_changed) (ValueEntry * self) = value_entry_do_changed;
static void (* const set_type) (ValueEntry * self, PongType type) = value_entry_set_type;
static char * (* const get_text) (ValueEntry * self) = value_entry_get_text;
static void (* const set_text) (ValueEntry * self, const char * text) = value_entry_set_text;

/* a macro for creating a new object of our type */
#define GET_NEW ((ValueEntry *)gtk_type_new(value_entry_get_type()))


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ ":Value:Entry::finalize"
	ValueEntry *self = VALUE_ENTRY (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
value_entry_class_init (ValueEntryClass * c)
{
#define __GOB_FUNCTION__ ":Value:Entry::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_notebook_get_type ());

	object_signals[CHANGED_SIGNAL] =
		gtk_signal_new ("changed",
			(GtkSignalRunType)(GTK_RUN_LAST | GTK_RUN_ACTION),
			GTK_CLASS_TYPE(gtk_object_class),
			GTK_SIGNAL_OFFSET (ValueEntryClass, changed),
			gtk_signal_default_marshaller,
			GTK_TYPE_NONE, 0);
	gtk_object_class_add_signals (gtk_object_class,
		object_signals, LAST_SIGNAL);


	c->changed = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 52 "value-entry.gob"
static void 
value_entry_init (ValueEntry * self)
#line 195 "value-entry.c"
{
#define __GOB_FUNCTION__ ":Value:Entry::init"
	self->_priv = g_new0 (ValueEntryPrivate, 1);
#line 28 "value-entry.gob"
	self->entry = NULL;
#line 201 "value-entry.c"
#line 28 "value-entry.gob"
	self->int_spinner = NULL;
#line 204 "value-entry.c"
#line 28 "value-entry.gob"
	self->float_spinner = NULL;
#line 207 "value-entry.c"
#line 28 "value-entry.gob"
	self->toggle = NULL;
#line 210 "value-entry.c"
#line 28 "value-entry.gob"
	self->pong_type = PONG_TYPE_INVALID;
#line 213 "value-entry.c"
#line 28 "value-entry.gob"
	self->_priv->inhibit_changed = FALSE;
#line 216 "value-entry.c"
 {
#line 53 "value-entry.gob"

		GtkAdjustment *adj;

		gtk_notebook_set_show_tabs (GTK_NOTEBOOK (self), FALSE);
		gtk_notebook_set_show_border (GTK_NOTEBOOK (self), FALSE);

		self->entry = gtk_entry_new ();
		gtk_widget_show (self->entry);
		gtk_notebook_append_page (GTK_NOTEBOOK (self),
					  self->entry,
					  NULL);
		gtk_signal_connect_object_while_alive
			(GTK_OBJECT (self->entry), "changed",
			 GTK_SIGNAL_FUNC (do_changed),
			 GTK_OBJECT (self));
		adj = (GtkAdjustment *) gtk_adjustment_new (0,
							    G_MININT, G_MAXINT,
							    1,
							    10,
							    0);
		self->int_spinner = gtk_spin_button_new (adj, 1.0, 0);
		gtk_widget_show (self->int_spinner);
		gtk_notebook_append_page (GTK_NOTEBOOK (self),
					  self->int_spinner,
					  NULL);
		gtk_spin_button_set_numeric
			(GTK_SPIN_BUTTON (self->int_spinner), TRUE);
		gtk_signal_connect_object_while_alive
			(GTK_OBJECT (self->int_spinner), "changed",
			 GTK_SIGNAL_FUNC (do_changed),
			 GTK_OBJECT (self));
							 
		/* hmm, this should be MINFLOAT and MAXFLOAT perhaps */
		adj = (GtkAdjustment *) gtk_adjustment_new (0,
							    G_MININT,
							    G_MAXINT,
							    0.1,
							    1.0,
							    0);
		self->float_spinner = gtk_spin_button_new (adj, 1.0, 5);
		gtk_widget_show (self->float_spinner);
		gtk_notebook_append_page (GTK_NOTEBOOK (self),
					  self->float_spinner,
					  NULL);
		/* strange that this doesn't work right for floats */
		gtk_spin_button_set_numeric
			(GTK_SPIN_BUTTON (self->float_spinner), TRUE);
		gtk_signal_connect_object_while_alive
			(GTK_OBJECT (self->float_spinner), "changed",
			 GTK_SIGNAL_FUNC (do_changed),
			 GTK_OBJECT (self));

		self->toggle = gtk_toggle_button_new_with_label (_("False"));
		gtk_widget_show (self->toggle);
		gtk_notebook_append_page (GTK_NOTEBOOK (self),
					  self->toggle,
					  NULL);
		gtk_signal_connect_object_while_alive
			(GTK_OBJECT (self->toggle), "toggled",
			 GTK_SIGNAL_FUNC (toggle_toggled),
			 GTK_OBJECT (self));
	
#line 281 "value-entry.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



#line 116 "value-entry.gob"
GtkWidget * 
value_entry_new (void)
{
#define __GOB_FUNCTION__ ":Value:Entry::new"
#line 295 "value-entry.c"
{
#line 119 "value-entry.gob"
	
		return (GtkWidget *)GET_NEW;
	}}
#line 301 "value-entry.c"
#undef __GOB_FUNCTION__

#line 123 "value-entry.gob"
static void 
value_entry_toggle_toggled (ValueEntry * self)
{
#define __GOB_FUNCTION__ ":Value:Entry::toggle_toggled"
#line 123 "value-entry.gob"
	g_return_if_fail (self != NULL);
#line 123 "value-entry.gob"
	g_return_if_fail (IS_VALUE_ENTRY (self));
#line 313 "value-entry.c"
{
#line 126 "value-entry.gob"
	
		GtkWidget *label = GTK_BIN (self->toggle)->child;

		if (GTK_TOGGLE_BUTTON (self->toggle)->active)
			gtk_label_set (GTK_LABEL (label), _("True"));
		else
			gtk_label_set (GTK_LABEL (label), _("False"));

		do_changed (self);
	}}
#line 326 "value-entry.c"
#undef __GOB_FUNCTION__

#line 137 "value-entry.gob"
void 
value_entry_changed (ValueEntry * self)
#line 332 "value-entry.c"
{
#line 137 "value-entry.gob"
	g_return_if_fail (self != NULL);
#line 137 "value-entry.gob"
	g_return_if_fail (IS_VALUE_ENTRY (self));
#line 338 "value-entry.c"
	gtk_signal_emit (GTK_OBJECT (self),
		object_signals[CHANGED_SIGNAL]);
}

#line 141 "value-entry.gob"
static void 
value_entry_do_changed (ValueEntry * self)
{
#define __GOB_FUNCTION__ ":Value:Entry::do_changed"
#line 141 "value-entry.gob"
	g_return_if_fail (self != NULL);
#line 141 "value-entry.gob"
	g_return_if_fail (IS_VALUE_ENTRY (self));
#line 352 "value-entry.c"
{
#line 144 "value-entry.gob"
	
		if ( ! self->_priv->inhibit_changed)
			changed (self);
	}}
#line 359 "value-entry.c"
#undef __GOB_FUNCTION__

#line 149 "value-entry.gob"
void 
value_entry_set_type (ValueEntry * self, PongType type)
{
#define __GOB_FUNCTION__ ":Value:Entry::set_type"
#line 149 "value-entry.gob"
	g_return_if_fail (self != NULL);
#line 149 "value-entry.gob"
	g_return_if_fail (IS_VALUE_ENTRY (self));
#line 371 "value-entry.c"
{
#line 152 "value-entry.gob"
	
		char * text;

		if (type == self->pong_type)
			return;

		text = get_text (self);

		if (type == PONG_TYPE_INT)
			gtk_notebook_set_page (GTK_NOTEBOOK (self),
					       INT_SPINNER_PAGE);
		else if (type == PONG_TYPE_FLOAT)
			gtk_notebook_set_page (GTK_NOTEBOOK (self),
					       FLOAT_SPINNER_PAGE);
		else if (type == PONG_TYPE_BOOL)
			gtk_notebook_set_page (GTK_NOTEBOOK (self),
					       TOGGLE_PAGE);
		else
			gtk_notebook_set_page (GTK_NOTEBOOK (self),
					       ENTRY_PAGE);

		self->pong_type = type;

		/* This is so that changing types does
		 * not mess up the value */
		self->_priv->inhibit_changed = TRUE;

		set_text (self, text);

		self->_priv->inhibit_changed = FALSE;

		g_free (text);

	}}
#line 408 "value-entry.c"
#undef __GOB_FUNCTION__

#line 187 "value-entry.gob"
char * 
value_entry_get_text (ValueEntry * self)
{
#define __GOB_FUNCTION__ ":Value:Entry::get_text"
#line 187 "value-entry.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 187 "value-entry.gob"
	g_return_val_if_fail (IS_VALUE_ENTRY (self), (char * )0);
#line 420 "value-entry.c"
{
#line 190 "value-entry.gob"
	
		char *ret = NULL;

		if (self->pong_type == PONG_TYPE_INT) {
			int val = gtk_spin_button_get_value_as_int
				(GTK_SPIN_BUTTON (self->int_spinner));

			ret = g_strdup_printf ("%d", val);
		} else if (self->pong_type == PONG_TYPE_FLOAT) {
			double val = gtk_spin_button_get_value_as_float
				(GTK_SPIN_BUTTON (self->float_spinner));

			ret = g_strdup_printf ("%g", val);
		} else if (self->pong_type == PONG_TYPE_BOOL) {
			/* Do not translate the "True" and "False" here */
			if (GTK_TOGGLE_BUTTON (self->toggle)->active)
				ret = g_strdup ("True");
			else
				ret = g_strdup ("False");
		} else {
			char *text;

			text = gtk_entry_get_text (GTK_ENTRY (self->entry));
			ret = g_strdup (pong_sure_string (text));
		}

		return ret;
	}}
#line 451 "value-entry.c"
#undef __GOB_FUNCTION__

#line 219 "value-entry.gob"
void 
value_entry_set_text (ValueEntry * self, const char * text)
{
#define __GOB_FUNCTION__ ":Value:Entry::set_text"
#line 219 "value-entry.gob"
	g_return_if_fail (self != NULL);
#line 219 "value-entry.gob"
	g_return_if_fail (IS_VALUE_ENTRY (self));
#line 463 "value-entry.c"
{
#line 222 "value-entry.gob"
	
		if (self->pong_type == PONG_TYPE_INT) {
			gtk_spin_button_set_value
				(GTK_SPIN_BUTTON (self->int_spinner),
				 atol (text));
		} else if (self->pong_type == PONG_TYPE_FLOAT) {
			gtk_spin_button_set_value
				(GTK_SPIN_BUTTON (self->float_spinner),
				 atof (text));
		} else if (self->pong_type == PONG_TYPE_BOOL) {
			gtk_toggle_button_set_active
				(GTK_TOGGLE_BUTTON (self->toggle),
				 pong_bool_from_string (text));
		} else {
			gtk_entry_set_text (GTK_ENTRY (self->entry), text);
		}
	}}
#line 483 "value-entry.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___value_entry_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))toggle_toggled)();
	((void (*)(void))changed)();
	((void (*)(void))do_changed)();
	((void (*)(void))set_type)();
	((void (*)(void))get_text)();
	((void (*)(void))set_text)();
	___value_entry_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

