#include "bibtex.h"

void print_all (gpointer key,
		gpointer data,
		gpointer user)
{
  printf ("%s = %s\n", (char *) key, (char *) data);
}

main (int argc, char * argv [])
{
  bibtex_entry * entry;
  bibtex_file * file;
  char * tmp;
  
  file = bibtex_open (argv [1]);

  if (file == NULL) {
    printf ("cant open\n");
    exit (0);
  }

  file->debug = 0;

  while (entry = bibtex_next_entry (file)) {

    if (entry->type)
      printf ("type= %s\n", entry->type);
    if (entry->name)
      printf ("name= %s\n", entry->name);

    g_hash_table_foreach (entry->table, print_all, NULL);
    bibtex_free_entry (entry);

    printf ("\n");
  }

  
  if (file->eof) 
    printf ("at end of file\n");
  else
    printf ("at error !\n");

  bibtex_close (file);

  g_mem_profile ();
}
