/*
 This file is part of pybliographer
 
 Copyright (C) 1998 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: bibtexparser.c,v 1.1 1998/11/11 13:45:32 gobry Exp $
*/

#include "Python.h"
#include "bibtex.h"

static void bibtex_py_close (void * pointer)
{
  bibtex_close ((bibtex_file *) pointer);
}

static PyObject *
bib_open (PyObject * self, PyObject * args)
{
  char * name;
  bibtex_file * file;

  if (! PyArg_ParseTuple(args, "s", & name))
    return NULL;
 
  file = bibtex_open (name);
  if (file == NULL) {
    PyErr_SetString (PyExc_IOError, "can't open file");
    return NULL;
  }
  
  return PyCObject_FromVoidPtr (file, bibtex_py_close);
}

static void fill_dico (gpointer key, gpointer value, gpointer user)
{
  PyObject * dico = (PyObject *) user;
  PyObject * tmp1, * tmp2;

  tmp1 = PyString_FromString ((char *) key);
  tmp2 = PyString_FromString ((char *) value);

  PyDict_SetItem (dico, tmp1, tmp2);

  Py_DECREF (tmp1);
  Py_DECREF (tmp2);
}

static PyObject *
bib_next (PyObject * self, PyObject * args)
{
  bibtex_entry * ent;
  bibtex_file * file;
  PyObject * dico, * tmp, * tmp2;

  if (! PyArg_ParseTuple(args, "O", & file))
    return NULL;

  file = (bibtex_file *) PyCObject_AsVoidPtr ((gpointer) file);

  ent = bibtex_next_entry (file);

  if (ent == NULL) {
    if (file->eof) {
      Py_INCREF(Py_None);
      return Py_None;
    }
    PyErr_SetString (PyExc_IOError, "parser can't read data");

    return NULL;
  }

  /* Creer le dico */
  
  dico = PyDict_New (); 

  g_hash_table_foreach (ent->table, fill_dico, dico);
  
  if (ent->name) {
    tmp = PyString_FromString ((char *) ent->name);
    tmp2 = PyString_FromString (" name ");
    PyDict_SetItem (dico, tmp2, tmp);
    Py_DECREF (tmp);
    Py_DECREF (tmp2);
  }
  
  if (ent->type) {
    tmp = PyString_FromString ((char *) ent->type);
    tmp2 = PyString_FromString (" type ");
    PyDict_SetItem (dico, tmp2, tmp);
    Py_DECREF (tmp);
    Py_DECREF (tmp2);
  }

  tmp = PyInt_FromLong ((long) ent->offset);
  tmp2 = PyString_FromString (" offset ");
  PyDict_SetItem (dico, tmp2, tmp);
  Py_DECREF (tmp);
  Py_DECREF (tmp2);
  
  tmp = PyInt_FromLong ((long) ent->length);
  tmp2 = PyString_FromString (" length ");
  PyDict_SetItem (dico, tmp2, tmp);
  Py_DECREF (tmp);
  Py_DECREF (tmp2);
    
  tmp = PyString_FromString ((char *) ent->body);
  tmp2 = PyString_FromString (" body ");
  PyDict_SetItem (dico, tmp2, tmp);
  Py_DECREF (tmp);
  Py_DECREF (tmp2);

  bibtex_free_entry (ent);

  return dico;
}

static PyObject *
bib_first (PyObject * self, PyObject * args)
{
  bibtex_entry * ent;
  bibtex_file * file;

  if (! PyArg_ParseTuple(args, "O", & file))
    return NULL;

  file = (bibtex_file *) PyCObject_AsVoidPtr ((gpointer) file);
  bibtex_first_entry (file);

  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
bib_offset (PyObject * self, PyObject * args)
{
  bibtex_entry * ent;
  bibtex_file * file;
  gint offset;

  if (! PyArg_ParseTuple(args, "Oi", & file, & offset))
    return NULL;

  file = (bibtex_file *) PyCObject_AsVoidPtr ((gpointer) file);
  bibtex_offset_entry (file, offset);

  if (file->error) {
    PyErr_SetString (PyExc_IOError, "parser can't reach position");
    return NULL;
  }
  
  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef bibtexMeth [] = {
  { "open", bib_open, METH_VARARGS },
  { "next", bib_next, METH_VARARGS },
  { "first", bib_first, METH_VARARGS },
  { "offset", bib_offset, METH_VARARGS },
  {NULL, NULL, 0},
};

void initbibtex ()
{
  (void) Py_InitModule("bibtex", bibtexMeth);
}

