# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: alpha.py,v 1.1 1999/09/24 07:20:16 gobry Exp $


""" This module implements the alpha style """

import string

from Pyblio import Autoload
from Pyblio.Style import Utils

def writer (id, fmt, database):

    fmt.start_group (id)

    def write_one (entry, fmt, key_table):

        key =  key_table [entry.name]
        
        # --------------------------------------------------
        # Write key
        # --------------------------------------------------
        fmt.start (key = key, entry = entry)


        # ---------- Author ----------
        if entry.has_key ('author'):
            group = entry ['author']
            text  = Utils.author_desc (group, fmt.coding)
            
            if text:
                fmt.write (text)
                fmt.write (".")
                
        # ---------- Title ----------
        if entry.has_key ('title'):
            fmt.separator ()
            fmt.write (entry ['title'].format (fmt.coding))
            
            fmt.write (".")

        # ---------- In Book/Proceedings ----------
        if entry.has_key ('booktitle'):
            fmt.separator ()
            fmt.write ("In ")
            fmt.write (entry ['booktitle'].format (fmt.coding),
                       'emph')

            fmt.write (".")

        # --------------------------------------------------
        fmt.end ()
        return

    # sort keys...
    key_list = Utils.sort_database (database)
    
    # generate output keys
    key_table = Utils.generate_key (database, fmt)
        
    # write all the entries in the database
    for key in key_list:
        entry = database [key]
        write_one (entry, fmt, key_table)

    fmt.end_group ()
    return


Autoload.register ('style', 'Alpha', writer)
