/*
 * Scaffold sample plugin
 *
 * Demonstrates the basics of how to write a plugin for Scaffold.
 */

#include <config.h>

#include <bonobo/bonobo-ui-component.h>

#include <libscaffold/scaffold-tool.h>
#include <libscaffold/glue-plugin.h>

gpointer parent_class;

typedef struct {
	ScaffoldTool parent;
} SampleTool;

typedef struct {
	ScaffoldToolClass parent;
} SampleToolClass;

/*
 * Insert the text "Hello, World!" in the current document
 */
static void
hello_world (GtkWidget *widget, gpointer data)
{
	ScaffoldTool *tool = SCAFFOLD_TOOL (data);

	scaffold_insert_text_at_cursor (tool, "Hello, world!\n");
}

static BonoboUIVerb verbs[] = {
	BONOBO_UI_UNSAFE_VERB ("HelloWorld", hello_world),
	BONOBO_UI_VERB_END
};

static void
shell_set (ScaffoldTool *tool)
{
	scaffold_tool_merge_ui (tool,
			      "scaffold-sample-tool",
			      SCAFFOLD_DATADIR,
			      "scaffold-sample-plugin.xml",
			      verbs,
			      tool);
}

static void
dispose (GObject *obj)
{
	scaffold_tool_unmerge_ui (SCAFFOLD_TOOL (obj));
}

static void
sample_tool_instance_init (GObject *object)
{
}

static void
sample_tool_class_init (GObjectClass *klass) 
{
	ScaffoldToolClass *tool_class = SCAFFOLD_TOOL_CLASS (klass);
	
	parent_class = g_type_class_peek_parent (klass);

	tool_class->shell_set = shell_set;
	klass->dispose = dispose;
}

SCAFFOLD_TOOL_BOILERPLATE (SampleTool, sample_tool);

SCAFFOLD_SIMPLE_PLUGIN (SampleTool, sample_tool);
