/* Siobhan Audio Player
 *
 * (c) 2005 Ariel Rios <ariel@gnu.org>
 *
 * callback.c: program callbacks
 *
 * This file is part of Siobhan Audio Player.
 *
 *   Siobhan is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Siobhan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <gst/gst.h>
#include <gtk/gtk.h>

#include "callback.h"
#include "timer.h"

void 
eos (GstElement *src, gpointer data) 
{
  GstElement *thread = GST_ELEMENT (data);

  g_print ("have eos, quitting\n");

  gst_element_set_state (GST_ELEMENT (thread), GST_STATE_NULL);
}



void
cb_play (GtkWidget *widget, gpointer data)
{

  CallBackData *cbd = (CallBackData *) data;
  GstElement *thread = cbd->thread;
  GstElement *filesrc = cbd->filesrc;

  gchar *playfile;

  g_object_get (G_OBJECT (filesrc), "location", &playfile, NULL);
  
  /*
    g_print (playfile);
  */
	if (playfile == NULL)
		return;

	if (gst_element_get_state (thread) != GST_STATE_PLAYING){
		gst_element_set_state (thread, GST_STATE_PLAYING);
		
	}
}



void
cb_stop (GtkWidget *widget, gpointer data)
{

  
  GstElement *thread = GST_ELEMENT (data);

  if (gst_element_get_state (GST_ELEMENT (thread)) != GST_STATE_NULL){
    gst_element_set_state (GST_ELEMENT (thread), GST_STATE_NULL);

  }
}


void 
cb_pause (GtkWidget *widget, gpointer data)
{

    GstElement *thread = GST_ELEMENT (data);

	switch (gst_element_get_state (thread))
	{
		case GST_STATE_PLAYING:
		  g_print ("'twas playing, now paus'd \n");
		  gst_element_set_state (thread, GST_STATE_PAUSED);
			break;
		case GST_STATE_PAUSED:
		  g_print ("'twas paus'd, now playin' \n");
		  gst_element_set_state (thread, GST_STATE_PLAYING);
		  break;
		default:
			g_print ("other \n");
			break;
	}
}



void
cb_properties (GtkWidget *widget, gpointer data)
{
  
}

 
void 
select_song (const gchar *filename, GstElement *filesrc)
{
	g_object_set (G_OBJECT (filesrc), "location", filename, NULL);
}


void 
cb_choose (GtkWidget *widget, gpointer data)
{
	GtkWidget *selection;
	const gchar *filename;
	CallBackData *cbd = (CallBackData *) data;

	GstElement *filesrc = cbd->filesrc;
	
	selection = gtk_file_selection_new ("Open File");
	
	
	if (gtk_dialog_run (GTK_DIALOG (selection)) == GTK_RESPONSE_OK)
	{
	  filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION (selection));
	  
	  select_song (filename, filesrc);
	}

	gtk_widget_destroy (selection);
	
	return;
	
}

gboolean
cb_iterate (gpointer data)
{


  CallBackData *cbd = (CallBackData *) data;
  GstPlayerTimer *slider = GST_PLAYER_TIMER (cbd->widget);
  GstElement *filesrc = cbd->filesrc;


  gint64 len, pos;
  GstFormat fmt = GST_FORMAT_TIME;

  /*
  if (gst_element_query (decoder, GST_QUERY_POSITION, &fmt, &pos) && gst_element_query (decoder, GST_QUERY_TOTAL, &fmt, &len)){
    g_print  ("\nTime %" GST_TIME_FORMAT " / %" GST_TIME_FORMAT " \r", 
	      GST_TIME_ARGS (pos), GST_TIME_ARGS (len));
	      }                                                                                                                                                          
  */

  g_usleep (100);                                                                                                                                                          

  if (gst_element_get_state (filesrc) == GST_STATE_PLAYING)

    gst_player_timer_progress (slider);

  
  return TRUE;
}
