/* tracker-sparql-expression.c generated by valac 0.13.4.8-6faa4, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-db-interface-sqlite.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-collation.h>
#include <libtracker-data/tracker-ontologies.h>


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	TrackerSparqlQuery* _tmp0_;
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
#line 30 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = query;
#line 30 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->query = _tmp0_;
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self;
#line 500 "tracker-sparql-expression.c"
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
#line 507 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 41 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_next (_tmp0_, &_inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 533 "tracker-sparql-expression.c"
		} else {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 541 "tracker-sparql-expression.c"
		}
	}
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 548 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 45 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 566 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 49 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_last (_tmp0_);
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 584 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 53 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_accept (_tmp0_, _tmp1_, &_inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 613 "tracker-sparql-expression.c"
		} else {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 621 "tracker-sparql-expression.c"
		}
	}
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 628 "tracker-sparql-expression.c"
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_ = NULL;
#line 57 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = msg;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 651 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 61 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_expect (_tmp0_, _tmp1_, &_inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 680 "tracker-sparql-expression.c"
		} else {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 688 "tracker-sparql-expression.c"
		}
	}
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 695 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
#line 65 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = strip;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 716 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
#line 69 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = literal;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "'", 0);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_strjoinv ("''", _tmp3_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = _tmp4_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = g_strdup_printf ("'%s'", _tmp5_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = _tmp6_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp5_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp7_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 759 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	TrackerPropertyType _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
#line 73 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = TRUE;
#line 782 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp5_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp5_ == TRACKER_PROPERTY_TYPE_DOUBLE;
#line 789 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp3_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp6_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = TRUE;
#line 797 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp7_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = _tmp7_ == TRACKER_PROPERTY_TYPE_DATE;
#line 804 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp2_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = TRUE;
#line 812 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp9_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = _tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME;
#line 819 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp1_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 827 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp11_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = _tmp11_ == TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 834 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp12_ = _tmp0_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp12_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 842 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	GString* _tmp0_;
#line 77 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 78 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 78 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append_printf (_tmp0_, " COLLATE %s", TRACKER_COLLATION_NAME);
#line 856 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 81 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 874 "tracker-sparql-expression.c"
		} else {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 882 "tracker-sparql-expression.c"
		}
	}
#line 83 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 887 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 895 "tracker-sparql-expression.c"
			{
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 907 "tracker-sparql-expression.c"
					} else {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 915 "tracker-sparql-expression.c"
					}
				}
#line 88 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 920 "tracker-sparql-expression.c"
			}
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 926 "tracker-sparql-expression.c"
			{
#line 91 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 930 "tracker-sparql-expression.c"
			}
			default:
			{
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 944 "tracker-sparql-expression.c"
					} else {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 952 "tracker-sparql-expression.c"
					}
				}
#line 94 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 957 "tracker-sparql-expression.c"
			}
		}
#line 96 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 962 "tracker-sparql-expression.c"
	}
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 974 "tracker-sparql-expression.c"
		} else {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 982 "tracker-sparql-expression.c"
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 994 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1002 "tracker-sparql-expression.c"
			{
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1014 "tracker-sparql-expression.c"
					} else {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1022 "tracker-sparql-expression.c"
					}
				}
#line 106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1027 "tracker-sparql-expression.c"
			}
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1045 "tracker-sparql-expression.c"
			{
#line 115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 1049 "tracker-sparql-expression.c"
			}
			default:
			{
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1063 "tracker-sparql-expression.c"
					} else {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1071 "tracker-sparql-expression.c"
					}
				}
#line 118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1076 "tracker-sparql-expression.c"
			}
		}
#line 120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 1081 "tracker-sparql-expression.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1297 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1297 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1297 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1297 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1298 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1298 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1105 "tracker-sparql-expression.c"
		glong _tmp4_;
#line 1299 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1299 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1299 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1113 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1125 "tracker-sparql-expression.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1308 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1150 "tracker-sparql-expression.c"
		glong _tmp2_;
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1156 "tracker-sparql-expression.c"
	} else {
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1160 "tracker-sparql-expression.c"
	}
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1310 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1166 "tracker-sparql-expression.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1178 "tracker-sparql-expression.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1188 "tracker-sparql-expression.c"
	}
#line 1317 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1317 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1194 "tracker-sparql-expression.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1319 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1208 "tracker-sparql-expression.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1218 "tracker-sparql-expression.c"
	}
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1224 "tracker-sparql-expression.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1324 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1324 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1233 "tracker-sparql-expression.c"
	}
#line 1326 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1326 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1326 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1326 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1253 "tracker-sparql-expression.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 1260 "tracker-sparql-expression.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1271 "tracker-sparql-expression.c"
	}
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1277 "tracker-sparql-expression.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1288 "tracker-sparql-expression.c"
	}
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1294 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp2_ = 0;
	gboolean _tmp26_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_;
	TrackerSparqlVariable* _tmp67_;
	GError * _inner_error_ = NULL;
#line 124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	variable = NULL;
#line 127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_current (self);
#line 129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 1329 "tracker-sparql-expression.c"
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		TrackerSparqlVariable* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariableBinding* _tmp15_;
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1359 "tracker-sparql-expression.c"
			} else {
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1369 "tracker-sparql-expression.c"
			}
		}
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = _tmp5_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_context_get_variable (_tmp7_, _tmp11_);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp13_;
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp11_);
#line 132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp9_);
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = variable;
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp14_->binding;
#line 134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ == NULL) {
#line 1404 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			GError* _tmp21_ = NULL;
			GError* _tmp22_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = variable;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_variable_get_name (_tmp16_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = g_strdup_printf ("use of undefined variable `%s'", _tmp18_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_get_error (self, _tmp20_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp20_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp22_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1438 "tracker-sparql-expression.c"
			} else {
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1448 "tracker-sparql-expression.c"
			}
		}
	} else {
		GString* _tmp23_;
		TrackerPropertyType _tmp24_ = 0;
		TrackerPropertyType _tmp25_;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = sql;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp24_ = tracker_sparql_expression_translate_expression (self, _tmp23_, &_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp25_ = _tmp24_;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1471 "tracker-sparql-expression.c"
			} else {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1481 "tracker-sparql-expression.c"
			}
		}
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = _tmp25_;
#line 1486 "tracker-sparql-expression.c"
	}
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp26_ = subquery;
#line 141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp26_) {
#line 1492 "tracker-sparql-expression.c"
		GString* _tmp27_;
		TrackerPropertyType _tmp28_;
		glong _tmp29_;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp27_ = sql;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp28_ = type;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp29_ = begin;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_convert_expression_to_string (_tmp27_, _tmp28_, _tmp29_);
#line 1504 "tracker-sparql-expression.c"
	}
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp30_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp31_ = _tmp30_;
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1520 "tracker-sparql-expression.c"
		} else {
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1530 "tracker-sparql-expression.c"
		}
	}
#line 145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp31_) {
#line 1535 "tracker-sparql-expression.c"
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_;
		GString* _tmp48_;
		TrackerSparqlVariable* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp32_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1557 "tracker-sparql-expression.c"
			} else {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1567 "tracker-sparql-expression.c"
			}
		}
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp33_) {
#line 1572 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp34_;
			TrackerSparqlContext* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			TrackerSparqlVariable* _tmp38_ = NULL;
			TrackerSparqlVariable* _tmp39_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = tracker_sparql_expression_get_context (self);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = _tmp34_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp36_ = tracker_sparql_expression_get_last_string (self, 0);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = _tmp36_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp38_ = tracker_sparql_context_get_variable (_tmp35_, _tmp37_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = _g_object_ref0 (_tmp38_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp39_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp37_);
#line 1597 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlContext* _tmp40_;
			TrackerSparqlContext* _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_;
			TrackerSparqlVariable* _tmp46_ = NULL;
			TrackerSparqlVariable* _tmp47_;
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1619 "tracker-sparql-expression.c"
				} else {
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1629 "tracker-sparql-expression.c"
				}
			}
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp40_ = tracker_sparql_expression_get_context (self);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = _tmp40_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp42_ = tracker_sparql_expression_get_last_string (self, 0);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp43_ = _tmp42_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp44_ = string_substring (_tmp43_, (glong) 1, (glong) (-1));
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp45_ = _tmp44_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp46_ = tracker_sparql_context_get_variable (_tmp41_, _tmp45_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp47_ = _g_object_ref0 (_tmp46_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp47_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp45_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp43_);
#line 1656 "tracker-sparql-expression.c"
		}
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = sql;
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp49_ = variable;
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp50_ = tracker_sparql_variable_get_sql_expression (_tmp49_);
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp51_ = _tmp50_;
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append_printf (_tmp48_, " AS %s", _tmp51_);
#line 158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp52_ = subquery;
#line 158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp52_) {
#line 1672 "tracker-sparql-expression.c"
			TrackerSparqlVariableBinding* _tmp53_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp54_;
			TrackerPropertyType _tmp55_;
			TrackerSparqlVariableBinding* _tmp56_;
			TrackerSparqlVariable* _tmp57_;
			TrackerSparqlVariableBinding* _tmp58_;
			TrackerSparqlVariable* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			TrackerSparqlPattern* _tmp62_;
			TrackerSparqlPattern* _tmp63_;
			GString* _tmp64_;
			GString* _tmp65_;
			TrackerSparqlVariableBinding* _tmp66_;
#line 159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = tracker_sparql_variable_binding_new ();
#line 159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp53_;
#line 160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = binding;
#line 160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = type;
#line 160 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) _tmp54_)->data_type = _tmp55_;
#line 161 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = binding;
#line 161 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = variable;
#line 161 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_->variable = _tmp57_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = binding;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = variable;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp60_ = tracker_sparql_variable_get_sql_expression (_tmp59_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = _tmp60_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp58_, _tmp61_);
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_expression_get_pattern (self);
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp63_ = _tmp62_;
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp64_ = g_string_new ("");
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp65_ = _tmp64_;
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp66_ = binding;
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_pattern_add_variable_binding (_tmp63_, _tmp65_, _tmp66_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (_tmp65_);
#line 158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 1730 "tracker-sparql-expression.c"
		}
	}
#line 167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp67_ = variable;
#line 167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp67_ != NULL) {
#line 1737 "tracker-sparql-expression.c"
		TrackerSparqlContext* _tmp68_;
		TrackerSparqlContext* _tmp69_;
		GHashTable* _tmp70_;
		TrackerSparqlVariable* _tmp71_;
		gconstpointer _tmp72_ = NULL;
		gint state;
		gint _tmp73_;
		TrackerSparqlContext* _tmp74_;
		TrackerSparqlContext* _tmp75_;
		GHashTable* _tmp76_;
		TrackerSparqlVariable* _tmp77_;
		TrackerSparqlVariable* _tmp78_;
		gint _tmp79_;
		TrackerSparqlContext* _tmp80_;
		TrackerSparqlContext* _tmp81_;
		TrackerSparqlContext* _tmp82_;
		TrackerSparqlContext* _tmp83_;
		gchar** _tmp84_;
		gint _tmp84__length1;
		TrackerSparqlVariable* _tmp85_;
		const gchar* _tmp86_;
		const gchar* _tmp87_;
		gchar* _tmp88_;
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp68_ = tracker_sparql_expression_get_context (self);
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp69_ = _tmp68_;
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp70_ = _tmp69_->var_set;
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp71_ = variable;
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp72_ = g_hash_table_lookup (_tmp70_, _tmp71_);
#line 168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		state = GPOINTER_TO_INT (_tmp72_);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp73_ = state;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp73_ == 0) {
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 1779 "tracker-sparql-expression.c"
		}
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp74_ = tracker_sparql_expression_get_context (self);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp75_ = _tmp74_;
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp76_ = _tmp75_->select_var_set;
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp77_ = variable;
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp78_ = _g_object_ref0 (_tmp77_);
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp79_ = state;
#line 172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_hash_table_insert (_tmp76_, _tmp78_, GINT_TO_POINTER (_tmp79_));
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp80_ = tracker_sparql_expression_get_context (self);
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp81_ = _tmp80_;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp82_ = tracker_sparql_expression_get_context (self);
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp83_ = _tmp82_;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp84_ = TRACKER_SPARQL_SELECT_CONTEXT (_tmp83_)->variable_names;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp84__length1 = TRACKER_SPARQL_SELECT_CONTEXT (_tmp83_)->variable_names_length1;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp85_ = variable;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp86_ = tracker_sparql_variable_get_name (_tmp85_);
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp87_ = _tmp86_;
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp88_ = g_strdup (_tmp87_);
#line 174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add1 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp81_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp81_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp81_)->_variable_names_size_, _tmp88_);
#line 1817 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlContext* _tmp89_;
		TrackerSparqlContext* _tmp90_;
		TrackerSparqlContext* _tmp91_;
		TrackerSparqlContext* _tmp92_;
		gchar** _tmp93_;
		gint _tmp93__length1;
		gint _tmp94_;
		gchar* _tmp95_ = NULL;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp89_ = tracker_sparql_expression_get_context (self);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp90_ = _tmp89_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp91_ = tracker_sparql_expression_get_context (self);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp92_ = _tmp91_;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp93_ = TRACKER_SPARQL_SELECT_CONTEXT (_tmp92_)->variable_names;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp93__length1 = TRACKER_SPARQL_SELECT_CONTEXT (_tmp92_)->variable_names_length1;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp94_ = variable_index;
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp95_ = g_strdup_printf ("var%d", _tmp94_ + 1);
#line 176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add2 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp90_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp90_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp90_)->_variable_names_size_, _tmp95_);
#line 1845 "tracker-sparql-expression.c"
	}
#line 179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (variable);
#line 179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 1853 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType _tmp4_;
	GError * _inner_error_ = NULL;
#line 182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_expression (self, _tmp2_, &_inner_error_);
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1889 "tracker-sparql-expression.c"
		} else {
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1897 "tracker-sparql-expression.c"
		}
	}
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 1902 "tracker-sparql-expression.c"
		GString* _tmp5_;
		GString* _tmp6_;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp5_, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 1913 "tracker-sparql-expression.c"
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1938 "tracker-sparql-expression.c"
		} else {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1946 "tracker-sparql-expression.c"
		}
	}
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 1951 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp2_, &_inner_error_);
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 1966 "tracker-sparql-expression.c"
			} else {
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 1974 "tracker-sparql-expression.c"
			}
		}
#line 194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp3_, " ASC");
#line 1981 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 1997 "tracker-sparql-expression.c"
			} else {
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2005 "tracker-sparql-expression.c"
			}
		}
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 2010 "tracker-sparql-expression.c"
			GString* _tmp6_;
			GString* _tmp7_;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp6_, &_inner_error_);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2025 "tracker-sparql-expression.c"
				} else {
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2033 "tracker-sparql-expression.c"
				}
			}
#line 197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp7_, " DESC");
#line 2040 "tracker-sparql-expression.c"
		} else {
			GString* _tmp8_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = sql;
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp8_, &_inner_error_);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2055 "tracker-sparql-expression.c"
				} else {
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2063 "tracker-sparql-expression.c"
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GError * _inner_error_ = NULL;
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2090 "tracker-sparql-expression.c"
		} else {
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2098 "tracker-sparql-expression.c"
		}
	}
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2111 "tracker-sparql-expression.c"
		} else {
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2119 "tracker-sparql-expression.c"
		}
	}
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2138 "tracker-sparql-expression.c"
		} else {
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2146 "tracker-sparql-expression.c"
		}
	}
#line 208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IS NOT NULL)");
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2163 "tracker-sparql-expression.c"
		} else {
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 209 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2171 "tracker-sparql-expression.c"
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType type;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GError * _inner_error_ = NULL;
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error_);
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2203 "tracker-sparql-expression.c"
		} else {
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2211 "tracker-sparql-expression.c"
		}
	}
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2224 "tracker-sparql-expression.c"
		} else {
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2232 "tracker-sparql-expression.c"
		}
	}
#line 217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(CASE ");
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2251 "tracker-sparql-expression.c"
		} else {
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2259 "tracker-sparql-expression.c"
		}
	}
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " WHEN 1 THEN ");
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2276 "tracker-sparql-expression.c"
		} else {
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2284 "tracker-sparql-expression.c"
		}
	}
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = _tmp4_;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2301 "tracker-sparql-expression.c"
		} else {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2309 "tracker-sparql-expression.c"
		}
	}
#line 226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 226 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, " WHEN 0 THEN ");
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2326 "tracker-sparql-expression.c"
		} else {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2334 "tracker-sparql-expression.c"
		}
	}
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2349 "tracker-sparql-expression.c"
		} else {
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2357 "tracker-sparql-expression.c"
		}
	}
#line 230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = sql;
#line 230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp7_, " ELSE NULL END)");
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2374 "tracker-sparql-expression.c"
		} else {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2382 "tracker-sparql-expression.c"
		}
	}
#line 234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2389 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2422 "tracker-sparql-expression.c"
		} else {
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 238 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2430 "tracker-sparql-expression.c"
		}
	}
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2443 "tracker-sparql-expression.c"
		} else {
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2451 "tracker-sparql-expression.c"
		}
	}
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "SparqlRegex(");
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2470 "tracker-sparql-expression.c"
		} else {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2478 "tracker-sparql-expression.c"
		}
	}
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, ", ");
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2495 "tracker-sparql-expression.c"
		} else {
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 243 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2503 "tracker-sparql-expression.c"
		}
	}
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2518 "tracker-sparql-expression.c"
		} else {
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2526 "tracker-sparql-expression.c"
		}
	}
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp4_;
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp6_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, _tmp8_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp8_);
#line 247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp6_);
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 248 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp9_, ", ");
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp11_ = _tmp10_;
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2559 "tracker-sparql-expression.c"
		} else {
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2567 "tracker-sparql-expression.c"
		}
	}
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp11_) {
#line 2572 "tracker-sparql-expression.c"
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GString* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2591 "tracker-sparql-expression.c"
			} else {
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2599 "tracker-sparql-expression.c"
			}
		}
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp13_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp15_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = _tmp16_;
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp17_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp15_);
#line 2616 "tracker-sparql-expression.c"
	} else {
		GString* _tmp18_;
#line 254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = sql;
#line 254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp18_, "''");
#line 2623 "tracker-sparql-expression.c"
	}
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2639 "tracker-sparql-expression.c"
		} else {
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2647 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
	TrackerSparqlPattern* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GError * _inner_error_ = NULL;
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_get_pattern (self);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_pattern_translate_exists (_tmp2_, _tmp3_, &_inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2684 "tracker-sparql-expression.c"
		} else {
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2692 "tracker-sparql-expression.c"
		}
	}
#line 263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp4_, ")");
#line 2699 "tracker-sparql-expression.c"
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_;
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (expression != NULL);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = expression;
#line 268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = type;
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_convert_expression_to_string (_tmp4_, _tmp5_, begin);
#line 2733 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	TrackerPropertyType _tmp0_;
#line 272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = type;
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_STRING:
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_INTEGER:
#line 2749 "tracker-sparql-expression.c"
		{
#line 279 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2753 "tracker-sparql-expression.c"
		}
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_RESOURCE:
#line 2757 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			glong _tmp2_;
			GString* _tmp3_;
#line 282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = begin;
#line 282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp1_, (gssize) _tmp2_, "(SELECT Uri FROM Resource WHERE ID = ");
#line 283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, ")");
#line 284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2774 "tracker-sparql-expression.c"
		}
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 2778 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			glong _tmp5_;
			GString* _tmp6_;
#line 287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = begin;
#line 287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp4_, (gssize) _tmp5_, "CASE ");
#line 288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp6_, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2795 "tracker-sparql-expression.c"
		}
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATE:
#line 2799 "tracker-sparql-expression.c"
		{
			GString* _tmp7_;
			glong _tmp8_;
			GString* _tmp9_;
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = begin;
#line 292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp7_, (gssize) _tmp8_, "strftime (\"%Y-%m-%d\", ");
#line 293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", \"unixepoch\")");
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2816 "tracker-sparql-expression.c"
		}
#line 273 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATETIME:
#line 2820 "tracker-sparql-expression.c"
		{
			GString* _tmp10_;
			glong _tmp11_;
			GString* _tmp12_;
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = begin;
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp10_, (gssize) _tmp11_, "strftime (\"%Y-%m-%dT%H:%M:%SZ\", ");
#line 298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp12_, ", \"unixepoch\")");
#line 299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2837 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp13_;
			glong _tmp14_;
			GString* _tmp15_;
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = sql;
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = begin;
#line 302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp13_, (gssize) _tmp14_, "CAST (");
#line 303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = sql;
#line 303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp15_, " AS TEXT)");
#line 304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2856 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 2879 "tracker-sparql-expression.c"
		{
			TrackerSparqlLiteralBinding* _tmp1_;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_;
			TrackerSparqlPattern* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerSparqlLiteralBinding* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
#line 314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_literal_binding_new ();
#line 314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp1_;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_pattern_parse_var_or_term (_tmp3_, NULL, &_tmp4_, &_inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			is_var = _tmp4_;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2916 "tracker-sparql-expression.c"
				} else {
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2926 "tracker-sparql-expression.c"
				}
			}
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = binding;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp7_->literal);
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_->literal = _tmp6_;
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2949 "tracker-sparql-expression.c"
				} else {
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2959 "tracker-sparql-expression.c"
				}
			}
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp9_) {
#line 2964 "tracker-sparql-expression.c"
				GString* _tmp10_;
				gssize _tmp11_;
				glong begin;
				GString* _tmp12_;
				TrackerSparqlLiteralBinding* _tmp13_;
				const gchar* _tmp14_;
				TrackerPropertyType _tmp15_ = 0;
				TrackerPropertyType type;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_;
				glong _tmp18_;
#line 319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = sql;
#line 319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = _tmp10_->len;
#line 319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				begin = (glong) _tmp11_;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = sql;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = binding;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = _tmp13_->literal;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = tracker_sparql_expression_translate_function (self, _tmp12_, _tmp14_, &_inner_error_);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp15_;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3002 "tracker-sparql-expression.c"
					} else {
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3012 "tracker-sparql-expression.c"
					}
				}
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3027 "tracker-sparql-expression.c"
					} else {
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3037 "tracker-sparql-expression.c"
					}
				}
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = type;
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = begin;
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_convert_expression_to_string (_tmp16_, _tmp17_, _tmp18_);
#line 3048 "tracker-sparql-expression.c"
			} else {
				GString* _tmp19_;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = sql;
#line 324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp19_, "?");
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 3066 "tracker-sparql-expression.c"
			}
#line 327 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 327 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3072 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp23_;
			gssize _tmp24_;
			glong begin;
			GString* _tmp25_;
			TrackerPropertyType _tmp26_ = 0;
			TrackerPropertyType type;
			GString* _tmp27_;
			TrackerPropertyType _tmp28_;
			glong _tmp29_;
#line 329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = sql;
#line 329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_->len;
#line 329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			begin = (glong) _tmp24_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = sql;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_translate_expression (self, _tmp25_, &_inner_error_);
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp26_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3105 "tracker-sparql-expression.c"
				} else {
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3113 "tracker-sparql-expression.c"
				}
			}
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = sql;
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = type;
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = begin;
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_convert_expression_to_string (_tmp27_, _tmp28_, _tmp29_);
#line 332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3126 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GError * _inner_error_ = NULL;
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3149 "tracker-sparql-expression.c"
		} else {
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3157 "tracker-sparql-expression.c"
		}
	}
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3170 "tracker-sparql-expression.c"
		} else {
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3178 "tracker-sparql-expression.c"
		}
	}
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp0_, &_inner_error_);
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3193 "tracker-sparql-expression.c"
		} else {
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3201 "tracker-sparql-expression.c"
		}
	}
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3214 "tracker-sparql-expression.c"
		} else {
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3222 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp2_;
	TrackerSparqlLiteralBinding* _tmp3_;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlLiteralBinding* _tmp4_;
	TrackerSparqlTokenType _tmp5_ = 0;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlLiteralBinding* _tmp18_;
	TrackerSparqlLiteralBinding* _tmp19_;
	GError * _inner_error_ = NULL;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3256 "tracker-sparql-expression.c"
		} else {
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3264 "tracker-sparql-expression.c"
		}
	}
#line 346 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp1_) {
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3279 "tracker-sparql-expression.c"
			} else {
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3287 "tracker-sparql-expression.c"
			}
		}
	}
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3301 "tracker-sparql-expression.c"
		} else {
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3309 "tracker-sparql-expression.c"
		}
	}
#line 352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, "?");
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_literal_binding_new ();
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	new_binding = _tmp3_;
#line 354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = new_binding;
#line 354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	((TrackerSparqlDataBinding*) _tmp4_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_current (self);
#line 356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 3328 "tracker-sparql-expression.c"
		TrackerSparqlLiteralBinding* _tmp6_;
		gchar* _tmp7_;
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = new_binding;
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = g_strdup ("1");
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp6_->literal);
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_->literal = _tmp7_;
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_next (self, &_inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3351 "tracker-sparql-expression.c"
			} else {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3361 "tracker-sparql-expression.c"
			}
		}
	} else {
		GString* _tmp8_;
		GString* _tmp9_;
		TrackerPropertyType _tmp10_ = 0;
		TrackerPropertyType _tmp11_;
		TrackerPropertyType _tmp12_;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = g_string_new ("");
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_string_free0 (_tmp9_);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3392 "tracker-sparql-expression.c"
			} else {
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3402 "tracker-sparql-expression.c"
			}
		}
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 3407 "tracker-sparql-expression.c"
			TrackerSparqlLiteralBinding* _tmp13_;
			gchar* _tmp14_;
#line 360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = new_binding;
#line 360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = g_strdup ("1");
#line 360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp13_->literal);
#line 360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_->literal = _tmp14_;
#line 3418 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp15_;
			gchar* _tmp16_;
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = new_binding;
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup ("0");
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp15_->literal);
#line 362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_->literal = _tmp16_;
#line 3430 "tracker-sparql-expression.c"
		}
	}
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_ = self->priv->query;
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp18_ = new_binding;
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_->bindings = g_list_append (_tmp17_->bindings, _tmp19_);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3453 "tracker-sparql-expression.c"
		} else {
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3463 "tracker-sparql-expression.c"
		}
	}
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (new_binding);
#line 3468 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3490 "tracker-sparql-expression.c"
		} else {
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3498 "tracker-sparql-expression.c"
		}
	}
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3511 "tracker-sparql-expression.c"
		} else {
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3519 "tracker-sparql-expression.c"
		}
	}
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3534 "tracker-sparql-expression.c"
		} else {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3542 "tracker-sparql-expression.c"
		}
	}
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 3547 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		const gchar* _tmp8_;
		TrackerSparqlVariable* _tmp9_ = NULL;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariable* variable;
		TrackerSparqlVariable* _tmp11_;
		TrackerSparqlVariableBinding* _tmp12_;
		gboolean _tmp20_ = FALSE;
		TrackerSparqlVariable* _tmp21_;
		TrackerSparqlVariableBinding* _tmp22_;
		TrackerPropertyType _tmp23_;
		gboolean _tmp27_;
		GString* _tmp29_;
		TrackerSparqlLiteralBinding* _tmp30_;
		TrackerSparqlLiteralBinding* new_binding;
		TrackerSparqlLiteralBinding* _tmp31_;
		TrackerSparqlVariable* _tmp32_;
		TrackerSparqlVariableBinding* _tmp33_;
		TrackerClass* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		TrackerSparqlQuery* _tmp38_;
		TrackerSparqlLiteralBinding* _tmp39_;
		TrackerSparqlLiteralBinding* _tmp40_;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp3_);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable_name = _tmp5_;
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = variable_name;
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = tracker_sparql_context_get_variable (_tmp7_, _tmp8_);
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp10_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = variable;
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_->binding;
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == NULL) {
#line 3609 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			GError* _tmp18_ = NULL;
			GError* _tmp19_;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = variable;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = tracker_sparql_variable_get_name (_tmp13_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = _tmp14_;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup_printf ("`%s' is not a valid variable", _tmp15_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_get_error (self, _tmp17_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp19_;
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3645 "tracker-sparql-expression.c"
			} else {
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3657 "tracker-sparql-expression.c"
			}
		}
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp21_ = variable;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp22_ = _tmp21_->binding;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = ((TrackerSparqlDataBinding*) _tmp22_)->data_type;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp23_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = TRUE;
#line 3670 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlVariable* _tmp24_;
			TrackerSparqlVariableBinding* _tmp25_;
			TrackerClass* _tmp26_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = variable;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_->binding;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = _tmp25_->type;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp26_ == NULL;
#line 3683 "tracker-sparql-expression.c"
		}
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp27_ = _tmp20_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp27_) {
#line 3689 "tracker-sparql-expression.c"
			GError* _tmp28_ = NULL;
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp28_;
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3705 "tracker-sparql-expression.c"
			} else {
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3717 "tracker-sparql-expression.c"
			}
		}
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp29_ = sql;
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp29_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = tracker_sparql_literal_binding_new ();
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		new_binding = _tmp30_;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_ = new_binding;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp32_ = variable;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_->binding;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp34_ = _tmp33_->type;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp35_ = tracker_class_get_uri (_tmp34_);
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = _tmp35_;
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp31_->literal);
#line 389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_->literal = _tmp37_;
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = self->priv->query;
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp39_ = new_binding;
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_->bindings = g_list_append (_tmp38_->bindings, _tmp40_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (new_binding);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 3760 "tracker-sparql-expression.c"
	} else {
		GError* _tmp41_ = NULL;
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp41_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_inner_error_ = _tmp41_;
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3773 "tracker-sparql-expression.c"
		} else {
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3781 "tracker-sparql-expression.c"
		}
	}
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3794 "tracker-sparql-expression.c"
		} else {
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3802 "tracker-sparql-expression.c"
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
#line 841 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 841 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 842 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 842 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 843 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = str;
#line 843 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 3825 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = uri;
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp0_, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
#line 3843 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 3857 "tracker-sparql-expression.c"
			} else {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 3865 "tracker-sparql-expression.c"
			}
		}
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_STRING;
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 3872 "tracker-sparql-expression.c"
	} else {
		const gchar* _tmp2_;
#line 405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = uri;
#line 405 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp2_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 3879 "tracker-sparql-expression.c"
			GString* _tmp3_;
			GString* _tmp4_;
			GString* _tmp5_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, "CAST (");
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp4_, &_inner_error_);
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 3899 "tracker-sparql-expression.c"
				} else {
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 408 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 3907 "tracker-sparql-expression.c"
				}
			}
#line 409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = sql;
#line 409 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp5_, " AS INTEGER)");
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 3918 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp6_;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = uri;
#line 412 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp6_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 3925 "tracker-sparql-expression.c"
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
#line 414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp7_ = sql;
#line 414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp7_, "CAST (");
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = sql;
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_translate_expression_as_string (self, _tmp8_, &_inner_error_);
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 3945 "tracker-sparql-expression.c"
					} else {
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 415 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 3953 "tracker-sparql-expression.c"
					}
				}
#line 416 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = sql;
#line 416 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp9_, " AS REAL)");
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 3964 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp10_;
#line 419 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = uri;
#line 419 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp10_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
#line 3971 "tracker-sparql-expression.c"
					GString* _tmp11_;
					GString* _tmp12_;
					GString* _tmp13_;
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp11_ = sql;
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp11_, "SparqlCaseFold (");
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp12_ = sql;
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_translate_expression_as_string (self, _tmp12_, &_inner_error_);
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 3991 "tracker-sparql-expression.c"
						} else {
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 422 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 3999 "tracker-sparql-expression.c"
						}
					}
#line 423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sql;
#line 423 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp13_, ")");
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 4010 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp14_;
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = uri;
#line 425 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp14_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
#line 4017 "tracker-sparql-expression.c"
						GString* _tmp15_;
						GString* _tmp16_;
						GString* _tmp17_;
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp15_ = sql;
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp15_, "lower (");
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp16_ = sql;
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						tracker_sparql_expression_translate_expression_as_string (self, _tmp16_, &_inner_error_);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4037 "tracker-sparql-expression.c"
							} else {
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4045 "tracker-sparql-expression.c"
							}
						}
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp17_ = sql;
#line 429 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp17_, ")");
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = TRACKER_PROPERTY_TYPE_STRING;
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 4056 "tracker-sparql-expression.c"
					} else {
						const gchar* _tmp18_;
#line 431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp18_ = uri;
#line 431 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (g_strcmp0 (_tmp18_, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
#line 4063 "tracker-sparql-expression.c"
							GString* _tmp19_;
							GString* _tmp20_;
							GString* _tmp21_;
#line 433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp19_ = sql;
#line 433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp19_, "SparqlLowerCase (");
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp20_ = sql;
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							tracker_sparql_expression_translate_expression_as_string (self, _tmp20_, &_inner_error_);
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4083 "tracker-sparql-expression.c"
								} else {
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 434 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4091 "tracker-sparql-expression.c"
								}
							}
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp21_ = sql;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp21_, ")");
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = TRACKER_PROPERTY_TYPE_STRING;
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 4102 "tracker-sparql-expression.c"
						} else {
							const gchar* _tmp22_;
#line 437 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp22_ = uri;
#line 437 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (g_strcmp0 (_tmp22_, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
#line 4109 "tracker-sparql-expression.c"
								GString* _tmp23_;
								GString* _tmp24_;
								GString* _tmp25_;
								GString* _tmp26_;
								TrackerSparqlLiteralBinding* _tmp27_;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								TrackerSparqlLiteralBinding* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_ = NULL;
								TrackerSparqlQuery* _tmp33_;
								TrackerSparqlLiteralBinding* _tmp34_;
								TrackerSparqlLiteralBinding* _tmp35_;
								GString* _tmp36_;
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp23_ = sql;
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp23_, "(");
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp24_ = sql;
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, _tmp24_, &_inner_error_);
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4141 "tracker-sparql-expression.c"
									} else {
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4149 "tracker-sparql-expression.c"
									}
								}
#line 441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp25_ = sql;
#line 441 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp25_, " GLOB ");
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4166 "tracker-sparql-expression.c"
									} else {
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4174 "tracker-sparql-expression.c"
									}
								}
#line 444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp26_ = sql;
#line 444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp26_, "?");
#line 445 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp27_ = tracker_sparql_literal_binding_new ();
#line 445 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								binding = _tmp27_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp28_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp29_ = _tmp28_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4199 "tracker-sparql-expression.c"
									} else {
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4209 "tracker-sparql-expression.c"
									}
								}
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_ = binding;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp31_ = _tmp29_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp32_ = g_strdup_printf ("*%s*", _tmp31_);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp30_->literal);
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_->literal = _tmp32_;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp31_);
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_ = self->priv->query;
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp34_ = binding;
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp35_ = _g_object_ref0 (_tmp34_);
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_->bindings = g_list_append (_tmp33_->bindings, _tmp35_);
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp36_ = sql;
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp36_, ")");
#line 451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_object_unref0 (binding);
#line 451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 4242 "tracker-sparql-expression.c"
							} else {
								const gchar* _tmp37_;
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp37_ = uri;
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
#line 4249 "tracker-sparql-expression.c"
									GString* _tmp38_;
									GString* _tmp39_;
									gchar* _tmp40_ = NULL;
									gchar* prefix;
									GString* _tmp41_;
									TrackerSparqlLiteralBinding* _tmp42_;
									TrackerSparqlLiteralBinding* binding;
									TrackerSparqlLiteralBinding* _tmp43_;
									const gchar* _tmp44_;
									gchar* _tmp45_;
									TrackerSparqlQuery* _tmp46_;
									TrackerSparqlLiteralBinding* _tmp47_;
									TrackerSparqlLiteralBinding* _tmp48_;
									GString* _tmp49_;
									GString* _tmp50_;
									TrackerSparqlLiteralBinding* _tmp51_;
									TrackerSparqlLiteralBinding* _tmp52_;
									const gchar* _tmp53_;
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_;
									gchar* _tmp56_;
									TrackerSparqlQuery* _tmp57_;
									TrackerSparqlLiteralBinding* _tmp58_;
									TrackerSparqlLiteralBinding* _tmp59_;
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp38_ = sql;
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_translate_expression_as_string (self, _tmp38_, &_inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4286 "tracker-sparql-expression.c"
										} else {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4294 "tracker-sparql-expression.c"
										}
									}
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp39_ = sql;
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp39_, " BETWEEN ");
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4311 "tracker-sparql-expression.c"
										} else {
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4319 "tracker-sparql-expression.c"
										}
									}
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp40_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									prefix = _tmp40_;
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4334 "tracker-sparql-expression.c"
										} else {
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 460 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4342 "tracker-sparql-expression.c"
										}
									}
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp41_ = sql;
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp41_, "?");
#line 463 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp42_ = tracker_sparql_literal_binding_new ();
#line 463 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp42_;
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_ = binding;
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp44_ = prefix;
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp45_ = g_strdup (_tmp44_);
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp43_->literal);
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_->literal = _tmp45_;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_ = self->priv->query;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp47_ = binding;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp48_ = _g_object_ref0 (_tmp47_);
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_->bindings = g_list_append (_tmp46_->bindings, _tmp48_);
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp49_ = sql;
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp49_, " AND ");
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp50_ = sql;
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp50_, "?");
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp51_ = tracker_sparql_literal_binding_new ();
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp51_;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_ = binding;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp53_ = prefix;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp54_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp55_ = _tmp54_;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp52_->literal);
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_->literal = _tmp56_;
#line 471 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp55_);
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_ = self->priv->query;
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp58_ = binding;
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp59_ = _g_object_ref0 (_tmp58_);
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_->bindings = g_list_append (_tmp57_->bindings, _tmp59_);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (prefix);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 4417 "tracker-sparql-expression.c"
								} else {
									const gchar* _tmp60_;
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp60_ = uri;
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (g_strcmp0 (_tmp60_, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
#line 4424 "tracker-sparql-expression.c"
										GString* _tmp61_;
										GString* _tmp62_;
										GString* _tmp63_;
										GString* _tmp64_;
										TrackerSparqlLiteralBinding* _tmp65_;
										TrackerSparqlLiteralBinding* binding;
										gchar* _tmp66_ = NULL;
										gchar* _tmp67_;
										TrackerSparqlLiteralBinding* _tmp68_;
										gchar* _tmp69_;
										gchar* _tmp70_ = NULL;
										TrackerSparqlQuery* _tmp71_;
										TrackerSparqlLiteralBinding* _tmp72_;
										TrackerSparqlLiteralBinding* _tmp73_;
										GString* _tmp74_;
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp61_ = sql;
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp61_, "(");
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp62_ = sql;
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, _tmp62_, &_inner_error_);
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4456 "tracker-sparql-expression.c"
											} else {
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 478 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4464 "tracker-sparql-expression.c"
											}
										}
#line 479 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp63_ = sql;
#line 479 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp63_, " GLOB ");
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4481 "tracker-sparql-expression.c"
											} else {
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4489 "tracker-sparql-expression.c"
											}
										}
#line 482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp64_ = sql;
#line 482 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp64_, "?");
#line 483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp65_ = tracker_sparql_literal_binding_new ();
#line 483 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										binding = _tmp65_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp66_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp67_ = _tmp66_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4514 "tracker-sparql-expression.c"
											} else {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4524 "tracker-sparql-expression.c"
											}
										}
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_ = binding;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp69_ = _tmp67_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp70_ = g_strdup_printf ("*%s", _tmp69_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp68_->literal);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_->literal = _tmp70_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp69_);
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_ = self->priv->query;
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp72_ = binding;
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp73_ = _g_object_ref0 (_tmp72_);
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_->bindings = g_list_append (_tmp71_->bindings, _tmp73_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp74_ = sql;
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp74_, ")");
#line 489 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 489 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 489 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return result;
#line 4557 "tracker-sparql-expression.c"
									} else {
										const gchar* _tmp75_;
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp75_ = uri;
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (g_strcmp0 (_tmp75_, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
#line 4564 "tracker-sparql-expression.c"
											GString* _tmp76_;
											GString* _tmp77_;
											GString* _tmp78_;
											GString* _tmp79_;
											gboolean _tmp80_ = FALSE;
											gboolean _tmp81_;
											GString* _tmp84_;
#line 491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp76_ = sql;
#line 491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp76_, "substr(");
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp77_ = sql;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp77_, &_inner_error_);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4588 "tracker-sparql-expression.c"
												} else {
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4596 "tracker-sparql-expression.c"
												}
											}
#line 494 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp78_ = sql;
#line 494 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp78_, ", ");
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4613 "tracker-sparql-expression.c"
												} else {
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4621 "tracker-sparql-expression.c"
												}
											}
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp79_ = sql;
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp79_, &_inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4636 "tracker-sparql-expression.c"
												} else {
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 496 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4644 "tracker-sparql-expression.c"
												}
											}
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp80_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp81_ = _tmp80_;
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4659 "tracker-sparql-expression.c"
												} else {
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4667 "tracker-sparql-expression.c"
												}
											}
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_tmp81_) {
#line 4672 "tracker-sparql-expression.c"
												GString* _tmp82_;
												GString* _tmp83_;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp82_ = sql;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp82_, ", ");
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp83_ = sql;
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp83_, &_inner_error_);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4691 "tracker-sparql-expression.c"
													} else {
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4699 "tracker-sparql-expression.c"
													}
												}
											}
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp84_ = sql;
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp84_, ")");
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											result = TRACKER_PROPERTY_TYPE_STRING;
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return result;
#line 4711 "tracker-sparql-expression.c"
										} else {
											const gchar* _tmp85_;
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp85_ = uri;
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (g_strcmp0 (_tmp85_, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
#line 4718 "tracker-sparql-expression.c"
												GString* _tmp86_;
												GString* _tmp87_;
												GString* _tmp88_;
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp86_ = sql;
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp86_, &_inner_error_);
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4734 "tracker-sparql-expression.c"
													} else {
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4742 "tracker-sparql-expression.c"
													}
												}
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp87_ = sql;
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp87_, "||");
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4759 "tracker-sparql-expression.c"
													} else {
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 509 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4767 "tracker-sparql-expression.c"
													}
												}
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp88_ = sql;
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp88_, &_inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4782 "tracker-sparql-expression.c"
													} else {
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4790 "tracker-sparql-expression.c"
													}
												}
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												while (TRUE) {
#line 4795 "tracker-sparql-expression.c"
													gboolean _tmp89_ = FALSE;
													gboolean _tmp90_;
													GString* _tmp91_;
													GString* _tmp92_;
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp89_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp90_ = _tmp89_;
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4812 "tracker-sparql-expression.c"
														} else {
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4820 "tracker-sparql-expression.c"
														}
													}
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (!_tmp90_) {
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														break;
#line 4827 "tracker-sparql-expression.c"
													}
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp91_ = sql;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp91_, "||");
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp92_ = sql;
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp92_, &_inner_error_);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4845 "tracker-sparql-expression.c"
														} else {
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4853 "tracker-sparql-expression.c"
														}
													}
												}
#line 516 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												result = TRACKER_PROPERTY_TYPE_STRING;
#line 516 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return result;
#line 4861 "tracker-sparql-expression.c"
											} else {
												const gchar* _tmp93_;
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp93_ = uri;
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (g_strcmp0 (_tmp93_, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
#line 4868 "tracker-sparql-expression.c"
													GString* _tmp94_;
													GString* _tmp95_;
													GString* _tmp96_;
													GString* _tmp97_;
													GString* _tmp102_;
													GString* _tmp103_;
													GString* _tmp104_;
#line 518 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp94_ = sql;
#line 518 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp94_, "SparqlStringJoin(");
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4890 "tracker-sparql-expression.c"
														} else {
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4898 "tracker-sparql-expression.c"
														}
													}
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp95_ = sql;
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp95_, &_inner_error_);
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4913 "tracker-sparql-expression.c"
														} else {
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 521 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4921 "tracker-sparql-expression.c"
														}
													}
#line 522 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp96_ = sql;
#line 522 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp96_, ", ");
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4938 "tracker-sparql-expression.c"
														} else {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4946 "tracker-sparql-expression.c"
														}
													}
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp97_ = sql;
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp97_, &_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4961 "tracker-sparql-expression.c"
														} else {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 4969 "tracker-sparql-expression.c"
														}
													}
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													while (TRUE) {
#line 4974 "tracker-sparql-expression.c"
														gboolean _tmp98_ = FALSE;
														gboolean _tmp99_;
														GString* _tmp100_;
														GString* _tmp101_;
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp98_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp99_ = _tmp98_;
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 4991 "tracker-sparql-expression.c"
															} else {
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 4999 "tracker-sparql-expression.c"
															}
														}
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (!_tmp99_) {
#line 525 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															break;
#line 5006 "tracker-sparql-expression.c"
														}
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp100_ = sql;
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp100_, ", ");
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp101_ = sql;
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp101_, &_inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5024 "tracker-sparql-expression.c"
															} else {
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5032 "tracker-sparql-expression.c"
															}
														}
													}
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5046 "tracker-sparql-expression.c"
														} else {
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 530 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5054 "tracker-sparql-expression.c"
														}
													}
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp102_ = sql;
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp102_, ",");
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5071 "tracker-sparql-expression.c"
														} else {
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 532 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5079 "tracker-sparql-expression.c"
														}
													}
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp103_ = sql;
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression (self, _tmp103_, &_inner_error_);
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5094 "tracker-sparql-expression.c"
														} else {
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5102 "tracker-sparql-expression.c"
														}
													}
#line 534 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp104_ = sql;
#line 534 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp104_, ")");
#line 536 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													result = TRACKER_PROPERTY_TYPE_STRING;
#line 536 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return result;
#line 5113 "tracker-sparql-expression.c"
												} else {
													const gchar* _tmp105_;
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp105_ = uri;
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (g_strcmp0 (_tmp105_, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
#line 5120 "tracker-sparql-expression.c"
														gchar* _tmp106_ = NULL;
														gchar* _tmp107_;
														gchar* _tmp108_ = NULL;
														gchar* _tmp109_;
														gchar* variable_name;
														TrackerSparqlContext* _tmp110_;
														TrackerSparqlContext* _tmp111_;
														const gchar* _tmp112_;
														TrackerSparqlVariable* _tmp113_ = NULL;
														TrackerSparqlVariable* _tmp114_;
														TrackerSparqlVariable* variable;
														GString* _tmp115_;
														GString* _tmp116_;
														TrackerSparqlVariable* _tmp117_;
														gchar* _tmp118_ = NULL;
														gchar* _tmp119_;
														GString* _tmp120_;
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5148 "tracker-sparql-expression.c"
															} else {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5156 "tracker-sparql-expression.c"
															}
														}
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp106_ = tracker_sparql_expression_get_last_string (self, 0);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp107_ = _tmp106_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp108_ = string_substring (_tmp107_, (glong) 1, (glong) (-1));
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp109_ = _tmp108_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp107_);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable_name = _tmp109_;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp110_ = tracker_sparql_expression_get_context (self);
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp111_ = _tmp110_;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp112_ = variable_name;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp113_ = tracker_sparql_context_get_variable (_tmp111_, _tmp112_);
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp114_ = _g_object_ref0 (_tmp113_);
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable = _tmp114_;
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp115_ = sql;
#line 542 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp115_, "strftime (\"%Y\", ");
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp116_ = sql;
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp117_ = variable;
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp118_ = tracker_sparql_variable_get_extra_sql_expression (_tmp117_, "localDate");
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp119_ = _tmp118_;
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp116_, _tmp119_);
#line 543 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp119_);
#line 544 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp120_ = sql;
#line 544 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp120_, " * 24 * 3600, \"unixepoch\")");
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_object_unref0 (variable);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (variable_name);
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return result;
#line 5211 "tracker-sparql-expression.c"
													} else {
														const gchar* _tmp121_;
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp121_ = uri;
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (g_strcmp0 (_tmp121_, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
#line 5218 "tracker-sparql-expression.c"
															gchar* _tmp122_ = NULL;
															gchar* _tmp123_;
															gchar* _tmp124_ = NULL;
															gchar* _tmp125_;
															gchar* variable_name;
															TrackerSparqlContext* _tmp126_;
															TrackerSparqlContext* _tmp127_;
															const gchar* _tmp128_;
															TrackerSparqlVariable* _tmp129_ = NULL;
															TrackerSparqlVariable* _tmp130_;
															TrackerSparqlVariable* variable;
															GString* _tmp131_;
															GString* _tmp132_;
															TrackerSparqlVariable* _tmp133_;
															gchar* _tmp134_ = NULL;
															gchar* _tmp135_;
															GString* _tmp136_;
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5246 "tracker-sparql-expression.c"
																} else {
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 548 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5254 "tracker-sparql-expression.c"
																}
															}
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp122_ = tracker_sparql_expression_get_last_string (self, 0);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp123_ = _tmp122_;
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp124_ = string_substring (_tmp123_, (glong) 1, (glong) (-1));
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp125_ = _tmp124_;
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp123_);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable_name = _tmp125_;
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp126_ = tracker_sparql_expression_get_context (self);
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp127_ = _tmp126_;
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp128_ = variable_name;
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp129_ = tracker_sparql_context_get_variable (_tmp127_, _tmp128_);
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp130_ = _g_object_ref0 (_tmp129_);
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable = _tmp130_;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp131_ = sql;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp131_, "strftime (\"%m\", ");
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp132_ = sql;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp133_ = variable;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp134_ = tracker_sparql_variable_get_extra_sql_expression (_tmp133_, "localDate");
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp135_ = _tmp134_;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp132_, _tmp135_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp135_);
#line 554 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp136_ = sql;
#line 554 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp136_, " * 24 * 3600, \"unixepoch\")");
#line 556 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 556 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_object_unref0 (variable);
#line 556 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (variable_name);
#line 556 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return result;
#line 5309 "tracker-sparql-expression.c"
														} else {
															const gchar* _tmp137_;
#line 557 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp137_ = uri;
#line 557 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (g_strcmp0 (_tmp137_, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
#line 5316 "tracker-sparql-expression.c"
																gchar* _tmp138_ = NULL;
																gchar* _tmp139_;
																gchar* _tmp140_ = NULL;
																gchar* _tmp141_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp142_;
																TrackerSparqlContext* _tmp143_;
																const gchar* _tmp144_;
																TrackerSparqlVariable* _tmp145_ = NULL;
																TrackerSparqlVariable* _tmp146_;
																TrackerSparqlVariable* variable;
																GString* _tmp147_;
																GString* _tmp148_;
																TrackerSparqlVariable* _tmp149_;
																gchar* _tmp150_ = NULL;
																gchar* _tmp151_;
																GString* _tmp152_;
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5344 "tracker-sparql-expression.c"
																	} else {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5352 "tracker-sparql-expression.c"
																	}
																}
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp138_ = tracker_sparql_expression_get_last_string (self, 0);
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp139_ = _tmp138_;
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp140_ = string_substring (_tmp139_, (glong) 1, (glong) (-1));
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp141_ = _tmp140_;
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp139_);
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable_name = _tmp141_;
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp142_ = tracker_sparql_expression_get_context (self);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp143_ = _tmp142_;
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp144_ = variable_name;
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp145_ = tracker_sparql_context_get_variable (_tmp143_, _tmp144_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp146_ = _g_object_ref0 (_tmp145_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable = _tmp146_;
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp147_ = sql;
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp147_, "strftime (\"%d\", ");
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp148_ = sql;
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp149_ = variable;
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp150_ = tracker_sparql_variable_get_extra_sql_expression (_tmp149_, "localDate");
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp151_ = _tmp150_;
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp148_, _tmp151_);
#line 563 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp151_);
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp152_ = sql;
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp152_, " * 24 * 3600, \"unixepoch\")");
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_object_unref0 (variable);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (variable_name);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return result;
#line 5407 "tracker-sparql-expression.c"
															} else {
																const gchar* _tmp153_;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp153_ = uri;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (g_strcmp0 (_tmp153_, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
#line 5414 "tracker-sparql-expression.c"
																	gchar* _tmp154_ = NULL;
																	gchar* _tmp155_;
																	gchar* _tmp156_ = NULL;
																	gchar* _tmp157_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp158_;
																	TrackerSparqlContext* _tmp159_;
																	const gchar* _tmp160_;
																	TrackerSparqlVariable* _tmp161_ = NULL;
																	TrackerSparqlVariable* _tmp162_;
																	TrackerSparqlVariable* variable;
																	GString* _tmp163_;
																	GString* _tmp164_;
																	TrackerSparqlVariable* _tmp165_;
																	gchar* _tmp166_ = NULL;
																	gchar* _tmp167_;
																	GString* _tmp168_;
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_ != NULL) {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5442 "tracker-sparql-expression.c"
																		} else {
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5450 "tracker-sparql-expression.c"
																		}
																	}
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp154_ = tracker_sparql_expression_get_last_string (self, 0);
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp155_ = _tmp154_;
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp156_ = string_substring (_tmp155_, (glong) 1, (glong) (-1));
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp157_ = _tmp156_;
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp155_);
#line 569 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable_name = _tmp157_;
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp158_ = tracker_sparql_expression_get_context (self);
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp159_ = _tmp158_;
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp160_ = variable_name;
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp161_ = tracker_sparql_context_get_variable (_tmp159_, _tmp160_);
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp162_ = _g_object_ref0 (_tmp161_);
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable = _tmp162_;
#line 572 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp163_ = sql;
#line 572 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp163_, "(");
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp164_ = sql;
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp165_ = variable;
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp166_ = tracker_sparql_variable_get_extra_sql_expression (_tmp165_, "localTime");
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp167_ = _tmp166_;
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp164_, _tmp167_);
#line 573 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp167_);
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp168_ = sql;
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp168_, " / 3600)");
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_object_unref0 (variable);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (variable_name);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return result;
#line 5505 "tracker-sparql-expression.c"
																} else {
																	const gchar* _tmp169_;
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp169_ = uri;
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (g_strcmp0 (_tmp169_, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
#line 5512 "tracker-sparql-expression.c"
																		gchar* _tmp170_ = NULL;
																		gchar* _tmp171_;
																		gchar* _tmp172_ = NULL;
																		gchar* _tmp173_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp174_;
																		TrackerSparqlContext* _tmp175_;
																		const gchar* _tmp176_;
																		TrackerSparqlVariable* _tmp177_ = NULL;
																		TrackerSparqlVariable* _tmp178_;
																		TrackerSparqlVariable* variable;
																		GString* _tmp179_;
																		GString* _tmp180_;
																		TrackerSparqlVariable* _tmp181_;
																		gchar* _tmp182_ = NULL;
																		gchar* _tmp183_;
																		GString* _tmp184_;
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_ != NULL) {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5540 "tracker-sparql-expression.c"
																			} else {
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5548 "tracker-sparql-expression.c"
																			}
																		}
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp170_ = tracker_sparql_expression_get_last_string (self, 0);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp171_ = _tmp170_;
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp172_ = string_substring (_tmp171_, (glong) 1, (glong) (-1));
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp173_ = _tmp172_;
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp171_);
#line 579 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable_name = _tmp173_;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp174_ = tracker_sparql_expression_get_context (self);
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp175_ = _tmp174_;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp176_ = variable_name;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp177_ = tracker_sparql_context_get_variable (_tmp175_, _tmp176_);
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp178_ = _g_object_ref0 (_tmp177_);
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable = _tmp178_;
#line 582 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp179_ = sql;
#line 582 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp179_, "(");
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp180_ = sql;
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp181_ = variable;
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp182_ = tracker_sparql_variable_get_extra_sql_expression (_tmp181_, "localTime");
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp183_ = _tmp182_;
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp180_, _tmp183_);
#line 583 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp183_);
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp184_ = sql;
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp184_, " / 60 % 60)");
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_object_unref0 (variable);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (variable_name);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return result;
#line 5603 "tracker-sparql-expression.c"
																	} else {
																		const gchar* _tmp185_;
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp185_ = uri;
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (g_strcmp0 (_tmp185_, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
#line 5610 "tracker-sparql-expression.c"
																			gchar* _tmp186_ = NULL;
																			gchar* _tmp187_;
																			gchar* _tmp188_ = NULL;
																			gchar* _tmp189_;
																			gchar* variable_name;
																			TrackerSparqlContext* _tmp190_;
																			TrackerSparqlContext* _tmp191_;
																			const gchar* _tmp192_;
																			TrackerSparqlVariable* _tmp193_ = NULL;
																			TrackerSparqlVariable* _tmp194_;
																			TrackerSparqlVariable* variable;
																			GString* _tmp195_;
																			GString* _tmp196_;
																			TrackerSparqlVariable* _tmp197_;
																			gchar* _tmp198_ = NULL;
																			gchar* _tmp199_;
																			GString* _tmp200_;
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_ != NULL) {
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_propagate_error (error, _inner_error_);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 5638 "tracker-sparql-expression.c"
																				} else {
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_clear_error (&_inner_error_);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 5646 "tracker-sparql-expression.c"
																				}
																			}
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp187_ = _tmp186_;
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp189_ = _tmp188_;
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp187_);
#line 589 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable_name = _tmp189_;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp190_ = tracker_sparql_expression_get_context (self);
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp191_ = _tmp190_;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp192_ = variable_name;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp193_ = tracker_sparql_context_get_variable (_tmp191_, _tmp192_);
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp194_ = _g_object_ref0 (_tmp193_);
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable = _tmp194_;
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp195_ = sql;
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp195_, "(");
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp196_ = sql;
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp197_ = variable;
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp198_ = tracker_sparql_variable_get_extra_sql_expression (_tmp197_, "localTime");
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp199_ = _tmp198_;
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp196_, _tmp199_);
#line 593 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp199_);
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp200_ = sql;
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp200_, "% 60)");
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_object_unref0 (variable);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (variable_name);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return result;
#line 5701 "tracker-sparql-expression.c"
																		} else {
																			const gchar* _tmp201_;
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp201_ = uri;
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (g_strcmp0 (_tmp201_, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
#line 5708 "tracker-sparql-expression.c"
																				gchar* _tmp202_ = NULL;
																				gchar* _tmp203_;
																				gchar* _tmp204_ = NULL;
																				gchar* _tmp205_;
																				gchar* variable_name;
																				TrackerSparqlContext* _tmp206_;
																				TrackerSparqlContext* _tmp207_;
																				const gchar* _tmp208_;
																				TrackerSparqlVariable* _tmp209_ = NULL;
																				TrackerSparqlVariable* _tmp210_;
																				TrackerSparqlVariable* variable;
																				GString* _tmp211_;
																				GString* _tmp212_;
																				TrackerSparqlVariable* _tmp213_;
																				gchar* _tmp214_ = NULL;
																				gchar* _tmp215_;
																				GString* _tmp216_;
																				GString* _tmp217_;
																				TrackerSparqlVariable* _tmp218_;
																				gchar* _tmp219_ = NULL;
																				gchar* _tmp220_;
																				GString* _tmp221_;
																				GString* _tmp222_;
																				TrackerSparqlVariable* _tmp223_;
																				const gchar* _tmp224_;
																				const gchar* _tmp225_;
																				GString* _tmp226_;
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_ != NULL) {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_propagate_error (error, _inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 5746 "tracker-sparql-expression.c"
																					} else {
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_clear_error (&_inner_error_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 5754 "tracker-sparql-expression.c"
																					}
																				}
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp202_ = tracker_sparql_expression_get_last_string (self, 0);
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp203_ = _tmp202_;
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp204_ = string_substring (_tmp203_, (glong) 1, (glong) (-1));
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp205_ = _tmp204_;
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp203_);
#line 599 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable_name = _tmp205_;
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp206_ = tracker_sparql_expression_get_context (self);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp207_ = _tmp206_;
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp208_ = variable_name;
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp209_ = tracker_sparql_context_get_variable (_tmp207_, _tmp208_);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp210_ = _g_object_ref0 (_tmp209_);
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable = _tmp210_;
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp211_ = sql;
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp211_, "(");
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp212_ = sql;
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp213_ = variable;
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp214_ = tracker_sparql_variable_get_extra_sql_expression (_tmp213_, "localDate");
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp215_ = _tmp214_;
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp212_, _tmp215_);
#line 603 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp215_);
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp216_ = sql;
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp216_, " * 24 * 3600 + ");
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp217_ = sql;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp218_ = variable;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp219_ = tracker_sparql_variable_get_extra_sql_expression (_tmp218_, "localTime");
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp220_ = _tmp219_;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp217_, _tmp220_);
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp220_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp221_ = sql;
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp221_, "- ");
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp222_ = sql;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp223_ = variable;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp224_ = tracker_sparql_variable_get_sql_expression (_tmp223_);
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp225_ = _tmp224_;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp222_, _tmp225_);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp226_ = sql;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp226_, ")");
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_object_unref0 (variable);
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (variable_name);
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return result;
#line 5839 "tracker-sparql-expression.c"
																			} else {
																				const gchar* _tmp227_;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp227_ = uri;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (g_strcmp0 (_tmp227_, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
#line 5846 "tracker-sparql-expression.c"
																					gboolean is_var = FALSE;
																					TrackerSparqlPattern* _tmp228_;
																					TrackerSparqlPattern* _tmp229_;
																					gboolean _tmp230_ = FALSE;
																					gchar* _tmp231_ = NULL;
																					gchar* v;
																					GString* _tmp232_;
																					const gchar* _tmp233_;
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp228_ = tracker_sparql_expression_get_pattern (self);
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp229_ = _tmp228_;
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp231_ = tracker_sparql_pattern_parse_var_or_term (_tmp229_, NULL, &_tmp230_, &_inner_error_);
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					is_var = _tmp230_;
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					v = _tmp231_;
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_ != NULL) {
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_propagate_error (error, _inner_error_);
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 5873 "tracker-sparql-expression.c"
																						} else {
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_clear_error (&_inner_error_);
#line 613 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 5881 "tracker-sparql-expression.c"
																						}
																					}
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp232_ = sql;
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp233_ = v;
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append_printf (_tmp232_, "\"%s_u_rank\"", _tmp233_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (v);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return result;
#line 5896 "tracker-sparql-expression.c"
																				} else {
																					const gchar* _tmp234_;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp234_ = uri;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (g_strcmp0 (_tmp234_, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
#line 5903 "tracker-sparql-expression.c"
																						gboolean is_var = FALSE;
																						TrackerSparqlPattern* _tmp235_;
																						TrackerSparqlPattern* _tmp236_;
																						gboolean _tmp237_ = FALSE;
																						gchar* _tmp238_ = NULL;
																						gchar* v;
																						GString* _tmp239_;
																						const gchar* _tmp240_;
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp235_ = tracker_sparql_expression_get_pattern (self);
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp236_ = _tmp235_;
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp238_ = tracker_sparql_pattern_parse_var_or_term (_tmp236_, NULL, &_tmp237_, &_inner_error_);
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						is_var = _tmp237_;
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						v = _tmp238_;
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_ != NULL) {
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_propagate_error (error, _inner_error_);
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 5930 "tracker-sparql-expression.c"
																							} else {
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_clear_error (&_inner_error_);
#line 619 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 5938 "tracker-sparql-expression.c"
																							}
																						}
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp239_ = sql;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp240_ = v;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append_printf (_tmp239_, "\"%s_u_offsets\"", _tmp240_);
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						result = TRACKER_PROPERTY_TYPE_STRING;
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (v);
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return result;
#line 5953 "tracker-sparql-expression.c"
																					} else {
																						const gchar* _tmp241_;
#line 623 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp241_ = uri;
#line 623 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (g_strcmp0 (_tmp241_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
#line 5960 "tracker-sparql-expression.c"
																							GString* _tmp242_;
																							TrackerPropertyType _tmp243_ = 0;
																							TrackerPropertyType type;
																							TrackerPropertyType _tmp244_;
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp242_ = sql;
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp243_ = tracker_sparql_expression_translate_expression (self, _tmp242_, &_inner_error_);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							type = _tmp243_;
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 5979 "tracker-sparql-expression.c"
																								} else {
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 5987 "tracker-sparql-expression.c"
																								}
																							}
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp244_ = type;
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_tmp244_ != TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 5994 "tracker-sparql-expression.c"
																								GError* _tmp245_ = NULL;
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp245_ = tracker_sparql_expression_get_error (self, "expected resource");
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_inner_error_ = _tmp245_;
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6006 "tracker-sparql-expression.c"
																								} else {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6014 "tracker-sparql-expression.c"
																								}
																							}
#line 629 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 629 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return result;
#line 6021 "tracker-sparql-expression.c"
																						} else {
																							const gchar* _tmp246_;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp246_ = uri;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (g_strcmp0 (_tmp246_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
#line 6028 "tracker-sparql-expression.c"
																								GString* _tmp247_;
																								TrackerPropertyType _tmp248_ = 0;
																								TrackerPropertyType type;
																								TrackerPropertyType _tmp249_;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp247_ = sql;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp248_ = tracker_sparql_expression_translate_expression (self, _tmp247_, &_inner_error_);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								type = _tmp248_;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6047 "tracker-sparql-expression.c"
																									} else {
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6055 "tracker-sparql-expression.c"
																									}
																								}
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp249_ = type;
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_tmp249_ != TRACKER_PROPERTY_TYPE_INTEGER) {
#line 6062 "tracker-sparql-expression.c"
																									GError* _tmp250_ = NULL;
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp250_ = tracker_sparql_expression_get_error (self, "expected integer ID");
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_inner_error_ = _tmp250_;
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6074 "tracker-sparql-expression.c"
																									} else {
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6082 "tracker-sparql-expression.c"
																									}
																								}
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return result;
#line 6089 "tracker-sparql-expression.c"
																							} else {
																								const gchar* _tmp251_;
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp251_ = uri;
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (g_strcmp0 (_tmp251_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
#line 6096 "tracker-sparql-expression.c"
																									GString* _tmp252_;
																									GString* _tmp253_;
																									GString* _tmp254_;
																									GString* _tmp255_;
																									GString* _tmp256_;
																									GString* _tmp257_;
																									GString* _tmp258_;
																									GString* _tmp259_;
																									GString* _tmp260_;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp252_ = sql;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp252_, "SparqlCartesianDistance(");
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp253_ = sql;
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp253_, &_inner_error_);
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6122 "tracker-sparql-expression.c"
																										} else {
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 639 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6130 "tracker-sparql-expression.c"
																										}
																									}
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp254_ = sql;
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp254_, ", ");
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6147 "tracker-sparql-expression.c"
																										} else {
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6155 "tracker-sparql-expression.c"
																										}
																									}
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp255_ = sql;
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp255_, &_inner_error_);
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6170 "tracker-sparql-expression.c"
																										} else {
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 642 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6178 "tracker-sparql-expression.c"
																										}
																									}
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp256_ = sql;
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp256_, ", ");
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6195 "tracker-sparql-expression.c"
																										} else {
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6203 "tracker-sparql-expression.c"
																										}
																									}
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp257_ = sql;
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp257_, &_inner_error_);
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6218 "tracker-sparql-expression.c"
																										} else {
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 645 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6226 "tracker-sparql-expression.c"
																										}
																									}
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp258_ = sql;
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp258_, ", ");
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6243 "tracker-sparql-expression.c"
																										} else {
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6251 "tracker-sparql-expression.c"
																										}
																									}
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp259_ = sql;
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp259_, &_inner_error_);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6266 "tracker-sparql-expression.c"
																										} else {
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 648 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6274 "tracker-sparql-expression.c"
																										}
																									}
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp260_ = sql;
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp260_, ")");
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 651 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return result;
#line 6285 "tracker-sparql-expression.c"
																								} else {
																									const gchar* _tmp261_;
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp261_ = uri;
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (g_strcmp0 (_tmp261_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
#line 6292 "tracker-sparql-expression.c"
																										GString* _tmp262_;
																										GString* _tmp263_;
																										GString* _tmp264_;
																										GString* _tmp265_;
																										GString* _tmp266_;
																										GString* _tmp267_;
																										GString* _tmp268_;
																										GString* _tmp269_;
																										GString* _tmp270_;
#line 653 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp262_ = sql;
#line 653 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp262_, "SparqlHaversineDistance(");
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp263_ = sql;
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp263_, &_inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6318 "tracker-sparql-expression.c"
																											} else {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6326 "tracker-sparql-expression.c"
																											}
																										}
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp264_ = sql;
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp264_, ", ");
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6343 "tracker-sparql-expression.c"
																											} else {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6351 "tracker-sparql-expression.c"
																											}
																										}
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp265_ = sql;
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp265_, &_inner_error_);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6366 "tracker-sparql-expression.c"
																											} else {
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 657 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6374 "tracker-sparql-expression.c"
																											}
																										}
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp266_ = sql;
#line 658 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp266_, ", ");
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6391 "tracker-sparql-expression.c"
																											} else {
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6399 "tracker-sparql-expression.c"
																											}
																										}
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp267_ = sql;
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp267_, &_inner_error_);
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6414 "tracker-sparql-expression.c"
																											} else {
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6422 "tracker-sparql-expression.c"
																											}
																										}
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp268_ = sql;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp268_, ", ");
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6439 "tracker-sparql-expression.c"
																											} else {
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6447 "tracker-sparql-expression.c"
																											}
																										}
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp269_ = sql;
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp269_, &_inner_error_);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6462 "tracker-sparql-expression.c"
																											} else {
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6470 "tracker-sparql-expression.c"
																											}
																										}
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp270_ = sql;
#line 664 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp270_, ")");
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return result;
#line 6481 "tracker-sparql-expression.c"
																									} else {
																										const gchar* _tmp271_;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp271_ = uri;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (g_strcmp0 (_tmp271_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
#line 6488 "tracker-sparql-expression.c"
																											GString* _tmp272_;
																											GString* _tmp273_;
																											GString* _tmp274_;
																											GString* _tmp275_;
																											GString* _tmp280_;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp272_ = sql;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp272_, "COALESCE(");
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp273_ = sql;
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression_as_string (self, _tmp273_, &_inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6510 "tracker-sparql-expression.c"
																												} else {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6518 "tracker-sparql-expression.c"
																												}
																											}
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp274_ = sql;
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp274_, ", ");
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6535 "tracker-sparql-expression.c"
																												} else {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6543 "tracker-sparql-expression.c"
																												}
																											}
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp275_ = sql;
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression_as_string (self, _tmp275_, &_inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6558 "tracker-sparql-expression.c"
																												} else {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6566 "tracker-sparql-expression.c"
																												}
																											}
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											while (TRUE) {
#line 6571 "tracker-sparql-expression.c"
																												gboolean _tmp276_ = FALSE;
																												gboolean _tmp277_;
																												GString* _tmp278_;
																												GString* _tmp279_;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp276_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp277_ = _tmp276_;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6588 "tracker-sparql-expression.c"
																													} else {
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6596 "tracker-sparql-expression.c"
																													}
																												}
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (!_tmp277_) {
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													break;
#line 6603 "tracker-sparql-expression.c"
																												}
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp278_ = sql;
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp278_, ", ");
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp279_ = sql;
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp279_, &_inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6621 "tracker-sparql-expression.c"
																													} else {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6629 "tracker-sparql-expression.c"
																													}
																												}
																											}
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp280_ = sql;
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp280_, ")");
#line 679 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											result = TRACKER_PROPERTY_TYPE_STRING;
#line 679 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return result;
#line 6641 "tracker-sparql-expression.c"
																										} else {
																											const gchar* _tmp281_;
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp281_ = uri;
#line 680 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (g_strcmp0 (_tmp281_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
#line 6648 "tracker-sparql-expression.c"
																												GString* _tmp282_;
																												GString* _tmp283_;
																												GString* _tmp284_;
																												GString* _tmp285_;
																												GString* _tmp286_;
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp282_ = sql;
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp282_, "SparqlUriIsParent(");
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp283_ = sql;
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp283_, &_inner_error_);
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6670 "tracker-sparql-expression.c"
																													} else {
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6678 "tracker-sparql-expression.c"
																													}
																												}
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp284_ = sql;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp284_, ", ");
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6695 "tracker-sparql-expression.c"
																													} else {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6703 "tracker-sparql-expression.c"
																													}
																												}
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp285_ = sql;
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp285_, &_inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6718 "tracker-sparql-expression.c"
																													} else {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6726 "tracker-sparql-expression.c"
																													}
																												}
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp286_ = sql;
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp286_, ")");
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return result;
#line 6737 "tracker-sparql-expression.c"
																											} else {
																												const gchar* _tmp287_;
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp287_ = uri;
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (g_strcmp0 (_tmp287_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
#line 6744 "tracker-sparql-expression.c"
																													GString* _tmp288_;
																													GString* _tmp289_;
																													GString* _tmp290_;
																													GString* _tmp291_;
																													GString* _tmp296_;
#line 691 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp288_ = sql;
#line 691 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp288_, "SparqlUriIsDescendant(");
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp289_ = sql;
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp289_, &_inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6766 "tracker-sparql-expression.c"
																														} else {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6774 "tracker-sparql-expression.c"
																														}
																													}
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp290_ = sql;
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp290_, ", ");
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6791 "tracker-sparql-expression.c"
																														} else {
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6799 "tracker-sparql-expression.c"
																														}
																													}
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp291_ = sql;
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp291_, &_inner_error_);
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6814 "tracker-sparql-expression.c"
																														} else {
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 6822 "tracker-sparql-expression.c"
																														}
																													}
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													while (TRUE) {
#line 6827 "tracker-sparql-expression.c"
																														gboolean _tmp292_ = FALSE;
																														gboolean _tmp293_;
																														GString* _tmp294_;
																														GString* _tmp295_;
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp292_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp293_ = _tmp292_;
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6844 "tracker-sparql-expression.c"
																															} else {
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6852 "tracker-sparql-expression.c"
																															}
																														}
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (!_tmp293_) {
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															break;
#line 6859 "tracker-sparql-expression.c"
																														}
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp294_ = sql;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp294_, ", ");
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp295_ = sql;
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp295_, &_inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6877 "tracker-sparql-expression.c"
																															} else {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6885 "tracker-sparql-expression.c"
																															}
																														}
																													}
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp296_ = sql;
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp296_, ")");
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return result;
#line 6897 "tracker-sparql-expression.c"
																												} else {
																													const gchar* _tmp297_;
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp297_ = uri;
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (g_strcmp0 (_tmp297_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
#line 6904 "tracker-sparql-expression.c"
																														GString* _tmp298_;
																														GString* _tmp299_;
																														GString* _tmp300_;
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp298_ = sql;
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp298_, "SparqlStringFromFilename(");
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp299_ = sql;
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp299_, &_inner_error_);
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6924 "tracker-sparql-expression.c"
																															} else {
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 706 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6932 "tracker-sparql-expression.c"
																															}
																														}
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp300_ = sql;
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp300_, ")");
#line 709 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														result = TRACKER_PROPERTY_TYPE_STRING;
#line 709 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return result;
#line 6943 "tracker-sparql-expression.c"
																													} else {
																														const gchar* _tmp301_;
																														TrackerProperty* _tmp302_ = NULL;
																														TrackerProperty* _tmp303_;
																														TrackerProperty* prop;
																														TrackerProperty* _tmp304_;
																														GString* _tmp306_;
																														GString* expr;
																														GString* _tmp307_;
																														gchar* _tmp308_;
																														gchar* value_separator;
																														gchar* graph_separator;
																														gboolean _tmp309_ = FALSE;
																														gboolean _tmp310_;
																														TrackerProperty* _tmp317_;
																														gboolean _tmp318_;
																														gboolean _tmp319_;
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp301_ = uri;
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp302_ = tracker_ontologies_get_property_by_uri (_tmp301_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp303_ = _g_object_ref0 (_tmp302_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														prop = _tmp303_;
#line 713 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp304_ = prop;
#line 713 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp304_ == NULL) {
#line 6973 "tracker-sparql-expression.c"
																															GError* _tmp305_ = NULL;
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp305_ = tracker_sparql_expression_get_error (self, "Unknown function");
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_inner_error_ = _tmp305_;
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6987 "tracker-sparql-expression.c"
																															} else {
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 6997 "tracker-sparql-expression.c"
																															}
																														}
#line 717 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp306_ = g_string_new ("");
#line 717 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														expr = _tmp306_;
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp307_ = expr;
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression (self, _tmp307_, &_inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7020 "tracker-sparql-expression.c"
																															} else {
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 718 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7032 "tracker-sparql-expression.c"
																															}
																														}
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp308_ = g_strdup (",");
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														value_separator = _tmp308_;
#line 721 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														graph_separator = NULL;
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp309_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp310_ = _tmp309_;
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7061 "tracker-sparql-expression.c"
																															} else {
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7077 "tracker-sparql-expression.c"
																															}
																														}
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp310_) {
#line 7082 "tracker-sparql-expression.c"
																															gchar* _tmp311_ = NULL;
																															gchar* _tmp312_;
																															gboolean _tmp313_ = FALSE;
																															gboolean _tmp314_;
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp311_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp312_ = _tmp311_;
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7107 "tracker-sparql-expression.c"
																																} else {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7123 "tracker-sparql-expression.c"
																																}
																															}
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (value_separator);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															value_separator = _tmp312_;
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp313_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp314_ = _tmp313_;
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7150 "tracker-sparql-expression.c"
																																} else {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7166 "tracker-sparql-expression.c"
																																}
																															}
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp314_) {
#line 7171 "tracker-sparql-expression.c"
																																gchar* _tmp315_ = NULL;
																																gchar* _tmp316_;
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp315_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp316_ = _tmp315_;
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7194 "tracker-sparql-expression.c"
																																	} else {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7210 "tracker-sparql-expression.c"
																																	}
																																}
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																graph_separator = _tmp316_;
#line 7217 "tracker-sparql-expression.c"
																															}
																														}
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp317_ = prop;
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp318_ = tracker_property_get_multiple_values (_tmp317_);
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp319_ = _tmp318_;
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp319_) {
#line 7228 "tracker-sparql-expression.c"
																															GString* _tmp320_;
																															GString* _tmp321_;
																															gssize _tmp322_;
																															glong begin;
																															GString* _tmp323_;
																															TrackerProperty* _tmp324_;
																															const gchar* _tmp325_;
																															const gchar* _tmp326_;
																															GString* _tmp327_;
																															TrackerProperty* _tmp328_;
																															TrackerPropertyType _tmp329_;
																															TrackerPropertyType _tmp330_;
																															glong _tmp331_;
																															const gchar* _tmp332_;
																															GString* _tmp340_;
																															const gchar* _tmp341_;
																															gchar* _tmp342_ = NULL;
																															gchar* _tmp343_;
																															GString* _tmp344_;
																															TrackerProperty* _tmp345_;
																															const gchar* _tmp346_;
																															const gchar* _tmp347_;
																															GString* _tmp348_;
																															const gchar* _tmp349_;
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp320_ = sql;
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp320_, "(SELECT GROUP_CONCAT(");
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp321_ = sql;
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp322_ = _tmp321_->len;
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															begin = (glong) _tmp322_;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp323_ = sql;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp324_ = prop;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp325_ = tracker_property_get_name (_tmp324_);
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp326_ = _tmp325_;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp323_, "\"%s\"", _tmp326_);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp327_ = sql;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp328_ = prop;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp329_ = tracker_property_get_data_type (_tmp328_);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp330_ = _tmp329_;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp331_ = begin;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_convert_expression_to_string (_tmp327_, _tmp330_, _tmp331_);
#line 737 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp332_ = graph_separator;
#line 737 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp332_ != NULL) {
#line 7289 "tracker-sparql-expression.c"
																																GString* _tmp333_;
																																const gchar* _tmp334_;
																																gchar* _tmp335_ = NULL;
																																gchar* _tmp336_;
																																TrackerProperty* _tmp337_;
																																const gchar* _tmp338_;
																																const gchar* _tmp339_;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp333_ = sql;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp334_ = graph_separator;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp335_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp334_);
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp336_ = _tmp335_;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp337_ = prop;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp338_ = tracker_property_get_name (_tmp337_);
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp339_ = _tmp338_;
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp333_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp336_, _tmp339_);
#line 738 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (_tmp336_);
#line 7315 "tracker-sparql-expression.c"
																															}
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp340_ = sql;
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp341_ = value_separator;
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp342_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp341_);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp343_ = _tmp342_;
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp340_, ",%s)", _tmp343_);
#line 740 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (_tmp343_);
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp344_ = sql;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp345_ = prop;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp346_ = tracker_property_get_table_name (_tmp345_);
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp347_ = _tmp346_;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp348_ = expr;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp349_ = _tmp348_->str;
#line 741 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp344_, " FROM \"%s\" WHERE ID = %s)", _tmp347_, _tmp349_);
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															result = TRACKER_PROPERTY_TYPE_STRING;
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (graph_separator);
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (value_separator);
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_string_free0 (expr);
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_object_unref0 (prop);
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return result;
#line 7355 "tracker-sparql-expression.c"
																														} else {
																															const gchar* _tmp350_;
#line 746 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp350_ = graph_separator;
#line 746 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp350_ == NULL) {
#line 7362 "tracker-sparql-expression.c"
																																GString* _tmp351_;
																																TrackerProperty* _tmp352_;
																																const gchar* _tmp353_;
																																const gchar* _tmp354_;
																																TrackerProperty* _tmp355_;
																																const gchar* _tmp356_;
																																const gchar* _tmp357_;
																																GString* _tmp358_;
																																const gchar* _tmp359_;
																																TrackerProperty* _tmp360_;
																																TrackerPropertyType _tmp361_;
																																TrackerPropertyType _tmp362_;
																																TrackerProperty* _tmp364_;
																																TrackerPropertyType _tmp365_;
																																TrackerPropertyType _tmp366_;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp351_ = sql;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp352_ = prop;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp353_ = tracker_property_get_name (_tmp352_);
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp354_ = _tmp353_;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp355_ = prop;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp356_ = tracker_property_get_table_name (_tmp355_);
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp357_ = _tmp356_;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp358_ = expr;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp359_ = _tmp358_->str;
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp351_, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp354_, _tmp357_, _tmp359_);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp360_ = prop;
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp361_ = tracker_property_get_data_type (_tmp360_);
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp362_ = _tmp361_;
#line 749 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_tmp362_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 7406 "tracker-sparql-expression.c"
																																	GString* _tmp363_;
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp363_ = sql;
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_append_collate (self, _tmp363_);
#line 7412 "tracker-sparql-expression.c"
																																}
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp364_ = prop;
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp365_ = tracker_property_get_data_type (_tmp364_);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp366_ = _tmp365_;
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = _tmp366_;
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 7432 "tracker-sparql-expression.c"
																															} else {
																																GString* _tmp367_;
																																GString* _tmp368_;
																																gssize _tmp369_;
																																glong begin;
																																GString* _tmp370_;
																																TrackerProperty* _tmp371_;
																																const gchar* _tmp372_;
																																const gchar* _tmp373_;
																																GString* _tmp374_;
																																TrackerProperty* _tmp375_;
																																TrackerPropertyType _tmp376_;
																																TrackerPropertyType _tmp377_;
																																glong _tmp378_;
																																GString* _tmp379_;
																																const gchar* _tmp380_;
																																gchar* _tmp381_ = NULL;
																																gchar* _tmp382_;
																																TrackerProperty* _tmp383_;
																																const gchar* _tmp384_;
																																const gchar* _tmp385_;
																																GString* _tmp386_;
																																TrackerProperty* _tmp387_;
																																const gchar* _tmp388_;
																																const gchar* _tmp389_;
																																GString* _tmp390_;
																																const gchar* _tmp391_;
#line 755 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp367_ = sql;
#line 755 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp367_, "(SELECT ");
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp368_ = sql;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp369_ = _tmp368_->len;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																begin = (glong) _tmp369_;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp370_ = sql;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp371_ = prop;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp372_ = tracker_property_get_name (_tmp371_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp373_ = _tmp372_;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp370_, "\"%s\"", _tmp373_);
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp374_ = sql;
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp375_ = prop;
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp376_ = tracker_property_get_data_type (_tmp375_);
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp377_ = _tmp376_;
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp378_ = begin;
#line 758 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_convert_expression_to_string (_tmp374_, _tmp377_, _tmp378_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp379_ = sql;
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp380_ = graph_separator;
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp381_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp380_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp382_ = _tmp381_;
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp383_ = prop;
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp384_ = tracker_property_get_name (_tmp383_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp385_ = _tmp384_;
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp379_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp382_, _tmp385_);
#line 759 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (_tmp382_);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp386_ = sql;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp387_ = prop;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp388_ = tracker_property_get_table_name (_tmp387_);
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp389_ = _tmp388_;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp390_ = expr;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp391_ = _tmp390_->str;
#line 760 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp386_, " FROM \"%s\" WHERE ID = %s)", _tmp389_, _tmp391_);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = TRACKER_PROPERTY_TYPE_STRING;
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 762 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 7536 "tracker-sparql-expression.c"
																															}
																														}
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_free0 (graph_separator);
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_free0 (value_separator);
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_string_free0 (expr);
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_object_unref0 (prop);
#line 7547 "tracker-sparql-expression.c"
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 7604 "tracker-sparql-expression.c"
		} else {
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 7614 "tracker-sparql-expression.c"
		}
	}
#line 772 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 7619 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (type_iri);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type_iri = _tmp2_;
#line 7627 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 7645 "tracker-sparql-expression.c"
			} else {
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 7655 "tracker-sparql-expression.c"
			}
		}
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp4_) {
#line 7660 "tracker-sparql-expression.c"
			gchar* _tmp5_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 0);
#line 775 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp5_;
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7690 "tracker-sparql-expression.c"
				} else {
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7702 "tracker-sparql-expression.c"
				}
			}
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = self->priv->query;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = ns;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = _tmp10_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (_tmp6_, _tmp7_, _tmp11_, &_inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp11_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp9_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7739 "tracker-sparql-expression.c"
				} else {
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7751 "tracker-sparql-expression.c"
				}
			}
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp14_;
#line 774 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 7760 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlQuery* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7782 "tracker-sparql-expression.c"
				} else {
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7792 "tracker-sparql-expression.c"
				}
			}
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = self->priv->query;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_last_string (self, 0);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) (-1));
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (_tmp15_, "", _tmp19_, &_inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = _tmp20_;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp19_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7825 "tracker-sparql-expression.c"
				} else {
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7835 "tracker-sparql-expression.c"
				}
			}
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp22_;
#line 7842 "tracker-sparql-expression.c"
		}
	}
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp23_ = type_iri;
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp23_, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
#line 784 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 7851 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		gboolean _tmp38_;
		gboolean _tmp40_;
		gboolean _tmp42_;
		gboolean _tmp44_;
		gboolean _tmp46_;
		gboolean _tmp48_;
		gboolean _tmp50_;
		gboolean _tmp52_;
		gboolean _tmp54_;
		gboolean _tmp56_;
		gboolean _tmp58_;
		gboolean _tmp60_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = type_iri;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp36_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = TRUE;
#line 7884 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp37_;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = type_iri;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
#line 7891 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = _tmp35_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp38_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = TRUE;
#line 7899 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp39_;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = type_iri;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = g_strcmp0 (_tmp39_, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
#line 7906 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _tmp34_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp40_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = TRUE;
#line 7914 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp41_;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = type_iri;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_strcmp0 (_tmp41_, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
#line 7921 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp42_ = _tmp33_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp42_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = TRUE;
#line 7929 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp43_;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp43_ = type_iri;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = g_strcmp0 (_tmp43_, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
#line 7936 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = _tmp32_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp44_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = TRUE;
#line 7944 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp45_;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp45_ = type_iri;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = g_strcmp0 (_tmp45_, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
#line 7951 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp46_ = _tmp31_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp46_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = TRUE;
#line 7959 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp47_;
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp47_ = type_iri;
#line 791 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
#line 7966 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = _tmp30_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp48_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = TRUE;
#line 7974 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp49_;
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type_iri;
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = g_strcmp0 (_tmp49_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
#line 7981 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp50_ = _tmp29_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp50_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = TRUE;
#line 7989 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp51_;
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = type_iri;
#line 793 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = g_strcmp0 (_tmp51_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
#line 7996 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp52_ = _tmp28_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp52_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = TRUE;
#line 8004 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp53_;
#line 794 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = type_iri;
#line 794 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = g_strcmp0 (_tmp53_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
#line 8011 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp54_ = _tmp27_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp54_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = TRUE;
#line 8019 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp55_;
#line 795 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = type_iri;
#line 795 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = g_strcmp0 (_tmp55_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
#line 8026 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp56_ = _tmp26_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp56_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = TRUE;
#line 8034 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp57_;
#line 796 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = type_iri;
#line 796 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = g_strcmp0 (_tmp57_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
#line 8041 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp58_ = _tmp25_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp58_) {
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = TRUE;
#line 8049 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp59_;
#line 797 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = type_iri;
#line 797 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = g_strcmp0 (_tmp59_, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
#line 8056 "tracker-sparql-expression.c"
		}
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp60_ = _tmp24_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp60_) {
#line 798 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 8064 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp61_;
#line 799 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = type_iri;
#line 799 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp61_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 800 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 8073 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp62_;
#line 801 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp62_ = type_iri;
#line 801 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp62_, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					type = TRACKER_PROPERTY_TYPE_DATE;
#line 8082 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp63_;
#line 803 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp63_ = type_iri;
#line 803 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp63_, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 8091 "tracker-sparql-expression.c"
					} else {
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_STRING;
#line 8095 "tracker-sparql-expression.c"
					}
				}
			}
		}
	}
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (type_iri);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 8107 "tracker-sparql-expression.c"
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _vala_type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_next (self, &_inner_error_);
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 8128 "tracker-sparql-expression.c"
		} else {
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 8136 "tracker-sparql-expression.c"
		}
	}
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_last (self);
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 8147 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* _tmp3_;
			const gchar* p;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			const gchar* end;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			GString* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = g_string_new ("");
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			sb = _tmp1_;
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			s = _tmp2_;
#line 820 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = s;
#line 820 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			p = _tmp3_;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = p;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = s;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = strlen (_tmp5_);
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = _tmp6_;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			end = _tmp4_ + _tmp7_;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			while (TRUE) {
#line 8189 "tracker-sparql-expression.c"
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* q;
				const gchar* _tmp12_;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = p;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = end;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!(((glong) _tmp8_) < ((glong) _tmp9_))) {
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					break;
#line 8204 "tracker-sparql-expression.c"
				}
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = p;
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = strchr (_tmp10_, (gint) '\\');
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				q = _tmp11_;
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = q;
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp12_ == NULL) {
#line 8216 "tracker-sparql-expression.c"
					GString* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sb;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = p;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp15_ = end;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp16_ = p;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp13_, _tmp14_, (gssize) ((glong) (_tmp15_ - _tmp16_)));
#line 826 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp17_ = end;
#line 826 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp17_;
#line 8236 "tracker-sparql-expression.c"
				} else {
					GString* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar _tmp24_;
					const gchar* _tmp49_;
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp18_ = sb;
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp19_ = p;
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp20_ = q;
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp21_ = p;
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp18_, _tmp19_, (gssize) ((glong) (_tmp20_ - _tmp21_)));
#line 829 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = q;
#line 829 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp22_ + 1;
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp23_ = p;
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp24_ = ((gchar*) _tmp23_)[0];
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					switch (_tmp24_) {
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\'':
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '"':
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\\':
#line 8272 "tracker-sparql-expression.c"
						{
							GString* _tmp25_;
							const gchar* _tmp26_;
							gchar _tmp27_;
#line 834 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp25_ = sb;
#line 834 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp26_ = p;
#line 834 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp27_ = ((gchar*) _tmp26_)[0];
#line 834 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp25_, _tmp27_);
#line 835 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8287 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'b':
#line 8291 "tracker-sparql-expression.c"
						{
							GString* _tmp28_;
#line 837 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp28_ = sb;
#line 837 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp28_, '\b');
#line 838 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8300 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'f':
#line 8304 "tracker-sparql-expression.c"
						{
							GString* _tmp29_;
#line 840 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp29_ = sb;
#line 840 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp29_, '\f');
#line 841 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8313 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'n':
#line 8317 "tracker-sparql-expression.c"
						{
							GString* _tmp30_;
#line 843 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp30_ = sb;
#line 843 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp30_, '\n');
#line 844 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8326 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'r':
#line 8330 "tracker-sparql-expression.c"
						{
							GString* _tmp31_;
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp31_ = sb;
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp31_, '\r');
#line 847 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8339 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 't':
#line 8343 "tracker-sparql-expression.c"
						{
							GString* _tmp32_;
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp32_ = sb;
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp32_, '\t');
#line 850 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8352 "tracker-sparql-expression.c"
						}
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'u':
#line 8356 "tracker-sparql-expression.c"
						{
							const gchar* _tmp33_;
							gchar* ptr;
							gchar* _tmp34_;
							gchar _tmp35_;
							gint _tmp36_ = 0;
							gchar* _tmp37_;
							gchar _tmp38_;
							gint _tmp39_ = 0;
							gchar* _tmp40_;
							gchar _tmp41_;
							gint _tmp42_ = 0;
							gchar* _tmp43_;
							gchar _tmp44_;
							gint _tmp45_ = 0;
							gunichar c;
							GString* _tmp46_;
							gunichar _tmp47_;
							const gchar* _tmp48_;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp33_ = p;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							ptr = ((gchar*) _tmp33_) + 1;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp34_ = ptr;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp35_ = _tmp34_[0];
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp36_ = g_ascii_xdigit_value (_tmp35_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp37_ = ptr;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp38_ = _tmp37_[1];
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp39_ = g_ascii_xdigit_value (_tmp38_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp40_ = ptr;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp41_ = _tmp40_[2];
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp42_ = g_ascii_xdigit_value (_tmp41_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp43_ = ptr;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp44_ = _tmp43_[3];
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp45_ = g_ascii_xdigit_value (_tmp44_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							c = (((((((gunichar) _tmp36_) * 16) + _tmp39_) * 16) + _tmp42_) * 16) + _tmp45_;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp46_ = sb;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp47_ = c;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_unichar (_tmp46_, _tmp47_);
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp48_ = p;
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							p = _tmp48_ + 4;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8418 "tracker-sparql-expression.c"
						}
						default:
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						break;
#line 8423 "tracker-sparql-expression.c"
					}
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp49_ = p;
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp49_ + 1;
#line 8429 "tracker-sparql-expression.c"
				}
			}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8448 "tracker-sparql-expression.c"
				} else {
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8460 "tracker-sparql-expression.c"
				}
			}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp51_) {
#line 8465 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp52_ = 0;
				TrackerPropertyType parsed_type;
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp52_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				parsed_type = _tmp52_;
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8484 "tracker-sparql-expression.c"
					} else {
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 864 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8496 "tracker-sparql-expression.c"
					}
				}
#line 865 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if ((&_vala_type) == NULL) {
#line 8501 "tracker-sparql-expression.c"
				} else {
					TrackerPropertyType _tmp53_;
#line 868 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp53_ = parsed_type;
#line 868 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_vala_type = _tmp53_;
#line 8508 "tracker-sparql-expression.c"
				}
			}
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = sb;
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _tmp54_->str;
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = g_strdup (_tmp55_);
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp56_;
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (s);
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (sb);
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 8527 "tracker-sparql-expression.c"
			}
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8531 "tracker-sparql-expression.c"
		}
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 8537 "tracker-sparql-expression.c"
		{
			gchar* _tmp57_ = NULL;
			gchar* _result_;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = tracker_sparql_expression_get_last_string (self, 3);
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp57_;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8561 "tracker-sparql-expression.c"
				} else {
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8571 "tracker-sparql-expression.c"
				}
			}
#line 877 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp59_) {
#line 8576 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp60_ = 0;
				TrackerPropertyType parsed_type;
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp60_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				parsed_type = _tmp60_;
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8593 "tracker-sparql-expression.c"
					} else {
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8603 "tracker-sparql-expression.c"
					}
				}
#line 880 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if ((&_vala_type) == NULL) {
#line 8608 "tracker-sparql-expression.c"
				} else {
					TrackerPropertyType _tmp61_;
#line 883 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp61_ = parsed_type;
#line 883 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_vala_type = _tmp61_;
#line 8615 "tracker-sparql-expression.c"
				}
			}
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 8624 "tracker-sparql-expression.c"
			}
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8628 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp62_ = NULL;
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_expression_get_error (self, "expected string literal");
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp62_;
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 8643 "tracker-sparql-expression.c"
			} else {
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 889 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 8651 "tracker-sparql-expression.c"
			}
		}
	}
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (type) {
#line 812 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*type = _vala_type;
#line 8659 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 893 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 893 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 893 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8687 "tracker-sparql-expression.c"
		} else {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8695 "tracker-sparql-expression.c"
		}
	}
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 8700 "tracker-sparql-expression.c"
		GString* _tmp2_;
		const gchar* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _result_;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = uri;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_function (self, _tmp2_, _tmp3_, &_inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_result_ = _tmp4_;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8721 "tracker-sparql-expression.c"
			} else {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8729 "tracker-sparql-expression.c"
			}
		}
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8742 "tracker-sparql-expression.c"
			} else {
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 897 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8750 "tracker-sparql-expression.c"
			}
		}
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _result_;
#line 898 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 8757 "tracker-sparql-expression.c"
	} else {
		GString* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
		TrackerSparqlLiteralBinding* binding;
		TrackerSparqlLiteralBinding* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		TrackerSparqlQuery* _tmp10_;
		TrackerSparqlLiteralBinding* _tmp11_;
		TrackerSparqlLiteralBinding* _tmp12_;
#line 901 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 901 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
#line 902 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_literal_binding_new ();
#line 902 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		binding = _tmp6_;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = binding;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = uri;
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp7_->literal);
#line 903 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_->literal = _tmp9_;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = self->priv->query;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = binding;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_->bindings = g_list_append (_tmp10_->bindings, _tmp12_);
#line 905 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 905 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (binding);
#line 905 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 8800 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 8820 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp1_, &_inner_error_);
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8839 "tracker-sparql-expression.c"
				} else {
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8847 "tracker-sparql-expression.c"
				}
			}
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 914 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8854 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 8858 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerPropertyType _tmp7_ = 0;
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8876 "tracker-sparql-expression.c"
				} else {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8884 "tracker-sparql-expression.c"
				}
			}
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 1);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_translate_uri_expression (self, _tmp4_, _tmp6_, &_inner_error_);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp6_);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8909 "tracker-sparql-expression.c"
				} else {
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8917 "tracker-sparql-expression.c"
				}
			}
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp9_;
#line 917 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8924 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 8930 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8945 "tracker-sparql-expression.c"
				} else {
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8953 "tracker-sparql-expression.c"
				}
			}
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = self->priv->query;
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_query_get_no_cache (_tmp10_);
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_) {
#line 8964 "tracker-sparql-expression.c"
				GString* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = sql;
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_expression_get_last_string (self, 0);
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp13_, _tmp15_);
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp15_);
#line 8978 "tracker-sparql-expression.c"
			} else {
				GString* _tmp16_;
				TrackerSparqlLiteralBinding* _tmp17_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp18_;
				gchar* _tmp19_ = NULL;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp16_, "?");
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_literal_binding_new ();
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp17_;
#line 928 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = binding;
#line 928 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_expression_get_last_string (self, 0);
#line 928 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp18_->literal);
#line 928 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_->literal = _tmp19_;
#line 929 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 929 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 929 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 929 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 922 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9014 "tracker-sparql-expression.c"
			}
#line 932 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 932 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9020 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 9024 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9039 "tracker-sparql-expression.c"
				} else {
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9047 "tracker-sparql-expression.c"
				}
			}
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = self->priv->query;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = tracker_sparql_query_get_no_cache (_tmp23_);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_) {
#line 9058 "tracker-sparql-expression.c"
				GString* _tmp26_;
#line 937 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 937 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "1");
#line 9064 "tracker-sparql-expression.c"
			} else {
				GString* _tmp27_;
				TrackerSparqlLiteralBinding* _tmp28_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp29_;
				gchar* _tmp30_;
				TrackerSparqlLiteralBinding* _tmp31_;
				TrackerSparqlQuery* _tmp32_;
				TrackerSparqlLiteralBinding* _tmp33_;
				TrackerSparqlLiteralBinding* _tmp34_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = sql;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp27_, "?");
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = tracker_sparql_literal_binding_new ();
#line 941 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp28_;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = binding;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = g_strdup ("1");
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp29_->literal);
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_->literal = _tmp30_;
#line 943 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = binding;
#line 943 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp31_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = self->priv->query;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = binding;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = _g_object_ref0 (_tmp33_);
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_->bindings = g_list_append (_tmp32_->bindings, _tmp34_);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9105 "tracker-sparql-expression.c"
			}
#line 947 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 947 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9111 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 9115 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9130 "tracker-sparql-expression.c"
				} else {
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9138 "tracker-sparql-expression.c"
				}
			}
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = self->priv->query;
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp36_ = tracker_sparql_query_get_no_cache (_tmp35_);
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = _tmp36_;
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp37_) {
#line 9149 "tracker-sparql-expression.c"
				GString* _tmp38_;
#line 952 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = sql;
#line 952 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp38_, "0");
#line 9155 "tracker-sparql-expression.c"
			} else {
				GString* _tmp39_;
				TrackerSparqlLiteralBinding* _tmp40_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp41_;
				gchar* _tmp42_;
				TrackerSparqlLiteralBinding* _tmp43_;
				TrackerSparqlQuery* _tmp44_;
				TrackerSparqlLiteralBinding* _tmp45_;
				TrackerSparqlLiteralBinding* _tmp46_;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp39_ = sql;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp39_, "?");
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp40_ = tracker_sparql_literal_binding_new ();
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp40_;
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_ = binding;
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp42_ = g_strdup ("0");
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp41_->literal);
#line 957 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_->literal = _tmp42_;
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp43_ = binding;
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp43_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_ = self->priv->query;
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp45_ = binding;
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_->bindings = g_list_append (_tmp44_->bindings, _tmp46_);
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9196 "tracker-sparql-expression.c"
			}
#line 962 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 962 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9202 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9212 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp47_ = 0;
			gchar* _tmp48_ = NULL;
			gchar* literal;
			TrackerPropertyType _tmp49_;
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp48_ = tracker_sparql_expression_parse_string_literal (self, &_tmp47_, &_inner_error_);
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp47_;
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			literal = _tmp48_;
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9232 "tracker-sparql-expression.c"
				} else {
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 967 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9240 "tracker-sparql-expression.c"
				}
			}
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type;
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			switch (_tmp49_) {
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_INTEGER:
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DOUBLE:
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATE:
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATETIME:
#line 9257 "tracker-sparql-expression.c"
				{
					TrackerSparqlQuery* _tmp50_;
					gboolean _tmp51_;
					gboolean _tmp52_;
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp50_ = self->priv->query;
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp51_ = tracker_sparql_query_get_no_cache (_tmp50_);
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp52_ = _tmp51_;
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp52_) {
#line 9270 "tracker-sparql-expression.c"
						GString* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp53_ = sql;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp54_ = literal;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp55_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp54_);
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp56_ = _tmp55_;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp53_, _tmp56_);
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp56_);
#line 9287 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp57_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp58_;
						const gchar* _tmp59_;
						gchar* _tmp60_;
						TrackerSparqlLiteralBinding* _tmp61_;
						TrackerPropertyType _tmp62_;
						TrackerSparqlQuery* _tmp63_;
						TrackerSparqlLiteralBinding* _tmp64_;
						TrackerSparqlLiteralBinding* _tmp65_;
						GString* _tmp66_;
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp57_ = tracker_sparql_literal_binding_new ();
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp57_;
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_ = binding;
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp59_ = literal;
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp60_ = g_strdup (_tmp59_);
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp58_->literal);
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_->literal = _tmp60_;
#line 980 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp61_ = binding;
#line 980 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp62_ = type;
#line 980 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						((TrackerSparqlDataBinding*) _tmp61_)->data_type = _tmp62_;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_ = self->priv->query;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp64_ = binding;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp65_ = _g_object_ref0 (_tmp64_);
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_->bindings = g_list_append (_tmp63_->bindings, _tmp65_);
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp66_ = sql;
#line 982 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp66_, "?");
#line 975 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 9334 "tracker-sparql-expression.c"
					}
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = type;
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 9342 "tracker-sparql-expression.c"
				}
				default:
				{
					TrackerSparqlQuery* _tmp67_;
					gboolean _tmp68_;
					gboolean _tmp69_;
					GString* _tmp82_;
#line 986 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp67_ = self->priv->query;
#line 986 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp68_ = tracker_sparql_query_get_no_cache (_tmp67_);
#line 986 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp69_ = _tmp68_;
#line 986 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp69_) {
#line 9358 "tracker-sparql-expression.c"
						GString* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp70_ = sql;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp71_ = literal;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp72_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp71_);
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp73_ = _tmp72_;
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp70_, _tmp73_);
#line 987 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp73_);
#line 9375 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp74_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp75_;
						const gchar* _tmp76_;
						gchar* _tmp77_;
						TrackerSparqlQuery* _tmp78_;
						TrackerSparqlLiteralBinding* _tmp79_;
						TrackerSparqlLiteralBinding* _tmp80_;
						GString* _tmp81_;
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp74_ = tracker_sparql_literal_binding_new ();
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp74_;
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_ = binding;
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp76_ = literal;
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp77_ = g_strdup (_tmp76_);
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp75_->literal);
#line 990 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_->literal = _tmp77_;
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_ = self->priv->query;
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp79_ = binding;
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp80_ = _g_object_ref0 (_tmp79_);
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_->bindings = g_list_append (_tmp78_->bindings, _tmp80_);
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp81_ = sql;
#line 992 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp81_, "?");
#line 986 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 9414 "tracker-sparql-expression.c"
					}
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp82_ = sql;
#line 994 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp82_);
#line 995 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 995 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 995 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 9426 "tracker-sparql-expression.c"
				}
			}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (literal);
#line 9431 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 9435 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9450 "tracker-sparql-expression.c"
				} else {
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9458 "tracker-sparql-expression.c"
				}
			}
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp83_ = self->priv->query;
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp84_ = tracker_sparql_query_get_no_cache (_tmp83_);
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp85_ = _tmp84_;
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp85_) {
#line 9469 "tracker-sparql-expression.c"
				GString* _tmp86_;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp86_ = sql;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp87_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp88_ = _tmp87_;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp86_, _tmp88_);
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp88_);
#line 9483 "tracker-sparql-expression.c"
			} else {
				GString* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp91_;
				gchar* _tmp92_ = NULL;
				TrackerSparqlLiteralBinding* _tmp93_;
				TrackerSparqlQuery* _tmp94_;
				TrackerSparqlLiteralBinding* _tmp95_;
				TrackerSparqlLiteralBinding* _tmp96_;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp89_ = sql;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp89_, "?");
#line 1005 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp90_ = tracker_sparql_literal_binding_new ();
#line 1005 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp90_;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_ = binding;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp92_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp91_->literal);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_->literal = _tmp92_;
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp93_ = binding;
#line 1007 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp93_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_ = self->priv->query;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp95_ = binding;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp96_ = _g_object_ref0 (_tmp95_);
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_->bindings = g_list_append (_tmp94_->bindings, _tmp96_);
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9524 "tracker-sparql-expression.c"
			}
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9530 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 9534 "tracker-sparql-expression.c"
		{
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp101_;
			TrackerSparqlContext* _tmp102_;
			const gchar* _tmp103_;
			TrackerSparqlVariable* _tmp104_ = NULL;
			TrackerSparqlVariable* _tmp105_;
			TrackerSparqlVariable* variable;
			GString* _tmp106_;
			TrackerSparqlVariable* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			TrackerSparqlVariable* _tmp110_;
			TrackerSparqlVariableBinding* _tmp111_;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9563 "tracker-sparql-expression.c"
				} else {
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9571 "tracker-sparql-expression.c"
				}
			}
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = string_substring (_tmp98_, (glong) 1, (glong) (-1));
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = _tmp99_;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp98_);
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable_name = _tmp100_;
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_expression_get_context (self);
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = variable_name;
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = tracker_sparql_context_get_variable (_tmp102_, _tmp103_);
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp105_ = _g_object_ref0 (_tmp104_);
#line 1015 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp105_;
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp106_ = sql;
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp107_ = variable;
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_variable_get_sql_expression (_tmp107_);
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = _tmp108_;
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp106_, _tmp109_);
#line 1018 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = variable;
#line 1018 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = _tmp110_->binding;
#line 1018 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp111_ == NULL) {
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1019 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 9622 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp112_;
				TrackerSparqlVariableBinding* _tmp113_;
				TrackerPropertyType _tmp114_;
				TrackerSparqlVariable* _tmp116_;
				TrackerSparqlVariableBinding* _tmp117_;
				TrackerPropertyType _tmp118_;
#line 1021 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp112_ = variable;
#line 1021 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp113_ = _tmp112_->binding;
#line 1021 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp114_ = ((TrackerSparqlDataBinding*) _tmp113_)->data_type;
#line 1021 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp114_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 9638 "tracker-sparql-expression.c"
					GString* _tmp115_;
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp115_ = sql;
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp115_);
#line 9644 "tracker-sparql-expression.c"
				}
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp116_ = variable;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp117_ = _tmp116_->binding;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp118_ = ((TrackerSparqlDataBinding*) _tmp117_)->data_type;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp118_;
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1024 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 9660 "tracker-sparql-expression.c"
			}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (variable_name);
#line 9666 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 9670 "tracker-sparql-expression.c"
		{
			GString* _tmp119_;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp119_ = sql;
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_str (self, _tmp119_, &_inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9685 "tracker-sparql-expression.c"
				} else {
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9693 "tracker-sparql-expression.c"
				}
			}
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9700 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 9704 "tracker-sparql-expression.c"
		{
			GString* _tmp120_;
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9717 "tracker-sparql-expression.c"
				} else {
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9725 "tracker-sparql-expression.c"
				}
			}
#line 1031 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp120_ = sql;
#line 1031 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp120_, "''");
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1032 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9736 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 9740 "tracker-sparql-expression.c"
		{
			GString* _tmp121_;
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9753 "tracker-sparql-expression.c"
				} else {
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1034 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9761 "tracker-sparql-expression.c"
				}
			}
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp121_ = sql;
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp121_, "0");
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9772 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 9776 "tracker-sparql-expression.c"
		{
			GString* _tmp122_;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp122_ = sql;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_datatype (self, _tmp122_, &_inner_error_);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9791 "tracker-sparql-expression.c"
				} else {
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9799 "tracker-sparql-expression.c"
				}
			}
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1039 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9806 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 9810 "tracker-sparql-expression.c"
		{
			GString* _tmp123_;
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp123_ = sql;
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_bound_call (self, _tmp123_, &_inner_error_);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9825 "tracker-sparql-expression.c"
				} else {
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9833 "tracker-sparql-expression.c"
				}
			}
#line 1042 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1042 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9840 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 9844 "tracker-sparql-expression.c"
		{
			GString* _tmp124_;
			TrackerPropertyType _tmp125_ = 0;
			TrackerPropertyType _result_;
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9859 "tracker-sparql-expression.c"
				} else {
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9867 "tracker-sparql-expression.c"
				}
			}
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9880 "tracker-sparql-expression.c"
				} else {
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1045 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9888 "tracker-sparql-expression.c"
				}
			}
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp124_ = sql;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp125_ = tracker_sparql_expression_translate_function (self, _tmp124_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce", &_inner_error_);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp125_;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9905 "tracker-sparql-expression.c"
				} else {
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9913 "tracker-sparql-expression.c"
				}
			}
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9926 "tracker-sparql-expression.c"
				} else {
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1047 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9934 "tracker-sparql-expression.c"
				}
			}
#line 1048 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 1048 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9941 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 9945 "tracker-sparql-expression.c"
		{
			GString* _tmp126_;
			TrackerPropertyType _tmp127_ = 0;
			TrackerPropertyType _tmp128_;
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp126_ = sql;
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp127_ = tracker_sparql_expression_translate_if_call (self, _tmp126_, &_inner_error_);
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp128_ = _tmp127_;
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9964 "tracker-sparql-expression.c"
				} else {
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9972 "tracker-sparql-expression.c"
				}
			}
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp128_;
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9979 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 9983 "tracker-sparql-expression.c"
		{
			GString* _tmp129_;
			GString* _tmp130_;
			GString* _tmp131_;
			GString* _tmp132_;
			GString* _tmp133_;
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10000 "tracker-sparql-expression.c"
				} else {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10008 "tracker-sparql-expression.c"
				}
			}
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10021 "tracker-sparql-expression.c"
				} else {
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10029 "tracker-sparql-expression.c"
				}
			}
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp129_ = sql;
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp129_, "(");
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp130_ = sql;
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp130_, &_inner_error_);
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10048 "tracker-sparql-expression.c"
				} else {
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1055 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10056 "tracker-sparql-expression.c"
				}
			}
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp131_ = sql;
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp131_, " = ");
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10073 "tracker-sparql-expression.c"
				} else {
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10081 "tracker-sparql-expression.c"
				}
			}
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp132_ = sql;
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp132_, &_inner_error_);
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10096 "tracker-sparql-expression.c"
				} else {
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10104 "tracker-sparql-expression.c"
				}
			}
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp133_ = sql;
#line 1059 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp133_, ")");
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10121 "tracker-sparql-expression.c"
				} else {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10129 "tracker-sparql-expression.c"
				}
			}
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10136 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 10142 "tracker-sparql-expression.c"
		{
			GString* _tmp134_;
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp134_ = sql;
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_isuri (self, _tmp134_, &_inner_error_);
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10157 "tracker-sparql-expression.c"
				} else {
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10165 "tracker-sparql-expression.c"
				}
			}
#line 1065 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1065 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10172 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 10176 "tracker-sparql-expression.c"
		{
			GString* _tmp135_;
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10189 "tracker-sparql-expression.c"
				} else {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10197 "tracker-sparql-expression.c"
				}
			}
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10210 "tracker-sparql-expression.c"
				} else {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10218 "tracker-sparql-expression.c"
				}
			}
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10231 "tracker-sparql-expression.c"
				} else {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10239 "tracker-sparql-expression.c"
				}
			}
#line 1071 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp135_ = sql;
#line 1071 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp135_, "0");
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10256 "tracker-sparql-expression.c"
				} else {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10264 "tracker-sparql-expression.c"
				}
			}
#line 1073 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1073 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10271 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 10275 "tracker-sparql-expression.c"
		{
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10287 "tracker-sparql-expression.c"
				} else {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10295 "tracker-sparql-expression.c"
				}
			}
#line 1076 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1076 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10302 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 10306 "tracker-sparql-expression.c"
		{
			GString* _tmp136_;
			TrackerSparqlQuery* _tmp137_;
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp136_ = sql;
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_regex (self, _tmp136_, &_inner_error_);
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10322 "tracker-sparql-expression.c"
				} else {
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10330 "tracker-sparql-expression.c"
				}
			}
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp137_ = self->priv->query;
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_query_set_no_cache (_tmp137_, TRUE);
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10341 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 10347 "tracker-sparql-expression.c"
		{
			GString* _tmp138_;
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp138_ = sql;
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_exists (self, _tmp138_, &_inner_error_);
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10362 "tracker-sparql-expression.c"
				} else {
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10370 "tracker-sparql-expression.c"
				}
			}
#line 1084 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1084 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10377 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 10381 "tracker-sparql-expression.c"
		{
			GString* _tmp139_;
			GString* _tmp140_;
			GString* _tmp141_;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10396 "tracker-sparql-expression.c"
				} else {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10404 "tracker-sparql-expression.c"
				}
			}
#line 1087 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp139_ = sql;
#line 1087 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp139_, "COUNT(");
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp140_ = sql;
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_aggregate_expression (self, _tmp140_, &_inner_error_);
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10423 "tracker-sparql-expression.c"
				} else {
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1088 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10431 "tracker-sparql-expression.c"
				}
			}
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp141_ = sql;
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp141_, ")");
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10442 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 10446 "tracker-sparql-expression.c"
		{
			GString* _tmp142_;
			GString* _tmp143_;
			TrackerPropertyType _tmp144_ = 0;
			TrackerPropertyType _tmp145_;
			GString* _tmp146_;
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10463 "tracker-sparql-expression.c"
				} else {
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1092 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10471 "tracker-sparql-expression.c"
				}
			}
#line 1093 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp142_ = sql;
#line 1093 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp142_, "SUM(");
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp143_ = sql;
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp144_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp143_, &_inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp145_ = _tmp144_;
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10492 "tracker-sparql-expression.c"
				} else {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10500 "tracker-sparql-expression.c"
				}
			}
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp145_;
#line 1095 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp146_ = sql;
#line 1095 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp146_, ")");
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1096 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10513 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 10517 "tracker-sparql-expression.c"
		{
			GString* _tmp147_;
			GString* _tmp148_;
			TrackerPropertyType _tmp149_ = 0;
			TrackerPropertyType _tmp150_;
			GString* _tmp151_;
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10534 "tracker-sparql-expression.c"
				} else {
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10542 "tracker-sparql-expression.c"
				}
			}
#line 1099 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp147_ = sql;
#line 1099 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp147_, "AVG(");
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp148_ = sql;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp149_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp148_, &_inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp150_ = _tmp149_;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10563 "tracker-sparql-expression.c"
				} else {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10571 "tracker-sparql-expression.c"
				}
			}
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp150_;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp151_ = sql;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp151_, ")");
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10584 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 10588 "tracker-sparql-expression.c"
		{
			GString* _tmp152_;
			GString* _tmp153_;
			TrackerPropertyType _tmp154_ = 0;
			TrackerPropertyType _tmp155_;
			GString* _tmp156_;
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10605 "tracker-sparql-expression.c"
				} else {
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1104 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10613 "tracker-sparql-expression.c"
				}
			}
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp152_ = sql;
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp152_, "MIN(");
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp153_ = sql;
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp154_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp153_, &_inner_error_);
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp155_ = _tmp154_;
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10634 "tracker-sparql-expression.c"
				} else {
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10642 "tracker-sparql-expression.c"
				}
			}
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp155_;
#line 1107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp156_ = sql;
#line 1107 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp156_, ")");
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10655 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 10659 "tracker-sparql-expression.c"
		{
			GString* _tmp157_;
			GString* _tmp158_;
			TrackerPropertyType _tmp159_ = 0;
			TrackerPropertyType _tmp160_;
			GString* _tmp161_;
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10676 "tracker-sparql-expression.c"
				} else {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10684 "tracker-sparql-expression.c"
				}
			}
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp157_ = sql;
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp157_, "MAX(");
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp158_ = sql;
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp159_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp158_, &_inner_error_);
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp160_ = _tmp159_;
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10705 "tracker-sparql-expression.c"
				} else {
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10713 "tracker-sparql-expression.c"
				}
			}
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp160_;
#line 1113 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp161_ = sql;
#line 1113 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp161_, ")");
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10726 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 10730 "tracker-sparql-expression.c"
		{
			GString* _tmp162_;
			GString* _tmp163_;
			GString* _tmp164_;
			gchar* _tmp165_ = NULL;
			gchar* _tmp166_;
			GString* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			GString* _tmp171_;
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10752 "tracker-sparql-expression.c"
				} else {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10760 "tracker-sparql-expression.c"
				}
			}
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp162_ = sql;
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp162_, "GROUP_CONCAT(");
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10777 "tracker-sparql-expression.c"
				} else {
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10785 "tracker-sparql-expression.c"
				}
			}
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp163_ = sql;
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp163_, &_inner_error_);
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10800 "tracker-sparql-expression.c"
				} else {
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1119 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10808 "tracker-sparql-expression.c"
				}
			}
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp164_ = sql;
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp164_, ", ");
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10825 "tracker-sparql-expression.c"
				} else {
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10833 "tracker-sparql-expression.c"
				}
			}
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp165_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp166_ = _tmp165_;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10848 "tracker-sparql-expression.c"
				} else {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10856 "tracker-sparql-expression.c"
				}
			}
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp167_ = sql;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp168_ = _tmp166_;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp169_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp168_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp170_ = _tmp169_;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp167_, _tmp170_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp170_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp168_);
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp171_ = sql;
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp171_, ")");
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10887 "tracker-sparql-expression.c"
				} else {
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10895 "tracker-sparql-expression.c"
				}
			}
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10902 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 10906 "tracker-sparql-expression.c"
		{
			gchar* _tmp172_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp173_;
			const gchar* _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_ = NULL;
			gchar* _tmp178_;
			gchar* _tmp179_ = NULL;
			gchar* _tmp180_;
			gchar* uri;
			GString* _tmp181_;
			const gchar* _tmp182_;
			TrackerPropertyType _tmp183_ = 0;
			TrackerPropertyType _tmp184_;
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10933 "tracker-sparql-expression.c"
				} else {
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10941 "tracker-sparql-expression.c"
				}
			}
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp172_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp172_;
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10960 "tracker-sparql-expression.c"
				} else {
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10970 "tracker-sparql-expression.c"
				}
			}
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp173_ = self->priv->query;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp174_ = ns;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp175_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp176_ = _tmp175_;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp177_ = string_substring (_tmp176_, (glong) 1, (glong) (-1));
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp178_ = _tmp177_;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp179_ = tracker_sparql_query_resolve_prefixed_name (_tmp173_, _tmp174_, _tmp178_, &_inner_error_);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp180_ = _tmp179_;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp178_);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp176_);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp180_;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11005 "tracker-sparql-expression.c"
				} else {
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11015 "tracker-sparql-expression.c"
				}
			}
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp181_ = sql;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp182_ = uri;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp183_ = tracker_sparql_expression_translate_uri_expression (self, _tmp181_, _tmp182_, &_inner_error_);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp184_ = _tmp183_;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11038 "tracker-sparql-expression.c"
				} else {
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11050 "tracker-sparql-expression.c"
				}
			}
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp184_;
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 1131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11061 "tracker-sparql-expression.c"
		}
#line 912 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 11065 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp185_;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_;
			gchar* _tmp188_ = NULL;
			gchar* _tmp189_;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_;
			gchar* uri;
			GString* _tmp192_;
			const gchar* _tmp193_;
			TrackerPropertyType _tmp194_ = 0;
			TrackerPropertyType _tmp195_;
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11089 "tracker-sparql-expression.c"
				} else {
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11097 "tracker-sparql-expression.c"
				}
			}
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp185_ = self->priv->query;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp187_ = _tmp186_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp189_ = _tmp188_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp190_ = tracker_sparql_query_resolve_prefixed_name (_tmp185_, "", _tmp189_, &_inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp191_ = _tmp190_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp189_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp187_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp191_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11128 "tracker-sparql-expression.c"
				} else {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11136 "tracker-sparql-expression.c"
				}
			}
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp192_ = sql;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp193_ = uri;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp194_ = tracker_sparql_expression_translate_uri_expression (self, _tmp192_, _tmp193_, &_inner_error_);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp195_ = _tmp194_;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11157 "tracker-sparql-expression.c"
				} else {
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11167 "tracker-sparql-expression.c"
				}
			}
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp195_;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11176 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp196_ = NULL;
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp196_ = tracker_sparql_expression_get_error (self, "expected primary expression");
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp196_;
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11191 "tracker-sparql-expression.c"
			} else {
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1137 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11199 "tracker-sparql-expression.c"
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp19_;
	TrackerPropertyType _tmp20_ = 0;
	TrackerPropertyType _tmp21_;
	GError * _inner_error_ = NULL;
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11230 "tracker-sparql-expression.c"
		} else {
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11238 "tracker-sparql-expression.c"
		}
	}
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 11243 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType optype;
		GString* _tmp5_;
		TrackerPropertyType _tmp6_;
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "NOT (");
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, _tmp3_, &_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp4_;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11268 "tracker-sparql-expression.c"
			} else {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11276 "tracker-sparql-expression.c"
			}
		}
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, ")");
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 11287 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11299 "tracker-sparql-expression.c"
			} else {
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11307 "tracker-sparql-expression.c"
			}
		}
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 11314 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11330 "tracker-sparql-expression.c"
			} else {
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11338 "tracker-sparql-expression.c"
			}
		}
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp9_) {
#line 11343 "tracker-sparql-expression.c"
			GString* _tmp10_;
			TrackerPropertyType _tmp11_ = 0;
			TrackerPropertyType _tmp12_;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, _tmp10_, &_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11361 "tracker-sparql-expression.c"
				} else {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11369 "tracker-sparql-expression.c"
				}
			}
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp12_;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11376 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11392 "tracker-sparql-expression.c"
				} else {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11400 "tracker-sparql-expression.c"
				}
			}
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp14_) {
#line 11405 "tracker-sparql-expression.c"
				GString* _tmp15_;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_ = 0;
				TrackerPropertyType optype;
				GString* _tmp18_;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = sql;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp15_, "-(");
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_expression_translate_primary_expression (self, _tmp16_, &_inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				optype = _tmp17_;
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11429 "tracker-sparql-expression.c"
					} else {
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1154 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11437 "tracker-sparql-expression.c"
					}
				}
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = sql;
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp18_, ")");
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = optype;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 11448 "tracker-sparql-expression.c"
			}
		}
	}
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp20_ = tracker_sparql_expression_translate_primary_expression (self, _tmp19_, &_inner_error_);
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp21_ = _tmp20_;
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11466 "tracker-sparql-expression.c"
		} else {
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11474 "tracker-sparql-expression.c"
		}
	}
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp21_;
#line 1158 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 11481 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1161 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1161 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, _tmp2_, &_inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11518 "tracker-sparql-expression.c"
		} else {
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11526 "tracker-sparql-expression.c"
		}
	}
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 11531 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11546 "tracker-sparql-expression.c"
			} else {
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11554 "tracker-sparql-expression.c"
			}
		}
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 11559 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 11576 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11588 "tracker-sparql-expression.c"
				} else {
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11596 "tracker-sparql-expression.c"
				}
			}
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " * ");
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, _tmp12_, &_inner_error_);
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11623 "tracker-sparql-expression.c"
				} else {
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11631 "tracker-sparql-expression.c"
				}
			}
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 11638 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11650 "tracker-sparql-expression.c"
				} else {
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11658 "tracker-sparql-expression.c"
				}
			}
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 11665 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11681 "tracker-sparql-expression.c"
				} else {
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11689 "tracker-sparql-expression.c"
				}
			}
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 11694 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 11711 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11723 "tracker-sparql-expression.c"
					} else {
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11731 "tracker-sparql-expression.c"
					}
				}
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1179 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " / ");
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_unary_expression (self, _tmp26_, &_inner_error_);
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11758 "tracker-sparql-expression.c"
					} else {
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11766 "tracker-sparql-expression.c"
					}
				}
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1181 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 11773 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11785 "tracker-sparql-expression.c"
					} else {
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11793 "tracker-sparql-expression.c"
					}
				}
#line 1184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 11800 "tracker-sparql-expression.c"
			} else {
#line 1186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 11804 "tracker-sparql-expression.c"
			}
		}
	}
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 11812 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp2_, &_inner_error_);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11849 "tracker-sparql-expression.c"
		} else {
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11857 "tracker-sparql-expression.c"
		}
	}
#line 1195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 11862 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11877 "tracker-sparql-expression.c"
			} else {
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11885 "tracker-sparql-expression.c"
			}
		}
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 11890 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 11907 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11919 "tracker-sparql-expression.c"
				} else {
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11927 "tracker-sparql-expression.c"
				}
			}
#line 1200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1201 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1201 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " + ");
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp12_, &_inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11954 "tracker-sparql-expression.c"
				} else {
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11962 "tracker-sparql-expression.c"
				}
			}
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 11969 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11981 "tracker-sparql-expression.c"
				} else {
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11989 "tracker-sparql-expression.c"
				}
			}
#line 1205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1205 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 11996 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12012 "tracker-sparql-expression.c"
				} else {
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12020 "tracker-sparql-expression.c"
				}
			}
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 12025 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 12042 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12054 "tracker-sparql-expression.c"
					} else {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12062 "tracker-sparql-expression.c"
					}
				}
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " - ");
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp26_, &_inner_error_);
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12089 "tracker-sparql-expression.c"
					} else {
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12097 "tracker-sparql-expression.c"
					}
				}
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 12104 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12116 "tracker-sparql-expression.c"
					} else {
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1213 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12124 "tracker-sparql-expression.c"
					}
				}
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 12131 "tracker-sparql-expression.c"
			} else {
#line 1217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12135 "tracker-sparql-expression.c"
			}
		}
	}
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12143 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_additive_expression (self, _tmp0_, &_inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12171 "tracker-sparql-expression.c"
		} else {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12179 "tracker-sparql-expression.c"
		}
	}
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12186 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	glong _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_ = 0;
	TrackerPropertyType op2type;
	GString* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	TrackerPropertyType _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (operator != NULL, 0);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = begin;
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_insert (_tmp0_, (gssize) _tmp1_, "(");
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = operator;
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp4_, &_inner_error_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	op2type = _tmp5_;
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12238 "tracker-sparql-expression.c"
		} else {
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12246 "tracker-sparql-expression.c"
		}
	}
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 1231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp6_, ")");
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = op1type;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 12259 "tracker-sparql-expression.c"
	} else {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = FALSE;
#line 12263 "tracker-sparql-expression.c"
	}
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp8_;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = TRUE;
#line 12271 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp11_ = FALSE;
		TrackerPropertyType _tmp12_;
		gboolean _tmp13_;
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = op1type;
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 12282 "tracker-sparql-expression.c"
		} else {
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = FALSE;
#line 12286 "tracker-sparql-expression.c"
		}
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp11_;
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp13_;
#line 12292 "tracker-sparql-expression.c"
	}
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp14_ = _tmp7_;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp14_) {
#line 12298 "tracker-sparql-expression.c"
		TrackerSparqlQuery* _tmp15_;
		GList* _tmp16_;
		guint _tmp17_ = 0U;
		guint _tmp18_;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = self->priv->query;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_->bindings;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = n_bindings;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp17_ == (_tmp18_ + 1)) {
#line 12313 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp19_;
			GList* _tmp20_;
			GList* _tmp21_ = NULL;
			gconstpointer _tmp22_;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = self->priv->query;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_->bindings;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = g_list_last (_tmp20_);
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_->data;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp22_))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 12328 "tracker-sparql-expression.c"
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		TrackerPropertyType _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp30_;
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp25_ = op1type;
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp25_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 12342 "tracker-sparql-expression.c"
		} else {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = FALSE;
#line 12346 "tracker-sparql-expression.c"
		}
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp26_ = _tmp24_;
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp26_) {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = TRUE;
#line 12354 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp27_ = FALSE;
			TrackerPropertyType _tmp28_;
			gboolean _tmp29_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = op1type;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp28_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = op2type == TRACKER_PROPERTY_TYPE_DATE;
#line 12365 "tracker-sparql-expression.c"
			} else {
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = FALSE;
#line 12369 "tracker-sparql-expression.c"
			}
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = _tmp27_;
#line 1240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = _tmp29_;
#line 12375 "tracker-sparql-expression.c"
		}
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = _tmp23_;
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp30_) {
#line 12381 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp31_;
			GList* _tmp32_;
			guint _tmp33_ = 0U;
			guint _tmp34_;
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = self->priv->query;
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = _tmp31_->bindings;
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_list_length (_tmp32_);
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = n_bindings;
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp33_ == (_tmp34_ + 1)) {
#line 12396 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp35_;
				GList* _tmp36_;
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = self->priv->query;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_->bindings;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = g_list_last (_tmp36_);
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_->data;
#line 1244 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp38_))->data_type = TRACKER_PROPERTY_TYPE_DATE;
#line 12411 "tracker-sparql-expression.c"
			}
		}
	}
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1247 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12419 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gint in_variable_count;
	gboolean _tmp0_;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 1250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	in_variable_count = 0;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = not;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 12442 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, " NOT");
#line 12448 "tracker-sparql-expression.c"
	}
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12460 "tracker-sparql-expression.c"
		} else {
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12468 "tracker-sparql-expression.c"
		}
	}
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IN (");
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12487 "tracker-sparql-expression.c"
		} else {
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12495 "tracker-sparql-expression.c"
		}
	}
#line 1260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp4_) {
#line 12500 "tracker-sparql-expression.c"
		gint _tmp5_;
		GString* _tmp6_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = in_variable_count;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		in_variable_count = _tmp5_ + 1;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12519 "tracker-sparql-expression.c"
			} else {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12527 "tracker-sparql-expression.c"
			}
		}
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		while (TRUE) {
#line 12532 "tracker-sparql-expression.c"
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			GString* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_ = FALSE;
			gint _tmp12_;
			gboolean _tmp16_;
			GString* _tmp18_;
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12553 "tracker-sparql-expression.c"
				} else {
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12561 "tracker-sparql-expression.c"
				}
			}
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp8_) {
#line 1263 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12568 "tracker-sparql-expression.c"
			}
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", ");
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = in_variable_count;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			in_variable_count = _tmp10_ + 1;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = in_variable_count;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_ > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
#line 12582 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = self->priv->query;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_query_get_no_cache (_tmp13_);
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = !_tmp15_;
#line 12594 "tracker-sparql-expression.c"
			} else {
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = FALSE;
#line 12598 "tracker-sparql-expression.c"
			}
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = _tmp11_;
#line 1268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp16_) {
#line 12604 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp17_;
#line 1269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = self->priv->query;
#line 1269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_query_set_no_cache (_tmp17_, TRUE);
#line 12610 "tracker-sparql-expression.c"
			}
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = sql;
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp18_, &_inner_error_);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12624 "tracker-sparql-expression.c"
				} else {
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12632 "tracker-sparql-expression.c"
				}
			}
		}
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12646 "tracker-sparql-expression.c"
			} else {
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12654 "tracker-sparql-expression.c"
			}
		}
	}
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 1278 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1278 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12666 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerSparqlQuery* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	guint n_bindings;
	GString* _tmp5_;
	TrackerPropertyType _tmp6_ = 0;
	TrackerPropertyType optype;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = self->priv->query;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_->bindings;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	n_bindings = _tmp4_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp5_, &_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp6_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12717 "tracker-sparql-expression.c"
		} else {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12725 "tracker-sparql-expression.c"
		}
	}
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12740 "tracker-sparql-expression.c"
		} else {
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12748 "tracker-sparql-expression.c"
		}
	}
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 12753 "tracker-sparql-expression.c"
		GString* _tmp9_;
		glong _tmp10_;
		guint _tmp11_;
		TrackerPropertyType _tmp12_;
		TrackerPropertyType _tmp13_ = 0;
		TrackerPropertyType _tmp14_;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = sql;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = begin;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = n_bindings;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = optype;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = tracker_sparql_expression_process_relational_expression (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, " >= ", &_inner_error_);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = _tmp13_;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12780 "tracker-sparql-expression.c"
			} else {
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12788 "tracker-sparql-expression.c"
			}
		}
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp14_;
#line 1287 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 12795 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_;
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12811 "tracker-sparql-expression.c"
			} else {
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12819 "tracker-sparql-expression.c"
			}
		}
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp16_) {
#line 12824 "tracker-sparql-expression.c"
			GString* _tmp17_;
			glong _tmp18_;
			guint _tmp19_;
			TrackerPropertyType _tmp20_;
			TrackerPropertyType _tmp21_ = 0;
			TrackerPropertyType _tmp22_;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = begin;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = n_bindings;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = optype;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_process_relational_expression (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, " = ", &_inner_error_);
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12851 "tracker-sparql-expression.c"
				} else {
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12859 "tracker-sparql-expression.c"
				}
			}
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp22_;
#line 1289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12866 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12882 "tracker-sparql-expression.c"
				} else {
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12890 "tracker-sparql-expression.c"
				}
			}
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp24_) {
#line 12895 "tracker-sparql-expression.c"
				GString* _tmp25_;
				glong _tmp26_;
				guint _tmp27_;
				TrackerPropertyType _tmp28_;
				TrackerPropertyType _tmp29_ = 0;
				TrackerPropertyType _tmp30_;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = begin;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = n_bindings;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = optype;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_process_relational_expression (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, " <> ", &_inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = _tmp29_;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12922 "tracker-sparql-expression.c"
					} else {
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12930 "tracker-sparql-expression.c"
					}
				}
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp30_;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 12937 "tracker-sparql-expression.c"
			} else {
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_;
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = _tmp31_;
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12953 "tracker-sparql-expression.c"
					} else {
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12961 "tracker-sparql-expression.c"
					}
				}
#line 1292 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp32_) {
#line 12966 "tracker-sparql-expression.c"
					GString* _tmp33_;
					glong _tmp34_;
					guint _tmp35_;
					TrackerPropertyType _tmp36_;
					TrackerPropertyType _tmp37_ = 0;
					TrackerPropertyType _tmp38_;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp33_ = sql;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp34_ = begin;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp35_ = n_bindings;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp36_ = optype;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp37_ = tracker_sparql_expression_process_relational_expression (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, " < ", &_inner_error_);
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp38_ = _tmp37_;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 12993 "tracker-sparql-expression.c"
						} else {
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13001 "tracker-sparql-expression.c"
						}
					}
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = _tmp38_;
#line 1293 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 13008 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_;
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp39_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp40_ = _tmp39_;
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13024 "tracker-sparql-expression.c"
						} else {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13032 "tracker-sparql-expression.c"
						}
					}
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp40_) {
#line 13037 "tracker-sparql-expression.c"
						GString* _tmp41_;
						glong _tmp42_;
						guint _tmp43_;
						TrackerPropertyType _tmp44_;
						TrackerPropertyType _tmp45_ = 0;
						TrackerPropertyType _tmp46_;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp41_ = sql;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp42_ = begin;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp43_ = n_bindings;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp44_ = optype;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp45_ = tracker_sparql_expression_process_relational_expression (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, " <= ", &_inner_error_);
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp46_ = _tmp45_;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13064 "tracker-sparql-expression.c"
							} else {
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13072 "tracker-sparql-expression.c"
							}
						}
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = _tmp46_;
#line 1295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 13079 "tracker-sparql-expression.c"
					} else {
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_;
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp47_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp48_ = _tmp47_;
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13095 "tracker-sparql-expression.c"
							} else {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13103 "tracker-sparql-expression.c"
							}
						}
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_tmp48_) {
#line 13108 "tracker-sparql-expression.c"
							GString* _tmp49_;
							glong _tmp50_;
							guint _tmp51_;
							TrackerPropertyType _tmp52_;
							TrackerPropertyType _tmp53_ = 0;
							TrackerPropertyType _tmp54_;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp49_ = sql;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp50_ = begin;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp51_ = n_bindings;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp52_ = optype;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp53_ = tracker_sparql_expression_process_relational_expression (self, _tmp49_, _tmp50_, _tmp51_, _tmp52_, " > ", &_inner_error_);
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp54_ = _tmp53_;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13135 "tracker-sparql-expression.c"
								} else {
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13143 "tracker-sparql-expression.c"
								}
							}
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = _tmp54_;
#line 1297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 13150 "tracker-sparql-expression.c"
						} else {
							gboolean _tmp55_ = FALSE;
							gboolean _tmp56_;
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp55_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp56_ = _tmp55_;
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13166 "tracker-sparql-expression.c"
								} else {
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13174 "tracker-sparql-expression.c"
								}
							}
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_tmp56_) {
#line 13179 "tracker-sparql-expression.c"
								GString* _tmp57_;
								TrackerPropertyType _tmp58_ = 0;
								TrackerPropertyType _tmp59_;
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp57_ = sql;
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp58_ = tracker_sparql_expression_translate_in (self, _tmp57_, FALSE, &_inner_error_);
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp59_ = _tmp58_;
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13197 "tracker-sparql-expression.c"
									} else {
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13205 "tracker-sparql-expression.c"
									}
								}
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = _tmp59_;
#line 1299 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 13212 "tracker-sparql-expression.c"
							} else {
								gboolean _tmp60_ = FALSE;
								gboolean _tmp61_;
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp60_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp61_ = _tmp60_;
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13228 "tracker-sparql-expression.c"
									} else {
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13236 "tracker-sparql-expression.c"
									}
								}
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_tmp61_) {
#line 13241 "tracker-sparql-expression.c"
									GString* _tmp62_;
									TrackerPropertyType _tmp63_ = 0;
									TrackerPropertyType _tmp64_;
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13255 "tracker-sparql-expression.c"
										} else {
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13263 "tracker-sparql-expression.c"
										}
									}
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp62_ = sql;
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp63_ = tracker_sparql_expression_translate_in (self, _tmp62_, TRUE, &_inner_error_);
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp64_ = _tmp63_;
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13280 "tracker-sparql-expression.c"
										} else {
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13288 "tracker-sparql-expression.c"
										}
									}
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = _tmp64_;
#line 1302 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 13295 "tracker-sparql-expression.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13308 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_relational_expression (self, _tmp0_, &_inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13336 "tracker-sparql-expression.c"
		} else {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13344 "tracker-sparql-expression.c"
		}
	}
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13351 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_value_logical (self, _tmp2_, &_inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13388 "tracker-sparql-expression.c"
		} else {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13396 "tracker-sparql-expression.c"
		}
	}
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 13401 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13425 "tracker-sparql-expression.c"
			} else {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13433 "tracker-sparql-expression.c"
			}
		}
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 13440 "tracker-sparql-expression.c"
		}
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13446 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13458 "tracker-sparql-expression.c"
			} else {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13466 "tracker-sparql-expression.c"
			}
		}
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " AND ");
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_value_logical (self, _tmp11_, &_inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13493 "tracker-sparql-expression.c"
			} else {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13501 "tracker-sparql-expression.c"
			}
		}
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13514 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13526 "tracker-sparql-expression.c"
			} else {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13534 "tracker-sparql-expression.c"
			}
		}
	}
#line 1326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13542 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp2_, &_inner_error_);
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13579 "tracker-sparql-expression.c"
		} else {
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13587 "tracker-sparql-expression.c"
		}
	}
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 13592 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13616 "tracker-sparql-expression.c"
			} else {
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13624 "tracker-sparql-expression.c"
			}
		}
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 13631 "tracker-sparql-expression.c"
		}
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13637 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13649 "tracker-sparql-expression.c"
			} else {
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13657 "tracker-sparql-expression.c"
			}
		}
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " OR ");
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp11_, &_inner_error_);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13684 "tracker-sparql-expression.c"
			} else {
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13692 "tracker-sparql-expression.c"
			}
		}
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1339 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1339 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13705 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13717 "tracker-sparql-expression.c"
			} else {
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13725 "tracker-sparql-expression.c"
			}
		}
	}
#line 1344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13733 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_conditional_or_expression (self, _tmp0_, &_inner_error_);
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13761 "tracker-sparql-expression.c"
		} else {
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13769 "tracker-sparql-expression.c"
		}
	}
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13776 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GString* _tmp9_;
	TrackerPropertyType _tmp10_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13801 "tracker-sparql-expression.c"
		} else {
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13809 "tracker-sparql-expression.c"
		}
	}
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 13816 "tracker-sparql-expression.c"
		GString* _tmp1_;
		TrackerSparqlPattern* _tmp2_;
		TrackerSparqlPattern* _tmp3_;
		GString* _tmp4_;
		TrackerSparqlSelectContext* _tmp5_ = NULL;
		TrackerSparqlSelectContext* select_context;
		GString* _tmp6_;
		TrackerSparqlSelectContext* _tmp7_;
		TrackerPropertyType _tmp8_;
#line 1357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, "(");
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = sql;
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_pattern_translate_select (_tmp3_, _tmp4_, TRUE, TRUE, &_inner_error_);
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		select_context = _tmp5_;
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13848 "tracker-sparql-expression.c"
			} else {
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13856 "tracker-sparql-expression.c"
			}
		}
#line 1359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13875 "tracker-sparql-expression.c"
			} else {
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13885 "tracker-sparql-expression.c"
			}
		}
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = select_context;
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = _tmp7_->type;
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp8_;
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tracker_sparql_context_unref0 (select_context);
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 13898 "tracker-sparql-expression.c"
	}
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp10_;
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13914 "tracker-sparql-expression.c"
		} else {
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13922 "tracker-sparql-expression.c"
		}
	}
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13935 "tracker-sparql-expression.c"
		} else {
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13943 "tracker-sparql-expression.c"
		}
	}
#line 1367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1367 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13950 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13976 "tracker-sparql-expression.c"
		} else {
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1371 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13984 "tracker-sparql-expression.c"
		}
	}
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13999 "tracker-sparql-expression.c"
		} else {
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14007 "tracker-sparql-expression.c"
		}
	}
#line 1372 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 14012 "tracker-sparql-expression.c"
		GString* _tmp2_;
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "DISTINCT ");
#line 14018 "tracker-sparql-expression.c"
	}
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp4_;
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14034 "tracker-sparql-expression.c"
		} else {
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14042 "tracker-sparql-expression.c"
		}
	}
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14055 "tracker-sparql-expression.c"
		} else {
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14063 "tracker-sparql-expression.c"
		}
	}
#line 1377 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1377 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14070 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 14114 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, _tmp1_, &_inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14133 "tracker-sparql-expression.c"
				} else {
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14141 "tracker-sparql-expression.c"
				}
			}
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1396 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 14148 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp4_;
			TrackerPropertyType _tmp5_ = 0;
			TrackerPropertyType _tmp6_;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp4_, &_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14169 "tracker-sparql-expression.c"
				} else {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14177 "tracker-sparql-expression.c"
				}
			}
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp6_;
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 14184 "tracker-sparql-expression.c"
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->context;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14204 "tracker-sparql-expression.c"
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->pattern;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14222 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
#line 14235 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
#line 14242 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = TRACKER_SPARQL_EXPRESSION (obj);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
#line 14252 "tracker-sparql-expression.c"
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (object);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (property_id) {
#line 14273 "tracker-sparql-expression.c"
		default:
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 14279 "tracker-sparql-expression.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



