/* tracker-explorer.c generated by valac 0.11.5, the Vala compiler
 * generated from tracker-explorer.vala, do not modify */

/**/
/* Copyright 2009, Rob Taylor <rob.taylor@codethink.co.uk>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;

#define TYPE_RESOURCES_PROXY (resources_proxy_get_type ())
typedef GDBusProxy ResourcesProxy;
typedef GDBusProxyClass ResourcesProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HISTORY_ITEM (history_item_get_type ())
#define HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ITEM, HistoryItem))
#define HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ITEM, HistoryItemClass))
#define IS_HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ITEM))
#define IS_HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ITEM))
#define HISTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ITEM, HistoryItemClass))

typedef struct _HistoryItem HistoryItem;
typedef struct _HistoryItemClass HistoryItemClass;
typedef struct _HistoryItemPrivate HistoryItemPrivate;
#define _history_item_unref0(var) ((var == NULL) ? NULL : (var = (history_item_unref (var), NULL)))
typedef struct _ParamSpecHistoryItem ParamSpecHistoryItem;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _ParamSpecHistory ParamSpecHistory;

#define TYPE_EXPLORER (explorer_get_type ())
#define EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPLORER, Explorer))
#define EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPLORER, ExplorerClass))
#define IS_EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPLORER))
#define IS_EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPLORER))
#define EXPLORER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPLORER, ExplorerClass))

typedef struct _Explorer Explorer;
typedef struct _ExplorerClass ExplorerClass;
typedef struct _ExplorerPrivate ExplorerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecExplorer ParamSpecExplorer;
#define _explorer_unref0(var) ((var == NULL) ? NULL : (var = (explorer_unref (var), NULL)))

struct _ResourcesIface {
	GTypeInterface parent_iface;
	gchar** (*SparqlQuery) (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
};

struct _HistoryItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryItemPrivate * priv;
	gchar* uri;
	HistoryItem* next;
	HistoryItem* prev;
};

struct _HistoryItemClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryItem *self);
};

struct _ParamSpecHistoryItem {
	GParamSpec parent_instance;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	HistoryItem* items;
	HistoryItem* current;
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

struct _Explorer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExplorerPrivate * priv;
};

struct _ExplorerClass {
	GTypeClass parent_class;
	void (*finalize) (Explorer *self);
};

struct _ExplorerPrivate {
	Resources* tracker;
	History* history;
	GtkListStore* uris;
	GtkListStore* relationships;
	GtkLabel* current_uri_label;
	GeeHashMap* namespaces;
	GtkNotebook* types;
	GtkButton* forward;
	GtkButton* back;
};

struct _ParamSpecExplorer {
	GParamSpec parent_instance;
};


static gpointer history_item_parent_class = NULL;
static gpointer history_parent_class = NULL;
static gpointer explorer_parent_class = NULL;

GType resources_proxy_get_type (void) G_GNUC_CONST;
guint resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType resources_get_type (void) G_GNUC_CONST;
gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** resources_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_resources_interface_init (ResourcesIface* iface);
static void _dbus_resources_SparqlQuery (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _resources_unregister_object (gpointer user_data);
gpointer history_item_ref (gpointer instance);
void history_item_unref (gpointer instance);
GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_item (GValue* value, gpointer v_object);
void value_take_history_item (GValue* value, gpointer v_object);
gpointer value_get_history_item (const GValue* value);
GType history_item_get_type (void) G_GNUC_CONST;
enum  {
	HISTORY_ITEM_DUMMY_PROPERTY
};
HistoryItem* history_item_new (const gchar* uri);
HistoryItem* history_item_construct (GType object_type, const gchar* uri);
static void history_item_finalize (HistoryItem* obj);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
gchar* history_current_uri (History* self);
gboolean history_can_go_forward (History* self);
gboolean history_can_go_back (History* self);
gboolean history_forward (History* self);
gboolean history_back (History* self);
void history_add (History* self, const gchar* uri);
History* history_new (void);
History* history_construct (GType object_type);
static void history_finalize (History* obj);
gpointer explorer_ref (gpointer instance);
void explorer_unref (gpointer instance);
GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_explorer (GValue* value, gpointer v_object);
void value_take_explorer (GValue* value, gpointer v_object);
gpointer value_get_explorer (const GValue* value);
GType explorer_get_type (void) G_GNUC_CONST;
#define EXPLORER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPLORER, ExplorerPrivate))
enum  {
	EXPLORER_DUMMY_PROPERTY
};
#define EXPLORER_UI_FILE "tracker-explorer.ui"
void explorer_show (Explorer* self);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
static void explorer_entry_changed (Explorer* self, GtkEditable* editable);
static void _explorer_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview);
static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview);
static void explorer_update_types_page (Explorer* self, GtkWidget* w);
static void _explorer_update_types_page_gtk_container_set_focus_child (GtkContainer* _sender, GtkWidget* widget, gpointer self);
static void explorer_forward_clicked (Explorer* self);
static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_back_clicked (Explorer* self);
static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_fetch_prefixes (Explorer* self);
static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static GtkTreeView* explorer_setup_reverserelationships (Explorer* self);
static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri);
static void explorer_clear_types (Explorer* self);
static void explorer_add_type (Explorer* self, const gchar* type);
static void explorer_set_current_uri (Explorer* self, const gchar* uri);
static void explorer_update_pane (Explorer* self);
Explorer* explorer_new (void);
Explorer* explorer_construct (GType object_type);
static void explorer_finalize (Explorer* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _resources_dbus_arg_info_SparqlQuery_query = {-1, "query", "s"};
static const GDBusArgInfo _resources_dbus_arg_info_SparqlQuery_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _resources_dbus_arg_info_SparqlQuery_in[] = {&_resources_dbus_arg_info_SparqlQuery_query, NULL};
static const GDBusArgInfo * const _resources_dbus_arg_info_SparqlQuery_out[] = {&_resources_dbus_arg_info_SparqlQuery_result, NULL};
static const GDBusMethodInfo _resources_dbus_method_info_SparqlQuery = {-1, "SparqlQuery", (GDBusArgInfo **) (&_resources_dbus_arg_info_SparqlQuery_in), (GDBusArgInfo **) (&_resources_dbus_arg_info_SparqlQuery_out)};
static const GDBusMethodInfo * const _resources_dbus_method_info[] = {&_resources_dbus_method_info_SparqlQuery, NULL};
static const GDBusSignalInfo * const _resources_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_resources_dbus_method_info), (GDBusSignalInfo **) (&_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_resources_dbus_property_info)};
static const GDBusInterfaceVTable _resources_dbus_interface_vtable = {resources_dbus_interface_method_call, resources_dbus_interface_get_property, resources_dbus_interface_set_property};

gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	return RESOURCES_GET_INTERFACE (self)->SparqlQuery (self, query, result_length1, result_length2, error);
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) resources_proxy_get_type);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Resources");
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) resources_register_object);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesProxy, resources_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_proxy_resources_interface_init) );
static void resources_proxy_class_init (ResourcesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = resources_proxy_g_signal;
}


static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void resources_proxy_init (ResourcesProxy* self) {
}


static gchar** resources_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		int _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}


static void resources_proxy_resources_interface_init (ResourcesIface* iface) {
	iface->SparqlQuery = resources_proxy_SparqlQuery;
}


static void _dbus_resources_SparqlQuery (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	int result_length2 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	result = resources_SparqlQuery (self, query, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("aas"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		GVariantBuilder _tmp10_;
		int _tmp11_;
		g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("aas"));
		for (_tmp11_ = 0; _tmp11_ < result_length2; _tmp11_++) {
			g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp7_));
			_tmp7_++;
		}
		g_variant_builder_add_value (&_tmp8_, g_variant_builder_end (&_tmp10_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	 result = (_vala_array_free ( result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_resources_SparqlQuery (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_resources_dbus_interface_info), &_resources_dbus_interface_vtable, data, _resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


HistoryItem* history_item_construct (GType object_type, const gchar* uri) {
	HistoryItem* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (HistoryItem*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (uri);
	_tmp1_ = _tmp0_;
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	return self;
}


HistoryItem* history_item_new (const gchar* uri) {
	return history_item_construct (TYPE_HISTORY_ITEM, uri);
}


static void value_history_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_item_unref (value->data[0].v_pointer);
	}
}


static void value_history_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		HistoryItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HistoryItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistoryItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM), NULL);
	return value->data[0].v_pointer;
}


void value_set_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_item_unref (old);
	}
}


void value_take_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_item_unref (old);
	}
}


static void history_item_class_init (HistoryItemClass * klass) {
	history_item_parent_class = g_type_class_peek_parent (klass);
	HISTORY_ITEM_CLASS (klass)->finalize = history_item_finalize;
}


static void history_item_instance_init (HistoryItem * self) {
	self->next = NULL;
	self->prev = NULL;
	self->ref_count = 1;
}


static void history_item_finalize (HistoryItem* obj) {
	HistoryItem * self;
	self = HISTORY_ITEM (obj);
	_g_free0 (self->uri);
	_history_item_unref0 (self->next);
	_history_item_unref0 (self->prev);
}


GType history_item_get_type (void) {
	static volatile gsize history_item_type_id__volatile = 0;
	if (g_once_init_enter (&history_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_item_init, value_history_item_free_value, value_history_item_copy_value, value_history_item_peek_pointer, "p", value_history_item_collect_value, "p", value_history_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryItem), 0, (GInstanceInitFunc) history_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_item_type_id;
		history_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_item_type_id__volatile, history_item_type_id);
	}
	return history_item_type_id__volatile;
}


gpointer history_item_ref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_item_unref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gchar* history_current_uri (History* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->current != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self->priv->current->uri);
		result = _tmp0_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


gboolean history_can_go_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		_tmp0_ = self->priv->current->next != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean history_can_go_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		_tmp0_ = self->priv->current->prev != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer _history_item_ref0 (gpointer self) {
	return self ? history_item_ref (self) : NULL;
}


gboolean history_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = history_can_go_forward (self);
	if (_tmp0_) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		_tmp1_ = _history_item_ref0 (self->priv->current->next);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp2_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean history_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = history_can_go_back (self);
	if (_tmp0_) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		_tmp1_ = _history_item_ref0 (self->priv->current->prev);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp2_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void history_add (History* self, const gchar* uri) {
	HistoryItem* _tmp0_ = NULL;
	HistoryItem* hi;
	HistoryItem* _tmp9_;
	HistoryItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = history_item_new (uri);
	hi = _tmp0_;
	if (self->priv->current == NULL) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
		HistoryItem* _tmp4_;
		_tmp1_ = _history_item_ref0 (hi);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->items);
		self->priv->items = _tmp2_;
		_tmp3_ = _history_item_ref0 (self->priv->items);
		_tmp4_ = _tmp3_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp4_;
	} else {
		HistoryItem* _tmp5_;
		HistoryItem* _tmp6_;
		HistoryItem* _tmp7_;
		HistoryItem* _tmp8_;
		_tmp5_ = _history_item_ref0 (hi);
		_tmp6_ = _tmp5_;
		_history_item_unref0 (self->priv->current->next);
		self->priv->current->next = _tmp6_;
		_tmp7_ = _history_item_ref0 (self->priv->current);
		_tmp8_ = _tmp7_;
		_history_item_unref0 (hi->prev);
		hi->prev = _tmp8_;
	}
	_tmp9_ = _history_item_ref0 (hi);
	_tmp10_ = _tmp9_;
	_history_item_unref0 (self->priv->current);
	self->priv->current = _tmp10_;
	_history_item_unref0 (hi);
}


History* history_construct (GType object_type) {
	History* self = NULL;
	self = (History*) g_type_create_instance (object_type);
	return self;
}


History* history_new (void) {
	return history_construct (TYPE_HISTORY);
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
}


static void history_instance_init (History * self) {
	self->priv = HISTORY_GET_PRIVATE (self);
	self->priv->items = NULL;
	self->priv->current = NULL;
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = HISTORY (obj);
	_history_item_unref0 (self->priv->items);
	_history_item_unref0 (self->priv->current);
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _explorer_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	explorer_entry_changed (self, _sender);
}


static void _explorer_update_types_page_gtk_container_set_focus_child (GtkContainer* _sender, GtkWidget* widget, gpointer self) {
	explorer_update_types_page (self, widget);
}


static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	explorer_forward_clicked (self);
}


static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	explorer_back_clicked (self);
}


void explorer_show (Explorer* self) {
	Resources* _tmp0_ = NULL;
	Resources* _tmp1_;
	Resources* _tmp2_;
	GtkBuilder* _tmp4_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* window;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* entry;
	GObject* _tmp12_ = NULL;
	GObject* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeView* urisview;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkTreeView* relationshipsview;
	GObject* _tmp18_ = NULL;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkNotebook* _tmp24_;
	GtkNotebook* _tmp25_;
	GObject* _tmp26_ = NULL;
	GObject* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GObject* _tmp30_ = NULL;
	GObject* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_initable_new (TYPE_RESOURCES_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Resources", "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
	_tmp1_ = (Resources*) _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->tracker);
	self->priv->tracker = _tmp2_;
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GtkMessageDialog* _tmp3_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus\n%s", e->message);
		msg = g_object_ref_sink (_tmp3_);
		gtk_dialog_run ((GtkDialog*) msg);
		gtk_main_quit ();
		_g_object_unref0 (msg);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	gtk_builder_add_from_file (builder, SRCDIR EXPLORER_UI_FILE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		gtk_builder_add_from_file (builder, TRACKER_UI_DIR EXPLORER_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			GtkMessageDialog* _tmp5_ = NULL;
			GtkMessageDialog* msg;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI\n%s", e->message);
			msg = g_object_ref_sink (_tmp5_);
			gtk_dialog_run ((GtkDialog*) msg);
			gtk_main_quit ();
			_g_object_unref0 (msg);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = gtk_builder_get_object (builder, "explorer");
	_tmp8_ = _g_object_ref0 ((_tmp7_ = _tmp6_, GTK_IS_WINDOW (_tmp7_) ? ((GtkWindow*) _tmp7_) : NULL));
	window = _tmp8_;
	g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	_tmp9_ = gtk_builder_get_object (builder, "text-search");
	_tmp11_ = _g_object_ref0 ((_tmp10_ = _tmp9_, GTK_IS_ENTRY (_tmp10_) ? ((GtkEntry*) _tmp10_) : NULL));
	entry = _tmp11_;
	g_signal_connect ((GtkEditable*) entry, "changed", (GCallback) _explorer_entry_changed_gtk_editable_changed, self);
	_tmp12_ = gtk_builder_get_object (builder, "uris");
	_tmp14_ = _g_object_ref0 ((_tmp13_ = _tmp12_, GTK_IS_TREE_VIEW (_tmp13_) ? ((GtkTreeView*) _tmp13_) : NULL));
	urisview = _tmp14_;
	explorer_setup_uris (self, urisview);
	_tmp15_ = gtk_builder_get_object (builder, "relationshipsview");
	_tmp17_ = _g_object_ref0 ((_tmp16_ = _tmp15_, GTK_IS_TREE_VIEW (_tmp16_) ? ((GtkTreeView*) _tmp16_) : NULL));
	relationshipsview = _tmp17_;
	explorer_setup_relationships (self, relationshipsview);
	_tmp18_ = gtk_builder_get_object (builder, "current-object");
	_tmp20_ = _g_object_ref0 ((_tmp19_ = _tmp18_, GTK_IS_LABEL (_tmp19_) ? ((GtkLabel*) _tmp19_) : NULL));
	_tmp21_ = _tmp20_;
	_g_object_unref0 (self->priv->current_uri_label);
	self->priv->current_uri_label = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "types");
	_tmp24_ = _g_object_ref0 ((_tmp23_ = _tmp22_, GTK_IS_NOTEBOOK (_tmp23_) ? ((GtkNotebook*) _tmp23_) : NULL));
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->priv->types);
	self->priv->types = _tmp25_;
	g_signal_connect ((GtkContainer*) self->priv->types, "set-focus-child", (GCallback) _explorer_update_types_page_gtk_container_set_focus_child, self);
	_tmp26_ = gtk_builder_get_object (builder, "forward");
	_tmp28_ = _g_object_ref0 ((_tmp27_ = _tmp26_, GTK_IS_BUTTON (_tmp27_) ? ((GtkButton*) _tmp27_) : NULL));
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->priv->forward);
	self->priv->forward = _tmp29_;
	g_signal_connect (self->priv->forward, "clicked", (GCallback) _explorer_forward_clicked_gtk_button_clicked, self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, FALSE);
	_tmp30_ = gtk_builder_get_object (builder, "back");
	_tmp32_ = _g_object_ref0 ((_tmp31_ = _tmp30_, GTK_IS_BUTTON (_tmp31_) ? ((GtkButton*) _tmp31_) : NULL));
	_tmp33_ = _tmp32_;
	_g_object_unref0 (self->priv->back);
	self->priv->back = _tmp33_;
	g_signal_connect (self->priv->back, "clicked", (GCallback) _explorer_back_clicked_gtk_button_clicked, self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, FALSE);
	explorer_fetch_prefixes (self);
	gtk_widget_show_all ((GtkWidget*) window);
	_g_object_unref0 (relationshipsview);
	_g_object_unref0 (urisview);
	_g_object_unref0 (entry);
	_g_object_unref0 (window);
	_g_object_unref0 (builder);
}


static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	explorer_row_selected (self, _sender, path, column);
}


static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (urisview != NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp1_;
	gtk_tree_view_set_model (urisview, (GtkTreeModel*) self->priv->uris);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (urisview, -1, "URI", (GtkCellRenderer*) _tmp3_, "text", 0, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	g_signal_connect (urisview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
}


static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (relationshipsview != NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->relationships);
	self->priv->relationships = _tmp1_;
	gtk_tree_view_set_model (relationshipsview, (GtkTreeModel*) self->priv->relationships);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Relationship", (GtkCellRenderer*) _tmp3_, "text", 1, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Object", (GtkCellRenderer*) _tmp5_, "text", 2, NULL, NULL);
	_g_object_unref0 (_tmp5_);
	g_signal_connect (relationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
}


static GtkTreeView* explorer_setup_reverserelationships (Explorer* self) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* reverserelationships;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeView* reverserelationshipsview;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	reverserelationships = _tmp0_;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) reverserelationships);
	reverserelationshipsview = g_object_ref_sink (_tmp1_);
	gtk_tree_view_set_model (reverserelationshipsview, (GtkTreeModel*) reverserelationships);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Subject", (GtkCellRenderer*) _tmp3_, "text", 1, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Relationship", (GtkCellRenderer*) _tmp5_, "text", 2, NULL, NULL);
	_g_object_unref0 (_tmp5_);
	g_signal_connect (reverserelationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
	result = reverserelationshipsview;
	_g_object_unref0 (reverserelationships);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


static void explorer_fetch_prefixes (Explorer* self) {
	gchar* _tmp0_;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint _result__length2;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("SELECT ?s ?prefix WHERE { ?s a tracker:Namespace ; tracker:prefix ?pre" \
"fix }");
	query = _tmp0_;
	_tmp3_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp1_, &_tmp2_, &_inner_error_);
	_result_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar* _tmp5_;
				gchar* _namespace;
				gint _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp5_ = g_strdup (_result_[(i * _result__length2) + 0]);
				_namespace = _tmp5_;
				_tmp6_ = strlen (_namespace);
				_tmp7_ = string_substring (_namespace, (glong) 0, (glong) (_tmp6_ - 1));
				_tmp8_ = _tmp7_;
				_g_free0 (_namespace);
				_namespace = _tmp8_;
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->namespaces, _namespace, _result_[(i * _result__length2) + 1]);
				_g_free0 (_namespace);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


static void explorer_entry_changed (Explorer* self, GtkEditable* editable) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* query;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint _result__length2;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = gtk_entry_get_text (GTK_ENTRY (editable));
	_tmp1_ = g_strdup_printf ("SELECT ?s WHERE { ?s fts:match \"%s*\" }", _tmp0_);
	query = _tmp1_;
	_tmp4_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp2_, &_tmp3_, &_inner_error_);
	_result_ = _tmp4_;
	_result__length1 = _tmp2_;
	_result__length2 = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	gtk_list_store_clear (self->priv->uris);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _result_;
		s_collection_length1 = _result__length1 * _result__length2;
		for (s_it = 0; s_it < (_result__length1 * _result__length2); s_it = s_it + 1) {
			gchar* _tmp5_;
			gchar* s;
			_tmp5_ = g_strdup (s_collection[s_it]);
			s = _tmp5_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp6_ = {0};
				gtk_list_store_append (self->priv->uris, &_tmp6_);
				iter = _tmp6_;
				gtk_list_store_set (self->priv->uris, &iter, 0, s, -1, -1);
				_g_free0 (s);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gpointer _tmp2_ = NULL;
	gchar* prefix;
	gchar* relationship = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (uri, "#", 0);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->namespaces, parts[0]);
	prefix = (gchar*) _tmp2_;
	if (prefix != NULL) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_strjoin (":", prefix, parts[1], NULL);
		_tmp4_ = _tmp3_;
		_g_free0 (relationship);
		relationship = _tmp4_;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup (uri);
		_tmp6_ = _tmp5_;
		_g_free0 (relationship);
		relationship = _tmp6_;
	}
	result = relationship;
	_g_free0 (prefix);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void explorer_clear_types (Explorer* self) {
	gint _tmp0_;
	gint npages;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_notebook_get_n_pages (self->priv->types);
	npages = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < npages)) {
					break;
				}
				gtk_notebook_remove_page (self->priv->types, 0);
			}
		}
	}
}


static void explorer_update_types_page (Explorer* self, GtkWidget* w) {
	gint _tmp0_;
	gint page_num;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* sw;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* type;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_;
	GtkListStore* _tmp12_;
	GtkListStore* model;
	gchar* _tmp13_ = NULL;
	gchar* query;
	gint _tmp14_;
	gint _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint _result__length2;
	GtkTreeIter iter = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_notebook_get_current_page (self->priv->types);
	page_num = _tmp0_;
	if (page_num < 0) {
		return;
	}
	_tmp1_ = gtk_notebook_get_nth_page (self->priv->types, page_num);
	_tmp3_ = _g_object_ref0 ((_tmp2_ = _tmp1_, GTK_IS_SCROLLED_WINDOW (_tmp2_) ? ((GtkScrolledWindow*) _tmp2_) : NULL));
	sw = _tmp3_;
	_tmp4_ = gtk_notebook_get_tab_label (self->priv->types, (GtkWidget*) sw);
	_tmp6_ = gtk_label_get_text ((_tmp5_ = _tmp4_, GTK_IS_LABEL (_tmp5_) ? ((GtkLabel*) _tmp5_) : NULL));
	_tmp7_ = g_strdup (_tmp6_);
	type = _tmp7_;
	_tmp8_ = gtk_bin_get_child ((GtkBin*) sw);
	_tmp10_ = gtk_tree_view_get_model ((_tmp9_ = _tmp8_, GTK_IS_TREE_VIEW (_tmp9_) ? ((GtkTreeView*) _tmp9_) : NULL));
	_tmp12_ = _g_object_ref0 ((_tmp11_ = _tmp10_, GTK_IS_LIST_STORE (_tmp11_) ? ((GtkListStore*) _tmp11_) : NULL));
	model = _tmp12_;
	_tmp13_ = g_strdup_printf ("SELECT ?r WHERE { ?r rdfs:range %s }", type);
	query = _tmp13_;
	_tmp16_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp14_, &_tmp15_, &_inner_error_);
	_result_ = _tmp16_;
	_result__length1 = _tmp14_;
	_result__length2 = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		goto __catch5_g_error;
	}
	gtk_list_store_clear (model);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar* _tmp18_ = NULL;
				gchar* relation;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* query2;
				gint _tmp23_;
				gint _tmp24_;
				gchar** _tmp25_ = NULL;
				gchar** result2;
				gint result2_length1;
				gint result2_length2;
				if (!_tmp17_) {
					i++;
				}
				_tmp17_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp18_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
				relation = _tmp18_;
				_tmp19_ = history_current_uri (self->priv->history);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strdup_printf ("SELECT ?s WHERE { ?s %s <%s>}", relation, _tmp20_);
				query2 = (_tmp22_ = _tmp21_, _g_free0 (_tmp20_), _tmp22_);
				_tmp25_ = resources_SparqlQuery (self->priv->tracker, query2, &_tmp23_, &_tmp24_, &_inner_error_);
				result2 = _tmp25_;
				result2_length1 = _tmp23_;
				result2_length2 = _tmp24_;
				if (_inner_error_ != NULL) {
					_g_free0 (query2);
					_g_free0 (relation);
					_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
					_g_free0 (query);
					goto __catch5_g_error;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp26_;
						_tmp26_ = TRUE;
						while (TRUE) {
							gchar* _tmp27_ = NULL;
							gchar* subject;
							GtkTreeIter _tmp28_ = {0};
							if (!_tmp26_) {
								j++;
							}
							_tmp26_ = FALSE;
							if (!(j < result2_length1)) {
								break;
							}
							_tmp27_ = explorer_subst_prefix (self, result2[(j * result2_length2) + 0]);
							subject = _tmp27_;
							gtk_list_store_append (model, &_tmp28_);
							iter = _tmp28_;
							gtk_list_store_set (model, &iter, 0, result2[(j * result2_length2) + 0], -1, -1);
							gtk_list_store_set (model, &iter, 1, subject, -1, -1);
							gtk_list_store_set (model, &iter, 2, relation, -1, -1);
							_g_free0 (subject);
						}
					}
				}
				result2 = (_vala_array_free (result2, result2_length1 * result2_length2, (GDestroyNotify) g_free), NULL);
				_g_free0 (query2);
				_g_free0 (relation);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		_g_free0 (type);
		_g_object_unref0 (sw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (model);
	_g_free0 (type);
	_g_object_unref0 (sw);
}


static void explorer_add_type (Explorer* self, const gchar* type) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* tab_label;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* child;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeView* tv;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (type);
	tab_label = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	child = g_object_ref_sink (_tmp1_);
	_tmp2_ = explorer_setup_reverserelationships (self);
	tv = _tmp2_;
	gtk_container_add ((GtkContainer*) child, (GtkWidget*) tv);
	gtk_notebook_append_page (self->priv->types, (GtkWidget*) child, (GtkWidget*) tab_label);
	gtk_widget_show_all ((GtkWidget*) child);
	_g_object_unref0 (tv);
	_g_object_unref0 (child);
	_g_object_unref0 (tab_label);
}


static void explorer_set_current_uri (Explorer* self, const gchar* uri) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	history_add (self->priv->history, uri);
	explorer_update_pane (self);
}


static void explorer_forward_clicked (Explorer* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_forward (self->priv->history);
	if (_tmp0_) {
		explorer_update_pane (self);
	}
}


static void explorer_back_clicked (Explorer* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_back (self->priv->history);
	if (_tmp0_) {
		explorer_update_pane (self);
	}
}


static void explorer_update_pane (Explorer* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* query;
	GtkTreeIter iter = {0};
	gint _tmp10_;
	gint _tmp11_;
	gchar** _tmp12_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint _result__length2;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_can_go_forward (self->priv->history);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, _tmp0_);
	_tmp1_ = history_can_go_back (self->priv->history);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, _tmp1_);
	_tmp2_ = history_current_uri (self->priv->history);
	_tmp3_ = _tmp2_;
	_tmp4_ = explorer_subst_prefix (self, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (self->priv->current_uri_label, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = history_current_uri (self->priv->history);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("SELECT ?r ?o  WHERE { <%s> ?r ?o }", _tmp7_);
	query = (_tmp9_ = _tmp8_, _g_free0 (_tmp7_), _tmp9_);
	_tmp12_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp10_, &_tmp11_, &_inner_error_);
	_result_ = _tmp12_;
	_result__length1 = _tmp10_;
	_result__length2 = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		goto __catch6_g_error;
	}
	gtk_list_store_clear (self->priv->relationships);
	explorer_clear_types (self);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gchar* _tmp14_ = NULL;
				gchar* relationship;
				gchar* _tmp15_ = NULL;
				gchar* obj;
				GtkTreeIter _tmp16_ = {0};
				gboolean _tmp17_ = FALSE;
				if (!_tmp13_) {
					i++;
				}
				_tmp13_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp14_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
				relationship = _tmp14_;
				_tmp15_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 1]);
				obj = _tmp15_;
				gtk_list_store_append (self->priv->relationships, &_tmp16_);
				iter = _tmp16_;
				gtk_list_store_set (self->priv->relationships, &iter, 0, _result_[(i * _result__length2) + 1], -1, -1);
				gtk_list_store_set (self->priv->relationships, &iter, 1, relationship, -1, -1);
				gtk_list_store_set (self->priv->relationships, &iter, 2, obj, -1, -1);
				if (g_strcmp0 (relationship, "rdf:type") == 0) {
					_tmp17_ = g_strcmp0 (obj, "rdfs:Resource") != 0;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					explorer_add_type (self, obj);
				}
				_g_free0 (obj);
				_g_free0 (relationship);
			}
		}
	}
	_tmp18_ = gtk_notebook_get_n_pages (self->priv->types);
	gtk_notebook_set_current_page (self->priv->types, _tmp18_ - 1);
	explorer_update_types_page (self, NULL);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = gtk_tree_view_get_model (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	gtk_tree_model_get_iter (model, &_tmp2_, path);
	iter = _tmp2_;
	gtk_tree_model_get (model, &iter, 0, &uri, -1);
	explorer_set_current_uri (self, uri);
	_g_object_unref0 (model);
}


Explorer* explorer_construct (GType object_type) {
	Explorer* self = NULL;
	self = (Explorer*) g_type_create_instance (object_type);
	return self;
}


Explorer* explorer_new (void) {
	return explorer_construct (TYPE_EXPLORER);
}


static void value_explorer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_explorer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		explorer_unref (value->data[0].v_pointer);
	}
}


static void value_explorer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = explorer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_explorer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_explorer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Explorer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = explorer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_explorer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Explorer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = explorer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExplorer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPLORER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_explorer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER), NULL);
	return value->data[0].v_pointer;
}


void value_set_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		explorer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		explorer_unref (old);
	}
}


void value_take_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		explorer_unref (old);
	}
}


static void explorer_class_init (ExplorerClass * klass) {
	explorer_parent_class = g_type_class_peek_parent (klass);
	EXPLORER_CLASS (klass)->finalize = explorer_finalize;
	g_type_class_add_private (klass, sizeof (ExplorerPrivate));
}


static void explorer_instance_init (Explorer * self) {
	History* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self->priv = EXPLORER_GET_PRIVATE (self);
	_tmp0_ = history_new ();
	self->priv->history = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->priv->namespaces = _tmp1_;
	self->ref_count = 1;
}


static void explorer_finalize (Explorer* obj) {
	Explorer * self;
	self = EXPLORER (obj);
	_g_object_unref0 (self->priv->tracker);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->relationships);
	_g_object_unref0 (self->priv->current_uri_label);
	_g_object_unref0 (self->priv->namespaces);
	_g_object_unref0 (self->priv->types);
	_g_object_unref0 (self->priv->forward);
	_g_object_unref0 (self->priv->back);
}


GType explorer_get_type (void) {
	static volatile gsize explorer_type_id__volatile = 0;
	if (g_once_init_enter (&explorer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_explorer_init, value_explorer_free_value, value_explorer_copy_value, value_explorer_peek_pointer, "p", value_explorer_collect_value, "p", value_explorer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExplorerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) explorer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Explorer), 0, (GInstanceInitFunc) explorer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType explorer_type_id;
		explorer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Explorer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&explorer_type_id__volatile, explorer_type_id);
	}
	return explorer_type_id__volatile;
}


gpointer explorer_ref (gpointer instance) {
	Explorer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void explorer_unref (gpointer instance) {
	Explorer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPLORER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Explorer* _tmp0_ = NULL;
	Explorer* s;
	gtk_init (&args_length1, &args);
	_tmp0_ = explorer_new ();
	s = _tmp0_;
	explorer_show (s);
	gtk_main ();
	result = 0;
	_explorer_unref0 (s);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



