/* tracker-utils.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))



#define secs_per_day ((60 * 60) * 24)
gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void uri_launch (const gchar* uri);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
#line 24 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 24 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	iter = _tmp2_;
#line 29 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = model;
#line 29 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = iter;
#line 29 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = col;
#line 29 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get (_tmp3_, &_tmp4_, _tmp5_, &uri, -1);
#line 31 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_strdup (uri);
#line 31 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp6_;
#line 31 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 94 "tracker-utils.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 1055 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1055 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1056 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1056 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 1056 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 1056 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1058 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1058 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 121 "tracker-utils.c"
		gchar* _tmp4_;
#line 1059 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1059 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1059 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 129 "tracker-utils.c"
	} else {
#line 1061 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = -1;
#line 1061 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 135 "tracker-utils.c"
	}
}


void uri_launch (const gchar* uri) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (uri != NULL);
#line 37 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = uri;
#line 37 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = string_index_of (_tmp0_, "://", 0);
#line 37 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp1_ < 1) {
#line 152 "tracker-utils.c"
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_ = NULL;
		gchar** command;
		gint command_length1;
		gint _command_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		GPid child_pid = 0;
		gchar** _tmp7_ = NULL;
		gchar** argv;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GPid _tmp22_;
#line 38 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = uri;
#line 38 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
#line 38 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		command = _tmp4_;
#line 38 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		command_length1 = _vala_array_length (_tmp3_);
#line 38 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_command_size_ = command_length1;
#line 39 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = command;
#line 39 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5__length1 = command_length1;
#line 39 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = _tmp5_[0];
#line 39 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:39: Attempting to spawn_async() '%s'", _tmp6_);
#line 42 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 42 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		argv = _tmp7_;
#line 42 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		argv_length1 = 1;
#line 42 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_argv_size_ = argv_length1;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = argv;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8__length1 = argv_length1;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp9_ = command;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp9__length1 = command_length1;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _tmp9_[0];
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp8_[0]);
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_[0] = _tmp11_;
#line 43 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp12_ = _tmp8_[0];
#line 219 "tracker-utils.c"
		{
			gchar** _tmp13_;
			gint _tmp13__length1;
			GPid _tmp14_ = 0;
#line 46 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = argv;
#line 46 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13__length1 = argv_length1;
#line 46 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_spawn_async ("/usr/bin", _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp14_, &_inner_error_);
#line 46 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			child_pid = _tmp14_;
#line 46 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_inner_error_ != NULL) {
#line 234 "tracker-utils.c"
				goto __catch23_g_error;
			}
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError* e = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			GError* _tmp17_;
			gint _tmp18_;
			GError* _tmp19_;
			gint _tmp20_;
			const gchar* _tmp21_ = NULL;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = command;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15__length1 = command_length1;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp16_ = _tmp15_[0];
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = e;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp18_ = _tmp17_->code;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp19_ = e;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp20_ = _tmp19_->code;
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = g_strerror (_tmp20_);
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:53: Could not launch '%s', %d->%s", _tmp16_, _tmp18_, _tmp21_);
#line 54 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 54 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return;
#line 280 "tracker-utils.c"
		}
		__finally23:
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 45 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return;
#line 295 "tracker-utils.c"
		}
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = child_pid;
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:57: Launched application with PID:%d", (gint) _tmp22_);
#line 58 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return;
#line 307 "tracker-utils.c"
	}
	{
		const gchar* _tmp23_;
		const gchar* _tmp24_;
#line 62 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp23_ = uri;
#line 62 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:62: Attempting to launch application for uri:'%s'", _tmp23_);
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp24_ = uri;
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_app_info_launch_default_for_uri (_tmp24_, NULL, &_inner_error_);
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 322 "tracker-utils.c"
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = e;
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = _tmp25_->message;
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = g_strconcat ("Could not launch application: ", _tmp26_, NULL);
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = _tmp27_;
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:65: %s", _tmp28_);
#line 65 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp28_);
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 352 "tracker-utils.c"
	}
	__finally24:
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return;
#line 363 "tracker-utils.c"
	}
}


void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* uri;
#line 69 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 69 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 70 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 71 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:71: Selected uri:'%s'", uri);
#line 73 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	uri_launch (uri);
#line 69 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 394 "tracker-utils.c"
}


void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col) {
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* uri;
	GFile* _tmp4_ = NULL;
	GFile* f;
	GFile* _tmp5_ = NULL;
	GFile* p;
	gchar* _tmp6_ = NULL;
	gchar* parent_uri;
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 78 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:78: Selected uri:'%s'", uri);
#line 80 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = g_file_new_for_uri (uri);
#line 80 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	f = _tmp4_;
#line 81 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = g_file_get_parent (f);
#line 81 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	p = _tmp5_;
#line 82 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_file_get_uri (p);
#line 82 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	parent_uri = _tmp6_;
#line 84 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:84: Parent uri:'%s'", parent_uri);
#line 85 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	uri_launch (parent_uri);
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (parent_uri);
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (p);
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (f);
#line 76 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 450 "tracker-utils.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 2444 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2445 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2445 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2445 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2445 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2446 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2446 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2446 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2446 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2447 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 496 "tracker-utils.c"
}


gchar* tracker_time_format_from_iso8601 (const gchar* s) {
	gchar* result = NULL;
	struct tm t = {0};
	const gchar* _tmp0_;
	GTimeVal tv_now = {0};
	GTimeVal tv_then = {0};
	const gchar* _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
	GTimeVal _tmp4_;
	glong _tmp5_;
	glong diff_sec;
	glong _tmp6_;
	glong diff_days;
	glong _tmp7_;
	glong _tmp8_ = 0L;
	glong diff_days_abs;
	glong _tmp9_;
	glong _tmp12_;
#line 88 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 89 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	memset (&t, 0, sizeof (struct tm));
#line 90 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = s;
#line 90 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	strptime (_tmp0_, "%FT%T", &t);
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 93 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 95 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_then);
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = s;
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_time_val_from_iso8601 (_tmp1_, &tv_then);
#line 98 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = tv_now;
#line 98 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 98 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = tv_then;
#line 98 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = _tmp4_.tv_sec;
#line 98 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_sec = _tmp3_ - _tmp5_;
#line 99 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = diff_sec;
#line 99 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days = _tmp6_ / secs_per_day;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = diff_days;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = labs (_tmp7_);
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days_abs = _tmp8_;
#line 105 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = diff_days_abs;
#line 105 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp9_ > ((glong) 7)) {
#line 561 "tracker-utils.c"
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 108 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _ ("%x");
#line 108 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_time_format (&t, _tmp10_);
#line 108 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp11_;
#line 108 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 572 "tracker-utils.c"
	}
#line 111 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = diff_days_abs;
#line 111 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp12_ == ((glong) 0)) {
#line 578 "tracker-utils.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp13_ = _ ("Today");
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp14_;
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 589 "tracker-utils.c"
	} else {
		gboolean future;
		glong _tmp15_;
		glong _tmp16_;
#line 114 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		future = FALSE;
#line 116 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = diff_days;
#line 116 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp15_ < ((glong) 0)) {
#line 117 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			future = TRUE;
#line 602 "tracker-utils.c"
		}
#line 119 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = diff_days;
#line 119 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp16_ <= ((glong) 1)) {
#line 608 "tracker-utils.c"
			gboolean _tmp17_;
#line 120 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = future;
#line 120 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp17_) {
#line 614 "tracker-utils.c"
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp18_ = _ ("Tomorrow");
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp19_ = g_strdup (_tmp18_);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp19_;
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 625 "tracker-utils.c"
			} else {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
#line 123 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp20_ = _ ("Yesterday");
#line 123 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp21_ = g_strdup (_tmp20_);
#line 123 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp21_;
#line 123 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 637 "tracker-utils.c"
			}
		} else {
			gboolean _tmp22_;
#line 125 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp22_ = future;
#line 125 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp22_) {
#line 645 "tracker-utils.c"
				glong _tmp23_;
				const gchar* _tmp24_ = NULL;
				glong _tmp25_;
				gchar* _tmp26_ = NULL;
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = diff_days_abs;
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = ngettext ("%ld day from now", "%ld days from now", (gulong) _tmp23_);
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp25_ = diff_days_abs;
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp26_;
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 662 "tracker-utils.c"
			} else {
				glong _tmp27_;
				const gchar* _tmp28_ = NULL;
				glong _tmp29_;
				gchar* _tmp30_ = NULL;
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp27_ = diff_days_abs;
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp28_ = ngettext ("%ld day ago", "%ld days ago", (gulong) _tmp27_);
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp29_ = diff_days_abs;
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp30_ = g_strdup_printf (_tmp28_, _tmp29_);
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp30_;
#line 130 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 680 "tracker-utils.c"
			}
		}
	}
}


gchar* tracker_time_format_from_seconds (const gchar* seconds_str) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gdouble seconds;
	gdouble total = 0.0;
	gint d = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble _tmp2_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GString* _tmp12_;
	GString* output;
	gint _tmp13_;
	gint _tmp18_;
	gint _tmp23_;
	const gchar* _tmp31_ = NULL;
	gint _tmp32_;
	GString* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	GString* _tmp38_;
	gssize _tmp39_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* str;
	const gchar* _tmp45_;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
#line 136 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (seconds_str != NULL, NULL);
#line 137 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = seconds_str;
#line 137 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = atoi (_tmp0_);
#line 137 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	seconds = (gdouble) _tmp1_;
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = seconds;
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp2_ == 0.0) {
#line 738 "tracker-utils.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = _ ("Less than one second");
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp4_;
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 749 "tracker-utils.c"
	}
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = seconds;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp5_;
#line 146 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = total;
#line 146 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	s = ((gint) _tmp6_) % 60;
#line 147 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = total;
#line 147 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp7_ / 60;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = total;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	m = ((gint) _tmp8_) % 60;
#line 149 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = total;
#line 149 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp9_ / 60;
#line 150 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp10_ = total;
#line 150 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	h = ((gint) _tmp10_) % 24;
#line 151 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp11_ = total;
#line 151 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	d = ((gint) _tmp11_) / 24;
#line 153 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = g_string_new ("");
#line 153 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	output = _tmp12_;
#line 155 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp13_ = d;
#line 155 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp13_ > 0) {
#line 787 "tracker-utils.c"
		GString* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = output;
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = d;
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = g_strdup_printf (" %dd", _tmp15_);
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp17_ = _tmp16_;
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp17_);
#line 804 "tracker-utils.c"
	}
#line 159 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp18_ = h;
#line 159 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp18_ > 0) {
#line 810 "tracker-utils.c"
		GString* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp19_ = output;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp20_ = h;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp21_ = g_strdup_printf (" %.2d", _tmp20_);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = _tmp21_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp19_, _tmp22_);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp22_);
#line 827 "tracker-utils.c"
	}
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp23_ = m;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp23_ > 0) {
#line 833 "tracker-utils.c"
		const gchar* _tmp24_ = NULL;
		gint _tmp25_;
		GString* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = h;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp25_ > 0) {
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = ":";
#line 847 "tracker-utils.c"
		} else {
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = "";
#line 851 "tracker-utils.c"
		}
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = output;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = _tmp24_;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = m;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp29_ = g_strdup_printf ("%s%.2d", _tmp27_, _tmp28_);
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp30_ = _tmp29_;
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp26_, _tmp30_);
#line 164 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp30_);
#line 867 "tracker-utils.c"
	}
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp32_ = m;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp32_ > 0) {
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp31_ = ":";
#line 875 "tracker-utils.c"
	} else {
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp31_ = "0:";
#line 879 "tracker-utils.c"
	}
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp33_ = output;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp34_ = _tmp31_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp35_ = s;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp36_ = g_strdup_printf ("%s%.2d", _tmp34_, _tmp35_);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp37_ = _tmp36_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_string_append (_tmp33_, _tmp37_);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (_tmp37_);
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp38_ = output;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp39_ = _tmp38_->len;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp39_ < ((gssize) 1)) {
#line 901 "tracker-utils.c"
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp40_ = _ ("Less than one second");
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp41_ = g_strdup (_tmp40_);
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp41_;
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_string_free0 (output);
#line 171 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 914 "tracker-utils.c"
	}
#line 174 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp42_ = output;
#line 174 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp43_ = _tmp42_->str;
#line 174 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp44_ = g_strdup (_tmp43_);
#line 174 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	str = _tmp44_;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp45_ = str;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp46_ = g_strchug (_tmp45_);
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp47_;
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (str);
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_string_free0 (output);
#line 176 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 938 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 182 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 945 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* pixbuf;
	gboolean _tmp3_;
	GFile* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GdkPixbuf* _tmp50_;
	GtkIconTheme* _tmp51_;
	gint _tmp52_;
	GdkPixbuf* _tmp53_ = NULL;
	GError * _inner_error_ = NULL;
#line 179 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 179 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = filename;
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 181 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	file = _tmp1_;
#line 182 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = _g_object_ref0 (GDK_IS_PIXBUF (NULL) ? ((GdkPixbuf*) NULL) : NULL);
#line 182 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp2_;
#line 184 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = is_image;
#line 184 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp3_) {
#line 982 "tracker-utils.c"
		GdkPixbuf* _tmp16_;
		{
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp4_ = file;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = g_file_get_path (_tmp4_);
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp6_ = _tmp5_;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp7_ = size;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp8_ = size;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp9_ = gdk_pixbuf_new_from_file_at_size (_tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp10_ = _tmp9_;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp6_);
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp11_ = _tmp10_;
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_inner_error_ != NULL) {
#line 1013 "tracker-utils.c"
				goto __catch25_g_error;
			}
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 186 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			pixbuf = _tmp11_;
#line 1020 "tracker-utils.c"
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp12_ = e;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = _tmp12_->message;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp14_ = g_strconcat ("Error loading icon pixbuf: ", _tmp13_, NULL);
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = _tmp14_;
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:188: %s", _tmp15_);
#line 188 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp15_);
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1048 "tracker-utils.c"
		}
		__finally25:
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 185 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1063 "tracker-utils.c"
		}
#line 191 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = pixbuf;
#line 191 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp16_ != NULL) {
#line 192 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			result = pixbuf;
#line 192 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 192 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return result;
#line 1075 "tracker-utils.c"
		}
	}
#line 196 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp17_ = file;
#line 196 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp18_ = g_file_query_exists (_tmp17_, NULL);
#line 196 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp18_) {
#line 1084 "tracker-utils.c"
		{
			GFile* _tmp19_;
			GFileInfo* _tmp20_ = NULL;
			GFileInfo* file_info;
			GFileInfo* _tmp21_;
#line 198 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp19_ = file;
#line 198 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp20_ = g_file_query_info (_tmp19_, "standard::icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 198 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			file_info = _tmp20_;
#line 198 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_inner_error_ != NULL) {
#line 1098 "tracker-utils.c"
				goto __catch26_g_error;
			}
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = file_info;
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp21_ != NULL) {
#line 1105 "tracker-utils.c"
				GFileInfo* _tmp22_;
				GIcon* _tmp23_ = NULL;
				GIcon* _tmp24_;
				GIcon* icon;
#line 203 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp22_ = file_info;
#line 203 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = g_file_info_get_icon (_tmp22_);
#line 203 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 203 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				icon = _tmp24_;
#line 1118 "tracker-utils.c"
				{
					GIcon* _tmp25_;
#line 206 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp25_ = icon;
#line 206 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					if (G_IS_FILE_ICON (_tmp25_)) {
#line 1125 "tracker-utils.c"
						GIcon* _tmp26_;
						GFile* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						GdkPixbuf* _tmp30_;
						GdkPixbuf* _tmp31_;
						GdkPixbuf* _tmp32_;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp26_ = icon;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp27_ = g_file_icon_get_file (G_FILE_ICON (_tmp26_));
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = g_file_get_path (_tmp27_);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp29_ = _tmp28_;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp30_ = gdk_pixbuf_new_from_file (_tmp29_, &_inner_error_);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp31_ = _tmp30_;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_g_free0 (_tmp29_);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp32_ = _tmp31_;
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						if (_inner_error_ != NULL) {
#line 1151 "tracker-utils.c"
							goto __catch27_g_error;
						}
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (pixbuf);
#line 207 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						pixbuf = _tmp32_;
#line 1158 "tracker-utils.c"
					} else {
						GIcon* _tmp33_;
#line 208 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp33_ = icon;
#line 208 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						if (G_IS_THEMED_ICON (_tmp33_)) {
#line 1165 "tracker-utils.c"
							GtkIconTheme* _tmp34_;
							GIcon* _tmp35_;
							gchar** _tmp36_;
							gchar** _tmp37_ = NULL;
							const gchar* _tmp38_;
							gint _tmp39_;
							GdkPixbuf* _tmp40_ = NULL;
							GdkPixbuf* _tmp41_;
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp34_ = theme;
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp35_ = icon;
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = _tmp36_ = g_themed_icon_get_names (G_THEMED_ICON (_tmp35_));
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp38_ = _tmp37_[0];
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp39_ = size;
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp40_ = gtk_icon_theme_load_icon (_tmp34_, _tmp38_, _tmp39_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp41_ = _tmp40_;
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							if (_inner_error_ != NULL) {
#line 1190 "tracker-utils.c"
								goto __catch27_g_error;
							}
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (pixbuf);
#line 209 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							pixbuf = _tmp41_;
#line 1197 "tracker-utils.c"
						}
					}
				}
				goto __finally27;
				__catch27_g_error:
				{
					GError* e = NULL;
					GError* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					e = _inner_error_;
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_inner_error_ = NULL;
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp42_ = e;
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp43_ = _tmp42_->message;
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp44_ = g_strconcat ("Error loading icon pixbuf: ", _tmp43_, NULL);
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp45_ = _tmp44_;
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					g_warning ("tracker-utils.vala:212: %s", _tmp45_);
#line 212 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_free0 (_tmp45_);
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_error_free0 (e);
#line 1227 "tracker-utils.c"
				}
				__finally27:
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				if (_inner_error_ != NULL) {
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (icon);
#line 205 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (file_info);
#line 1236 "tracker-utils.c"
					goto __catch26_g_error;
				}
#line 202 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_g_object_unref0 (icon);
#line 1241 "tracker-utils.c"
			}
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file_info);
#line 1245 "tracker-utils.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
			GError* e = NULL;
			GError* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp46_ = e;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp47_ = _tmp46_->message;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp48_ = g_strconcat ("Error looking up file for pixbuf: ", _tmp47_, NULL);
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp49_ = _tmp48_;
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:216: %s", _tmp49_);
#line 216 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp49_);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1273 "tracker-utils.c"
		}
		__finally26:
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1288 "tracker-utils.c"
		}
	}
#line 220 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp50_ = pixbuf;
#line 220 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp50_ != NULL) {
#line 221 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = pixbuf;
#line 221 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (file);
#line 221 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 1301 "tracker-utils.c"
	}
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp51_ = theme;
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp52_ = size;
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp53_ = tracker_pixbuf_new_from_name (_tmp51_, "text-x-generic", _tmp52_);
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp53_;
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (pixbuf);
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (file);
#line 224 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1317 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
#line 227 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 227 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = _g_object_ref0 (GDK_IS_PIXBUF (NULL) ? ((GdkPixbuf*) NULL) : NULL);
#line 229 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp0_;
#line 1334 "tracker-utils.c"
	{
		GtkIconTheme* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_;
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp1_ = theme;
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = name;
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = size;
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = gtk_icon_theme_load_icon (_tmp1_, _tmp2_, _tmp3_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = _tmp4_;
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 1353 "tracker-utils.c"
			goto __catch28_g_error;
		}
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 232 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		pixbuf = _tmp5_;
#line 1360 "tracker-utils.c"
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 234 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = name;
#line 234 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = e;
#line 234 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = _tmp7_->message;
#line 234 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:234: Could not load default icon pixbuf from theme " \
"for '%s': %s", _tmp6_, _tmp8_);
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 1383 "tracker-utils.c"
	}
	__finally28:
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_inner_error_ != NULL) {
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 231 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return NULL;
#line 1396 "tracker-utils.c"
	}
#line 237 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = pixbuf;
#line 237 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1402 "tracker-utils.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



