/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


#define TRACKER_TYPE_TURTLE_WRITER (tracker_turtle_writer_get_type ())
#define TRACKER_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriter))
#define TRACKER_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))
#define TRACKER_IS_TURTLE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_IS_TURTLE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_WRITER))
#define TRACKER_TURTLE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterClass))

typedef struct _TrackerTurtleWriter TrackerTurtleWriter;
typedef struct _TrackerTurtleWriterClass TrackerTurtleWriterClass;
typedef struct _TrackerTurtleWriterPrivate TrackerTurtleWriterPrivate;

#define TRACKER_TURTLE_WRITER_TYPE_STATE (tracker_turtle_writer_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TrackerTurtleWriter {
	GObject parent_instance;
	TrackerTurtleWriterPrivate * priv;
};

struct _TrackerTurtleWriterClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_TURTLE_WRITER_STATE_SUBJECT,
	TRACKER_TURTLE_WRITER_STATE_PREDICATE,
	TRACKER_TURTLE_WRITER_STATE_OBJECT,
	TRACKER_TURTLE_WRITER_STATE_BLANK
} TrackerTurtleWriterState;

struct _TrackerTurtleWriterPrivate {
	GDataOutputStream* stream;
	TrackerTurtleWriterState* states;
	gint states_length1;
	gint states_size;
	GError* err;
};


static gpointer tracker_turtle_writer_parent_class = NULL;

GType tracker_turtle_writer_get_type (void);
static GType tracker_turtle_writer_state_get_type (void);
#define TRACKER_TURTLE_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_TURTLE_WRITER, TrackerTurtleWriterPrivate))
enum  {
	TRACKER_TURTLE_WRITER_DUMMY_PROPERTY
};
TrackerTurtleWriter* tracker_turtle_writer_new (GOutputStream* stream);
TrackerTurtleWriter* tracker_turtle_writer_construct (GType object_type, GOutputStream* stream);
static void tracker_turtle_writer_append (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_subject (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_subject_iri (TrackerTurtleWriter* self, const char* iri);
static TrackerTurtleWriterState tracker_turtle_writer_get_state (TrackerTurtleWriter* self);
static void _vala_array_add13 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
void tracker_turtle_writer_predicate (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_predicate_iri (TrackerTurtleWriter* self, const char* iri);
static void _vala_array_add14 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
void tracker_turtle_writer_object (TrackerTurtleWriter* self, const char* s);
void tracker_turtle_writer_object_iri (TrackerTurtleWriter* self, const char* iri);
static void _vala_array_add15 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
static void _vala_array_add16 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
void tracker_turtle_writer_object_string (TrackerTurtleWriter* self, const char* literal);
void tracker_turtle_writer_object_boolean (TrackerTurtleWriter* self, gboolean literal);
void tracker_turtle_writer_object_int64 (TrackerTurtleWriter* self, gint64 literal);
void tracker_turtle_writer_object_date (TrackerTurtleWriter* self, time_t* literal);
static void _vala_array_add17 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
void tracker_turtle_writer_object_blank_open (TrackerTurtleWriter* self);
static void _vala_array_add18 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value);
void tracker_turtle_writer_object_blank_close (TrackerTurtleWriter* self);
void tracker_turtle_writer_close (TrackerTurtleWriter* self, GError** error);
static void tracker_turtle_writer_finalize (GObject* obj);
static void tracker_turtle_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);




static GType tracker_turtle_writer_state_get_type (void) {
	static GType tracker_turtle_writer_state_type_id = 0;
	if (G_UNLIKELY (tracker_turtle_writer_state_type_id == 0)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_WRITER_STATE_SUBJECT, "TRACKER_TURTLE_WRITER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_WRITER_STATE_PREDICATE, "TRACKER_TURTLE_WRITER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_WRITER_STATE_OBJECT, "TRACKER_TURTLE_WRITER_STATE_OBJECT", "object"}, {TRACKER_TURTLE_WRITER_STATE_BLANK, "TRACKER_TURTLE_WRITER_STATE_BLANK", "blank"}, {0, NULL, NULL}};
		tracker_turtle_writer_state_type_id = g_enum_register_static ("TrackerTurtleWriterState", values);
	}
	return tracker_turtle_writer_state_type_id;
}


TrackerTurtleWriter* tracker_turtle_writer_construct (GType object_type, GOutputStream* stream) {
	TrackerTurtleWriter * self;
	GDataOutputStream* _tmp0_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (TrackerTurtleWriter*) g_object_new (object_type, NULL);
	self->priv->stream = (_tmp0_ = g_data_output_stream_new (stream), _g_object_unref0 (self->priv->stream), _tmp0_);
	return self;
}


TrackerTurtleWriter* tracker_turtle_writer_new (GOutputStream* stream) {
	return tracker_turtle_writer_construct (TRACKER_TYPE_TURTLE_WRITER, stream);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void tracker_turtle_writer_append (TrackerTurtleWriter* self, const char* s) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_inner_error_ = NULL;
	if (self->priv->err != NULL) {
		return;
	}
	{
		g_data_output_stream_put_string (self->priv->stream, s, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GError* _tmp0_;
			self->priv->err = (_tmp0_ = _g_error_copy0 ((GError*) e), _g_error_free0 (self->priv->err), _tmp0_);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


void tracker_turtle_writer_subject_iri (TrackerTurtleWriter* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_turtle_writer_subject (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add13 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_subject (TrackerTurtleWriter* self, const char* s) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail ((self->priv->states_length1 == 0) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT));
	_tmp0_ = FALSE;
	if (self->priv->states_length1 > 0) {
		_tmp0_ = tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		tracker_turtle_writer_append (self, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	tracker_turtle_writer_append (self, s);
	_vala_array_add13 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_SUBJECT);
}


void tracker_turtle_writer_predicate_iri (TrackerTurtleWriter* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_turtle_writer_predicate (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add14 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_predicate (TrackerTurtleWriter* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (((tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_SUBJECT) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT)) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_BLANK));
	if (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT) {
		tracker_turtle_writer_append (self, " ;");
		self->priv->states_length1 = self->priv->states_length1 - 2;
	}
	tracker_turtle_writer_append (self, " ");
	tracker_turtle_writer_append (self, s);
	_vala_array_add14 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_PREDICATE);
}


void tracker_turtle_writer_object_iri (TrackerTurtleWriter* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_turtle_writer_object (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add15 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_object (TrackerTurtleWriter* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail ((tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_PREDICATE) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT));
	if (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT) {
		tracker_turtle_writer_append (self, " ,");
		self->priv->states_length1--;
	}
	tracker_turtle_writer_append (self, " ");
	tracker_turtle_writer_append (self, s);
	_vala_array_add15 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_OBJECT);
}


static void _vala_array_add16 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_object_string (TrackerTurtleWriter* self, const char* literal) {
	gchar* p;
	g_return_if_fail (self != NULL);
	g_return_if_fail (literal != NULL);
	g_return_if_fail ((tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_PREDICATE) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT));
	if (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT) {
		tracker_turtle_writer_append (self, " ,");
		self->priv->states_length1--;
	}
	tracker_turtle_writer_append (self, " \"");
	p = literal;
	while (TRUE) {
		gsize len;
		char* _tmp0_;
		if (!((*p) != '\0')) {
			break;
		}
		len = strcspn ((const char*) p, "\t\n\r\"\\");
		tracker_turtle_writer_append (self, _tmp0_ = g_strndup ((const char*) p, (gsize) ((glong) len)));
		_g_free0 (_tmp0_);
		p = p + len;
		switch (*p) {
			case '\t':
			{
				tracker_turtle_writer_append (self, "\\t");
				break;
			}
			case '\n':
			{
				tracker_turtle_writer_append (self, "\\n");
				break;
			}
			case '\r':
			{
				tracker_turtle_writer_append (self, "\\r");
				break;
			}
			case '"':
			{
				tracker_turtle_writer_append (self, "\\\"");
				break;
			}
			case '\\':
			{
				tracker_turtle_writer_append (self, "\\\\");
				break;
			}
			default:
			{
				continue;
			}
		}
		p++;
	}
	tracker_turtle_writer_append (self, "\"");
	_vala_array_add16 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_OBJECT);
}


void tracker_turtle_writer_object_boolean (TrackerTurtleWriter* self, gboolean literal) {
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	if (literal) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	tracker_turtle_writer_object (self, _tmp0_);
}


void tracker_turtle_writer_object_int64 (TrackerTurtleWriter* self, gint64 literal) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	tracker_turtle_writer_object (self, _tmp0_ = g_strdup_printf ("%lli", literal));
	_g_free0 (_tmp0_);
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	gmtime_r (&time, &_result_);
	*result = _result_;
	return;
}


void tracker_turtle_writer_object_date (TrackerTurtleWriter* self, time_t* literal) {
	struct tm _tmp0_ = {0};
	struct tm tm;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	tm = (g_time_gm ((*literal), &_tmp0_), _tmp0_);
	tracker_turtle_writer_object_string (self, _tmp1_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02d", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec));
	_g_free0 (_tmp1_);
}


static void _vala_array_add17 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_object_blank_open (TrackerTurtleWriter* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail ((tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_PREDICATE) || (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT));
	if (tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT) {
		tracker_turtle_writer_append (self, " ,");
		self->priv->states_length1--;
	}
	tracker_turtle_writer_append (self, " [");
	_vala_array_add17 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_BLANK);
}


static void _vala_array_add18 (TrackerTurtleWriterState** array, int* length, int* size, TrackerTurtleWriterState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerTurtleWriterState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_turtle_writer_object_blank_close (TrackerTurtleWriter* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail ((tracker_turtle_writer_get_state (self) == TRACKER_TURTLE_WRITER_STATE_OBJECT) && (self->priv->states[self->priv->states_length1 - 3] == TRACKER_TURTLE_WRITER_STATE_BLANK));
	tracker_turtle_writer_append (self, "]");
	self->priv->states_length1 = self->priv->states_length1 - 3;
	_vala_array_add18 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_TURTLE_WRITER_STATE_OBJECT);
}


void tracker_turtle_writer_close (TrackerTurtleWriter* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->err != NULL) {
		_inner_error_ = _g_error_copy0 (self->priv->err);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static TrackerTurtleWriterState tracker_turtle_writer_get_state (TrackerTurtleWriter* self) {
	TrackerTurtleWriterState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->states[self->priv->states_length1 - 1];
	return result;
}


static void tracker_turtle_writer_class_init (TrackerTurtleWriterClass * klass) {
	tracker_turtle_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerTurtleWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_turtle_writer_get_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_writer_finalize;
}


static void tracker_turtle_writer_instance_init (TrackerTurtleWriter * self) {
	self->priv = TRACKER_TURTLE_WRITER_GET_PRIVATE (self);
}


static void tracker_turtle_writer_finalize (GObject* obj) {
	TrackerTurtleWriter * self;
	self = TRACKER_TURTLE_WRITER (obj);
	_g_object_unref0 (self->priv->stream);
	self->priv->states = (g_free (self->priv->states), NULL);
	_g_error_free0 (self->priv->err);
	G_OBJECT_CLASS (tracker_turtle_writer_parent_class)->finalize (obj);
}


GType tracker_turtle_writer_get_type (void) {
	static GType tracker_turtle_writer_type_id = 0;
	if (tracker_turtle_writer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleWriter), 0, (GInstanceInitFunc) tracker_turtle_writer_instance_init, NULL };
		tracker_turtle_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleWriter", &g_define_type_info, 0);
	}
	return tracker_turtle_writer_type_id;
}


static void tracker_turtle_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerTurtleWriter * self;
	self = TRACKER_TURTLE_WRITER (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




